/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.comm;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;

public final class DebugStreamFactory {
    private DebugStreamFactory() {
    }

    public static DebugStream createServerSocket(int n) {
        DebugStream debugStream = null;
        try {
            ServerSocket serverSocket = new ServerSocket(n, 1);
            Socket socket = serverSocket.accept();
            serverSocket.close();
            debugStream = DebugStreamFactory.createServerDebugStream(socket);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return debugStream;
    }

    public static Thread createServerSocket(int n, ActionListener actionListener) {
        ServerWaitingThread serverWaitingThread = new ServerWaitingThread(actionListener);
        if (ServerWaitingThread.mav$connect(serverWaitingThread, n)) {
            return serverWaitingThread;
        }
        return null;
    }

    public static DebugStream createClientSocket(InetAddress inetAddress, int n) {
        DebugStream debugStream = null;
        try {
            Socket socket = new Socket(inetAddress, n);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            debugStream = new DebugStream(dataInputStream, dataOutputStream);
            debugStream.setSide(true);
            debugStream.readHandshake();
            debugStream.writeHandshake();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return debugStream;
    }

    private static DebugStream createServerDebugStream(Socket socket) throws IOException {
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        DebugStream debugStream = new DebugStream(inputStream, outputStream);
        debugStream.setSide(false);
        debugStream.writeHandshake();
        debugStream.readHandshake();
        return debugStream;
    }

    static DebugStream maS$createServerDebugStream(Socket socket) {
        return DebugStreamFactory.createServerDebugStream(socket);
    }

    private static class ServerWaitingThread
    extends Thread {
        private ActionListener _listener;
        private ServerSocket _listen;

        public ServerWaitingThread(ActionListener actionListener) {
            this._listener = actionListener;
        }

        private boolean connect(int n) {
            boolean bl = false;
            try {
                this._listen = new ServerSocket(n, 5);
                bl = true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return bl;
        }

        public void run() {
            try {
                while (true) {
                    try {
                        Socket socket = this._listen.accept();
                        DebugStream debugStream = DebugStreamFactory.maS$createServerDebugStream(socket);
                        ActionEvent actionEvent = new ActionEvent(debugStream, 1001, null);
                        this._listener.actionPerformed(actionEvent);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }

        static boolean mav$connect(ServerWaitingThread serverWaitingThread, int n) {
            return serverWaitingThread.connect(n);
        }
    }
}

