/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debuggee.request;

import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debuggee.References;
import oracle.jdevimpl.runner.uidebug.debuggee.Request;
import oracle.jdevimpl.runner.uidebug.debuggee.dynalistener.ListenerFinder;

public class ReqFindEventTypes
extends Request {
    public static final int REQUEST_TYPE = 8;
    private int _componentID;
    private ArrayList _eventTypes;
    private boolean _includeChildren;

    void $init$() {
        this._componentID = -1;
    }

    public ReqFindEventTypes(int n) {
        super(n, 8);
        this.$init$();
    }

    public void readParam(DebugStream debugStream) throws IOException {
        this._componentID = debugStream.readInt();
        this._includeChildren = debugStream.readBoolean();
    }

    public void doIt() {
        Object object = References.getInstance().getReferee(this._componentID);
        if (this._includeChildren) {
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            this.recFindEventTypes(object, hashSet, hashSet2);
            this._eventTypes = new ArrayList(hashSet);
        } else {
            this._eventTypes = ListenerFinder.findEventTypes(object.getClass());
        }
        Collections.sort(this._eventTypes);
    }

    private void recFindEventTypes(Object object, HashSet hashSet, HashSet hashSet2) {
        Class<?> clazz = object.getClass();
        if (!hashSet2.contains(clazz)) {
            ArrayList arrayList = ListenerFinder.findEventTypes(clazz);
            hashSet.addAll(arrayList);
            hashSet2.add(clazz);
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component = container.getComponent(n2);
                this.recFindEventTypes(component, hashSet, hashSet2);
                ++n2;
            }
        }
    }

    public void writeReply(DebugStream debugStream) throws IOException {
        debugStream.writeInt(this.getReqID());
        debugStream.writeInt(8);
        debugStream.writeInt(this._eventTypes.size());
        for (String string : this._eventTypes) {
            debugStream.writeUTF(string);
        }
    }
}

