/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debuggee.request;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.Timer;
import javax.swing.border.Border;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debuggee.References;
import oracle.jdevimpl.runner.uidebug.debuggee.Request;

public class ReqHighlight
extends Request
implements ActionListener {
    private Component _component;
    public static final int REQUEST_TYPE = 6;
    private int _highlight_type;
    private static HighLighter _highlighter;

    public ReqHighlight(int n) {
        super(n, 6);
    }

    public void readParam(DebugStream debugStream) throws IOException {
        int n = debugStream.readInt();
        this._component = (Component)References.getInstance().getReferee(n);
        this._highlight_type = debugStream.readInt();
    }

    public void doIt() {
        if (this._component != null) {
            switch (this._highlight_type) {
                case 0: {
                    this.whenShow();
                    break;
                }
                case 1: {
                    this.whenHide();
                    break;
                }
                case 2: {
                    this.whenFlash();
                }
            }
        }
    }

    public void writeReply(DebugStream debugStream) throws IOException {
    }

    private HighLighter getHighlighter() {
        if (_highlighter == null) {
            _highlighter = new HighLighter();
        }
        return _highlighter;
    }

    private void whenShow() {
        HighLighter highLighter = this.getHighlighter();
        highLighter.locate(this._component);
    }

    private void whenHide() {
        HighLighter highLighter = this.getHighlighter();
        highLighter.hide();
    }

    private void whenFlash() {
        Timer timer = new Timer(2000, this);
        timer.setRepeats(false);
        this.whenShow();
        timer.start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.whenHide();
    }

    public static class HighLighter
    extends JWindow {
        private Border _border;

        void $init$() {
            this._border = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder());
        }

        HighLighter() {
            this.$init$();
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.red);
            this.getContentPane().add(jPanel);
            this.getRootPane().setBorder(this._border);
        }

        public void locate(Component component) {
            if (component != null && component.isShowing()) {
                Rectangle rectangle = new Rectangle(component.getLocationOnScreen(), component.getSize());
                this.moveTo(rectangle);
                this.setVisible(true);
            } else {
                this.setVisible(false);
            }
        }

        public void moveTo(Rectangle rectangle) {
            Border border = this._border;
            Insets insets = this._border.getBorderInsets(this.getRootPane());
            if (rectangle.width - insets.left - insets.right < 10 || rectangle.height - insets.top - insets.bottom < 10) {
                border = null;
            }
            this.getRootPane().setBorder(border);
            this.setBounds(rectangle);
        }
    }
}

