/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger;

import java.util.ArrayList;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerListener;

public final class Debugger {
    private static Debugger INSTANCE;
    private final ArrayList _processListeners;
    private final ArrayList _debugProcesses;
    private DebuggerProcess _activeDebugProcess;

    void $init$() {
        this._processListeners = new ArrayList();
        this._debugProcesses = new ArrayList(1);
    }

    private Debugger() {
        this.$init$();
    }

    public static Debugger getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Debugger();
        }
        return INSTANCE;
    }

    static void startUIDebugger(Context context) {
        DebuggerProcess debuggerProcess = new DebuggerProcess(context);
        debuggerProcess.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDebuggerProcessCount() {
        ArrayList arrayList = this._debugProcesses;
        synchronized (arrayList) {
            int n = this._debugProcesses.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerProcess getDebuggerProcess(int n) {
        ArrayList arrayList = this._debugProcesses;
        synchronized (arrayList) {
            DebuggerProcess debuggerProcess = (DebuggerProcess)this._debugProcesses.get(n);
            return debuggerProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDebugProcess(DebuggerProcess debuggerProcess) {
        ArrayList arrayList = this._debugProcesses;
        synchronized (arrayList) {
            this._debugProcesses.add(debuggerProcess);
        }
        this.fireDebuggerListenerEvent(0, debuggerProcess);
        this.setActiveDebugger(debuggerProcess);
    }

    public void removeDebugProcess(DebuggerProcess debuggerProcess) {
        this.fireDebuggerListenerEvent(1, debuggerProcess);
        this._debugProcesses.remove(debuggerProcess);
        DebuggerProcess debuggerProcess2 = this._debugProcesses.size() == 0 ? null : (DebuggerProcess)this._debugProcesses.get(0);
        this.setActiveDebugger(debuggerProcess2);
    }

    private void setActiveDebugger(DebuggerProcess debuggerProcess) {
        this._activeDebugProcess = debuggerProcess;
        this.fireDebuggerListenerEvent(2, this._activeDebugProcess);
    }

    public DebuggerProcess getActiveDebuggerProcess() {
        return this._activeDebugProcess;
    }

    public void addDebuggerListener(DebuggerListener debuggerListener) {
        this._processListeners.add(debuggerListener);
    }

    public void removeDebuggerListener(DebuggerListener debuggerListener) {
        this._processListeners.remove(debuggerListener);
    }

    private void fireDebuggerListenerEvent(int n, DebuggerProcess debuggerProcess) {
        if (SwingUtilities.isEventDispatchThread()) {
            DebuggerEvent debuggerEvent = null;
            int n2 = this._processListeners.size();
            int n3 = 0;
            while (n3 < n2) {
                DebuggerListener debuggerListener = (DebuggerListener)this._processListeners.get(n3);
                if (debuggerEvent == null) {
                    debuggerEvent = new DebuggerEvent(n, debuggerProcess);
                }
                try {
                    switch (debuggerEvent.getEventID()) {
                        case 2: {
                            debuggerListener.debuggerProcessActivated(debuggerEvent);
                            break;
                        }
                        case 0: {
                            debuggerListener.debuggerProcessCreated(debuggerEvent);
                            break;
                        }
                        case 1: {
                            debuggerListener.debuggerProcessDied(debuggerEvent);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n3;
            }
        } else {
            SwingUtilities.invokeLater(new 1(this, n, debuggerProcess));
        }
    }

    static void mav$fireDebuggerListenerEvent(Debugger debugger, int n, DebuggerProcess debuggerProcess) {
        debugger.fireDebuggerListenerEvent(n, debuggerProcess);
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ int v$eventID;
        private final /* synthetic */ DebuggerProcess v$debuggerProcess;
        final /* synthetic */ Debugger this$0;

        public void run() {
            Debugger.mav$fireDebuggerListenerEvent(this.this$0, this.v$eventID, this.v$debuggerProcess);
        }

        public 1(Debugger debugger, int n, DebuggerProcess debuggerProcess) {
            this.v$debuggerProcess = debuggerProcess;
            this.v$eventID = n;
            this.this$0 = debugger;
        }
    }
}

