/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.BitField;
import oracle.ide.view.View;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerListener;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessListener;
import oracle.jdevimpl.runner.uidebug.debugger.ui.DebuggerDockable;
import oracle.jdevimpl.runner.uidebug.debugger.ui.DockableListeners;
import oracle.jdevimpl.runner.uidebug.debugger.ui.DockableOutline;
import oracle.jdevimpl.runner.uidebug.debugger.ui.DockableTree;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public final class DebuggerAddin
implements Observer,
DebuggerProcessListener,
DebuggerListener,
DockableFactory,
MenuListener,
Addin,
Controller {
    public static final String FACTORY_ID = "UIDebugger";
    private static DebuggerAddin INSTANCE;
    private int VIEW_UIOUTLINE_CMD_ID;
    IdeAction VIEW_UIOUTLINE_ACTION;
    private int VIEW_UITREE_CMD_ID;
    IdeAction VIEW_UITREE_ACTION;
    private int VIEW_UILISTENERS_CMD_ID;
    IdeAction VIEW_UILISTENERS_ACTION;
    private int RUN_UIDEBUG_CMD_ID;
    IdeAction RUN_UIDEBUG_ACTION;
    private Project _activeProject;
    private DebuggerDockable _outline;
    private DebuggerDockable _tree;
    private DebuggerDockable _listeners;

    public DebuggerAddin() {
        INSTANCE = this;
    }

    public static DebuggerAddin getInstance() {
        return INSTANCE;
    }

    private void updateStartMenu() {
        if (SwingUtilities.isEventDispatchThread()) {
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            View view = ideMainWindow.getLastActiveView();
            Context context = view.getContext();
            this.update(this.RUN_UIDEBUG_ACTION, context);
        } else {
            SwingUtilities.invokeLater(new 1());
        }
    }

    public void initialize() {
        DockStation.getDockStation().registerDockableFactory(FACTORY_ID, (DockableFactory)this);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/runner/uidebug/debugger/accelerators.xml");
        Debugger.getInstance().addDebuggerListener(this);
        this.createActions();
        Ide.getSystem().attach((Observer)this);
    }

    private void createActions() {
        this.VIEW_UIOUTLINE_CMD_ID = Ide.findOrCreateCmdID((String)"VIEW_UIOUTLINE_CMD_ID");
        this.VIEW_UIOUTLINE_ACTION = this.createViewAction(24, this.VIEW_UIOUTLINE_CMD_ID, 25, 27);
        this.VIEW_UITREE_CMD_ID = Ide.findOrCreateCmdID((String)"VIEW_UITREE_CMD_ID");
        this.VIEW_UITREE_ACTION = this.createViewAction(19, this.VIEW_UITREE_CMD_ID, 20, 22);
        this.VIEW_UILISTENERS_CMD_ID = Ide.findOrCreateCmdID((String)"VIEW_UILISTENERS_CMD_ID");
        this.VIEW_UILISTENERS_ACTION = this.createViewAction(30, this.VIEW_UILISTENERS_CMD_ID, 31, 33);
        String string = DbgArb.getString(0);
        this.RUN_UIDEBUG_CMD_ID = Ide.findOrCreateCmdID((String)"RUN_UIDEBUG_CMD_ID");
        this.RUN_UIDEBUG_ACTION = IdeAction.get((int)this.RUN_UIDEBUG_CMD_ID, null, (String)UIDebugArb.getString(1), (String)string, (Integer)UIDebugArb.getInteger(3), (ArrayResourceBundle)UIDebugArb.getInstance(), (int)4, null, (boolean)true);
        this.RUN_UIDEBUG_ACTION.putValue("NoCtxName", (Object)UIDebugArb.getString(2));
        this.RUN_UIDEBUG_ACTION.addController((Controller)this);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)this.RUN_UIDEBUG_ACTION, JDeveloperMenuConstants.WEIGHT_DEBUG_UI_DEBUG_PROJECT);
        JMenu jMenu = menubar.createSubMenu(UIDebugArb.getString(11), UIDebugArb.getInteger(12), JDeveloperMenuConstants.WEIGHT_VIEW_UI_DEBUGGER);
        jMenu.addMenuListener(this);
        menubar.add((Component)jMenu, MenuManager.getJMenu((String)"View"), JDeveloperMenuConstants.SECTION_VIEW_DEBUG_RUN);
        JMenu jMenu2 = oracle.ide.runner.Debugger.getDebugger().getDebugMenu();
        menubar.add((Component)jMenuItem, jMenu2, JDeveloperMenuConstants.SECTION_DEBUG_UI_DEBUG);
    }

    private IdeAction createViewAction(int n, int n2, int n3, int n4) {
        String string = UIDebugArb.getString(n);
        IdeAction ideAction = IdeAction.get((int)n2, null, (String)string, (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)UIDebugArb.getInteger(n3), (ArrayResourceBundle)UIDebugArb.getInstance(), (int)n4, null, (boolean)true);
        ideAction.putValue("NoCtxName", (Object)UIDebugArb.format(14, string));
        ideAction.addController((Controller)this);
        return ideAction;
    }

    private void expandViewMenu(JMenu jMenu) {
        Menubar menubar = Ide.getMenubar();
        jMenu.removeMenuListener(this);
        boolean bl = Debugger.getInstance().getActiveDebuggerProcess() != null;
        this.VIEW_UIOUTLINE_ACTION.setEnabled(bl);
        this.VIEW_UITREE_ACTION.setEnabled(bl);
        this.VIEW_UILISTENERS_ACTION.setEnabled(bl);
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)this.VIEW_UIOUTLINE_ACTION);
        JMenuItem jMenuItem2 = menubar.createMenuItem((ToggleAction)this.VIEW_UITREE_ACTION);
        JMenuItem jMenuItem3 = menubar.createMenuItem((ToggleAction)this.VIEW_UILISTENERS_ACTION);
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction == this.VIEW_UIOUTLINE_ACTION) {
            DockUtil.showDockableWindow((DockableView)this.getOutline());
            return true;
        }
        if (ideAction == this.VIEW_UITREE_ACTION) {
            DockUtil.showDockableWindow((DockableView)this.getTree());
            return true;
        }
        if (ideAction == this.VIEW_UILISTENERS_ACTION) {
            DockUtil.showDockableWindow((DockableView)this.getListeners());
            return true;
        }
        if (ideAction == this.RUN_UIDEBUG_ACTION) {
            DebuggerAddin.runUIDebug();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == this.VIEW_UIOUTLINE_CMD_ID) {
            DebuggerDockable debuggerDockable = this.getOutline();
            DebuggerAddin.updateView(ideAction);
        } else if (n == this.VIEW_UITREE_CMD_ID) {
            DebuggerDockable debuggerDockable = this.getTree();
            DebuggerAddin.updateView(ideAction);
        } else if (n == this.VIEW_UILISTENERS_CMD_ID) {
            DebuggerDockable debuggerDockable = this.getListeners();
            DebuggerAddin.updateView(ideAction);
        } else if (n == this.RUN_UIDEBUG_CMD_ID) {
            String string;
            if (this._activeProject != null) {
                String string2 = this._activeProject.getShortLabel();
                string = UIDebugArb.format(1, string2);
                int n2 = Debugger.getInstance().getDebuggerProcessCount();
                ideAction.setEnabled(n2 == 0);
            } else {
                string = UIDebugArb.getString(2);
                ideAction.setEnabled(false);
            }
            ideAction.putValue("Name", (Object)string);
        } else {
            return false;
        }
        return true;
    }

    private static void updateView(IdeAction ideAction) {
        boolean bl = Debugger.getInstance().getActiveDebuggerProcess() != null;
        ideAction.setEnabled(bl);
    }

    private static boolean runUIDebug() {
        if (Ide.getActiveWorkspace() != null && Ide.getActiveProject() != null) {
            Debugger.startUIDebugger(null);
        }
        return true;
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (object == Ide.getSystem()) {
            if (n == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                if (this._activeProject != null) {
                    this._activeProject.detach((Observer)this);
                }
                this._activeProject = Ide.getActiveProject();
                if (this._activeProject != null) {
                    this._activeProject.attach((Observer)this);
                }
                this.updateStartMenu();
            }
        } else if (object instanceof Project && n == UpdateMessage.PROPERTY_SET) {
            this.updateStartMenu();
        }
    }

    public Dockable getDockable(ViewId viewId) {
        DebuggerDockable debuggerDockable = null;
        String string = viewId.getName();
        if ("OUTLINE".equals(string)) {
            debuggerDockable = this.getOutline();
        } else if ("TREE".equals(string)) {
            debuggerDockable = this.getTree();
        } else if ("LISTENERS".equals(string)) {
            debuggerDockable = this.getListeners();
        }
        return debuggerDockable;
    }

    public void install() {
        DockStation dockStation = DockStation.getDockStation();
        DebuggerDockable debuggerDockable = this.getTree();
        DockingParam dockingParam = new DockingParam();
        dockingParam.setPosition(1);
        dockStation.dock((Dockable)debuggerDockable, dockingParam);
        DebuggerDockable debuggerDockable2 = this.getOutline();
        DockingParam dockingParam2 = new DockingParam();
        dockingParam2.setPosition((Dockable)debuggerDockable, 3);
        dockStation.dock((Dockable)debuggerDockable2, dockingParam2);
        DebuggerDockable debuggerDockable3 = this.getListeners();
        DockingParam dockingParam3 = new DockingParam();
        dockingParam3.setPosition((Dockable)debuggerDockable2, 3);
        dockStation.dock((Dockable)debuggerDockable3, dockingParam3);
    }

    private DebuggerDockable getOutline() {
        if (this._outline == null) {
            this._outline = new DockableOutline();
        }
        return this._outline;
    }

    private DebuggerDockable getTree() {
        if (this._tree == null) {
            this._tree = new DockableTree();
        }
        return this._tree;
    }

    public DebuggerDockable getListeners() {
        if (this._listeners == null) {
            this._listeners = new DockableListeners();
        }
        return this._listeners;
    }

    public void debuggerProcessActivated(DebuggerEvent debuggerEvent) {
    }

    public void debuggerProcessCreated(DebuggerEvent debuggerEvent) {
        DebuggerProcess debuggerProcess = debuggerEvent.getDebuggerProcess();
        debuggerProcess.addDebuggerProcessListener(this);
    }

    public void debuggerProcessDied(DebuggerEvent debuggerEvent) {
        if (Debugger.getInstance().getDebuggerProcessCount() == 1) {
            DockStation dockStation = DockStation.getDockStation();
            dockStation.setDockableVisible(DockableListeners.getViewID(), false);
            dockStation.setDockableVisible(DockableOutline.getViewID(), false);
            dockStation.setDockableVisible(DockableTree.getViewID(), false);
            debuggerEvent.getDebuggerProcess().removeDebuggerProcessListener(this);
        }
    }

    public void rootChanging(DebuggerProcessEvent debuggerProcessEvent) {
    }

    public void rootChanged(DebuggerProcessEvent debuggerProcessEvent) {
    }

    public void stateChanged(DebuggerProcessEvent debuggerProcessEvent) {
        if (BitField.isSet((int)debuggerProcessEvent.getStateMask(), (int)1)) {
            DebuggerProcess debuggerProcess = debuggerProcessEvent.getSource();
            debuggerProcess.removeDebuggerProcessListener(this);
            this.getTree().show();
            this.getOutline().show();
        }
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuSelected(MenuEvent menuEvent) {
        JMenu jMenu = (JMenu)menuEvent.getSource();
        if (jMenu.getComponentCount() == 0) {
            this.expandViewMenu(jMenu);
        }
    }

    static void mav$updateStartMenu(DebuggerAddin debuggerAddin) {
        debuggerAddin.updateStartMenu();
    }

    public final class 1
    implements Runnable {
        public void run() {
            DebuggerAddin.mav$updateStartMenu(DebuggerAddin.this);
        }
    }
}

