/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.EOFException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.util.BitField;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.RunWhilePaused;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.comm.DebugStreamFactory;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.ReceiveQueue;
import oracle.jdevimpl.runner.uidebug.debugger.Request;
import oracle.jdevimpl.runner.uidebug.debugger.UIDebugConnectArg;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessListener;
import oracle.jdevimpl.runner.uidebug.debugger.model.XComponent;
import oracle.jdevimpl.runner.uidebug.debugger.reply.ListenerMessage;
import oracle.jdevimpl.runner.uidebug.debugger.reply.RepFullTree;
import oracle.jdevimpl.runner.uidebug.debugger.reply.Reply;
import oracle.jdevimpl.runner.uidebug.debugger.ui.ComponentDetail;
import oracle.jdevimpl.runner.uidebug.debugger.ui.ComponentOutline;
import oracle.jdevimpl.runner.uidebug.debugger.ui.ComponentTree;
import oracle.jdevimpl.runner.uidebug.debugger.ui.ListenersOutput;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public final class DebuggerProcess
extends DebuggingProcess {
    public static final int STATE_ACTIVE = 1;
    public static final int STATE_PAUSED = 2;
    private static final int STATE_STARTED = 256;
    private DebugStream _stream;
    private final ReceiveQueue _receiveQueue;
    private final LinkedList _pendingReplies;
    private final ArrayList _references;
    private DebugConnectArg _host;
    private int _stateMask;
    private final DefaultMutableTreeNode _root;
    private XComponent _selection;
    private final ArrayList _selListeners;
    public static final String SELECTION_PROPERTY = "SELECTION";
    private final ArrayList _listeners;
    private ComponentTree _tree;
    private ComponentDetail _detail;
    private ComponentOutline _outline;
    private ListenersOutput _listenerOutput;
    private DebugConnectArg _uiDebugRemotePort;

    void $init$() {
        this._receiveQueue = new ReceiveQueue();
        this._pendingReplies = new LinkedList();
        this._references = new ArrayList(50);
        this._root = new DefaultMutableTreeNode();
        this._selListeners = new ArrayList(3);
        this._listeners = new ArrayList(3);
    }

    DebuggerProcess(Context context) {
        super(context, null);
        this.$init$();
    }

    protected void checkCommands() {
        super.checkCommands();
        this.updateState();
    }

    private void updateState() {
        int n = this._stateMask & 0x100 | (BitField.isSet((int)this._stateMask, (int)256) ? 1 : 0) | (this.canPause() ? 0 : 2);
        if (n != this._stateMask) {
            this._stateMask = n;
            DebuggerProcessEvent debuggerProcessEvent = new DebuggerProcessEvent(this, 2, this._stateMask);
            this.fireDebuggerProcessEvent(debuggerProcessEvent);
        }
    }

    public String getProcessLabelPrefix() {
        return UIDebugArb.getString(5);
    }

    public Icon getIcon() {
        return UIDebugArb.getIcon(4);
    }

    public boolean canRun(String string, Object object, Node node, List list) {
        if ("Java".equals(string)) {
            if ("Embedded Server".equals(object)) {
                list.add(UIDebugArb.format(7, node.getShortLabel()));
                return false;
            }
            return true;
        }
        if ("Database".equals(string)) {
            list.add(UIDebugArb.format(8, node.getShortLabel()));
            return false;
        }
        if ("XSLT".equals(string)) {
            list.add(UIDebugArb.format(9, node.getShortLabel()));
            return false;
        }
        if ("XQuery".equals(string)) {
            list.add(UIDebugArb.format(10, node.getShortLabel()));
            return false;
        }
        return false;
    }

    public Object getValue(String string, Object object, String string2) {
        if ("Java".equals(string)) {
            if ("ClassPath".equals(string2)) {
                return this.getClassPath();
            }
            if ("LastJavaCommandOptions".equals(string2)) {
                return this.getLastJavaCommandOptions();
            }
        }
        return super.getValue(string, object, string2);
    }

    private String getClassPath() {
        String string = Ide.getLibDirectory() + "jdev-remote.jar";
        return string;
    }

    private String[] getLastJavaCommandOptions() {
        String[] stringArray = new String[]{"oracle.jdevimpl.runner.uidebug.debuggee.Debuggee", "-silent"};
        return stringArray;
    }

    protected boolean startTarget() {
        boolean bl = super.startTarget();
        if (bl) {
            DebuggerThread debuggerThread = new DebuggerThread();
            debuggerThread.start();
        }
        return bl;
    }

    public void finished() {
        super.finished();
        this._stateMask = BitField.unset((int)this._stateMask, (int)256);
        this.updateState();
    }

    protected DebugConnectArg[] getDebugConnectArgs(DebugConnector debugConnector) {
        DebugConnectArg[] debugConnectArgArray = super.getDebugConnectArgs(debugConnector);
        this._host = DebugShared.findConnectArg(debugConnectArgArray, "hostname");
        this._uiDebugRemotePort = new UIDebugConnectArg();
        DebugConnectArg[] debugConnectArgArray2 = new DebugConnectArg[debugConnectArgArray.length + 1];
        System.arraycopy(debugConnectArgArray, 0, debugConnectArgArray2, 0, debugConnectArgArray.length);
        debugConnectArgArray2[debugConnectArgArray.length] = this._uiDebugRemotePort;
        return debugConnectArgArray2;
    }

    public ReceiveQueue getReceiveQueue() {
        return this._receiveQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushRequest(Request request) {
        try {
            if (request.isWaitForReply()) {
                LinkedList linkedList = this._pendingReplies;
                synchronized (linkedList) {
                    this._pendingReplies.addLast(request);
                }
            }
            this._stream.writeInt(request.getRequestID());
            request.write(this._stream);
            this._stream.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void invokeWhilePaused(Runnable runnable) {
        this.runWhilePaused(new DoWhilePaused(runnable));
    }

    public void addWatch(XComponent xComponent) {
        this.runAfterPaused(new DoWhilePaused(xComponent, 1));
    }

    public void addInspect(XComponent xComponent) {
        this.runAfterPaused(new DoWhilePaused(xComponent, 2));
    }

    public void whenShowSourceFile(XComponent xComponent) {
        this.runWhilePaused(new DoWhilePaused(xComponent, 3));
    }

    public void whenShowSourceFile(DebugMethodInfo debugMethodInfo) {
        this.runWhilePaused(new DoWhilePaused(debugMethodInfo));
    }

    public ComponentDetail getDetail() {
        if (this._detail == null) {
            this._detail = new ComponentDetail(this);
        }
        return this._detail;
    }

    public boolean isDetailCreated() {
        return this._detail != null;
    }

    public ComponentOutline getOutline() {
        if (this._outline == null) {
            this._outline = new ComponentOutline(this);
        }
        return this._outline;
    }

    public boolean isOutlineCreated() {
        return this._outline != null;
    }

    public ComponentTree getTree() {
        if (this._tree == null) {
            this._tree = new ComponentTree(this);
        }
        return this._tree;
    }

    public boolean isTreeCreated() {
        return this._tree != null;
    }

    public ListenersOutput getListenerOutput() {
        if (this._listenerOutput == null) {
            this._listenerOutput = new ListenersOutput(this);
        }
        return this._listenerOutput;
    }

    public boolean isListenerOutputCreated() {
        return this._listenerOutput != null;
    }

    public void addDebuggerProcessListener(DebuggerProcessListener debuggerProcessListener) {
        this._listeners.add(debuggerProcessListener);
    }

    public void removeDebuggerProcessListener(DebuggerProcessListener debuggerProcessListener) {
        this._listeners.remove(debuggerProcessListener);
    }

    public void fireDebuggerProcessEvent(DebuggerProcessEvent debuggerProcessEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            ArrayList arrayList = (ArrayList)this._listeners.clone();
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                DebuggerProcessListener debuggerProcessListener = (DebuggerProcessListener)arrayList.get(n2);
                switch (debuggerProcessEvent.getEventID()) {
                    case 0: {
                        debuggerProcessListener.rootChanging(debuggerProcessEvent);
                        break;
                    }
                    case 1: {
                        debuggerProcessListener.rootChanged(debuggerProcessEvent);
                        break;
                    }
                    case 2: {
                        debuggerProcessListener.stateChanged(debuggerProcessEvent);
                    }
                }
                ++n2;
            }
        } else {
            SwingUtilities.invokeLater(new 1(this, debuggerProcessEvent));
        }
    }

    public TreeNode getWindowsRoot() {
        return this._root;
    }

    public int getStateMask() {
        return this._stateMask;
    }

    public XComponent getSelection() {
        return this._selection;
    }

    public void setSelection(XComponent xComponent) {
        if (this._selection != xComponent) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, SELECTION_PROPERTY, this._selection, xComponent);
            this._selection = xComponent;
            this.fireSelectionChangeEvent(propertyChangeEvent);
        }
    }

    public void addSelectionListener(PropertyChangeListener propertyChangeListener) {
        this._selListeners.add(propertyChangeListener);
    }

    public void removeSelectionListener(PropertyChangeListener propertyChangeListener) {
        this._selListeners.remove(propertyChangeListener);
    }

    private void fireSelectionChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        int n = this._selListeners.size();
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this._selListeners.get(n2);
            propertyChangeListener.propertyChange(propertyChangeEvent);
            ++n2;
        }
    }

    public XComponent searchReference(int n) {
        XComponent xComponent = null;
        if (n < this._references.size()) {
            xComponent = (XComponent)this._references.get(n);
        }
        return xComponent;
    }

    public XComponent findReference(int n) {
        XComponent xComponent = this.searchReference(n);
        if (xComponent == null) {
            xComponent = new XComponent(n);
            this._references.ensureCapacity(n + 1);
            int n2 = this._references.size() - 1;
            while (n2 < n) {
                this._references.add(null);
                ++n2;
            }
            this._references.set(n, xComponent);
        }
        return xComponent;
    }

    public ArrayList filter(String string, String string2) {
        ArrayList<DebugMethodInfo> arrayList = new ArrayList<DebugMethodInfo>();
        List list = this.getTracingIncludeList();
        List list2 = this.getTracingExcludeList();
        DebugClassInfo debugClassInfo = this.vm.findFirstClassByName(string);
        DebugMethodInfo[] debugMethodInfoArray = debugClassInfo.getMethods();
        DebugClassInfo debugClassInfo2 = this.vm.findFirstClassByName(string2);
        int n = 0;
        while (n < debugMethodInfoArray.length) {
            DebugMethodInfo debugMethodInfo = debugMethodInfoArray[n];
            DebugClassInfo debugClassInfo3 = debugClassInfo2;
            DebugMethodInfo debugMethodInfo2 = null;
            while (debugMethodInfo2 == null && debugClassInfo3 != null && this.isInTracing(debugClassInfo3, list, list2)) {
                DebugMethodInfo[] debugMethodInfoArray2 = debugClassInfo3.getMethods();
                int n2 = 0;
                while (n2 < debugMethodInfoArray2.length) {
                    int[] nArray;
                    DebugMethodInfo debugMethodInfo3 = debugMethodInfoArray2[n2];
                    if (debugMethodInfo.getNameWithoutClass().equals(debugMethodInfo3.getNameWithoutClass()) && (nArray = debugMethodInfo3.getMethodLineRange()) != null && nArray[0] != nArray[1]) {
                        debugMethodInfo2 = debugMethodInfo3;
                    }
                    ++n2;
                }
                debugClassInfo3 = debugClassInfo3.getSuperClass(1);
            }
            if (debugMethodInfo2 != null) {
                arrayList.add(debugMethodInfo2);
            }
            ++n;
        }
        return arrayList;
    }

    private boolean isInTracing(DebugClassInfo debugClassInfo, List list, List list2) {
        String string = debugClassInfo.getName();
        return DebugShared.isClassOrPackageDebuggable(string, list, list2);
    }

    static DebugConnectArg ra$_host(DebuggerProcess debuggerProcess) {
        return debuggerProcess._host;
    }

    static DebugConnectArg ra$_uiDebugRemotePort(DebuggerProcess debuggerProcess) {
        return debuggerProcess._uiDebugRemotePort;
    }

    static void wa$_stream(DebuggerProcess debuggerProcess, DebugStream debugStream) {
        debuggerProcess._stream = debugStream;
    }

    static DebugStream ra$_stream(DebuggerProcess debuggerProcess) {
        return debuggerProcess._stream;
    }

    static LinkedList ra$_pendingReplies(DebuggerProcess debuggerProcess) {
        return debuggerProcess._pendingReplies;
    }

    static ReceiveQueue ra$_receiveQueue(DebuggerProcess debuggerProcess) {
        return debuggerProcess._receiveQueue;
    }

    static int ra$_stateMask(DebuggerProcess debuggerProcess) {
        return debuggerProcess._stateMask;
    }

    static void wa$_stateMask(DebuggerProcess debuggerProcess, int n) {
        debuggerProcess._stateMask = n;
    }

    static void mav$updateState(DebuggerProcess debuggerProcess) {
        debuggerProcess.updateState();
    }

    static void mav$showSourceFile(DebuggerProcess debuggerProcess, DebugLocation debugLocation, boolean bl) {
        debuggerProcess.showSourceFile(debugLocation, bl);
    }

    static DebugVirtualMachine ra$vm(DebuggerProcess debuggerProcess) {
        return debuggerProcess.vm;
    }

    static void mav$showSourceFile(DebuggerProcess debuggerProcess, DebugClassInfo debugClassInfo) {
        debuggerProcess.showSourceFile(debugClassInfo);
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ DebuggerProcessEvent v$e;
        final /* synthetic */ DebuggerProcess this$0;

        public void run() {
            this.this$0.fireDebuggerProcessEvent(this.v$e);
        }

        public 1(DebuggerProcess debuggerProcess, DebuggerProcessEvent debuggerProcessEvent) {
            this.v$e = debuggerProcessEvent;
            this.this$0 = debuggerProcess;
        }
    }

    private final class DebuggerThread
    extends Thread {
        public DebuggerThread() {
            super("UI-ProcessDebugger");
            this.setDaemon(true);
        }

        public void run() {
            if (this.createConnection()) {
                Debugger.getInstance().addDebugProcess(DebuggerProcess.this);
                DebuggerProcess.wa$_stateMask(DebuggerProcess.this, BitField.set((int)DebuggerProcess.ra$_stateMask(DebuggerProcess.this), (int)256));
                DebuggerProcess.mav$updateState(DebuggerProcess.this);
                this.runRequestLoop();
            }
            Debugger.getInstance().removeDebugProcess(DebuggerProcess.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runRequestLoop() {
            try {
                while (true) {
                    int n = DebuggerProcess.ra$_stream(DebuggerProcess.this).readInt();
                    int n2 = DebuggerProcess.ra$_stream(DebuggerProcess.this).readInt();
                    Reply reply = null;
                    LinkedList linkedList = DebuggerProcess.ra$_pendingReplies(DebuggerProcess.this);
                    synchronized (linkedList) {
                        Iterator iterator = DebuggerProcess.ra$_pendingReplies(DebuggerProcess.this).iterator();
                        while (iterator.hasNext()) {
                            Reply reply2 = (Reply)iterator.next();
                            if (reply2.getRequestID() != n) continue;
                            reply = reply2;
                            iterator.remove();
                            break;
                        }
                    }
                    if (reply == null) {
                        switch (n2) {
                            case 1: {
                                reply = new RepFullTree(n);
                                break;
                            }
                            case 100: {
                                reply = new ListenerMessage(n);
                                break;
                            }
                            default: {
                                System.err.println("Invalid request ID:" + n2);
                            }
                        }
                    }
                    if (reply == null) continue;
                    reply.readReply(DebuggerProcess.ra$_stream(DebuggerProcess.this));
                    DebuggerProcess.ra$_receiveQueue(DebuggerProcess.this).fireReplyEvent(reply);
                }
            }
            catch (SocketException socketException) {
            }
            catch (EOFException eOFException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private boolean createConnection() {
            InetAddress inetAddress;
            try {
                String string = DebuggerProcess.ra$_host(DebuggerProcess.this) == null || DebuggerProcess.ra$_host(DebuggerProcess.this).getValue() == null || DebuggerProcess.ra$_host(DebuggerProcess.this).getValue().length() == 0 ? "127.0.0.1" : DebuggerProcess.ra$_host(DebuggerProcess.this).getValue();
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println(unknownHostException.getLocalizedMessage());
                boolean bl = false;
                return bl;
            }
            int n = 4030;
            if (DebuggerProcess.ra$_uiDebugRemotePort(DebuggerProcess.this) != null) {
                try {
                    n = Integer.parseInt(DebuggerProcess.ra$_uiDebugRemotePort(DebuggerProcess.this).getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(numberFormatException.getLocalizedMessage());
                    boolean bl = false;
                    return bl;
                }
            }
            int n2 = 0;
            while (n2 < 5) {
                DebuggerProcess.wa$_stream(DebuggerProcess.this, DebugStreamFactory.createClientSocket(inetAddress, n));
                if (DebuggerProcess.ra$_stream(DebuggerProcess.this) != null) break;
                try {
                    DebuggerThread.sleep(2048L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n2;
            }
            return DebuggerProcess.ra$_stream(DebuggerProcess.this) != null;
        }
    }

    private final class DoWhilePaused
    implements RunWhilePaused {
        private static final int DO_WATCH = 1;
        private static final int DO_INSPECT = 2;
        private static final int DO_GOTO_CLASS_SOURCE = 3;
        private static final int DO_GOTO_METHOD_SOURCE = 4;
        private static final int DO_INVOKE_WHILE_PAUSED = 5;
        private final int _doWhat;
        private XComponent _xComponent;
        private String _className;
        private DebugMethodInfo _methodInfo;
        private Runnable _runnable;

        void $init$() {
            this._xComponent = null;
        }

        public DoWhilePaused(XComponent xComponent, int n) {
            this.$init$();
            this._xComponent = xComponent;
            this._doWhat = n;
        }

        public DoWhilePaused(String string) {
            this.$init$();
            this._className = string;
            this._doWhat = 3;
        }

        public DoWhilePaused(DebugMethodInfo debugMethodInfo) {
            this.$init$();
            this._methodInfo = debugMethodInfo;
            this._doWhat = 4;
        }

        public DoWhilePaused(Runnable runnable) {
            this.$init$();
            this._runnable = runnable;
            this._doWhat = 5;
        }

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            switch (this._doWhat) {
                case 1: {
                    this.doWatch(bl);
                    break;
                }
                case 2: {
                    this.doInspect(bl);
                    break;
                }
                case 3: {
                    this.doGoToClassSource(bl);
                    break;
                }
                case 4: {
                    this.doGoToMethodSource(bl);
                    break;
                }
                case 5: {
                    this._runnable.run();
                }
            }
        }

        private void doWatch(boolean bl) {
            if (bl) {
                String string = "oracle.jdevimpl.runner.uidebug.debuggee.References.INSTANCE._list.elementData[" + this._xComponent.getID() + "].referent";
                EvaluatorItem evaluatorItem = new EvaluatorItem(string);
                evaluatorItem.setOptions(this._xComponent.toString(), false, DebuggerProcess.this);
                JDebugger jDebugger = JDebugger.getInstance();
                jDebugger.addWatch(evaluatorItem);
            }
        }

        private void doInspect(boolean bl) {
            if (bl) {
                String string = "oracle.jdevimpl.runner.uidebug.debuggee.References.INSTANCE._list.elementData[" + this._xComponent.getID() + "].referent";
                EvaluatorItem evaluatorItem = new EvaluatorItem(string);
                evaluatorItem.setOptions(this._xComponent.toString(), false, DebuggerProcess.this);
                JDebugger jDebugger = JDebugger.getInstance();
                jDebugger.inspect(evaluatorItem);
            }
        }

        private void doGoToClassSource(boolean bl) {
            if (bl) {
                String string = this._className == null ? this._xComponent.getClassName() : this._className;
                DebugClassInfo[] debugClassInfoArray = DebuggerProcess.ra$vm(DebuggerProcess.this).listClasses();
                int n = 0;
                while (n < debugClassInfoArray.length) {
                    DebugClassInfo debugClassInfo = debugClassInfoArray[n];
                    if (string.equals(debugClassInfo.getName())) {
                        DebuggerProcess.mav$showSourceFile(DebuggerProcess.this, debugClassInfo);
                    }
                    ++n;
                }
            }
        }

        private void doGoToMethodSource(boolean bl) {
            DebugLocation debugLocation;
            if (bl && (debugLocation = this._methodInfo.getFirstLocation()) != null) {
                DebuggerProcess.mav$showSourceFile(DebuggerProcess.this, debugLocation, false);
            }
        }
    }
}

