/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.model;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.jdevimpl.runner.uidebug.debugger.model.Listener;

public final class Listeners {
    private ArrayList _listeners;
    private boolean _includeChilds;

    public Listeners() {
    }

    public Listeners(Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            this._listeners = new ArrayList<Object>(Arrays.asList(objectArray));
        }
        this._includeChilds = bl;
    }

    public Listeners(Listeners listeners) {
        if (listeners._listeners != null) {
            this._listeners = (ArrayList)listeners._listeners.clone();
        }
    }

    public void compare(Listeners listeners, ArrayList arrayList, ArrayList arrayList2) {
        if (this._includeChilds != listeners._includeChilds) {
            if (this._listeners != null) {
                arrayList.addAll(this._listeners);
            }
            if (listeners._listeners != null) {
                arrayList2.addAll(listeners._listeners);
            }
        } else {
            this.diffToRemove(listeners, arrayList);
            listeners.diffToRemove(this, arrayList2);
        }
    }

    private void diffToRemove(Listeners listeners, ArrayList arrayList) {
        int n = this.getListenerCount();
        int n2 = 0;
        while (n2 < n) {
            Listener listener = this.getListener(n2);
            if (!listeners.hasListener(listener)) {
                arrayList.add(listener);
            }
            ++n2;
        }
    }

    public void addListener(Listener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList(1);
        }
        this._listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this._listeners.remove(listener);
    }

    public void removeListener(int n) {
        int n2 = this._listeners.size();
        int n3 = 0;
        while (n3 < n2) {
            Listener listener = (Listener)this._listeners.get(n3);
            if (listener.getId() == n) {
                this._listeners.remove(n3);
                break;
            }
            ++n3;
        }
    }

    public int getListenerCount() {
        return this._listeners == null ? 0 : this._listeners.size();
    }

    public Listener getListener(int n) {
        return (Listener)this._listeners.get(n);
    }

    private boolean hasListener(Listener listener) {
        return this._listeners != null && this._listeners.contains(listener);
    }

    public boolean isIncludeChilds() {
        return this._includeChilds;
    }

    public void setIncludeChilds(boolean bl) {
        this._includeChilds = bl;
    }
}

