/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.model;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.util.BitField;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerAddin;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.model.Listener;
import oracle.jdevimpl.runner.uidebug.debugger.model.Listeners;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqAddListener;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqFullTree;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqHighlight;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqValidate;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqVisible;
import oracle.jdevimpl.runner.uidebug.debugger.ui.DebuggerDockable;
import oracle.jdevimpl.runner.uidebug.debugger.ui.ListenersPanel;
import oracle.jdevimpl.runner.uidebug.debugger.ui.ShowListenersPanel;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public final class XComponent
extends DefaultMutableTreeNode
implements ActionListener {
    private final int _nID;
    private String _className;
    private Rectangle _bounds;
    private boolean _isVisible;
    private BufferedImage _bufferedImage;
    private Listeners _listeners;
    private static final String MENU_GOTOSOURCE = UIDebugArb.getString(37);
    private static final String MENU_WATCH = UIDebugArb.getString(38);
    private static final String MENU_INSPECT = UIDebugArb.getString(39);
    private static final String MENU_EVENTS = UIDebugArb.getString(40);
    private static final String MENU_HIGHLIGHT = UIDebugArb.getString(44);
    private static final String MENU_HIDE = UIDebugArb.getString(50);
    private static final String MENU_SHOW = UIDebugArb.getString(48);
    private static final String MENU_SHOW_LISTENERS = UIDebugArb.getString(42);
    private static final String MENU_VALIDATE = UIDebugArb.getString(46);

    public XComponent(int n) {
        this._nID = n;
    }

    public boolean equals(Object object) {
        return object instanceof XComponent && ((XComponent)object)._nID == this._nID;
    }

    public int compareTo(Object object) {
        XComponent xComponent = (XComponent)object;
        return this._nID - xComponent._nID;
    }

    public String toString() {
        return this._className + "(" + this._nID + ")";
    }

    public int getID() {
        return this._nID;
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String string) {
        this._className = string;
    }

    public Rectangle getBounds() {
        return this._bounds;
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this._bounds == null) {
            this._bounds = new Rectangle();
        }
        this._bounds.setRect(n, n2, n3, n4);
    }

    public BufferedImage getBufferedImage() {
        return this._bufferedImage;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        this._bufferedImage = bufferedImage;
    }

    public boolean isVisible() {
        return this._isVisible;
    }

    public boolean isShowing() {
        boolean bl = false;
        if (this.isVisible()) {
            TreeNode treeNode = this.getParent();
            if (treeNode instanceof XComponent) {
                XComponent xComponent = (XComponent)treeNode;
                bl = xComponent.isShowing();
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public void setVisible(boolean bl) {
        this._isVisible = bl;
    }

    private XComponent getXComponentAt(int n) {
        return (XComponent)this.getChildAt(n);
    }

    public Listeners getListeners() {
        if (this._listeners == null) {
            this._listeners = new Listeners();
        }
        return this._listeners;
    }

    public void paintComponent(Graphics2D graphics2D) {
        if (this.isVisible()) {
            graphics2D.drawRect(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
            int n = this.getChildCount();
            if (n != 0) {
                Shape shape = graphics2D.getClip();
                graphics2D.clipRect(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
                graphics2D.translate(this._bounds.x, this._bounds.y);
                int n2 = 0;
                while (n2 < n) {
                    this.getXComponentAt(n2).paintComponent(graphics2D);
                    ++n2;
                }
                graphics2D.translate(-this._bounds.x, -this._bounds.y);
                graphics2D.setClip(shape);
            }
        }
    }

    public Rectangle getLocation(boolean bl) {
        Rectangle rectangle = new Rectangle(this._bounds);
        TreeNode treeNode = this.getParent();
        while (treeNode instanceof XComponent) {
            XComponent xComponent = (XComponent)treeNode;
            rectangle.translate(xComponent._bounds.x, xComponent._bounds.y);
            if (bl && rectangle.intersects(xComponent._bounds)) {
                rectangle = rectangle.intersection(xComponent._bounds);
            }
            treeNode = treeNode.getParent();
        }
        return rectangle;
    }

    public XComponent searchComponentAt(int n, int n2) {
        XComponent xComponent = null;
        if (this.isVisible() && this._bounds.contains(n, n2)) {
            int n3 = this.getChildCount();
            int n4 = 0;
            while (xComponent == null && n4 < n3) {
                xComponent = this.getXComponentAt(n4).searchComponentAt(n - this._bounds.x, n2 - this._bounds.y);
                ++n4;
            }
            if (xComponent == null) {
                xComponent = this;
            }
        }
        return xComponent;
    }

    public JMenuItem[] getMenuItems() {
        DebuggerProcess debuggerProcess = Debugger.getInstance().getActiveDebuggerProcess();
        boolean bl = BitField.isSet((int)debuggerProcess.getStateMask(), (int)2);
        JMenuItem jMenuItem = this.createMenuItem(MENU_GOTOSOURCE, true);
        JMenuItem jMenuItem2 = this.createMenuItem(MENU_WATCH, true);
        JMenuItem jMenuItem3 = this.createMenuItem(MENU_INSPECT, true);
        JMenuItem jMenuItem4 = this.createMenuItem(MENU_EVENTS, bl ^ true);
        JMenuItem jMenuItem5 = this.createMenuItem(MENU_HIGHLIGHT, bl ^ true);
        JMenuItem jMenuItem6 = this.createMenuItem(MENU_VALIDATE, bl ^ true);
        JMenuItem jMenuItem7 = this.createMenuItem(this.isVisible() ? MENU_HIDE : MENU_SHOW, bl ^ true);
        JMenuItem jMenuItem8 = this.createMenuItem(MENU_SHOW_LISTENERS, bl ^ true);
        JMenuItem[] jMenuItemArray = new JMenuItem[]{jMenuItem, null, jMenuItem2, jMenuItem3, null, jMenuItem4, jMenuItem8, null, jMenuItem5, jMenuItem7};
        return jMenuItemArray;
    }

    private JMenuItem createMenuItem(String string, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(bl);
        return jMenuItem;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        DebuggerProcess debuggerProcess = Debugger.getInstance().getActiveDebuggerProcess();
        if (string == MENU_WATCH) {
            this.whenWatch();
        } else if (string == MENU_INSPECT) {
            this.whenInspect();
        } else if (string == MENU_GOTOSOURCE) {
            this.whenGoToSource();
        } else if (string == MENU_EVENTS) {
            this.whenEvents();
        } else if (string == MENU_HIGHLIGHT) {
            debuggerProcess.pushRequest(new ReqHighlight(this.getID(), 2));
        } else if (string == MENU_VALIDATE) {
            debuggerProcess.pushRequest(new ReqValidate(this.getID()));
        } else if (string == MENU_HIDE) {
            debuggerProcess.pushRequest(new ReqVisible(this.getID(), false));
            debuggerProcess.pushRequest(new ReqFullTree());
        } else if (string == MENU_SHOW) {
            debuggerProcess.pushRequest(new ReqVisible(this.getID(), true));
            debuggerProcess.pushRequest(new ReqFullTree());
        } else if (string == MENU_SHOW_LISTENERS) {
            this.whenShowListners();
        }
    }

    private void whenWatch() {
        DebuggerProcess debuggerProcess = Debugger.getInstance().getActiveDebuggerProcess();
        debuggerProcess.addWatch(this);
    }

    private void whenInspect() {
        DebuggerProcess debuggerProcess = Debugger.getInstance().getActiveDebuggerProcess();
        debuggerProcess.addInspect(this);
    }

    public void whenGoToSource() {
        DebuggerProcess debuggerProcess = Debugger.getInstance().getActiveDebuggerProcess();
        debuggerProcess.whenShowSourceFile(this);
    }

    private void whenEvents() {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        Listeners listeners = ListenersPanel.showDialog((JFrame)ideMainWindow, this._nID);
        if (listeners != null) {
            DebuggerProcess debuggerProcess = Debugger.getInstance().getActiveDebuggerProcess();
            int n = listeners.getListenerCount();
            int n2 = 0;
            while (n2 < n) {
                Listener listener = listeners.getListener(n2);
                ReqAddListener reqAddListener = new ReqAddListener(this.getID(), listener.getType(), listeners.isIncludeChilds());
                debuggerProcess.pushRequest(reqAddListener);
                ++n2;
            }
            if (n != 0) {
                DebuggerAddin debuggerAddin = DebuggerAddin.getInstance();
                DebuggerDockable debuggerDockable = debuggerAddin.getListeners();
                debuggerDockable.show();
            }
        }
    }

    private void whenShowListners() {
        ShowListenersPanel.showDialog((JFrame)Ide.getMainWindow(), this);
    }
}

