/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.reply;

import java.io.IOException;
import java.util.Arrays;
import oracle.ide.util.Pair;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.model.XComponent;
import oracle.jdevimpl.runner.uidebug.debugger.reply.DefaultReply;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public final class ListenerMessage
extends DefaultReply {
    public static final int REQUEST_TYPE = 100;
    private int _rootID;
    private int _listenerRefID;
    private XComponent _xComponent;
    private Pair[] _properties;
    private String _methodName;
    private DebuggerProcess _debuggerProcess;
    private int _componentID;

    public ListenerMessage(int n) {
        super(n, 100);
    }

    public void readReply(DebugStream debugStream) throws IOException {
        this._rootID = debugStream.readInt();
        this._listenerRefID = debugStream.readInt();
        this._componentID = debugStream.readInt();
        Debugger debugger = Debugger.getInstance();
        this._debuggerProcess = debugger.getActiveDebuggerProcess();
        this._methodName = debugStream.readUTF();
        int n = debugStream.readInt();
        this._properties = new Pair[n];
        int n2 = 0;
        while (n2 < n) {
            String string = debugStream.readUTF();
            String string2 = debugStream.readUTF();
            this._properties[n2] = new Pair((Object)string, (Object)string2);
            ++n2;
        }
        Arrays.sort(this._properties);
    }

    public int getRootID() {
        return this._rootID;
    }

    public int getListenerRefID() {
        return this._listenerRefID;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public Pair[] getProperties() {
        return this._properties;
    }

    public XComponent getXComponent() {
        if (this._xComponent == null) {
            this._xComponent = this._debuggerProcess.searchReference(this._componentID);
        }
        return this._xComponent;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        XComponent xComponent = this.getXComponent();
        if (xComponent != null) {
            stringBuffer.append(xComponent.toString());
        } else {
            stringBuffer.append(UIDebugArb.getString(13));
        }
        stringBuffer.append(".");
        stringBuffer.append(this._methodName);
        stringBuffer.append("()");
        return stringBuffer.toString();
    }
}

