/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.request;

import java.io.IOException;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.Request;
import oracle.jdevimpl.runner.uidebug.debugger.model.Listener;
import oracle.jdevimpl.runner.uidebug.debugger.model.XComponent;
import oracle.jdevimpl.runner.uidebug.debugger.reply.Reply;

public final class ReqAddListener
extends Request
implements Reply {
    private static final int REQUEST_TYPE = 3;
    private final int _componentID;
    private final String _type;
    private final boolean _children;

    public ReqAddListener(int n, String string, boolean bl) {
        super(3, true);
        this._componentID = n;
        this._type = string;
        this._children = bl;
    }

    public void write(DebugStream debugStream) throws IOException {
        super.write(debugStream);
        debugStream.writeInt(this._componentID);
        debugStream.writeUTF(this._type);
        debugStream.writeBoolean(this._children);
    }

    public void readReply(DebugStream debugStream) throws IOException {
        int n = debugStream.readInt();
        Debugger debugger = Debugger.getInstance();
        DebuggerProcess debuggerProcess = debugger.getActiveDebuggerProcess();
        XComponent xComponent = debuggerProcess.searchReference(this._componentID);
        if (xComponent != null) {
            Listener listener = new Listener(this._type, n);
            xComponent.getListeners().addListener(listener);
        }
    }
}

