/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.request;

import java.io.IOException;
import java.util.ArrayList;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debugger.Request;
import oracle.jdevimpl.runner.uidebug.debugger.reply.Reply;

public final class ReqFindEventTypes
extends Request
implements Reply {
    private static final int REQUEST_TYPE = 8;
    private final int _componentID;
    private final boolean _includeChildren;
    private ArrayList _listeners;

    public ReqFindEventTypes(int n, boolean bl) {
        super(8, true);
        this._componentID = n;
        this._includeChildren = bl;
    }

    public void write(DebugStream debugStream) throws IOException {
        super.write(debugStream);
        debugStream.writeInt(this._componentID);
        debugStream.writeBoolean(this._includeChildren);
    }

    public void readReply(DebugStream debugStream) throws IOException {
        int n = debugStream.readInt();
        this._listeners = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            String string = debugStream.readUTF();
            this._listeners.add(string);
            ++n2;
        }
    }

    public int getListenerCount() {
        return this._listeners == null ? 0 : this._listeners.size();
    }

    public String getListener(int n) {
        return (String)this._listeners.get(n);
    }
}

