/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.request;

import java.io.IOException;
import java.util.ArrayList;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debugger.Request;
import oracle.jdevimpl.runner.uidebug.debugger.reply.Reply;

public final class ReqFindObjectListeners
extends Request
implements Reply {
    private static final int REQUEST_TYPE = 9;
    private final int _componentID;
    private ArrayList _objectListeners;

    public ReqFindObjectListeners(int n) {
        super(9, true);
        this._componentID = n;
    }

    public void write(DebugStream debugStream) throws IOException {
        super.write(debugStream);
        debugStream.writeInt(this._componentID);
    }

    public void readReply(DebugStream debugStream) throws IOException {
        int n = debugStream.readInt();
        this._objectListeners = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            String string = debugStream.readUTF();
            String string2 = debugStream.readUTF();
            Object[] objectArray = new Object[]{string, string2};
            this._objectListeners.add(objectArray);
            ++n2;
        }
    }

    public int getListenerCount() {
        return this._objectListeners == null ? 0 : this._objectListeners.size();
    }

    public String getListenerInterface(int n) {
        return this.getListener(n, 0);
    }

    public String getListenerClass(int n) {
        return this.getListener(n, 1);
    }

    private String getListener(int n, int n2) {
        Object[] objectArray = (Object[])this._objectListeners.get(n);
        return (String)objectArray[n2];
    }
}

