/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.tree.TreeNode;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.BitField;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessListener;
import oracle.jdevimpl.runner.uidebug.debugger.model.XComponent;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqFullTree;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public final class ComponentOutline
extends JPanel
implements ActionListener,
MouseInputListener,
PropertyChangeListener,
DebuggerProcessListener {
    private static final int ZOOM_MIN = -4;
    private static final int ZOOM_MAX = 4;
    private final DebuggerProcess _process;
    private TreeNode _root;
    private JComponent _ui;
    private JButton _butRefresh;
    private JButton _butZoomIn;
    private JButton _butZoomOut;
    private JScrollBar _sbHorz;
    private JScrollBar _sbVert;
    private double _scale;
    private int _zoom;
    private Point _lastMousePos;
    private final boolean _isAdjusting;
    private JCheckBox _cbImage;
    private JCheckBox _cbOutline;

    void $init$() {
        this._scale = 1.0;
        this._zoom = 0;
        this._lastMousePos = new Point();
        this._isAdjusting = false;
    }

    public ComponentOutline(DebuggerProcess debuggerProcess) {
        this.$init$();
        this._process = debuggerProcess;
        this._process.addDebuggerProcessListener(this);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this._process.addSelectionListener(this);
        this.setRequestFocusEnabled(true);
        this.setBackground(UIManager.getColor("window"));
    }

    public double getScale() {
        return this._scale;
    }

    private void setScale(double d) {
        JViewport jViewport = (JViewport)this.getParent();
        Point point = jViewport.getViewPosition();
        point.x = (int)((double)point.x / this._scale * d);
        point.y = (int)((double)point.y / this._scale * d);
        Dimension dimension = jViewport.getSize();
        Rectangle rectangle = this.getOuterBounds();
        int n = Math.max(0, (int)((double)rectangle.width * d) - dimension.width);
        int n2 = Math.max(0, (int)((double)rectangle.height * d) - dimension.height);
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.x > n) {
            point.x = n;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        if (point.y > n2) {
            point.y = n2;
        }
        this._scale = d;
        jViewport.setViewPosition(point);
        this.refresh();
    }

    private void refresh() {
        Dimension dimension = this.getBoundSize();
        this.setPreferredSize(dimension);
        this.revalidate();
        this.repaint();
    }

    private Dimension getBoundSize() {
        Rectangle rectangle = this.getOuterBounds();
        Dimension dimension = rectangle != null ? new Dimension((int)((double)rectangle.width * this._scale), (int)((double)rectangle.height * this._scale)) : new Dimension(0, 0);
        return dimension;
    }

    public JComponent getGUI() {
        if (this._ui == null) {
            this._ui = new JPanel(new GridBagLayout());
            Insets insets = new Insets(0, 0, 0, 0);
            this._butZoomIn = new JButton(IdeArb.getIcon((int)385));
            this._butZoomIn.setRequestFocusEnabled(false);
            this._butZoomIn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this._butZoomIn.setContentAreaFilled(false);
            this._butZoomIn.addActionListener(this);
            this._butZoomIn.setEnabled(this._root != null);
            this._butZoomOut = new JButton(IdeArb.getIcon((int)386));
            this._butZoomOut.setRequestFocusEnabled(false);
            this._butZoomOut.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this._butZoomOut.setContentAreaFilled(false);
            this._butZoomOut.addActionListener(this);
            this._butZoomOut.setEnabled(this._root != null);
            this._butRefresh = new JButton(IdeArb.getIcon((int)387));
            KeyStroke keyStroke = KeyStroke.getKeyStroke(116, 0);
            this.addKey(new MyAction(this._butRefresh), keyStroke);
            String string = UIDebugArb.getString(23) + " " + KeyUtil.toString((KeyStroke)keyStroke);
            this._butRefresh.setToolTipText(string);
            this._butRefresh.addActionListener(this);
            this._cbImage = this.createCheckBox(29, true);
            this._cbOutline = this.createCheckBox(28, false);
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            jToolBar.setRollover(true);
            jToolBar.add(this._butRefresh);
            jToolBar.add(this._cbImage);
            jToolBar.add(this._cbOutline);
            this._sbHorz = new JScrollBar(0);
            this._sbHorz.setUnitIncrement(10);
            this._sbVert = new JScrollBar(1);
            this._sbVert.setUnitIncrement(10);
            JScrollPane jScrollPane = new JScrollPane(this, 22, 32);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jScrollPane.addComponentListener(new 1(this, jScrollPane));
            jScrollPane.getViewport().setScrollMode(0);
            jScrollPane.setHorizontalScrollBar(this._sbHorz);
            jScrollPane.setVerticalScrollBar(this._sbVert);
            this._ui.add((Component)jToolBar, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 18, 2, insets, 0, 0));
            this._ui.add((Component)jScrollPane, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
            this._ui.add((Component)this._sbVert, new GridBagConstraints(4, 1, 1, 1, 0.0, 1.0, 18, 3, insets, 0, 0));
            this._ui.add((Component)this._sbHorz, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
            this._ui.add((Component)this._butZoomOut, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this._ui.add((Component)this._butZoomIn, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this.whenStateChanges();
        }
        return this._ui;
    }

    private JCheckBox createCheckBox(int n, boolean bl) {
        String string = UIDebugArb.getString(n);
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(bl);
        ResourceUtils.resButton((AbstractButton)jCheckBox, (String)string);
        int n2 = StringUtils.getMnemonicKeyCode((String)string);
        MyAction myAction = new MyAction(jCheckBox);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n2, 8);
        this.addKey(myAction, keyStroke);
        jCheckBox.addActionListener(this);
        return jCheckBox;
    }

    private void addKey(Action action, KeyStroke keyStroke) {
        InputMap inputMap = this._ui.getInputMap(1);
        inputMap.put(keyStroke, action);
        ActionMap actionMap = this._ui.getActionMap();
        actionMap.put(action, action);
    }

    private Rectangle getOuterBounds() {
        int n;
        Rectangle rectangle = null;
        if (this._root != null && (n = this._root.getChildCount()) != 0) {
            int n2 = 0;
            while (n2 < n) {
                XComponent xComponent = (XComponent)this._root.getChildAt(n2);
                if (xComponent.isVisible()) {
                    if (rectangle == null) {
                        rectangle = new Rectangle(xComponent.getBounds());
                    } else {
                        Rectangle rectangle2 = xComponent.getBounds();
                        int n3 = Math.min(rectangle.x, rectangle2.x);
                        int n4 = Math.max(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
                        int n5 = Math.min(rectangle.y, rectangle2.y);
                        int n6 = Math.max(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height);
                        rectangle.setBounds(n3, n5, n4 - n3, n6 - n5);
                    }
                }
                if (rectangle == null || rectangle.isEmpty()) {
                    rectangle = null;
                }
                ++n2;
            }
        }
        return rectangle;
    }

    private XComponent searchComponentAt(Point point) {
        Rectangle rectangle;
        XComponent xComponent = null;
        if (this.isVisible() && (rectangle = this.getOuterBounds()) != null) {
            int n = (int)((double)point.x / this._scale + (double)rectangle.x);
            int n2 = (int)((double)point.y / this._scale + (double)rectangle.y);
            int n3 = this._root.getChildCount();
            int n4 = 0;
            while (n4 < n3) {
                XComponent xComponent2 = (XComponent)this._root.getChildAt(n4);
                XComponent xComponent3 = xComponent2.searchComponentAt(n, n2);
                if (xComponent3 != null) {
                    xComponent = xComponent3;
                }
                ++n4;
            }
        }
        return xComponent;
    }

    private void selectAt(Point point) {
        XComponent xComponent = this.searchComponentAt(point);
        this._process.setSelection(xComponent);
    }

    private boolean handlePopupEvent(MouseEvent mouseEvent) {
        boolean bl = mouseEvent.isPopupTrigger();
        if (bl) {
            this.showContextMenu(mouseEvent.getPoint());
        }
        return bl;
    }

    private void showContextMenu(Point point) {
        XComponent xComponent = this._process.getSelection();
        if (xComponent != null) {
            JMenuItem[] jMenuItemArray = xComponent.getMenuItems();
            JPopupMenu jPopupMenu = new JPopupMenu();
            int n = 0;
            while (n < jMenuItemArray.length) {
                JMenuItem jMenuItem = jMenuItemArray[n];
                if (jMenuItem != null) {
                    jPopupMenu.add(jMenuItem);
                } else {
                    jPopupMenu.addSeparator();
                }
                ++n;
            }
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    private void whenRootChanges(TreeNode treeNode) {
        this._root = treeNode;
        if (this._ui != null) {
            boolean bl = treeNode != null;
            this._butZoomIn.setEnabled(bl);
            this._butZoomOut.setEnabled(bl);
            this._butRefresh.setEnabled(bl);
        }
        this.refresh();
    }

    private void zoomBy(int n) {
        int n2 = this._zoom + n;
        if (n2 >= -4 && n2 <= 4) {
            this._zoom = n2;
            this.setScale(Math.pow(2.0, this._zoom));
            this._butZoomOut.setEnabled(n2 != -4);
            this._butZoomIn.setEnabled(n2 != 4);
        }
    }

    private static void whenRefresh() {
        Debugger.getInstance().getActiveDebuggerProcess().pushRequest(new ReqFullTree());
    }

    private void whenImage() {
        if (!this._cbImage.isSelected()) {
            this._cbOutline.setSelected(true);
        }
        this.repaint();
    }

    private void whenOutline() {
        if (!this._cbOutline.isSelected()) {
            this._cbImage.setSelected(true);
        }
        this.repaint();
    }

    private void whenStateChanges() {
        if (this._butRefresh != null) {
            boolean bl = BitField.isSet((int)this._process.getStateMask(), (int)2);
            boolean bl2 = BitField.isSet((int)this._process.getStateMask(), (int)1);
            this._butRefresh.setEnabled(bl2 && !bl);
        }
    }

    protected void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        Rectangle rectangle = this.getOuterBounds();
        if (rectangle != null) {
            Area area = new Area();
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            XComponent xComponent = this._process.getSelection();
            graphics2D.scale(this._scale, this._scale);
            graphics2D.translate(-rectangle.x, -rectangle.y);
            int n = this._root.getChildCount();
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.lightGray);
            int n2 = 0;
            while (n2 < n) {
                XComponent xComponent2 = (XComponent)this._root.getChildAt(n2);
                if (xComponent2.isVisible()) {
                    Rectangle rectangle2 = xComponent2.getBounds();
                    area.add(new Area(rectangle2));
                    BufferedImage bufferedImage = xComponent2.getBufferedImage();
                    if (this._cbImage.isSelected() && bufferedImage != null) {
                        graphics2D.drawImage(bufferedImage, null, rectangle2.x, rectangle2.y);
                    } else {
                        graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    }
                }
                ++n2;
            }
            if (this._cbOutline.isSelected()) {
                graphics2D.setColor(Color.black);
                BasicStroke basicStroke = new BasicStroke(0.0f);
                graphics2D.setStroke(basicStroke);
                int n3 = 0;
                while (n3 < n) {
                    XComponent xComponent3 = (XComponent)this._root.getChildAt(n3);
                    xComponent3.paintComponent(graphics2D);
                    ++n3;
                }
            }
            if (xComponent != null) {
                Rectangle rectangle3 = xComponent.getLocation(false);
                area.subtract(new Area(rectangle3));
                graphics2D.setColor(new Color(255, 0, 0, 64));
                graphics2D.fill(area);
            }
            graphics2D.setColor(color);
            graphics2D.setTransform(affineTransform);
        }
    }

    public void rootChanging(DebuggerProcessEvent debuggerProcessEvent) {
    }

    public void stateChanged(DebuggerProcessEvent debuggerProcessEvent) {
        this.whenStateChanges();
    }

    public void rootChanged(DebuggerProcessEvent debuggerProcessEvent) {
        TreeNode treeNode = debuggerProcessEvent.getSource().getWindowsRoot();
        this.whenRootChanges(treeNode);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "SELECTION") {
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        XComponent xComponent;
        if (!this.handlePopupEvent(mouseEvent) && mouseEvent.getClickCount() == 2 && (xComponent = this.searchComponentAt(mouseEvent.getPoint())) != null) {
            mouseEvent.consume();
            xComponent.whenGoToSource();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        JViewport jViewport = (JViewport)this.getParent();
        Point point = jViewport.getViewPosition();
        Point point2 = mouseEvent.getPoint();
        this._lastMousePos.setLocation(point2.x - point.x, point2.y - point.y);
        this.selectAt(point2);
        this.handlePopupEvent(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        JViewport jViewport = (JViewport)this.getParent();
        Point point = jViewport.getViewPosition();
        Dimension dimension = jViewport.getSize();
        Dimension dimension2 = jViewport.getViewSize();
        Point point2 = mouseEvent.getPoint();
        point2.x -= point.x;
        point2.y -= point.y;
        point.translate(this._lastMousePos.x - point2.x, this._lastMousePos.y - point2.y);
        int n = Math.max(0, dimension2.width - dimension.width);
        int n2 = Math.max(0, dimension2.height - dimension.height);
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.x > n) {
            point.x = n;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        if (point.y > n2) {
            point.y = n2;
        }
        jViewport.setViewPosition(point);
        this._lastMousePos = point2;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.handlePopupEvent(mouseEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._butRefresh) {
            ComponentOutline.whenRefresh();
        } else if (object == this._butZoomIn) {
            this.zoomBy(1);
        } else if (object == this._butZoomOut) {
            this.zoomBy(-1);
        } else if (object == this._cbImage) {
            this.whenImage();
        } else if (object == this._cbOutline) {
            this.whenOutline();
        }
    }

    private void myActionPerformed(MyAction myAction) {
        if (myAction._src == this._cbImage) {
            this._cbImage.setSelected(this._cbImage.isSelected() ^ true);
            this.whenImage();
        } else if (myAction._src == this._cbOutline) {
            this._cbOutline.setSelected(this._cbOutline.isSelected() ^ true);
            this.whenOutline();
        } else if (myAction._src == this._butRefresh) {
            ComponentOutline.whenRefresh();
        }
    }

    static JScrollBar ra$_sbHorz(ComponentOutline componentOutline) {
        return componentOutline._sbHorz;
    }

    static JScrollBar ra$_sbVert(ComponentOutline componentOutline) {
        return componentOutline._sbVert;
    }

    static void mav$myActionPerformed(ComponentOutline componentOutline, MyAction myAction) {
        componentOutline.myActionPerformed(myAction);
    }

    public final class 1
    implements ComponentListener {
        private final /* synthetic */ JScrollPane v$sp;
        final /* synthetic */ ComponentOutline this$0;

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            Dimension dimension = this.v$sp.getViewport().getExtentSize();
            ComponentOutline.ra$_sbHorz(this.this$0).setBlockIncrement(dimension.width);
            ComponentOutline.ra$_sbVert(this.this$0).setBlockIncrement(dimension.height);
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public 1(ComponentOutline componentOutline, JScrollPane jScrollPane) {
            this.v$sp = jScrollPane;
            this.this$0 = componentOutline;
        }
    }

    public final class MyAction
    extends AbstractAction {
        final JComponent _src;

        MyAction(JComponent jComponent) {
            this._src = jComponent;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ComponentOutline.mav$myActionPerformed(ComponentOutline.this, this);
        }
    }
}

