/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.BitField;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessListener;
import oracle.jdevimpl.runner.uidebug.debugger.model.XComponent;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqFullTree;
import oracle.jdevimpl.runner.uidebug.debugger.ui.ComponentTreeRenderer;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public final class ComponentTree
implements ActionListener,
MouseListener,
PropertyChangeListener,
TreeSelectionListener,
DebuggerProcessListener {
    private final DebuggerProcess _process;
    private final DefaultTreeModel _model;
    private final TreeSelectionModel _selModel;
    private JComponent _ui;
    private JTree _tree;
    private ArrayList _expandedRows;
    private JScrollPane _scrollPane;
    private Point _ptScroll;
    private JButton _butRefresh;

    public ComponentTree(DebuggerProcess debuggerProcess) {
        this._process = debuggerProcess;
        this._model = new DefaultTreeModel(debuggerProcess.getWindowsRoot());
        this._selModel = new DefaultTreeSelectionModel();
        this._selModel.setSelectionMode(1);
        this._selModel.addTreeSelectionListener(this);
        this._process.addSelectionListener(this);
        debuggerProcess.addDebuggerProcessListener(this);
    }

    public JComponent getGUI() {
        if (this._ui == null) {
            this._ui = new JPanel(new BorderLayout());
            this._scrollPane = new JScrollPane(this.getJTree());
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this._butRefresh = new JButton(IdeArb.getIcon((int)387));
            this._butRefresh.setEnabled(true);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(116, 0);
            this.addKey(new MyAction(this._butRefresh), keyStroke);
            String string = UIDebugArb.getString(23) + " " + KeyUtil.toString((KeyStroke)keyStroke);
            this._butRefresh.setToolTipText(string);
            this._butRefresh.addActionListener(this);
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            jToolBar.setRollover(true);
            jToolBar.add(this._butRefresh);
            this._ui.add((Component)jToolBar, "North");
            this._ui.add((Component)this._scrollPane, "Center");
            this.whenStateChanges();
        }
        return this._ui;
    }

    private void addKey(Action action, KeyStroke keyStroke) {
        InputMap inputMap = this._ui.getInputMap(1);
        inputMap.put(keyStroke, action);
        ActionMap actionMap = this._ui.getActionMap();
        actionMap.put(action, action);
    }

    private JTree getJTree() {
        if (this._tree == null) {
            this._tree = new JTree(this._model);
            this._tree.setToggleClickCount(999);
            this._tree.setSelectionModel(this._selModel);
            this._tree.setRootVisible(false);
            this._tree.setShowsRootHandles(true);
            this._tree.setCellRenderer(new ComponentTreeRenderer());
            this._tree.addMouseListener(this);
        }
        return this._tree;
    }

    private void recGetExpandedRows(TreePath treePath, ArrayList arrayList) {
        if (this._tree.isExpanded(treePath)) {
            arrayList.add(treePath);
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            int n = treeNode.getChildCount();
            int n2 = 0;
            while (n2 < n) {
                TreeNode treeNode2 = treeNode.getChildAt(n2);
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                this.recGetExpandedRows(treePath2, arrayList);
                ++n2;
            }
        }
    }

    private void expandRows(ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = (TreePath)arrayList.get(n2);
            this._tree.expandPath(treePath);
            ++n2;
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object;
        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof XComponent) {
            XComponent xComponent = (XComponent)object;
            this._process.setSelection(xComponent);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "SELECTION") {
            this.whenSelectionChanges(propertyChangeEvent);
        }
    }

    private void whenSelectionChanges(PropertyChangeEvent propertyChangeEvent) {
        XComponent xComponent = (XComponent)propertyChangeEvent.getNewValue();
        this.setSelection(xComponent);
    }

    private void setSelection(XComponent xComponent) {
        if (xComponent == null) {
            this._selModel.clearSelection();
        } else {
            Object[] objectArray = this._model.getPathToRoot(xComponent);
            TreePath treePath = new TreePath(objectArray);
            this._selModel.setSelectionPath(treePath);
            if (this._tree != null) {
                this._tree.scrollPathToVisible(treePath);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showContextMenu(mouseEvent.getPoint());
        } else if (mouseEvent.getClickCount() == 2) {
            Object object;
            mouseEvent.consume();
            TreePath treePath = this._tree.getSelectionPath();
            if (treePath != null && (object = treePath.getLastPathComponent()) instanceof XComponent) {
                XComponent xComponent = (XComponent)object;
                xComponent.whenGoToSource();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showContextMenu(mouseEvent.getPoint());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showContextMenu(mouseEvent.getPoint());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void showContextMenu(Point point) {
        Object object;
        TreePath treePath = this._tree.getPathForLocation(point.x, point.y);
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof XComponent) {
            this._selModel.setSelectionPath(treePath);
            XComponent xComponent = (XComponent)object;
            JMenuItem[] jMenuItemArray = xComponent.getMenuItems();
            JPopupMenu jPopupMenu = new JPopupMenu();
            int n = 0;
            while (n < jMenuItemArray.length) {
                JMenuItem jMenuItem = jMenuItemArray[n];
                if (jMenuItem != null) {
                    jPopupMenu.add(jMenuItem);
                } else {
                    jPopupMenu.addSeparator();
                }
                ++n;
            }
            jPopupMenu.show(this.getJTree(), point.x, point.y);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._butRefresh) {
            ComponentTree.whenRefresh();
        }
    }

    private void myActionPerformed(MyAction myAction) {
        if (myAction._src == this._butRefresh) {
            ComponentTree.whenRefresh();
        }
    }

    private static void whenRefresh() {
        DebuggerProcess debuggerProcess = Debugger.getInstance().getActiveDebuggerProcess();
        if (debuggerProcess != null) {
            debuggerProcess.pushRequest(new ReqFullTree());
        }
    }

    public void rootChanging(DebuggerProcessEvent debuggerProcessEvent) {
        TreeNode treeNode = (TreeNode)this._model.getRoot();
        this._expandedRows = new ArrayList(100);
        this.recGetExpandedRows(new TreePath(treeNode), this._expandedRows);
        this._ptScroll = this._scrollPane.getViewport().getViewPosition();
    }

    public void rootChanged(DebuggerProcessEvent debuggerProcessEvent) {
        DebuggerProcess debuggerProcess = debuggerProcessEvent.getSource();
        this._model.nodeStructureChanged(debuggerProcess.getWindowsRoot());
        if (this._expandedRows != null) {
            this.expandRows(this._expandedRows);
        }
        this._scrollPane.getViewport().setViewPosition(this._ptScroll);
        XComponent xComponent = debuggerProcess.getSelection();
        this.setSelection(xComponent);
    }

    public void stateChanged(DebuggerProcessEvent debuggerProcessEvent) {
        this.whenStateChanges();
    }

    private void whenStateChanges() {
        if (this._butRefresh != null) {
            boolean bl = BitField.isSet((int)this._process.getStateMask(), (int)2);
            boolean bl2 = BitField.isSet((int)this._process.getStateMask(), (int)1);
            this._butRefresh.setEnabled(bl2 && !bl);
        }
    }

    static void mav$myActionPerformed(ComponentTree componentTree, MyAction myAction) {
        componentTree.myActionPerformed(myAction);
    }

    public final class MyAction
    extends AbstractAction {
        final JComponent _src;

        MyAction(JComponent jComponent) {
            this._src = jComponent;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ComponentTree.mav$myActionPerformed(ComponentTree.this, this);
        }
    }
}

