/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.ide.Context;
import oracle.ide.docking.DockableWindow;
import oracle.ide.view.View;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerListener;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public abstract class DebuggerDockable
extends DockableWindow
implements DebuggerListener {
    private JComponent _ui;

    public DebuggerDockable(String string) {
        super("UIDebugger." + string);
    }

    public final Context getContext(EventObject eventObject) {
        return Context.newIdeContext((View)this, (EventObject)eventObject);
    }

    public final String getTitleName() {
        return this.getTabName();
    }

    public final String getMenuTitle() {
        return DebuggerDockable.isUIDebugging() ? super.getMenuTitle() : null;
    }

    public final Component getGUI() {
        JComponent jComponent = null;
        if (DebuggerDockable.isUIDebugging()) {
            if (this._ui == null) {
                this._ui = new JLabel(UIDebugArb.getString(36));
                this._ui.setLayout(new BorderLayout());
                DebuggerProcess debuggerProcess = Debugger.getInstance().getActiveDebuggerProcess();
                if (debuggerProcess != null) {
                    this.attachUI(debuggerProcess);
                }
                Debugger.getInstance().addDebuggerListener(this);
            }
            jComponent = this._ui;
        }
        return jComponent;
    }

    public final void debuggerProcessActivated(DebuggerEvent debuggerEvent) {
        DebuggerProcess debuggerProcess = debuggerEvent.getDebuggerProcess();
        if (debuggerProcess != null) {
            this.attachUI(debuggerProcess);
        }
    }

    public final void debuggerProcessCreated(DebuggerEvent debuggerEvent) {
    }

    public final void debuggerProcessDied(DebuggerEvent debuggerEvent) {
        DebuggerProcess debuggerProcess = debuggerEvent.getDebuggerProcess();
        if (this.isDebuggerUICreated(debuggerProcess)) {
            this._ui.remove(this.getDebuggerUI(debuggerProcess));
        }
    }

    private void attachUI(DebuggerProcess debuggerProcess) {
        JComponent jComponent = this.getDebuggerUI(debuggerProcess);
        if (jComponent.getParent() != this._ui) {
            this._ui.add((Component)jComponent, "Center");
            this._ui.revalidate();
        }
    }

    protected abstract JComponent getDebuggerUI(DebuggerProcess var1);

    protected abstract boolean isDebuggerUICreated(DebuggerProcess var1);

    private static boolean isUIDebugging() {
        Debugger debugger = Debugger.getInstance();
        int n = debugger.getDebuggerProcessCount();
        return n != 0;
    }
}

