/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.Pair;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessListener;
import oracle.jdevimpl.runner.uidebug.debugger.events.ReplyEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.ReplyListener;
import oracle.jdevimpl.runner.uidebug.debugger.model.XComponent;
import oracle.jdevimpl.runner.uidebug.debugger.reply.ListenerMessage;
import oracle.jdevimpl.runner.uidebug.debugger.reply.Reply;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqRemoveListener;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public final class ListenersOutput
implements ActionListener,
MouseListener,
TreeSelectionListener,
ReplyListener,
DebuggerProcessListener {
    private static final String MENU_CLEAR = UIDebugArb.getString(35);
    private static final String MENU_REMOVE = UIDebugArb.getString(34);
    private final DebuggerProcess _process;
    private JComponent _UI;
    private JTree _tree;
    private final DefaultMutableTreeNode _root;
    private DefaultListSelectionModel _selModel;
    private final boolean _rootExpanded;

    void $init$() {
        this._rootExpanded = false;
    }

    public ListenersOutput(DebuggerProcess debuggerProcess) {
        this.$init$();
        this._process = debuggerProcess;
        this._root = new DefaultMutableTreeNode();
        this._process.getReceiveQueue().addReplyListener(this);
        this._process.addDebuggerProcessListener(this);
    }

    public JComponent getGUI() {
        if (this._UI == null) {
            this._tree = new JTree(this._root);
            this._tree.setRootVisible(false);
            this._tree.setShowsRootHandles(true);
            this._selModel = new DefaultListSelectionModel();
            this._selModel.setSelectionMode(0);
            this._tree.addTreeSelectionListener(this);
            this._tree.addMouseListener(this);
            this._UI = new JScrollPane(this._tree);
            this._UI.setBorder(BorderFactory.createEmptyBorder());
        }
        return this._UI;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        XComponent xComponent;
        ListenerMessage listenerMessage = this.getSelectedMessage();
        if (listenerMessage != null && (xComponent = listenerMessage.getXComponent()) != null) {
            this._process.setSelection(xComponent);
        }
    }

    private ListenerMessage getSelectedMessage() {
        ListenerMessage listenerMessage = null;
        TreePath treePath = this._tree.getSelectionPath();
        if (treePath != null) {
            int n = treePath.getPathCount();
            int n2 = n - 1;
            while (n2 > 0) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(n2);
                if (defaultMutableTreeNode.getUserObject() instanceof ListenerMessage) {
                    listenerMessage = (ListenerMessage)defaultMutableTreeNode.getUserObject();
                }
                --n2;
            }
        }
        return listenerMessage;
    }

    public void replyReceived(ReplyEvent replyEvent) {
        Reply reply = replyEvent.getReply();
        switch (reply.getRequestType()) {
            case 100: {
                this.whenNewEvent((ListenerMessage)reply);
            }
        }
    }

    private void whenNewEvent(ListenerMessage listenerMessage) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(listenerMessage);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this._tree.getModel();
        Pair[] pairArray = listenerMessage.getProperties();
        int n = 0;
        while (n < pairArray.length) {
            Pair pair = pairArray[n];
            String string = pair.first + " = " + pair.second;
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(string));
            ++n;
        }
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, this._root, this._root.getChildCount());
        this._tree.expandPath(new TreePath(this._root));
        int n2 = this._tree.getRowCount() - 1;
        Rectangle rectangle = this._tree.getRowBounds(n2);
        this._tree.scrollRectToVisible(rectangle);
    }

    private void showContextMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(MENU_CLEAR);
        jMenuItem.addActionListener(this);
        JMenuItem jMenuItem2 = new JMenuItem(MENU_REMOVE);
        jMenuItem2.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        Point point = GraphicsUtils.getPopupMenuShowPoint((JPopupMenu)jPopupMenu, (MouseEvent)mouseEvent);
        Component component = mouseEvent.getComponent();
        jPopupMenu.show(component, point.x, point.y);
    }

    private void whenMouseButton(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showContextMenu(mouseEvent);
        }
    }

    private void whenClear() {
        this._root.removeAllChildren();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this._tree.getModel();
        defaultTreeModel.reload();
    }

    private void whenRemove() {
        ListenerMessage listenerMessage = this.getSelectedMessage();
        if (listenerMessage != null) {
            int n = listenerMessage.getListenerRefID();
            ReqRemoveListener reqRemoveListener = new ReqRemoveListener(n);
            DebuggerProcess debuggerProcess = Debugger.getInstance().getActiveDebuggerProcess();
            int n2 = listenerMessage.getRootID();
            XComponent xComponent = debuggerProcess.searchReference(n2);
            xComponent.getListeners().removeListener(n);
            debuggerProcess.pushRequest(reqRemoveListener);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.whenMouseButton(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.whenMouseButton(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.whenMouseButton(mouseEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (MENU_CLEAR.equals(string)) {
            this.whenClear();
        } else if (MENU_REMOVE.equals(string)) {
            this.whenRemove();
        }
    }

    public void rootChanging(DebuggerProcessEvent debuggerProcessEvent) {
    }

    public void stateChanged(DebuggerProcessEvent debuggerProcessEvent) {
    }

    public void rootChanged(DebuggerProcessEvent debuggerProcessEvent) {
        if (this._UI != null) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this._tree.getModel();
            defaultTreeModel.nodeStructureChanged(this._root);
        }
    }
}

