/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.events.ReplyEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.ReplyListener;
import oracle.jdevimpl.runner.uidebug.debugger.model.Listener;
import oracle.jdevimpl.runner.uidebug.debugger.model.Listeners;
import oracle.jdevimpl.runner.uidebug.debugger.reply.Reply;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqFindEventTypes;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public final class ListenersPanel
extends JPanel
implements ItemListener,
ReplyListener {
    private final int _componentID;
    private final JCheckBox _children;
    private final JList _list;

    private ListenersPanel(int n) {
        this.setLayout(new BorderLayout());
        this._componentID = n;
        DefaultListModel defaultListModel = new DefaultListModel();
        this._list = new JList(defaultListModel);
        this._children = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._children, (String)UIDebugArb.getString(53));
        this._children.addItemListener(this);
        this.add((Component)new JScrollPane(this._list), "Center");
        this.add((Component)this._children, "South");
    }

    public static Listeners showDialog(JFrame jFrame, int n) {
        Listeners listeners = null;
        ListenersPanel listenersPanel = new ListenersPanel(n);
        String string = UIDebugArb.getString(52);
        HelpSystem.getHelpSystem().registerTopic((JComponent)listenersPanel, "f1_xray_eventclasses_dlog_html");
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)jFrame, string, 7);
        jEWTDialog.setInitialFocus((Component)listenersPanel._list);
        jEWTDialog.setContent((Component)listenersPanel);
        jEWTDialog.setResizable(true);
        listenersPanel.refresh();
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            Object[] objectArray = listenersPanel._list.getSelectedValues();
            boolean bl = listenersPanel._children.getModel().isSelected();
            listeners = new Listeners(objectArray, bl);
        }
        return listeners;
    }

    private void refresh() {
        DebuggerProcess debuggerProcess = Debugger.getInstance().getActiveDebuggerProcess();
        boolean bl = this._children.getModel().isSelected();
        this.setUIEnabled(false);
        ReqFindEventTypes reqFindEventTypes = new ReqFindEventTypes(this._componentID, bl);
        debuggerProcess.getReceiveQueue().addReplyListener(this);
        debuggerProcess.pushRequest(reqFindEventTypes);
    }

    private void setUIEnabled(boolean bl) {
        this._list.setEnabled(bl);
        this._children.setEnabled(bl);
        Cursor cursor = bl ? null : Cursor.getPredefinedCursor(3);
        this._children.setCursor(cursor);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.refresh();
    }

    public void replyReceived(ReplyEvent replyEvent) {
        Reply reply = replyEvent.getReply();
        if (reply instanceof ReqFindEventTypes) {
            DebuggerProcess debuggerProcess = Debugger.getInstance().getActiveDebuggerProcess();
            debuggerProcess.getReceiveQueue().removeReplyListener(this);
            ReqFindEventTypes reqFindEventTypes = (ReqFindEventTypes)reply;
            DefaultListModel defaultListModel = (DefaultListModel)this._list.getModel();
            defaultListModel.removeAllElements();
            int n = reqFindEventTypes.getListenerCount();
            int n2 = 0;
            while (n2 < n) {
                String string = reqFindEventTypes.getListener(n2);
                Listener listener = new Listener(string);
                defaultListModel.addElement(listener);
                ++n2;
            }
            this.setUIEnabled(true);
        }
    }
}

