/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Pair;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.events.ReplyEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.ReplyListener;
import oracle.jdevimpl.runner.uidebug.debugger.model.XComponent;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqFindObjectListeners;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public class ShowListenersPanel
extends JPanel
implements MouseListener,
TreeSelectionListener,
Runnable,
ActionListener,
ReplyListener {
    private static final String TYPE_ROOT = "r";
    private static final String TYPE_LISTENER_INTERFACE = "li";
    private static final String TYPE_LISTENER_CLASS = "lc";
    private static final String TYPE_LISTENER_METHOD = "lm";
    private DismissableJEWTDialog _container;
    private int _requestId;
    private DefaultMutableTreeNode _root;
    private JTree _tree;
    private JButton _butGoToSource;

    private ShowListenersPanel(int n) {
        super(new BorderLayout());
        this._requestId = n;
        DebuggerProcess debuggerProcess = this.getDebuggerProcess();
        debuggerProcess.getReceiveQueue().addReplyListener(this);
        this._root = new DefaultMutableTreeNode(new Pair((Object)"", (Object)TYPE_ROOT));
        JLabel jLabel = new JLabel();
        this._tree = new JTree(new DefaultTreeModel(this._root));
        this._tree.setCellRenderer(new 3());
        this._tree.addMouseListener(this);
        this._tree.setShowsRootHandles(true);
        this._tree.setRootVisible(false);
        this._tree.setEnabled(false);
        this._tree.setCursor(Cursor.getPredefinedCursor(3));
        this._tree.getSelectionModel().addTreeSelectionListener(this);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._tree, (String)UIDebugArb.getString(55));
        this.add((Component)jLabel, "North");
        this.add((Component)new JScrollPane(this._tree), "Center");
    }

    public static void showDialog(JFrame jFrame, XComponent xComponent) {
        DismissableJEWTDialog dismissableJEWTDialog;
        ReqFindObjectListeners reqFindObjectListeners = new ReqFindObjectListeners(xComponent.getID());
        ShowListenersPanel showListenersPanel = new ShowListenersPanel(reqFindObjectListeners.getRequestID());
        String string = UIDebugArb.getString(54);
        String string2 = MessageFormat.format(string, xComponent);
        HelpSystem.getHelpSystem().registerTopic((JComponent)showListenersPanel, "f1_xray_listendial_html");
        showListenersPanel._container = dismissableJEWTDialog = new DismissableJEWTDialog(jFrame, string2, 20);
        showListenersPanel._butGoToSource = new JButton();
        showListenersPanel._butGoToSource.setEnabled(false);
        ResourceUtils.resButton((AbstractButton)showListenersPanel._butGoToSource, (String)UIDebugArb.getString(56));
        showListenersPanel._butGoToSource.addActionListener(showListenersPanel);
        dismissableJEWTDialog.addCustomButton(showListenersPanel._butGoToSource);
        dismissableJEWTDialog.setContent(showListenersPanel);
        dismissableJEWTDialog.setResizable(true);
        DebuggerProcess debuggerProcess = Debugger.getInstance().getActiveDebuggerProcess();
        debuggerProcess.pushRequest(reqFindObjectListeners);
        WizardLauncher.runDialog((JDialog)((Object)dismissableJEWTDialog));
    }

    private DebuggerProcess getDebuggerProcess() {
        return Debugger.getInstance().getActiveDebuggerProcess();
    }

    public void replyReceived(ReplyEvent replyEvent) {
        if (this._requestId == replyEvent.getReply().getRequestID()) {
            DebuggerProcess debuggerProcess = this.getDebuggerProcess();
            debuggerProcess.getReceiveQueue().removeReplyListener(this);
            debuggerProcess.invokeWhilePaused(new 2(this, replyEvent));
        }
    }

    private void fillTree(ReplyEvent replyEvent) {
        DebuggerProcess debuggerProcess = this.getDebuggerProcess();
        ReqFindObjectListeners reqFindObjectListeners = (ReqFindObjectListeners)replyEvent.getReply();
        int n = reqFindObjectListeners.getListenerCount();
        int n2 = 0;
        while (n2 < n) {
            String string;
            String string2 = reqFindObjectListeners.getListenerInterface(n2);
            ArrayList arrayList = debuggerProcess.filter(string2, string = reqFindObjectListeners.getListenerClass(n2));
            if (!arrayList.isEmpty()) {
                DefaultMutableTreeNode defaultMutableTreeNode = this.findInterface(string2);
                Pair pair = new Pair((Object)string, (Object)TYPE_LISTENER_CLASS);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(pair);
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    DebugMethodInfo debugMethodInfo = (DebugMethodInfo)arrayList.get(n3);
                    String string3 = debugMethodInfo.getNameWithoutClassOrSignature();
                    Pair pair2 = new Pair((Object)string3, (Object)debugMethodInfo);
                    Pair pair3 = new Pair((Object)pair2, (Object)TYPE_LISTENER_METHOD);
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(pair3);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    ++n3;
                }
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
            ++n2;
        }
        this.recSortTree(this._root);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this._tree.getModel();
        defaultTreeModel.reload();
        this._tree.setEnabled(true);
        this._tree.setCursor(null);
        IdeUtil.expandAllTreeRows((JTree)this._tree);
    }

    private void recSortTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(defaultMutableTreeNode.getChildAt(n2));
            ++n2;
        }
        Collections.sort(arrayList, new 1());
        defaultMutableTreeNode.removeAllChildren();
        int n3 = 0;
        while (n3 < arrayList.size()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)arrayList.get(n3);
            this.recSortTree(defaultMutableTreeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            ++n3;
        }
    }

    private DefaultMutableTreeNode findInterface(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.searchInterface(string);
        if (defaultMutableTreeNode == null) {
            Pair pair = new Pair((Object)string, (Object)TYPE_LISTENER_INTERFACE);
            defaultMutableTreeNode = new DefaultMutableTreeNode(pair);
            this._root.add(defaultMutableTreeNode);
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode searchInterface(String string) {
        int n = this._root.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._root.getChildAt(n2);
            String string2 = defaultMutableTreeNode.getUserObject().toString();
            if (string.equals(string2)) {
                return defaultMutableTreeNode;
            }
            ++n2;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._butGoToSource) {
            this.whenGoToSource();
        }
    }

    private void whenGoToSource() {
        DismissableJEWTDialog.mav$dismiss(this._container);
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        TreeSelectionModel treeSelectionModel = this._tree.getSelectionModel();
        TreePath treePath = treeSelectionModel.getLeadSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Pair pair = (Pair)defaultMutableTreeNode.getUserObject();
        Pair pair2 = (Pair)pair.first;
        DebugMethodInfo debugMethodInfo = (DebugMethodInfo)pair2.second;
        DebuggerProcess debuggerProcess = this.getDebuggerProcess();
        debuggerProcess.whenShowSourceFile(debugMethodInfo);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreeSelectionModel treeSelectionModel = this._tree.getSelectionModel();
        boolean bl = false;
        TreePath treePath = treeSelectionModel.getLeadSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            bl = defaultMutableTreeNode.isLeaf();
        }
        this._butGoToSource.setEnabled(bl);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this._tree && mouseEvent.getClickCount() == 2 && this._butGoToSource.isEnabled()) {
            this.whenGoToSource();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    static void mav$fillTree(ShowListenersPanel showListenersPanel, ReplyEvent replyEvent) {
        showListenersPanel.fillTree(replyEvent);
    }

    private static final class DismissableJEWTDialog
    extends JEWTDialog {
        public DismissableJEWTDialog(Frame frame, String string, int n) {
            super(frame, string, n);
        }

        private void dismiss() {
            this.dismissDialog(false);
        }

        static void mav$dismiss(DismissableJEWTDialog dismissableJEWTDialog) {
            dismissableJEWTDialog.dismiss();
        }
    }

    public final class 3
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Pair pair = (Pair)defaultMutableTreeNode.getUserObject();
            Object object2 = pair.second;
            Icon icon = object2 == ShowListenersPanel.TYPE_LISTENER_INTERFACE ? JavaIcons.getIcon(1) : (object2 == ShowListenersPanel.TYPE_LISTENER_CLASS ? JavaIcons.getIcon(0) : (object2 == ShowListenersPanel.TYPE_LISTENER_METHOD ? JavaIcons.getIcon(3) : null));
            jLabel.setIcon(icon);
            return jLabel;
        }
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ ReplyEvent v$event;
        final /* synthetic */ ShowListenersPanel this$0;

        public void run() {
            ShowListenersPanel.mav$fillTree(this.this$0, this.v$event);
        }

        public 2(ShowListenersPanel showListenersPanel, ReplyEvent replyEvent) {
            this.v$event = replyEvent;
            this.this$0 = showListenersPanel;
        }
    }

    public final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)object2;
            Comparable comparable = (Comparable)defaultMutableTreeNode.getUserObject();
            Object object3 = defaultMutableTreeNode2.getUserObject();
            return comparable.compareTo(object3);
        }
    }
}

