/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.xslt;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.URLPathField;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdevimpl.runner.xslt.XSLTArb;
import oracle.jdevimpl.runner.xslt.XSLTConfiguration;

public final class XSLTPanel
extends JPanel
implements DocumentListener {
    private URLTextField inputFileField;
    private JButton inputFileButton;
    private JCheckBox showInputFileCheckBox;
    private URLTextField outputFileField;
    private JButton outputFileButton;
    private JCheckBox showOutputFileCheckBox;
    private URLPathField sourcePathField;
    private JButton sourcePathButton;
    private JTextField xsltOptionsTextField;
    private JEWTDialog dlg;

    XSLTPanel() {
        this(false);
    }

    private XSLTPanel(boolean bl) {
        JLabel jLabel = new JLabel();
        this.inputFileField = new URLTextField(null, false, false);
        this.inputFileButton = new JButton();
        this.showInputFileCheckBox = new JCheckBox();
        JLabel jLabel2 = new JLabel();
        this.outputFileField = new URLTextField(null, false, false);
        this.outputFileButton = new JButton();
        this.showOutputFileCheckBox = new JCheckBox();
        JLabel jLabel3 = new JLabel();
        this.sourcePathField = new URLPathField();
        this.sourcePathButton = new JButton();
        JLabel jLabel4 = new JLabel();
        this.xsltOptionsTextField = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.inputFileField, (String)XSLTArb.getString(7));
        this.inputFileField.setDialogTitle(XSLTArb.getString(9));
        ResourceUtils.resButton((AbstractButton)this.inputFileButton, (String)XSLTArb.getString(8));
        this.inputFileButton.addActionListener((ActionListener)this.inputFileField);
        ResourceUtils.resButton((AbstractButton)this.showInputFileCheckBox, (String)XSLTArb.getString(10));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.outputFileField, (String)XSLTArb.getString(11));
        this.outputFileField.setDialogTitle(XSLTArb.getString(13));
        ResourceUtils.resButton((AbstractButton)this.outputFileButton, (String)XSLTArb.getString(12));
        this.outputFileButton.addActionListener((ActionListener)this.outputFileField);
        ResourceUtils.resButton((AbstractButton)this.showOutputFileCheckBox, (String)XSLTArb.getString(14));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.sourcePathField, (String)XSLTArb.getString(15));
        this.sourcePathField.setEditTitle(XSLTArb.getString(17));
        ResourceUtils.resButton((AbstractButton)this.sourcePathButton, (String)XSLTArb.getString(16));
        this.sourcePathButton.addActionListener((ActionListener)this.sourcePathField);
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.xsltOptionsTextField, (String)XSLTArb.getString(18));
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this.inputFileField, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.inputFileButton, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)this.showInputFileCheckBox, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.add((Component)this.outputFileField, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.outputFileButton, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)this.showOutputFileCheckBox, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.add((Component)jLabel3, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.add((Component)this.sourcePathField, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.sourcePathButton, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)jLabel4, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.add((Component)this.xsltOptionsTextField, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (bl) {
            this.add((Component)new JLabel(), new GridBagConstraints(0, n, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.inputFileField.getDocument().addDocumentListener(this);
            this.outputFileField.getDocument().addDocumentListener(this);
            this.sourcePathField.getDocument().addDocumentListener(this);
        }
    }

    void loadFrom(Project project, XSLTConfiguration xSLTConfiguration) {
        URL uRL = J2eeSettings.getInstance(project).getHtmlRootDirectory();
        URL uRL2 = xSLTConfiguration.getInputFileURL();
        if (uRL2 != null) {
            this.inputFileField.setURL(uRL2);
        } else {
            this.inputFileField.setDefaultChooserURL(uRL);
        }
        this.showInputFileCheckBox.setSelected(xSLTConfiguration.isShowInputFile());
        URL uRL3 = xSLTConfiguration.getOutputFileURL();
        if (uRL3 != null) {
            this.outputFileField.setURL(uRL3);
        } else {
            this.outputFileField.setDefaultChooserURL(uRL);
        }
        this.showOutputFileCheckBox.setSelected(xSLTConfiguration.isShowOutputFile());
        URLPath uRLPath = xSLTConfiguration.getSourcePath();
        this.sourcePathField.setURLPath(uRLPath);
        this.xsltOptionsTextField.setText(xSLTConfiguration.getXSLTOptions());
    }

    void commitTo(XSLTConfiguration xSLTConfiguration) throws TraversalException {
        URL uRL = this.inputFileField.getURL();
        if (uRL == null) {
            xSLTConfiguration.setInputFileURL(uRL);
        } else if (uRL.getProtocol().equals("file")) {
            xSLTConfiguration.setInputFileURL(URLFileSystem.canonicalize((URL)uRL));
        }
        xSLTConfiguration.setShowInputFile(this.showInputFileCheckBox.isSelected());
        URL uRL2 = this.outputFileField.getURL();
        if (uRL2 == null) {
            xSLTConfiguration.setOutputFileURL(uRL2);
        } else if (uRL2.getProtocol().equals("file")) {
            xSLTConfiguration.setOutputFileURL(URLFileSystem.canonicalize((URL)uRL2));
        }
        xSLTConfiguration.setShowOutputFile(this.showOutputFileCheckBox.isSelected());
        try {
            URLPath uRLPath = this.sourcePathField.getURLPath();
            xSLTConfiguration.setSourcePath(uRLPath);
        }
        catch (URLPathField.BadEntryException badEntryException) {
            throw new TraversalException(ControlsArb.format(55, badEntryException.getBadEntry()));
        }
        xSLTConfiguration.setXSLTOptions(this.xsltOptionsTextField.getText());
    }

    void setJEWTDialog(JEWTDialog jEWTDialog) {
        this.dlg = jEWTDialog;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableOk();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableOk();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableOk();
    }

    private void enableOk() {
        if (this.dlg != null) {
            this.dlg.setOKButtonEnabled(this.canOk());
        }
    }

    private boolean canOk() {
        if (this.inputFileField.getURL() != null && this.outputFileField.getURL() != null) {
            try {
                this.sourcePathField.getURLPath();
                boolean bl = true;
                return bl;
            }
            catch (URLPathField.BadEntryException badEntryException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean veto() {
        URL uRL;
        String string = null;
        URL uRL2 = this.inputFileField.getURL();
        if (uRL2 == null) {
            string = XSLTArb.getString(19);
        }
        if (!uRL2.getProtocol().equals("file")) {
            string = XSLTArb.getString(20);
        }
        if ((uRL = this.outputFileField.getURL()) == null) {
            string = XSLTArb.getString(21);
        }
        if (!uRL.getProtocol().equals("file")) {
            string = XSLTArb.getString(22);
        }
        if (string != null) {
            String string2 = XSLTArb.getString(6);
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string, string2, 0);
            return true;
        }
        return false;
    }

    public static boolean showXSLTDialog(Project project) {
        XSLTConfiguration xSLTConfiguration = XSLTConfiguration.getInstance((PropertyStorage)project);
        XSLTPanel xSLTPanel = new XSLTPanel(true);
        String string = XSLTArb.getString(6);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)xSLTPanel, (Component)xSLTPanel.inputFileField, (String)string);
        xSLTPanel.setJEWTDialog(jEWTDialog);
        xSLTPanel.loadFrom(project, xSLTConfiguration);
        xSLTPanel.enableOk();
        HelpSystem.getHelpSystem().registerTopic((JComponent)xSLTPanel, "f1_projsetxsltrun_html");
        jEWTDialog.addVetoableChangeListener((VetoableChangeListener)new 1(xSLTPanel));
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            try {
                xSLTPanel.commitTo(xSLTConfiguration);
            }
            catch (Exception exception) {
                // empty catch block
            }
            project.markDirty(true);
            return true;
        }
        return false;
    }

    static boolean mav$veto(XSLTPanel xSLTPanel) {
        return xSLTPanel.veto();
    }

    public static final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ XSLTPanel v$xsltPanel;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent) && XSLTPanel.mav$veto(this.v$xsltPanel)) {
                throw new PropertyVetoException("no", propertyChangeEvent);
            }
        }

        public 1(XSLTPanel xSLTPanel) {
            this.v$xsltPanel = xSLTPanel;
        }
    }
}

