/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.xslt;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.panels.Navigable;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.Runner;
import oracle.ide.runner.SmartDataProvider;
import oracle.ide.runner.StarterFactory;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.runner.Source;
import oracle.jdeveloper.runner.xslt.XSLTStarterFactory;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.runner.xslt.XSLTArb;
import oracle.jdevimpl.runner.xslt.XSLTConfiguration;
import oracle.jdevimpl.runner.xslt.XSLTRunnerPanel;
import oracle.jdevimpl.runner.xslt.XSLTSmartDataProvider;
import oracle.jdevimpl.runner.xslt.XSLTSourceFinder;

public final class XSLTRunnerAddin
implements IdeListener,
Addin {
    private static File xsltJar;
    private static boolean firstTime;
    private static boolean firstTimeDebugging;
    public static final String CLASSNAME_XMLString = "$oracle.xml.xslt.XMLString";
    public static final String CLASSNAME_XMLNode = "$oracle.xml.xslt.XMLNode";

    public void initialize() {
        Ide.addIdeListener((IdeListener)this);
    }

    public void shutdown() {
    }

    public boolean canShutdown() {
        return true;
    }

    public void addinsLoaded(IdeEvent ideEvent) {
    }

    public void mainWindowOpened(IdeEvent ideEvent) {
        Ide.removeIdeListener((IdeListener)this);
        if (XSLTRunnerAddin.isXSLTDebuggingSupported()) {
            Runner runner = Runner.getRunner();
            if (runner != null) {
                runner.registerStarterFactory(XMLSourceNode.class, (StarterFactory)new XSLTStarterFactory());
                Navigable navigable = new Navigable(XSLTArb.getString(5), XSLTRunnerPanel.class);
                runner.addRunConfigurationLaunchNavigable(navigable);
            }
            Source.addSourceFinder(new XSLTSourceFinder());
        }
    }

    public void mainWindowClosing(IdeEvent ideEvent) {
    }

    private static boolean supportsJDWP(String string) {
        try {
            Object object;
            Method method;
            Class<?> clazz = Class.forName(string);
            if (clazz != null && (method = clazz.getMethod("supportsJDWP", null)) != null && (object = method.invoke(null, null)) instanceof Boolean) {
                boolean bl = (Boolean)object;
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static {
        firstTime = true;
        firstTimeDebugging = true;
    }

    public static synchronized File getXSLTJarForDebugging() {
        if (firstTime) {
            String string = Ide.getProperty((String)"XSLTDebuggerJarDirectory");
            if (string != null) {
                xsltJar = new File(string, "xmlparserv2.jar");
            } else if (XSLTRunnerAddin.supportsJDWP("oracle.xml.xslt.XSLProcessor") || XSLTRunnerAddin.supportsJDWP("oracle.xml.parser.v2.XSLProcessor")) {
                String string2 = Ide.getOracleHomeDirectory();
                if (!string2.endsWith(File.separator)) {
                    string2 = string2 + File.separator;
                }
                string2 = string2 + "lib" + File.separator;
                xsltJar = new File(string2, "xmlparserv2.jar");
            }
            firstTime = false;
        }
        return xsltJar;
    }

    public static boolean isXSLTDebuggingSupported() {
        return XSLTRunnerAddin.getXSLTJarForDebugging() != null;
    }

    public static String getFirstXSLTDebugOption(String string) {
        if (firstTimeDebugging) {
            firstTimeDebugging = false;
            Debugger debugger = Debugger.getDebugger();
            if (debugger != null) {
                debugger.addSmartDataProvider((SmartDataProvider)new XSLTSmartDataProvider());
            }
        }
        return "-Doracle.xml.xslt.jdwp=server=y,port=" + string;
    }

    public static String getLastXSLTDebugOption() {
        return "-debug";
    }

    public static String getXSLTPackage() {
        return "$oracle.xml.xslt";
    }

    public static String getXSLTPackage(URL uRL) {
        return XSLTRunnerAddin.getXSLTPackage();
    }

    public static boolean isXSLTStylesheet(DebugClassInfo debugClassInfo) {
        if (debugClassInfo != null && debugClassInfo.getLanguage() == 4) {
            String string = XSLTRunnerAddin.getXSLTPackage() + ".";
            String string2 = debugClassInfo.getName();
            if (string2.startsWith(string) && !string2.substring(string.length()).startsWith("XML")) {
                return true;
            }
        }
        return false;
    }

    private static String convertName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '_' && n + 1 < stringBuffer.length()) {
                switch (stringBuffer.charAt(n + 1)) {
                    default: {
                        n += 2;
                        break;
                    }
                    case '_': {
                        stringBuffer.replace(n, n + 2, "_");
                        ++n;
                        break;
                    }
                    case 'A': {
                        stringBuffer.replace(n, n + 2, File.separator);
                        ++n;
                        break;
                    }
                    case 'B': {
                        stringBuffer.replace(n, n + 2, ".");
                        ++n;
                        break;
                    }
                    case 'C': {
                        stringBuffer.replace(n, n + 2, "-");
                        ++n;
                        break;
                    }
                    case 'D': {
                        stringBuffer.replace(n, n + 2, " ");
                        ++n;
                        break;
                    }
                    case 'E': {
                        stringBuffer.replace(n, n + 2, ":");
                        ++n;
                        break;
                    }
                }
                continue;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getStylesheetName(DebugClassInfo debugClassInfo, boolean bl) {
        String string = debugClassInfo.getNameWithoutPackage();
        String string2 = XSLTRunnerAddin.convertName(string);
        if (bl) {
            if (string2.length() > 2 && string2.charAt(0) == File.separatorChar && string2.charAt(2) == ':') {
                string2 = string2.substring(1);
            }
        } else {
            int n = string2.lastIndexOf(File.separator);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
        }
        return string2;
    }

    public static String getTemplateName(DebugMethodInfo debugMethodInfo, DebugStackFrameInfo debugStackFrameInfo) {
        String string = debugMethodInfo.getNameWithoutClassOrSignature();
        if (string.startsWith("$$")) {
            DebugDataInfo debugDataInfo;
            DebugVariableInfo debugVariableInfo;
            if (debugStackFrameInfo != null && (debugVariableInfo = debugStackFrameInfo.getVariable("$matchPattern")) != null && (debugDataInfo = debugVariableInfo.getDataInfo()) instanceof DebugDataCompositeInfo) {
                String string2 = DebugShared.makeCourtesyValue((DebugDataCompositeInfo)debugDataInfo, false, false);
                int n = string2.indexOf(34) == -1 ? 25 : 24;
                return XSLTArb.format(n, string2);
            }
            return XSLTArb.format(23, string.substring(2));
        }
        return XSLTRunnerAddin.convertName(string);
    }

    public static Node getXSLTInputNode(Project project, boolean bl) {
        try {
            URL uRL;
            XSLTConfiguration xSLTConfiguration = XSLTConfiguration.getInstance((PropertyStorage)project);
            if ((!bl || xSLTConfiguration.isShowInputFile()) && (uRL = xSLTConfiguration.getInputFileURL()) != null) {
                Node node = NodeFactory.findOrCreate((URL)uRL);
                return node;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Node getXSLTOutputNode(Project project, boolean bl) {
        try {
            URL uRL;
            XSLTConfiguration xSLTConfiguration = XSLTConfiguration.getInstance((PropertyStorage)project);
            if ((!bl || xSLTConfiguration.isShowOutputFile()) && (uRL = xSLTConfiguration.getOutputFileURL()) != null) {
                Node node = NodeFactory.findOrCreate((URL)uRL);
                return node;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getXMLNodeTypeName(short s) {
        switch (s) {
            case 1: {
                return XSLTArb.getString(26);
            }
            case 2: {
                return XSLTArb.getString(27);
            }
            case 3: {
                return XSLTArb.getString(28);
            }
            case 4: {
                return XSLTArb.getString(29);
            }
            case 5: {
                return XSLTArb.getString(30);
            }
            case 6: {
                return XSLTArb.getString(31);
            }
            case 7: {
                return XSLTArb.getString(32);
            }
            case 8: {
                return XSLTArb.getString(33);
            }
            case 9: {
                return XSLTArb.getString(34);
            }
            case 10: {
                return XSLTArb.getString(35);
            }
            case 11: {
                return XSLTArb.getString(36);
            }
            case 12: {
                return XSLTArb.getString(37);
            }
        }
        return null;
    }

    public static boolean isXSLT(XMLSourceNode xMLSourceNode) {
        block15: {
            Reader reader = null;
            try {
                try {
                    reader = xMLSourceNode.getReader();
                    StartElementPacket startElementPacket = XMLUtil.getXMLRootElement((Reader)reader);
                    if (startElementPacket == null || startElementPacket.namespaceURI == null || !startElementPacket.namespaceURI.equals("http://www.w3.org/1999/XSL/Transform") || startElementPacket.attributes == null) break block15;
                    int n = startElementPacket.attributes.getLength() - 1;
                    while (n >= 0) {
                        String string = startElementPacket.attributes.getLocalName(n);
                        if (string != null && string.equals("version")) {
                            boolean bl = true;
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return bl;
                        }
                        --n;
                    }
                }
                catch (Exception exception) {}
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return false;
    }
}

