/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.ide.Context;
import oracle.ide.config.ClientSetting;
import oracle.javatools.editor.EditorProperties;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdeveloper.style.CodingStyleOptionsListener;
import oracle.jdevimpl.style.CodingStyleAddin;
import oracle.jdevimpl.style.preferences.CodingStylePreferences;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.profile.ProfileRepository;

public class CodingStyleManagerImpl
extends CodingStyleManager {
    private CodingStyleProfile profile;
    private CodingStyleProfile localProfile;
    private CodingStyleOptionsListener profileListener;

    void $init$() {
        this.localProfile = new CodingStyleProfile();
        this.profileListener = new ProfileListener(null);
    }

    public CodingStyleManagerImpl() {
        this.$init$();
        CodingStylePreferences codingStylePreferences = this.getCodingStylePreferences();
        codingStylePreferences.addPropertyChangeListener(new PreferencesListener(null));
        this.updateProfile();
    }

    public CodingStyleOptions getCodingStyleOptions() {
        return this.localProfile;
    }

    public CodingStyleOptions getCodingStyleOptions(Context context) {
        return this.getCodingStyleOptions();
    }

    private void updateProfile() {
        if (this.profile != null) {
            this.profile.removeCodingStyleOptionsListener(this.profileListener);
        }
        CodingStylePreferences codingStylePreferences = this.getCodingStylePreferences();
        String string = codingStylePreferences.getActiveProfile();
        ProfileRepository profileRepository = ProfileRepository.getProfileRepository();
        if (string != null) {
            this.profile = profileRepository.getProfile(string);
        }
        if (this.profile == null) {
            this.profile = profileRepository.getDefaultProfile();
        }
        if (this.profile != null) {
            this.profile.copyTo(this.localProfile);
            this.profile.addCodingStyleOptionsListener(this.profileListener);
        }
        EditorProperties editorProperties = EditorProperties.getProperties();
        editorProperties.putIntegerProperty("indent-size", this.profile.getIndentSize());
        editorProperties.putBooleanProperty("use-tabs", this.profile.getIndentReplaceWithTabs());
        editorProperties.putIntegerProperty("tab-size", this.profile.getTabSize());
        editorProperties.putBooleanProperty("java-open-brace-same-line", this.profile.getClassBracePosition() == 0);
    }

    private CodingStylePreferences getCodingStylePreferences() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)CodingStyleAddin.getExtensionID());
        return (CodingStylePreferences)clientSetting.getData("CodingStylePreferences");
    }

    static void mav$updateProfile(CodingStyleManagerImpl codingStyleManagerImpl) {
        codingStyleManagerImpl.updateProfile();
    }

    private class PreferencesListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CodingStyleManagerImpl.mav$updateProfile(CodingStyleManagerImpl.this);
        }

        private PreferencesListener() {
        }

        PreferencesListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ProfileListener
    implements CodingStyleOptionsListener {
        public void optionsChanged(CodingStyleOptions codingStyleOptions) {
            CodingStyleManagerImpl.mav$updateProfile(CodingStyleManagerImpl.this);
        }

        private ProfileListener() {
        }

        ProfileListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

