/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.migration;

import java.io.File;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.IdeSettingsMigrator;
import oracle.ide.migration.MigrationManager;
import oracle.ide.migration.Migrator;
import oracle.jdevimpl.java.editing.JavaOptions;
import oracle.jdevimpl.java.imports.JavaImportOptions;
import oracle.jdevimpl.java.insight.JavaInsightOptions;
import oracle.jdevimpl.style.CodingStyleAddin;
import oracle.jdevimpl.style.preferences.CodingStylePreferences;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.profile.ProfileRepository;
import oracle.jdevimpl.style.resource.CodingStyleArb;

public class CodingStyleMigrator
implements Migrator {
    private static final int CODING_STYLE_CATEGORY = 0;
    private boolean selected;

    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    public String getDescription(int n) {
        return null;
    }

    public boolean canMigrate(int n, File file) {
        return n == 0;
    }

    public void setSelected(int n, boolean bl) {
        if (n == 0) {
            this.selected = bl;
        }
    }

    public boolean isSelected(int n) {
        return n == 0 ? this.selected : false;
    }

    public String[] migrate(File file, File file2) {
        MigrationManager migrationManager;
        Migrator migrator;
        if (this.isSelected(0) && (migrator = (migrationManager = MigrationManager.getMigrationManager()).getMigrator(IdeSettingsMigrator.class)) != null && migrator.isSelected(0)) {
            Ide.addIdeListener((IdeListener)new SecondPhaseMigrator(null));
        }
        return null;
    }

    private class SecondPhaseMigrator
    extends IdeAdapter {
        public void addinsLoaded(IdeEvent ideEvent) {
            if (this.isMigrationNeeded()) {
                this.performMigration();
            }
            Ide.removeIdeListener((IdeListener)this);
        }

        private boolean isMigrationNeeded() {
            AddinManager addinManager = AddinManager.getAddinManager();
            if (addinManager != null) {
                CodingStyleAddin codingStyleAddin = (CodingStyleAddin)addinManager.getAddin("oracle.jdevimpl.style.CodingStyleAddin");
                return codingStyleAddin != null && codingStyleAddin.isMigrationNeeded();
            }
            return false;
        }

        private void performMigration() {
            ClientSetting clientSetting;
            EditorOptions editorOptions;
            CodingStyleProfile codingStyleProfile = new CodingStyleProfile();
            ProfileRepository profileRepository = ProfileRepository.getProfileRepository();
            CodingStyleProfile codingStyleProfile2 = profileRepository.getDefaultProfile();
            codingStyleProfile2.copyTo(codingStyleProfile);
            String string = CodingStyleArb.getString(99);
            codingStyleProfile.setName(string);
            IdeSettings ideSettings = Ide.getSettings();
            if (ideSettings != null && (editorOptions = (EditorOptions)ideSettings.getData("EditorOptions")) != null) {
                int n = editorOptions.getTabSize();
                codingStyleProfile.setTabSize(n);
                codingStyleProfile.setIndentSize(n);
                codingStyleProfile.setIndentReplaceWithTabs(editorOptions.getUseSpaces() ^ true);
            }
            if ((clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper")) != null) {
                JavaImportOptions javaImportOptions;
                JavaInsightOptions javaInsightOptions;
                JavaOptions javaOptions = (JavaOptions)clientSetting.getData("JavaEditingOptions");
                if (javaOptions != null) {
                    int n = javaOptions.getOpenBraceSameLine() ? 0 : 1;
                    codingStyleProfile.setArrayBracePosition(n);
                    codingStyleProfile.setBlockBracePosition(n);
                    codingStyleProfile.setClassBracePosition(n);
                    codingStyleProfile.setMethodBracePosition(n);
                }
                if ((javaInsightOptions = (JavaInsightOptions)clientSetting.getData("JavaInsightOptions")) != null) {
                    codingStyleProfile.setUseWideImports(javaInsightOptions.getExplicitImport() ^ true);
                }
                if ((javaImportOptions = (JavaImportOptions)clientSetting.getData("JavaImportOptions")) != null) {
                    codingStyleProfile.setGroupImports(javaImportOptions.getGroupImports());
                    if (javaImportOptions.getCollapseGroups()) {
                        codingStyleProfile.setGroupPackageDepth(javaImportOptions.getPackageDepth());
                    } else {
                        codingStyleProfile.setGroupPackageDepth(0);
                    }
                }
            }
            profileRepository.addProfile(codingStyleProfile);
            CodingStylePreferences codingStylePreferences = (CodingStylePreferences)clientSetting.getData("CodingStylePreferences");
            codingStylePreferences.setActiveProfile(string);
        }

        private SecondPhaseMigrator() {
        }

        SecondPhaseMigrator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

