/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdevimpl.style.preferences.CodingStylePreferences;
import oracle.jdevimpl.style.profile.CodingStylePreviewPanel;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.profile.CodingStyleProfilePanel;
import oracle.jdevimpl.style.profile.ProfileModel;
import oracle.jdevimpl.style.resource.CodingStyleArb;

public class CodingStylePreferencesPanel
extends DefaultTraversablePanel
implements ApplyListener,
ActionListener,
ItemListener {
    private JComboBox profileList;
    private ProfileModel model;
    private JButton editButton;
    private JButton deleteButton;
    private JButton saveAsButton;
    private JButton importButton;
    private JButton exportButton;
    private JButton restoreButton;
    private CodingStylePreviewPanel preview;
    private URL lastImportExportURL;
    private CodingStylePreferences preferences;
    private static final String PREFERENCES_HELP_TOPIC = "f1_ideidesetcodingstyle_html";
    private static final String EDIT_PROFILE_HELP_TOPIC = "f1_ideidesetsavecodingstyle_html";
    private static final String EXPORT_HELP_TOPIC = "f1_ideidesetexportcodingstyle_html";
    private static final String IMPORT_HELP_TOPIC = "f1_ideidesetimportcodingstyle_html";
    private static final String SAMPLE;

    static {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package mypackage;");
        stringBuffer.append("${import}");
        stringBuffer.append("public class Class1");
        stringBuffer.append("{");
        stringBuffer.append("private int ${field field} = 1 + 2 + 3;");
        stringBuffer.append("public Class1()");
        stringBuffer.append("{");
        stringBuffer.append("}");
        stringBuffer.append("public static void main(");
        stringBuffer.append("String[] ${parameter args})");
        stringBuffer.append("{");
        stringBuffer.append("Class1 ${local class1} = new Class1();");
        stringBuffer.append("if ( ${local class1}.toString() != null )");
        stringBuffer.append("{");
        stringBuffer.append("System.out.println( 1 );");
        stringBuffer.append("}");
        stringBuffer.append("else");
        stringBuffer.append("{");
        stringBuffer.append("}");
        stringBuffer.append("switch (${parameter args}.length)");
        stringBuffer.append("{");
        stringBuffer.append("case 0:");
        stringBuffer.append("break;");
        stringBuffer.append("default:");
        stringBuffer.append("break;");
        stringBuffer.append("}");
        stringBuffer.append("}");
        stringBuffer.append("}");
        SAMPLE = stringBuffer.toString();
    }

    public CodingStylePreferencesPanel() {
        this.setHelpID(PREFERENCES_HELP_TOPIC);
        this.model = new ProfileModel();
        this.profileList = new JComboBox(this.model);
        this.profileList.setRenderer(new ProfileRenderer(null));
        this.profileList.setEditable(false);
        this.profileList.addItemListener(this);
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.profileList, (String)CodingStyleArb.getString(1));
        this.editButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.editButton, (String)CodingStyleArb.getString(2));
        this.editButton.addActionListener(this);
        this.saveAsButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.saveAsButton, (String)CodingStyleArb.getString(3));
        this.saveAsButton.addActionListener(this);
        this.deleteButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.deleteButton, (String)CodingStyleArb.getString(4));
        this.deleteButton.addActionListener(this);
        this.importButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.importButton, (String)CodingStyleArb.getString(5));
        this.importButton.addActionListener(this);
        this.exportButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.exportButton, (String)CodingStyleArb.getString(6));
        this.exportButton.addActionListener(this);
        this.restoreButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.restoreButton, (String)CodingStyleArb.getString(7));
        this.restoreButton.addActionListener(this);
        this.preview = new CodingStylePreviewPanel();
        this.preview.setSampleCode(SAMPLE);
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.preview.getEditor(), (String)CodingStyleArb.getString(8));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        jPanel.add((Component)this.profileList, gridBagConstraints);
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.add((Component)this.editButton);
        buttonBar.add((Component)this.saveAsButton);
        buttonBar.add((Component)this.deleteButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel.add((Component)buttonBar, gridBagConstraints);
        ButtonBar buttonBar2 = new ButtonBar();
        buttonBar2.setAlignment(4);
        buttonBar2.add((Component)this.importButton);
        buttonBar2.add((Component)this.exportButton);
        buttonBar2.add((Component)this.restoreButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 3));
        jPanel2.add((Component)jLabel2, "North");
        jPanel2.add((Component)this.preview, "Center");
        this.setLayout(new BorderLayout(0, 5));
        this.add(jPanel, "North");
        this.add(jPanel2, "Center");
        this.add((Component)buttonBar2, "South");
    }

    public void onEntry(TraversableContext traversableContext) {
        this.preferences = this.getCodingStylePreferences(traversableContext);
        CodingStyleProfile codingStyleProfile = null;
        String string = this.preferences.getActiveProfile();
        boolean bl = string != null && !this.model.contains(string);
        codingStyleProfile = string == null || bl ? this.model.getDefaultProfile() : this.model.getProfile(string);
        this.model.setSelectedItem(codingStyleProfile);
        this.updatePreview();
        this.updateButtons();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        CodingStylePreferences codingStylePreferences = this.getCodingStylePreferences(traversableContext);
        CodingStyleProfile codingStyleProfile = this.getSelectedProfile();
        if (codingStyleProfile != null) {
            codingStylePreferences.setActiveProfile(this.getSelectedProfile().getName());
        } else {
            codingStylePreferences.setActiveProfile(null);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.updatePreview();
            this.updateButtons();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.editButton) {
            this.editProfile();
        } else if (object == this.saveAsButton) {
            this.saveProfile();
        } else if (object == this.deleteButton) {
            this.deleteProfile();
        } else if (object == this.exportButton) {
            this.exportProfile();
        } else if (object == this.importButton) {
            this.importProfile();
        } else if (object == this.restoreButton) {
            this.restoreProfile();
        }
    }

    public void apply(ApplyEvent applyEvent) {
        this.model.save();
    }

    public void cancel(ApplyEvent applyEvent) {
        this.model.revert();
    }

    private void updatePreview() {
        CodingStyleProfile codingStyleProfile = this.getSelectedProfile();
        this.preview.setProfile(codingStyleProfile);
        this.preview.update();
    }

    private void updateButtons() {
        CodingStyleProfile codingStyleProfile = this.getSelectedProfile();
        boolean bl = codingStyleProfile != null;
        this.deleteButton.setEnabled(bl && !this.model.isDefaultProfile(codingStyleProfile));
        this.restoreButton.setEnabled(bl && this.model.canRestore(codingStyleProfile));
        this.editButton.setEnabled(bl);
        this.exportButton.setEnabled(bl);
        this.saveAsButton.setEnabled(bl);
    }

    private void editProfile() {
        CodingStyleProfilePanel codingStyleProfilePanel = new CodingStyleProfilePanel();
        CodingStyleProfile codingStyleProfile = this.getSelectedProfile();
        CodingStyleProfile codingStyleProfile2 = new CodingStyleProfile();
        codingStyleProfile.copyTo(codingStyleProfile2);
        Namespace namespace = new Namespace();
        namespace.put("Profile", (Object)codingStyleProfile2);
        MessageFormat messageFormat = new MessageFormat(CodingStyleArb.getString(25));
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)((Object)this), messageFormat.format(new Object[]{codingStyleProfile2.getName()}), (Traversable)codingStyleProfilePanel, namespace, (DialogRunnerCallback)new SizeKeeperCallback("coding.style.profile"));
        tDialogLauncher.setInitialSize(800, 600);
        try {
            if (tDialogLauncher.showDialog() && ModelUtil.areDifferent((Object)codingStyleProfile, (Object)codingStyleProfile2)) {
                codingStyleProfile2.copyTo(codingStyleProfile);
                this.model.setModified(codingStyleProfile);
                this.updatePreview();
                this.updateButtons();
            }
        }
        finally {
            tDialogLauncher.dispose();
        }
    }

    private void saveProfile() {
        CodingStyleProfile codingStyleProfile = this.getSelectedProfile();
        String string = codingStyleProfile.getName();
        String string2 = this.getProfileName(string);
        if (string2 != null && (string2.equalsIgnoreCase(string) || !this.model.contains(string2) || this.confirmSaveAsOverwrite(string2))) {
            CodingStyleProfile codingStyleProfile2 = this.model.copy(codingStyleProfile, string2);
            this.model.setSelectedItem(codingStyleProfile2);
            this.model.revert(codingStyleProfile);
        }
    }

    private boolean confirmSaveAsOverwrite(String string) {
        String string2;
        String string3 = CodingStyleArb.format(18, string);
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), string3, string2 = CodingStyleArb.getString(19), 2);
        return n == 0;
    }

    private String getProfileName(String string) {
        JTextField jTextField = new JTextField(string, 32);
        jTextField.selectAll();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)jTextField, (String)CodingStyleArb.getString(22));
        JPanel jPanel = new JPanel(new GridBagLayout());
        HelpUtils.setHelpID((JComponent)jPanel, (String)EDIT_PROFILE_HELP_TOPIC);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)jTextField, gridBagConstraints);
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)((Object)this), (String)CodingStyleArb.getString(23), (int)7);
        jTextField.getDocument().addDocumentListener(new SaveAsListener(jEWTDialog));
        jEWTDialog.setContent((Component)jPanel);
        jEWTDialog.setOKButtonText(CodingStyleArb.getString(24));
        return jEWTDialog.runDialog() ? jTextField.getText().trim() : null;
    }

    private void deleteProfile() {
        CodingStyleProfile codingStyleProfile = this.getSelectedProfile();
        if (this.confirmDelete(codingStyleProfile)) {
            this.model.remove(codingStyleProfile);
        }
    }

    private boolean confirmDelete(CodingStyleProfile codingStyleProfile) {
        String string;
        String string2 = CodingStyleArb.format(97, codingStyleProfile.getName());
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), string2, string = CodingStyleArb.getString(98), 2);
        return n == 0;
    }

    private void exportProfile() {
        ExportURLChooser exportURLChooser = new ExportURLChooser();
        DialogUtil.initURLChooser((URLChooser)exportURLChooser, null);
        if (this.lastImportExportURL != null) {
            exportURLChooser.setSelectedURL(this.lastImportExportURL);
        } else {
            URL uRL = this.getUserHomeDirectory();
            if (uRL != null) {
                exportURLChooser.setSelectedURL(uRL);
            }
        }
        exportURLChooser.clearChooseableURLFilters();
        DefaultURLFilter defaultURLFilter = new DefaultURLFilter(CodingStyleArb.getString(20), ".xml");
        exportURLChooser.addChooseableURLFilter((URLFilter)defaultURLFilter);
        exportURLChooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
        exportURLChooser.setURLFilter((URLFilter)defaultURLFilter);
        int n = exportURLChooser.showSaveDialog((Component)((Object)this), CodingStyleArb.getString(9));
        if (n == 0) {
            URL uRL = exportURLChooser.getSelectedURL();
            if ("".equals(URLFileSystem.getSuffix((URL)uRL))) {
                uRL = URLFileSystem.convertSuffix((URL)uRL, (String)"", (String)".xml");
            }
            try {
                this.getSelectedProfile().exportTo(uRL);
                this.lastImportExportURL = URLFileSystem.getParent((URL)uRL);
            }
            catch (Exception exception) {
                String string = CodingStyleArb.format(14, URLFileSystem.getPlatformPathName((URL)uRL), exception.toString());
                String string2 = CodingStyleArb.getString(13);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string, string2, 0);
            }
        }
    }

    private void importProfile() {
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        uRLChooser.clearChooseableURLFilters();
        DefaultURLFilter defaultURLFilter = new DefaultURLFilter(CodingStyleArb.getString(20), ".xml");
        uRLChooser.addChooseableURLFilter((URLFilter)defaultURLFilter);
        uRLChooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
        uRLChooser.setURLFilter((URLFilter)defaultURLFilter);
        uRLChooser.setHelpID(IMPORT_HELP_TOPIC);
        if (this.lastImportExportURL != null) {
            uRLChooser.setSelectedURL(this.lastImportExportURL);
        } else {
            URL uRL = this.getUserHomeDirectory();
            if (uRL != null) {
                uRLChooser.setSelectedURL(uRL);
            }
        }
        int n = uRLChooser.showOpenDialog((Component)((Object)this), CodingStyleArb.getString(15));
        if (n == 0) {
            try {
                URL uRL = uRLChooser.getSelectedURL();
                CodingStyleProfile codingStyleProfile = CodingStyleProfile.importFrom(uRL);
                String string = codingStyleProfile.getName();
                if (!this.model.contains(string) || this.confirmImportOverwrite(string)) {
                    this.model.add(codingStyleProfile);
                    this.model.setSelectedItem(codingStyleProfile);
                    this.lastImportExportURL = URLFileSystem.getParent((URL)uRL);
                }
            }
            catch (IOException iOException) {
                ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)iOException);
            }
        }
    }

    private boolean confirmImportOverwrite(String string) {
        String string2;
        String string3 = CodingStyleArb.format(16, string);
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), string3, string2 = CodingStyleArb.getString(17), 2);
        return n == 0;
    }

    private void restoreProfile() {
        this.model.restore(this.getSelectedProfile());
        this.updatePreview();
        this.updateButtons();
    }

    private URL getUserHomeDirectory() {
        URL uRL = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
        return URLFileSystem.exists((URL)uRL) ? uRL : null;
    }

    private CodingStyleProfile getSelectedProfile() {
        return (CodingStyleProfile)this.model.getSelectedItem();
    }

    private CodingStylePreferences getCodingStylePreferences(TraversableContext traversableContext) {
        return (CodingStylePreferences)traversableContext.find("CodingStylePreferences");
    }

    private class ExportURLChooser
    extends URLChooser {
        public ExportURLChooser() {
            this.setHelpID(CodingStylePreferencesPanel.EXPORT_HELP_TOPIC);
        }

        public boolean approveSelection() {
            return super.approveSelection() && this.checkExistingFile() && this.checkReadOnlyFile();
        }

        private boolean checkExistingFile() {
            URL uRL = this.getSelectedURL();
            if (URLFileSystem.exists((URL)uRL)) {
                String string = CodingStyleArb.format(11, URLFileSystem.getPlatformPathName((URL)uRL));
                String string2 = CodingStyleArb.getString(10);
                int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), string, string2, 2);
                return n == 0;
            }
            return true;
        }

        private boolean checkReadOnlyFile() {
            URL uRL = this.getSelectedURL();
            if (URLFileSystem.isReadOnly((URL)uRL)) {
                String string = CodingStyleArb.format(12, URLFileSystem.getPlatformPathName((URL)uRL));
                String string2 = CodingStyleArb.getString(13);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string, string2, 0);
                return false;
            }
            return true;
        }
    }

    private class ProfileRenderer
    extends BasicComboBoxRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof CodingStyleProfile) {
                CodingStyleProfile codingStyleProfile = (CodingStyleProfile)object;
                object = codingStyleProfile.isModified() ? CodingStyleArb.format(21, codingStyleProfile.getName()) : codingStyleProfile.getName();
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }

        private ProfileRenderer() {
        }

        ProfileRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SaveAsListener
    implements DocumentListener {
        private JEWTDialog dialog;

        public SaveAsListener(JEWTDialog jEWTDialog) {
            this.dialog = jEWTDialog;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent.getDocument());
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent.getDocument());
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent.getDocument());
        }

        private void update(Document document) {
            String string;
            try {
                string = document.getText(0, document.getLength()).trim();
            }
            catch (BadLocationException badLocationException) {
                throw new UnexpectedExceptionError((Throwable)badLocationException);
            }
            this.dialog.setOKButtonEnabled(string.length() > 0);
        }
    }
}

