/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreePath;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutPanel;
import oracle.jdevimpl.style.profile.CodingStylePreviewPanel;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.resource.CodingStyleArb;
import oracle.jdevimpl.style.treetable.CodingStyleTreeBoolean;
import oracle.jdevimpl.style.treetable.CodingStyleTreeCategory;
import oracle.jdevimpl.style.treetable.CodingStyleTreeCategoryBoolean;
import oracle.jdevimpl.style.treetable.CodingStyleTreeItem;
import oracle.jdevimpl.style.treetable.CodingStyleTreeList;
import oracle.jdevimpl.style.treetable.CodingStyleTreeNumber;
import oracle.jdevimpl.style.treetable.CodingStyleTreeTable;
import oracle.jdevimpl.style.treetable.CodingStyleTreeTableModel;

public class CodingStyleFormatPanel
extends DefaultTraversablePanel
implements TreeSelectionListener,
ChangeListener {
    private static final String INDENT_HELP_ID = "f1_ideideseteditcodingstyleindent_html";
    private static final String BRACE_POSITION_HELP_ID = "f1_ideideseteditcodingstylebrace_html";
    private static final String NEWLINES_HELP_ID = "f1_ideideseteditcodingstylenewline_html";
    private static final String LINEWRAPPING_HELP_ID = "f1_ideideseteditcodingstylewrapping_html";
    private static final String BLANKLINES_HELP_ID = "f1_ideideseteditcodingstyleblank_html";
    private static final String SPACE_HELP_ID = "f1_ideideseteditcodingstylespace_html";
    private static final int MAP_READ = 0;
    private static final int MAP_WRITE = 1;
    private CodingStyleTreeTableModel model;
    private CodingStylePreviewPanel preview;
    private CodingStyleTreeTable treeTable;
    private CodingStyleProfile profile;
    private String sample;

    void $init$() {
        this.preview = new CodingStylePreviewPanel();
    }

    public CodingStyleFormatPanel() {
        this.$init$();
        this.setHelpID(INDENT_HELP_ID);
        this.model = this.createModel();
        this.model.addChangeListener(this);
        this.treeTable = new CodingStyleTreeTable((TreeTableModel)this.model);
        JTree jTree = this.treeTable.getTree();
        this.model.setTree(jTree);
        jTree.addTreeSelectionListener(this);
        jTree.expandRow(0);
        jTree.setSelectionPath(jTree.getPathForRow(0));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.treeTable));
        Color color = this.treeTable.getBackground();
        jScrollPane.setBackground(color);
        jScrollPane.getViewport().setBackground(color);
        DockLayoutPanel dockLayoutPanel = new DockLayoutPanel();
        dockLayoutPanel.setName("format.splitter");
        dockLayoutPanel.add((Component)jScrollPane, (Object)new DockLayoutConstraint(0, null));
        dockLayoutPanel.add((Component)this.preview, (Object)new DockLayoutConstraint(1, null));
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setLayout(new BorderLayout());
        this.add((Component)dockLayoutPanel, "Center");
    }

    public void onEntry(TraversableContext traversableContext) {
        this.profile = (CodingStyleProfile)traversableContext.find("Profile");
        this.loadFromProfile(this.profile);
        this.updatePreview();
    }

    public void onExit(TraversableContext traversableContext) {
        TableCellEditor tableCellEditor = this.treeTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        this.saveToProfile(this.profile);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.profile != null) {
            this.saveToProfile(this.profile);
        }
        this.updatePreview();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        if (treePath != null) {
            int n = treePath.getPathCount() - 1;
            while (n >= 0) {
                String string;
                Object object = treePath.getPathComponent(n);
                if (object instanceof CodingStyleTreeItem && (string = ((CodingStyleTreeItem)object).getSample()) != null) {
                    this.sample = string;
                    this.updatePreview();
                    break;
                }
                --n;
            }
            int n2 = treePath.getPathCount() - 1;
            while (n2 >= 0) {
                Object object = treePath.getPathComponent(n2);
                if (object instanceof CodingStyleTreeCategory) {
                    this.setHelpID(((CodingStyleTreeCategory)object).getHelpID());
                    break;
                }
                --n2;
            }
        }
    }

    private CodingStyleTreeTableModel createModel() {
        CodingStyleTreeTableModel codingStyleTreeTableModel = new CodingStyleTreeTableModel(null);
        this.sample = this.getRootSample();
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, "root", INDENT_HELP_ID, this.sample);
        codingStyleTreeTableModel.setRoot(codingStyleTreeCategory);
        codingStyleTreeCategory.addChild(this.createIndentationCategory(codingStyleTreeTableModel));
        codingStyleTreeCategory.addChild(this.createBracePositionCategory(codingStyleTreeTableModel));
        codingStyleTreeCategory.addChild(this.createNewLinesCategory(codingStyleTreeTableModel));
        codingStyleTreeCategory.addChild(this.createLineWrappingCategory(codingStyleTreeTableModel));
        codingStyleTreeCategory.addChild(this.createBlankLinesCategory(codingStyleTreeTableModel));
        codingStyleTreeCategory.addChild(this.createSpacesCategory(codingStyleTreeTableModel));
        return codingStyleTreeTableModel;
    }

    private String getRootSample() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package mypackage;");
        stringBuffer.append("${import}");
        stringBuffer.append("public class Class1");
        stringBuffer.append("{");
        stringBuffer.append("private int ${field field} = 1 + 2 + 3;");
        stringBuffer.append("public Class1()");
        stringBuffer.append("{");
        stringBuffer.append("}");
        stringBuffer.append("public static void main(String[]");
        stringBuffer.append("${parameter args})");
        stringBuffer.append("{");
        stringBuffer.append("Class1 ${local class1} = new Class1();");
        stringBuffer.append("if (${local class1}.toString() != null)");
        stringBuffer.append("{");
        stringBuffer.append("System.out.println( 1 );");
        stringBuffer.append("}");
        stringBuffer.append("else");
        stringBuffer.append("{");
        stringBuffer.append("}");
        stringBuffer.append("switch (${parameter args}.length)");
        stringBuffer.append("{");
        stringBuffer.append("case 0:");
        stringBuffer.append("break;");
        stringBuffer.append("default:");
        stringBuffer.append("break;");
        stringBuffer.append("}");
        stringBuffer.append("}");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private CodingStyleTreeCategory createBracePositionCategory(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package mypackage.brace.position;");
        stringBuffer.append("public class Class1 {");
        stringBuffer.append("private String[] ${field values} = {");
        stringBuffer.append("\"a\", \"b\", \"c\"");
        stringBuffer.append("};");
        stringBuffer.append("public Class1(){");
        stringBuffer.append("}");
        stringBuffer.append("public static void main(String[]");
        stringBuffer.append("${parameter args}) {");
        stringBuffer.append("if (${parameter args}.length < 2) {");
        stringBuffer.append("printUsage();");
        stringBuffer.append("}");
        stringBuffer.append("try {");
        stringBuffer.append("for (int ${local i} = 1; ${local i} < ");
        stringBuffer.append("${parameter args}.length; ${local i}++)");
        stringBuffer.append("{");
        stringBuffer.append("processArg(${parameter args}[${local i});");
        stringBuffer.append("}");
        stringBuffer.append("}");
        stringBuffer.append("catch (Exception ${local e}) {");
        stringBuffer.append("${local e}.printStackTrace();");
        stringBuffer.append("}");
        stringBuffer.append("switch (${parameter args}.length)");
        stringBuffer.append("{");
        stringBuffer.append("case 0:");
        stringBuffer.append("{");
        stringBuffer.append("break;");
        stringBuffer.append("}");
        stringBuffer.append("default:");
        stringBuffer.append("{");
        stringBuffer.append("break;");
        stringBuffer.append("}");
        stringBuffer.append("}");
        stringBuffer.append("}");
        stringBuffer.append("}");
        String string = stringBuffer.toString();
        String[] stringArray = new String[]{CodingStyleArb.getString(27), CodingStyleArb.getString(28)};
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, CodingStyleArb.getString(26), BRACE_POSITION_HELP_ID, string);
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("classBracePosition", CodingStyleArb.getString(29), null, stringArray));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("methodBracePosition", CodingStyleArb.getString(30), null, stringArray));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("blockBracePosition", CodingStyleArb.getString(31), null, stringArray));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("arrayBracePosition", CodingStyleArb.getString(32), null, stringArray));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("switchCaseBracePosition", CodingStyleArb.getString(137), null, stringArray));
        return codingStyleTreeCategory;
    }

    private CodingStyleTreeCategory createNewLinesCategory(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package mypackage.newlines;");
        stringBuffer.append("public class MyClass extends BaseClass");
        stringBuffer.append(" implements MyInterface {");
        stringBuffer.append("public void myMethod() throws IOException {");
        stringBuffer.append("try {");
        stringBuffer.append("if (isTrue())");
        stringBuffer.append("{");
        stringBuffer.append("int ${local i} = 0;");
        stringBuffer.append("do");
        stringBuffer.append("{");
        stringBuffer.append("${local i} = getValue();");
        stringBuffer.append("System.out.println(\"Value: \" + value);");
        stringBuffer.append("} while ( ${local i} > 0 );");
        stringBuffer.append("} else {");
        stringBuffer.append("System.out.println(\"false\");");
        stringBuffer.append("}");
        stringBuffer.append("} catch (Exception ${local e}) {");
        stringBuffer.append("e.printStackTrace();");
        stringBuffer.append("} finally {");
        stringBuffer.append("done();");
        stringBuffer.append("} ");
        stringBuffer.append("}");
        stringBuffer.append("}");
        String string = stringBuffer.toString();
        CodingStyleTreeCategoryBoolean codingStyleTreeCategoryBoolean = new CodingStyleTreeCategoryBoolean(codingStyleTreeTableModel, CodingStyleArb.getString(41), NEWLINES_HELP_ID, string);
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("newlineExtends", CodingStyleArb.getString(42), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("newlineImplements", CodingStyleArb.getString(43), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("newlineThrows", CodingStyleArb.getString(44), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("newlineElse", CodingStyleArb.getString(45), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("newlineWhile", CodingStyleArb.getString(46), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("newlineCatch", CodingStyleArb.getString(47), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("newlineFinally", CodingStyleArb.getString(48), null));
        return codingStyleTreeCategoryBoolean;
    }

    private CodingStyleTreeCategory createLineWrappingCategory(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package mypackage.line.wrapping;");
        stringBuffer.append("@Annotation1 @Annotation2(date=\"1/1/2007\",");
        stringBuffer.append("author=\"jsmith\") public class MyClass ");
        stringBuffer.append("implements Interface1,Interface2,Interface3 {");
        stringBuffer.append("private String[] ${field values} = {\"red\",");
        stringBuffer.append("\"orange\",\"yellow\", \"green\", \"blue\", ");
        stringBuffer.append("\"indigo\",\"violet\"};");
        stringBuffer.append("public final void myMethod() throws ");
        stringBuffer.append("Exception1, Exception2, Exception3, Exception4");
        stringBuffer.append("{");
        stringBuffer.append("boolean ${local isOracle}=${field values}[1].");
        stringBuffer.append("substring(0, 3).toUpperCase().concat(\"CLE\").");
        stringBuffer.append("equalsIgnoreCase(\"ORACLE\");");
        stringBuffer.append("print(${field values}[0], ${field values}[1], ");
        stringBuffer.append("${field values}[2], ${field values}[3], ");
        stringBuffer.append("${field values}[4], ${field values}[5], ");
        stringBuffer.append("${field values}[6]);");
        stringBuffer.append("for (int ${local index} = ");
        stringBuffer.append("getMinimumIntegerValue();");
        stringBuffer.append(" index <getMaximumIntegerValue(); index++)");
        stringBuffer.append("{}");
        stringBuffer.append("if (${field values}[0].length() > 2 &&");
        stringBuffer.append(" ${field values}[1].length() == 3 ||");
        stringBuffer.append(" ${field values}[2].length() < 10");
        stringBuffer.append("&& ${field values}[3].length() == 0)");
        stringBuffer.append("{}");
        stringBuffer.append("String ${local str} = isOracle ? ");
        stringBuffer.append("\"the string matches ORACLE\":");
        stringBuffer.append("\"the string does not match ORACLE\";");
        stringBuffer.append("}");
        stringBuffer.append("public void print(String ${parameter arg1}, ");
        stringBuffer.append("String ${parameter arg2},");
        stringBuffer.append("String ${parameter arg3},");
        stringBuffer.append("String ${parameter arg4},");
        stringBuffer.append("String ${parameter arg5},");
        stringBuffer.append("String ${parameter arg6},");
        stringBuffer.append("String ${parameter arg7})");
        stringBuffer.append("{}");
        stringBuffer.append("}");
        String string = stringBuffer.toString();
        String[] stringArray = new String[]{CodingStyleArb.getString(49), CodingStyleArb.getString(50), CodingStyleArb.getString(51)};
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, CodingStyleArb.getString(52), LINEWRAPPING_HELP_ID, string);
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("wrapLineWidth", CodingStyleArb.getString(53), null, 1, 1000));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("wrapAlign", CodingStyleArb.getString(54), null));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("wrapModifiers", CodingStyleArb.getString(55), null, stringArray));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("wrapExtends", CodingStyleArb.getString(56), null, stringArray));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("wrapThrows", CodingStyleArb.getString(57), null, stringArray));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("wrapArrayConstant", CodingStyleArb.getString(58), null, stringArray));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("wrapParameterList", CodingStyleArb.getString(59), null, stringArray));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("wrapInvokeArguments", CodingStyleArb.getString(60), null, stringArray));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("wrapDotChain", CodingStyleArb.getString(61), null, stringArray));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("wrapForStatement", CodingStyleArb.getString(62), null, stringArray));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("wrapBinaryOperator", CodingStyleArb.getString(63), null, stringArray));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("wrapTernaryExpression", CodingStyleArb.getString(64), null, stringArray));
        return codingStyleTreeCategory;
    }

    private CodingStyleTreeCategory createBlankLinesCategory(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package mypackage.blank.lines;");
        stringBuffer.append("${import}");
        stringBuffer.append("public class Class1");
        stringBuffer.append("{");
        stringBuffer.append("private int ${field field} = 1");
        stringBuffer.append("private Object ${field anonymous} =");
        stringBuffer.append("new Object(){};");
        stringBuffer.append("public Class1()");
        stringBuffer.append("{");
        stringBuffer.append("}");
        stringBuffer.append("public static void main(String[]");
        stringBuffer.append("${parameter args})");
        stringBuffer.append("{");
        stringBuffer.append("// 10 existing blank lines\n");
        stringBuffer.append("\n\n\n\n\n\n\n\n\n\n");
        stringBuffer.append("// End existing blank lines\n");
        stringBuffer.append("if (${parameter args}.length > 0)");
        stringBuffer.append("{");
        stringBuffer.append("System.out.println(${parameter args}.length)");
        stringBuffer.append("}");
        stringBuffer.append("else");
        stringBuffer.append("{");
        stringBuffer.append("}");
        stringBuffer.append("}");
        stringBuffer.append("private class MemberClass {}");
        stringBuffer.append("}");
        stringBuffer.append("class EmptyClass");
        stringBuffer.append("{");
        stringBuffer.append("}");
        String string = stringBuffer.toString();
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, CodingStyleArb.getString(65), BLANKLINES_HELP_ID, string);
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("blanklinesAfterPackage", CodingStyleArb.getString(66), null, 0, 20));
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("blanklinesAfterImports", CodingStyleArb.getString(67), null, 0, 20));
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("blanklinesBeforeFirstClass", CodingStyleArb.getString(68), null, 0, 20));
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("blanklinesBeforeFirstMember", CodingStyleArb.getString(69), null, 0, 20));
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("blanklinesAfterLastMember", CodingStyleArb.getString(70), null, 0, 20));
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("blanklinesBeforeField", CodingStyleArb.getString(71), null, 0, 20));
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("blanklinesBeforeMethod", CodingStyleArb.getString(72), null, 0, 20));
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("blanklinesBeforeMemberClass", CodingStyleArb.getString(73), null, 0, 20));
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("blanklinesEmptyClass", CodingStyleArb.getString(74), null, 0, 20));
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("blanklinesEmptyAnonymous", CodingStyleArb.getString(75), null, 0, 20));
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("blanklinesEmptyBlock", CodingStyleArb.getString(76), null, 0, 20));
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("blanklinesEmptyMethod", CodingStyleArb.getString(77), null, 0, 20));
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("blanklinesPreserved", CodingStyleArb.getString(78), null, 0, 20));
        return codingStyleTreeCategory;
    }

    private CodingStyleTreeCategory createIndentationCategory(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package mypackage.indentation;");
        stringBuffer.append("public class Class1");
        stringBuffer.append("{");
        stringBuffer.append("private int ${field field} = 1 + 2 + 3;");
        stringBuffer.append("public Class1()");
        stringBuffer.append("{");
        stringBuffer.append("}");
        stringBuffer.append("public static void main(String[] ");
        stringBuffer.append("${parameter args})");
        stringBuffer.append("{");
        stringBuffer.append("Class1 ${local class1} = new Class1();");
        stringBuffer.append("if ( ${local class1}.toString() != null )");
        stringBuffer.append("{");
        stringBuffer.append("System.out.println( 1 );");
        stringBuffer.append("}");
        stringBuffer.append("else");
        stringBuffer.append("{");
        stringBuffer.append("}");
        stringBuffer.append("switch (${parameter args}.length)");
        stringBuffer.append("{");
        stringBuffer.append("case 0:");
        stringBuffer.append("break;");
        stringBuffer.append("default:");
        stringBuffer.append("break;");
        stringBuffer.append("}");
        stringBuffer.append("}");
        stringBuffer.append("}");
        String string = stringBuffer.toString();
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, CodingStyleArb.getString(33), INDENT_HELP_ID, string);
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("indentSize", CodingStyleArb.getString(34), null, 1, 20));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("indentReplaceWithTabs", CodingStyleArb.getString(35), null));
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("tabSize", CodingStyleArb.getString(36), null, 1, 20));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("indentClassMembers", CodingStyleArb.getString(37), null));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("indentControlBlocks", CodingStyleArb.getString(38), null));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("indentBlockChildren", CodingStyleArb.getString(39), null));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("indentSwitchCases", CodingStyleArb.getString(40), null));
        return codingStyleTreeCategory;
    }

    private CodingStyleTreeCategory createSpacesCategory(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package mypackage.spaces;");
        stringBuffer.append("public class MyClass");
        stringBuffer.append(" implements Interface1, Inteface2 {");
        stringBuffer.append("private String[] ${field values} =");
        stringBuffer.append("{\"a\", \"b\", \"c\"};");
        stringBuffer.append("public void myMethod(int[] ${parameter a}) {");
        stringBuffer.append("int ${local total} = 0;");
        stringBuffer.append("for (int ${local total} : ${parameter a}) {");
        stringBuffer.append("${local total} += e;");
        stringBuffer.append("}");
        stringBuffer.append("int[] ${local copy} = new int[5];");
        stringBuffer.append("int ${local max} = (${parameter a}.length < 5)");
        stringBuffer.append("?  ${parameter a}.length : 5;");
        stringBuffer.append("for (int ${local i} = 0; ${local i}  <");
        stringBuffer.append("${local max}; ${local i}++) {");
        stringBuffer.append("${local copy}[i] = ${parameter a}[${local i}];");
        stringBuffer.append("}");
        stringBuffer.append("Integer ${local x} = (Integer)getValue(");
        stringBuffer.append("${parameter a}, ${local total});");
        stringBuffer.append("}");
        stringBuffer.append("}");
        String string = stringBuffer.toString();
        CodingStyleTreeCategoryBoolean codingStyleTreeCategoryBoolean = new CodingStyleTreeCategoryBoolean(codingStyleTreeTableModel, CodingStyleArb.getString(79), SPACE_HELP_ID, string);
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("spaceBeforeOpenBrace", CodingStyleArb.getString(80), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("spaceBeforeComma", CodingStyleArb.getString(81), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("spaceAfterComma", CodingStyleArb.getString(82), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("spaceBeforeSemicolon", CodingStyleArb.getString(83), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("spaceAfterSemicolon", CodingStyleArb.getString(84), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("spaceBeforeQuestion", CodingStyleArb.getString(85), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("spaceAfterQuestion", CodingStyleArb.getString(86), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("spaceBeforeColon", CodingStyleArb.getString(87), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("spaceAfterColon", CodingStyleArb.getString(88), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("spaceAfterTypecast", CodingStyleArb.getString(89), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("spaceBeforeArguments", CodingStyleArb.getString(90), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("spaceBeforeParameters", CodingStyleArb.getString(91), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("spaceAfterKeyword", CodingStyleArb.getString(92), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("spaceAroundAssignment", CodingStyleArb.getString(93), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("spaceAroundBinaryOperator", CodingStyleArb.getString(94), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("spaceWithinParenthesis", CodingStyleArb.getString(95), null));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("spaceWithinBrackets", CodingStyleArb.getString(96), null));
        return codingStyleTreeCategoryBoolean;
    }

    private void loadFromProfile(CodingStyleProfile codingStyleProfile) {
        CodingStyleTreeCategory codingStyleTreeCategory = (CodingStyleTreeCategory)this.model.getRoot();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(CodingStyleProfile.class);
            Map map = this.createPropertyMap(beanInfo, 0);
            this.loadSettingsFromCategory(codingStyleTreeCategory, codingStyleProfile, map);
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
    }

    private void saveToProfile(CodingStyleProfile codingStyleProfile) {
        CodingStyleTreeCategory codingStyleTreeCategory = (CodingStyleTreeCategory)this.model.getRoot();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(CodingStyleProfile.class);
            Map map = this.createPropertyMap(beanInfo, 1);
            this.saveSettingsToCategory(codingStyleTreeCategory, codingStyleProfile, map);
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
    }

    private void loadSettingsFromCategory(CodingStyleTreeCategory codingStyleTreeCategory, CodingStyleProfile codingStyleProfile, Map map) {
        int n = 0;
        while (n < codingStyleTreeCategory.getChildCount()) {
            CodingStyleTreeItem codingStyleTreeItem = codingStyleTreeCategory.getChild(n);
            if (codingStyleTreeItem instanceof CodingStyleTreeCategory) {
                CodingStyleTreeCategory codingStyleTreeCategory2 = (CodingStyleTreeCategory)codingStyleTreeItem;
                this.loadSettingsFromCategory(codingStyleTreeCategory2, codingStyleProfile, map);
            } else {
                Object object;
                Method method = (Method)map.get(codingStyleTreeItem.getPropertyName());
                if (method != null && (object = this.invokeReadMethod(method, codingStyleProfile)) != null) {
                    codingStyleTreeItem.setValue(object);
                }
            }
            ++n;
        }
    }

    private void saveSettingsToCategory(CodingStyleTreeCategory codingStyleTreeCategory, CodingStyleProfile codingStyleProfile, Map map) {
        int n = 0;
        while (n < codingStyleTreeCategory.getChildCount()) {
            CodingStyleTreeItem codingStyleTreeItem = codingStyleTreeCategory.getChild(n);
            if (codingStyleTreeItem instanceof CodingStyleTreeCategory) {
                CodingStyleTreeCategory codingStyleTreeCategory2 = (CodingStyleTreeCategory)codingStyleTreeItem;
                this.saveSettingsToCategory(codingStyleTreeCategory2, codingStyleProfile, map);
            } else {
                Method method = (Method)map.get(codingStyleTreeItem.getPropertyName());
                if (method != null) {
                    this.invokeWriteMethod(method, codingStyleProfile, codingStyleTreeItem.getValue());
                }
            }
            ++n;
        }
    }

    private Object invokeMethod(Method method, Object object, Object[] objectArray) {
        try {
            Object object2 = method.invoke(object, objectArray);
            return object2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private Object invokeReadMethod(Method method, Object object) {
        return this.invokeMethod(method, object, new Object[0]);
    }

    private Object invokeWriteMethod(Method method, Object object, Object object2) {
        return this.invokeMethod(method, object, new Object[]{object2});
    }

    private void updatePreview() {
        this.preview.setSampleCode(this.sample);
        this.preview.setProfile(this.profile);
        this.preview.update();
    }

    private Map createPropertyMap(BeanInfo beanInfo, int n) {
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n2 = 0;
        while (n2 < propertyDescriptorArray.length) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
            String string = propertyDescriptor.getName();
            Method method = n == 0 ? propertyDescriptor.getReadMethod() : propertyDescriptor.getWriteMethod();
            hashMap.put(string, method);
            ++n2;
        }
        return hashMap;
    }
}

