/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.style.profile.CodingStylePreviewPanel;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.resource.CodingStyleArb;

public class CodingStyleImportsPanel
extends DefaultTraversablePanel {
    private static final String HELP_TOPIC = "f1_ideideseteditcodingstyleimports_html";
    private CodingStyleProfile profile;
    private CodingStylePreviewPanel preview;
    private JCheckBox groupImports;
    private WholeNumberField groupDepth;
    private JCheckBox useWideImports;
    private WholeNumberField importThreshold;
    private JCheckBox innerClasses;
    private boolean loading;

    void $init$() {
        this.preview = new CodingStylePreviewPanel();
        this.groupImports = new JCheckBox();
        this.groupDepth = new WholeNumberField(8);
        this.useWideImports = new JCheckBox();
        this.importThreshold = new WholeNumberField(8);
        this.innerClasses = new JCheckBox();
    }

    public CodingStyleImportsPanel() {
        this.$init$();
        this.setHelpID(HELP_TOPIC);
        CheckBoxListener checkBoxListener = new CheckBoxListener(null);
        FieldListener fieldListener = new FieldListener(null);
        ResourceUtils.resButton((AbstractButton)this.groupImports, (String)CodingStyleArb.getString(129));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.groupDepth, (String)CodingStyleArb.getString(130));
        new ItemSelectableTracker((ItemSelectable)this.groupImports, new Component[]{jLabel, this.groupDepth});
        this.groupImports.addItemListener(checkBoxListener);
        this.groupDepth.getDocument().addDocumentListener(fieldListener);
        ResourceUtils.resButton((AbstractButton)this.useWideImports, (String)CodingStyleArb.getString(131));
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.importThreshold, (String)CodingStyleArb.getString(132));
        new ItemSelectableTracker((ItemSelectable)this.useWideImports, new Component[]{jLabel2, this.importThreshold});
        this.useWideImports.addItemListener(checkBoxListener);
        this.importThreshold.getDocument().addDocumentListener(fieldListener);
        ResourceUtils.resButton((AbstractButton)this.innerClasses, (String)CodingStyleArb.getString(133));
        this.innerClasses.addItemListener(checkBoxListener);
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.preview.getEditor(), (String)CodingStyleArb.getString(128));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 2, 0);
        this.add(this.groupImports, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(0, 29, 10, 3);
        this.add(jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.add((Component)this.groupDepth, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.add(this.useWideImports, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(0, 29, 10, 3);
        this.add(jLabel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.add((Component)this.importThreshold, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 5, 15, 0);
        this.add(this.innerClasses, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.add(jLabel3, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add(this.preview, gridBagConstraints);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.profile = (CodingStyleProfile)traversableContext.find("Profile");
        this.preview.setProfile(this.profile);
        this.preview.setSampleCode(this.getSampleCode());
        this.preview.update();
        try {
            this.loading = true;
            this.groupImports.setSelected(this.profile.getGroupImports());
            this.groupDepth.setText(Integer.toString(this.profile.getGroupPackageDepth()));
            this.useWideImports.setSelected(this.profile.getUseWideImports());
            this.importThreshold.setText(Integer.toString(this.profile.getWideImportThreshold()));
            this.innerClasses.setSelected(this.profile.getImportInnerClasses());
        }
        finally {
            this.loading = false;
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.profile = (CodingStyleProfile)traversableContext.find("Profile");
        this.saveToProfile();
    }

    private void saveToProfile() {
        this.profile.setGroupImports(this.groupImports.isSelected());
        this.profile.setGroupPackageDepth(this.groupDepth.getValue());
        this.profile.setUseWideImports(this.useWideImports.isSelected());
        this.profile.setWideImportThreshold(this.importThreshold.getValue());
        this.profile.setImportInnerClasses(this.innerClasses.isSelected());
    }

    private String getSampleCode() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.profile != null) {
            boolean bl = this.profile.getUseWideImports();
            int n = this.profile.getWideImportThreshold();
            if (bl && n < 4) {
                stringBuffer.append("import java.awt.*;");
            } else {
                stringBuffer.append("import java.awt.Button;");
                stringBuffer.append("import java.awt.Component;");
                stringBuffer.append("import java.awt.Container;");
            }
            if (bl && n < 3) {
                stringBuffer.append("import java.awt.event.*;");
            } else {
                stringBuffer.append("import java.awt.event.ActionEvent;");
                stringBuffer.append("import java.awt.event.ActionListener;");
            }
            if (this.profile.getImportInnerClasses()) {
                if (bl && n < 2) {
                    stringBuffer.append("import java.util.*;");
                    stringBuffer.append("import java.util.Map.Entry;");
                } else {
                    stringBuffer.append("import java.util.Map;");
                    stringBuffer.append("import java.util.Map.Entry;");
                }
            } else if (bl && n < 2) {
                stringBuffer.append("import java.util.*;");
            } else {
                stringBuffer.append("import java.util.Map;");
            }
            if (bl && n < 5) {
                stringBuffer.append("import javax.swing.*;");
            } else {
                stringBuffer.append("import javax.swing.JButton;");
                stringBuffer.append("import javax.swing.JCheckBox;");
                stringBuffer.append("import javax.swing.JPanel;");
                stringBuffer.append("import javax.swing.JScrollPane;");
            }
        }
        return stringBuffer.toString();
    }

    private void updatePreview() {
        this.saveToProfile();
        this.preview.setSampleCode(this.getSampleCode());
        this.preview.update();
    }

    static boolean ra$loading(CodingStyleImportsPanel codingStyleImportsPanel) {
        return codingStyleImportsPanel.loading;
    }

    static void mav$updatePreview(CodingStyleImportsPanel codingStyleImportsPanel) {
        codingStyleImportsPanel.updatePreview();
    }

    private class CheckBoxListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (!CodingStyleImportsPanel.ra$loading(CodingStyleImportsPanel.this)) {
                CodingStyleImportsPanel.mav$updatePreview(CodingStyleImportsPanel.this);
            }
        }

        private CheckBoxListener() {
        }

        CheckBoxListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class FieldListener
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            this.handleEvent();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.handleEvent();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.handleEvent();
        }

        private void handleEvent() {
            if (!CodingStyleImportsPanel.ra$loading(CodingStyleImportsPanel.this)) {
                CodingStyleImportsPanel.mav$updatePreview(CodingStyleImportsPanel.this);
            }
        }

        private FieldListener() {
        }

        FieldListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

