/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.style.profile.CodingStylePreviewPanel;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.resource.CodingStyleArb;

public class CodingStyleNamingPanel
extends DefaultTraversablePanel {
    private static final String HELP_TOPIC = "f1_ideideseteditcodingstylenaming_html";
    private static final int FIELD_COLUMNS = 12;
    private CodingStylePreviewPanel preview;
    private CodingStyleProfile profile;
    private boolean loading;
    private JTextField fieldPrefix;
    private JTextField fieldSuffix;
    private JTextField staticFieldPrefix;
    private JTextField staticFieldSuffix;
    private JTextField parameterPrefix;
    private JTextField parameterSuffix;
    private JTextField localVariablePrefix;
    private JTextField localVariableSuffix;

    void $init$() {
        this.fieldPrefix = new PrefixField(12);
        this.fieldSuffix = new SuffixField(12);
        this.staticFieldPrefix = new PrefixField(12);
        this.staticFieldSuffix = new SuffixField(12);
        this.parameterPrefix = new PrefixField(12);
        this.parameterSuffix = new SuffixField(12);
        this.localVariablePrefix = new PrefixField(12);
        this.localVariableSuffix = new SuffixField(12);
    }

    public CodingStyleNamingPanel() {
        this.$init$();
        this.setHelpID(HELP_TOPIC);
        this.preview = new CodingStylePreviewPanel();
        this.preview.setSampleCode(this.getSampleCode());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.preview.getEditor(), (String)CodingStyleArb.getString(118));
        this.fieldPrefix.getDocument().addDocumentListener(new FieldListener(null));
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.fieldPrefix, (String)CodingStyleArb.getString(120));
        this.fieldSuffix.getDocument().addDocumentListener(new FieldListener(null));
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.fieldSuffix, (String)CodingStyleArb.getString(121));
        this.staticFieldPrefix.getDocument().addDocumentListener(new FieldListener(null));
        JLabel jLabel4 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.staticFieldPrefix, (String)CodingStyleArb.getString(122));
        this.staticFieldSuffix.getDocument().addDocumentListener(new FieldListener(null));
        JLabel jLabel5 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel5, (Component)this.staticFieldSuffix, (String)CodingStyleArb.getString(123));
        this.parameterPrefix.getDocument().addDocumentListener(new FieldListener(null));
        JLabel jLabel6 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel6, (Component)this.parameterPrefix, (String)CodingStyleArb.getString(124));
        this.parameterSuffix.getDocument().addDocumentListener(new FieldListener(null));
        JLabel jLabel7 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel7, (Component)this.parameterSuffix, (String)CodingStyleArb.getString(125));
        this.localVariablePrefix.getDocument().addDocumentListener(new FieldListener(null));
        JLabel jLabel8 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel8, (Component)this.localVariablePrefix, (String)CodingStyleArb.getString(126));
        this.localVariableSuffix.getDocument().addDocumentListener(new FieldListener(null));
        JLabel jLabel9 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel9, (Component)this.localVariableSuffix, (String)CodingStyleArb.getString(127));
        JPanel jPanel = new JPanel();
        String string = CodingStyleArb.getString(119);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(string), BorderFactory.createEmptyBorder(0, 8, 8, 8)));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 3);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 3, 24);
        jPanel.add((Component)this.fieldPrefix, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(0, 0, 3, 3);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel.add((Component)this.fieldSuffix, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 3, 3);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 3, 24);
        jPanel.add((Component)this.staticFieldPrefix, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(0, 0, 3, 3);
        jPanel.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel.add((Component)this.staticFieldSuffix, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 3, 3);
        jPanel.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 3, 24);
        jPanel.add((Component)this.parameterPrefix, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(0, 0, 3, 3);
        jPanel.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel.add((Component)this.parameterSuffix, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 24);
        jPanel.add((Component)this.localVariablePrefix, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel.add((Component)jLabel9, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.localVariableSuffix, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add(jPanel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.add(jLabel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.preview, gridBagConstraints);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.profile = (CodingStyleProfile)traversableContext.find("Profile");
        this.preview.setProfile(this.profile);
        this.preview.update();
        try {
            this.loading = true;
            this.fieldPrefix.setText(this.profile.getFieldPrefix());
            this.fieldSuffix.setText(this.profile.getFieldSuffix());
            this.staticFieldPrefix.setText(this.profile.getStaticFieldPrefix());
            this.staticFieldSuffix.setText(this.profile.getStaticFieldSuffix());
            this.parameterPrefix.setText(this.profile.getParameterPrefix());
            this.parameterSuffix.setText(this.profile.getParameterSuffix());
            this.localVariablePrefix.setText(this.profile.getLocalVariablePrefix());
            this.localVariableSuffix.setText(this.profile.getLocalVariableSuffix());
        }
        finally {
            this.loading = false;
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.profile = (CodingStyleProfile)traversableContext.find("Profile");
        this.saveToProfile();
    }

    private void saveToProfile() {
        this.profile.setFieldPrefix(this.normalize(this.fieldPrefix.getText()));
        this.profile.setFieldSuffix(this.normalize(this.fieldSuffix.getText()));
        this.profile.setStaticFieldPrefix(this.normalize(this.staticFieldPrefix.getText()));
        this.profile.setStaticFieldSuffix(this.normalize(this.staticFieldSuffix.getText()));
        this.profile.setParameterPrefix(this.normalize(this.parameterPrefix.getText()));
        this.profile.setParameterSuffix(this.normalize(this.parameterSuffix.getText()));
        this.profile.setLocalVariablePrefix(this.normalize(this.localVariablePrefix.getText()));
        this.profile.setLocalVariableSuffix(this.normalize(this.localVariableSuffix.getText()));
    }

    private String normalize(String string) {
        if (string != null && string.trim().length() == 0) {
            return null;
        }
        return string;
    }

    private String getSampleCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package mypackage.naming;");
        stringBuffer.append("public class Class1");
        stringBuffer.append("{");
        stringBuffer.append("private String ${field field};");
        stringBuffer.append("private static String ${static staticField};");
        stringBuffer.append("public int getValue(");
        stringBuffer.append("String ${parameter parameter})");
        stringBuffer.append("{");
        stringBuffer.append("int ${local local} = 10;");
        stringBuffer.append("return ${local local};");
        stringBuffer.append("}");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    static boolean ra$loading(CodingStyleNamingPanel codingStyleNamingPanel) {
        return codingStyleNamingPanel.loading;
    }

    static void mav$saveToProfile(CodingStyleNamingPanel codingStyleNamingPanel) {
        codingStyleNamingPanel.saveToProfile();
    }

    static CodingStylePreviewPanel ra$preview(CodingStyleNamingPanel codingStyleNamingPanel) {
        return codingStyleNamingPanel.preview;
    }

    private class FieldListener
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            this.handleEvent();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.handleEvent();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.handleEvent();
        }

        private void handleEvent() {
            if (!CodingStyleNamingPanel.ra$loading(CodingStyleNamingPanel.this)) {
                CodingStyleNamingPanel.mav$saveToProfile(CodingStyleNamingPanel.this);
                CodingStyleNamingPanel.ra$preview(CodingStyleNamingPanel.this).update();
            }
        }

        private FieldListener() {
        }

        FieldListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PrefixField
    extends JTextField {
        public PrefixField(int n) {
            super(n);
        }

        protected Document createDefaultModel() {
            return new JavaIdentifierDocument(true);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    private class SuffixField
    extends JTextField {
        public SuffixField(int n) {
            super(n);
        }

        protected Document createDefaultModel() {
            return new JavaIdentifierDocument(false);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    private class JavaIdentifierDocument
    extends PlainDocument {
        private boolean isPrefix;

        public JavaIdentifierDocument(boolean bl) {
            this.isPrefix = bl;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            boolean bl = true;
            char[] cArray = string.toCharArray();
            int n2 = 0;
            if (this.isPrefix && n == 0) {
                bl = Character.isJavaIdentifierStart(cArray[n2++]);
            }
            while (bl && n2 < cArray.length) {
                bl = Character.isJavaIdentifierPart(cArray[n2++]);
            }
            if (bl) {
                super.insertString(n, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

