/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.button.ButtonBar;
import oracle.ide.nulls.NullIcon;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.OverlayedIcon;
import oracle.jdevimpl.java.explorer.SideBySideIcon;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.resource.CodingStyleArb;

public class CodingStyleOrderPanel
extends DefaultTraversablePanel {
    private static final String HELP_TOPIC = "f1_ideideseteditcodingstyleorder_html";
    private static final int ACCESS_LEVEL_PUBLIC = 0;
    private static final int ACCESS_LEVEL_PROTECTED = 1;
    private static final int ACCESS_LEVEL_PACKAGE = 2;
    private static final int ACCESS_LEVEL_PRIVATE = 3;
    private JList list;
    private JButton upButton;
    private JButton downButton;
    private boolean moving;
    private CodingStyleProfile profile;
    private ArrayList listItems;
    private DefaultListModel model;

    void $init$() {
        this.listItems = new ArrayList();
        this.model = new DefaultListModel();
    }

    public CodingStyleOrderPanel() {
        this.$init$();
        this.setHelpID(HELP_TOPIC);
        this.listItems.add(new JavaMember(0, true, JavaIcons.getIcon(2), CodingStyleArb.getString(103), 0));
        this.listItems.add(new JavaMember(1, true, JavaIcons.getIcon(2), CodingStyleArb.getString(104), 1));
        this.listItems.add(new JavaMember(2, true, JavaIcons.getIcon(2), CodingStyleArb.getString(105), 2));
        this.listItems.add(new JavaMember(3, true, JavaIcons.getIcon(2), CodingStyleArb.getString(106), 3));
        this.listItems.add(new JavaMember(0, false, JavaIcons.getIcon(2), CodingStyleArb.getString(107), 4));
        this.listItems.add(new JavaMember(1, false, JavaIcons.getIcon(2), CodingStyleArb.getString(108), 5));
        this.listItems.add(new JavaMember(2, false, JavaIcons.getIcon(2), CodingStyleArb.getString(109), 6));
        this.listItems.add(new JavaMember(3, false, JavaIcons.getIcon(2), CodingStyleArb.getString(110), 7));
        this.listItems.add(new JavaMember(-1, false, JavaIcons.getIcon(4), CodingStyleArb.getString(111), 8));
        this.listItems.add(new JavaMember(-1, false, JavaIcons.getIcon(3), CodingStyleArb.getString(112), 9));
        this.listItems.add(new JavaMember(-1, false, JavaIcons.getIcon(0), CodingStyleArb.getString(113), 10));
        this.updateModel();
        this.list = new JList(this.model);
        this.list.setSelectionMode(2);
        this.list.setSelectedIndex(0);
        this.list.setCellRenderer(new JavaMemberRenderer(null));
        this.list.addListSelectionListener(new SelectionListener(null));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.list, (String)CodingStyleArb.getString(100));
        JScrollPane jScrollPane = new JScrollPane(this.list);
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setOrientation(1);
        buttonBar.setAlignment(1);
        this.upButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.upButton, (String)CodingStyleArb.getString(101));
        ButtonListener buttonListener = new ButtonListener(null);
        this.upButton.addActionListener(buttonListener);
        buttonBar.add((Component)this.upButton);
        this.downButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.downButton, (String)CodingStyleArb.getString(102));
        this.downButton.addActionListener(buttonListener);
        buttonBar.add((Component)this.downButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(8, 3));
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)buttonBar, "East");
        jPanel.add((Component)jLabel, "North");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(jPanel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 0.0;
        this.add(new JLabel(), gridBagConstraints);
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.profile = (CodingStyleProfile)traversableContext.find("Profile");
        Collections.sort(this.listItems);
        this.updateModel();
        this.updateButtons();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        CodingStyleProfile codingStyleProfile = (CodingStyleProfile)traversableContext.find("Profile");
        byte by = 0;
        boolean bl = false;
        int n = this.model.getSize();
        int n2 = 0;
        while (n2 < n) {
            JavaMember javaMember = (JavaMember)this.model.get(n2);
            byte by2 = codingStyleProfile.getMemberOrder(javaMember.getId());
            if (by2 < by) {
                bl = true;
                break;
            }
            by = by2;
            ++n2;
        }
        if (bl) {
            int n3 = 0;
            while (n3 < n) {
                JavaMember javaMember = (JavaMember)this.model.get(n3);
                codingStyleProfile.setMemberOrder(javaMember.getId(), (byte)n3);
                ++n3;
            }
        }
    }

    private void updateButtons() {
        int[] nArray = this.list.getSelectedIndices();
        if (nArray.length > 0) {
            this.upButton.setEnabled(nArray[0] > 0);
            this.downButton.setEnabled(nArray[nArray.length - 1] < this.model.getSize() - 1);
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    private void moveUp() {
        try {
            this.moving = true;
            int[] nArray = this.list.getSelectedIndices();
            int[] nArray2 = new int[nArray.length];
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                Object e = this.model.get(n2);
                this.model.removeElementAt(n2);
                this.model.add(n2 - 1, e);
                nArray2[n] = n2 - 1;
                ++n;
            }
            this.list.setSelectedIndices(nArray2);
        }
        finally {
            this.moving = false;
            this.updateButtons();
        }
    }

    private void moveDown() {
        try {
            this.moving = true;
            int[] nArray = this.list.getSelectedIndices();
            int[] nArray2 = new int[nArray.length];
            int n = nArray.length - 1;
            while (n >= 0) {
                int n2 = nArray[n];
                Object e = this.model.get(n2);
                this.model.removeElementAt(n2);
                if (n2 + 1 == this.model.getSize()) {
                    this.model.addElement(e);
                } else {
                    this.model.add(n2 + 1, e);
                }
                nArray2[n] = n2 + 1;
                --n;
            }
            this.list.setSelectedIndices(nArray2);
        }
        finally {
            this.moving = false;
            this.updateButtons();
        }
    }

    private void updateModel() {
        int n = this.model.getSize();
        Iterator iterator = this.listItems.iterator();
        while (iterator.hasNext()) {
            this.model.addElement(iterator.next());
        }
        if (n > 0) {
            this.model.removeRange(0, n - 1);
        }
        if (this.list != null) {
            this.list.setSelectedIndex(0);
        }
    }

    static CodingStyleProfile ra$profile(CodingStyleOrderPanel codingStyleOrderPanel) {
        return codingStyleOrderPanel.profile;
    }

    static JButton ra$upButton(CodingStyleOrderPanel codingStyleOrderPanel) {
        return codingStyleOrderPanel.upButton;
    }

    static void mav$moveUp(CodingStyleOrderPanel codingStyleOrderPanel) {
        codingStyleOrderPanel.moveUp();
    }

    static JButton ra$downButton(CodingStyleOrderPanel codingStyleOrderPanel) {
        return codingStyleOrderPanel.downButton;
    }

    static void mav$moveDown(CodingStyleOrderPanel codingStyleOrderPanel) {
        codingStyleOrderPanel.moveDown();
    }

    static boolean ra$moving(CodingStyleOrderPanel codingStyleOrderPanel) {
        return codingStyleOrderPanel.moving;
    }

    static void mav$updateButtons(CodingStyleOrderPanel codingStyleOrderPanel) {
        codingStyleOrderPanel.updateButtons();
    }

    private class JavaMember
    implements Comparable {
        private Icon icon;
        private String name;
        private int id;

        public JavaMember(int n, boolean bl, Icon icon, String string, int n2) {
            this.name = string;
            this.id = n2;
            if (icon == null) {
                icon = new NullIcon();
            }
            Object object = new NullIcon(13, 16);
            if (n >= 0) {
                switch (n) {
                    case 0: {
                        object = JavaArb.getIcon(62);
                        break;
                    }
                    case 1: {
                        object = JavaArb.getIcon(63);
                        break;
                    }
                    case 2: {
                        object = JavaArb.getIcon(65);
                        break;
                    }
                    case 3: {
                        object = JavaArb.getIcon(64);
                        break;
                    }
                    default: {
                        object = null;
                    }
                }
                if (object != null && bl) {
                    Icon icon2 = JavaArb.getIcon(66);
                    object = new OverlayedIcon(icon2, (Icon)object);
                }
            }
            this.icon = new SideBySideIcon(icon, (Icon)object, 1);
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return this.name;
        }

        public int compareTo(Object object) {
            if (!(object instanceof JavaMember)) {
                throw new ClassCastException();
            }
            JavaMember javaMember = (JavaMember)object;
            Byte by = new Byte(CodingStyleOrderPanel.ra$profile(CodingStyleOrderPanel.this).getMemberOrder(this.id));
            Byte by2 = new Byte(CodingStyleOrderPanel.ra$profile(CodingStyleOrderPanel.this).getMemberOrder(javaMember.id));
            return by.compareTo(by2);
        }
    }

    private class JavaMemberRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof JavaMember) {
                JavaMember javaMember = (JavaMember)object;
                this.setText(javaMember.getName());
                this.setIcon(javaMember.getIcon());
            }
            return this;
        }

        private JavaMemberRenderer() {
        }

        JavaMemberRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == CodingStyleOrderPanel.ra$upButton(CodingStyleOrderPanel.this)) {
                CodingStyleOrderPanel.mav$moveUp(CodingStyleOrderPanel.this);
            } else if (object == CodingStyleOrderPanel.ra$downButton(CodingStyleOrderPanel.this)) {
                CodingStyleOrderPanel.mav$moveDown(CodingStyleOrderPanel.this);
            }
        }

        private ButtonListener() {
        }

        ButtonListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!CodingStyleOrderPanel.ra$moving(CodingStyleOrderPanel.this)) {
                CodingStyleOrderPanel.mav$updateButtons(CodingStyleOrderPanel.this);
            }
        }

        private SelectionListener() {
        }

        SelectionListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

