/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdevimpl.style.profile.CodingStyleProfile;

public class CodingStylePreviewPanel
extends JPanel {
    private CodingStyleProfile profile;
    private BasicEditorPane editor = EditorFactory.createStandaloneEditorPane();
    private String sample;

    public CodingStylePreviewPanel() {
        this.editor.setLanguageSupport("Sample.java");
        this.editor.setProtected(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this.editor);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
    }

    public void setSampleCode(String string) {
        this.sample = string;
    }

    public void setProfile(CodingStyleProfile codingStyleProfile) {
        this.profile = codingStyleProfile;
    }

    public BasicEditorPane getEditor() {
        return this.editor;
    }

    public void update() {
        if (this.profile != null && this.sample != null) {
            Rectangle rectangle = new Rectangle();
            this.editor.computeVisibleRect(rectangle);
            String string = this.profile.applyNamingConventions(this.sample);
            string = this.organizeImports(string);
            string = this.profile.format(string);
            this.editor.setProtected(false);
            this.editor.setText(string);
            this.editor.setProtected(true);
            this.editor.putProperty("tab-size", (Object)new Integer(this.profile.getTabSize()));
            this.editor.putProperty("right-margin-column", (Object)new Integer(this.profile.getWrapLineWidth()));
            this.editor.scrollRectToVisible(rectangle);
        }
    }

    private String organizeImports(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Pattern pattern = Pattern.compile("\\$\\{import\\}");
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        while (matcher.find(n)) {
            int n2 = matcher.start();
            int n3 = matcher.end();
            stringBuffer.append(string.substring(n, n2));
            if (this.profile.getUseWideImports() && this.profile.getWideImportThreshold() < 2) {
                stringBuffer.append("import java.util.*;");
            } else {
                stringBuffer.append("import java.util.List;");
            }
            n = n3;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }
}

