/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaPreferences;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourcePreferences;
import oracle.javatools.util.CopyOnWriteList;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdeveloper.style.CodingStyleOptionsListener;

public class CodingStyleProfile
extends HashStructureAdapter
implements JavaPreferences,
Copyable,
CodingStyleOptions {
    public static final String DATA_KEY = "Profile";
    private static final String NAME = "profile.name";
    private static final String FIELD_PREFIX = "field.prefix";
    private static final String FIELD_SUFFIX = "field.suffix";
    private static final String STATIC_FIELD_PREFIX = "static.field.prefix";
    private static final String STATIC_FIELD_SUFFIX = "static.field.suffix";
    private static final String PARAMETER_PREFIX = "parameter.prefix";
    private static final String PARAMETER_SUFFIX = "parameter.suffix";
    private static final String LOCAL_VARIABLE_PREFIX = "local.variable.prefix";
    private static final String LOCAL_VARIABLE_SUFFIX = "local.variable.suffix";
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"coding-style-profile");
    private static final String ROOT_TAG = "profile";
    private SourcePreferences preferences;
    private boolean modified;
    private boolean dirty;
    private boolean disableEvents;
    private final CopyOnWriteList listeners;
    public static final String PROPERTY_INDENT_SIZE = "indentSize";
    public static final String PROPERTY_INDENT_REPLACE_WITH_TABS = "indentReplaceWithTabs";
    public static final String PROPERTY_INDENT_TAB_SIZE = "tabSize";
    public static final String PROPERTY_INDENT_CLASS_MEMBERS = "indentClassMembers";
    public static final String PROPERTY_INDENT_CONTROL_BLOCKS = "indentControlBlocks";
    public static final String PROPERTY_INDENT_BLOCK_CHILDREN = "indentBlockChildren";
    public static final String PROPERTY_INDENT_SWITCH_CASES = "indentSwitchCases";
    public static final String PROPERTY_BLANKLINES_PRESERVED = "blanklinesPreserved";
    public static final String PROPERTY_BLANKLINES_AFTER_PACKAGE = "blanklinesAfterPackage";
    public static final String PROPERTY_BLANKLINES_AFTER_IMPORTS = "blanklinesAfterImports";
    public static final String PROPERTY_BLANKLINES_BEFORE_FIRST_CLASS = "blanklinesBeforeFirstClass";
    public static final String PROPERTY_BLANKLINES_BEFORE_FIRST_MEMBER = "blanklinesBeforeFirstMember";
    public static final String PROPERTY_BLANKLINES_AFTER_LAST_MEMBER = "blanklinesAfterLastMember";
    public static final String PROPERTY_BLANKLINES_BEFORE_FIELD = "blanklinesBeforeField";
    public static final String PROPERTY_BLANKLINES_BEFORE_METHOD = "blanklinesBeforeMethod";
    public static final String PROPERTY_BLANKLINES_BEFORE_MEMBER_CLASS = "blanklinesBeforeMemberClass";
    public static final String PROPERTY_BLANKLINES_EMPTY_CLASS = "blanklinesEmptyClass";
    public static final String PROPERTY_BLANKLINES_EMPTY_ANONYMOUS = "blanklinesEmptyAnonymous";
    public static final String PROPERTY_BLANKLINES_EMPTY_METHOD = "blanklinesEmptyMethod";
    public static final String PROPERTY_BLANKLINES_EMPTY_BLOCK = "blanklinesEmptyBlock";
    public static final String PROPERTY_BRACE_POSITION_CLASS = "classBracePosition";
    public static final String PROPERTY_BRACE_POSITION_METHOD = "methodBracePosition";
    public static final String PROPERTY_BRACE_POSITION_BLOCK = "blockBracePosition";
    public static final String PROPERTY_BRACE_POSITION_ARRAY = "arrayBracePosition";
    public static final String PROPERTY_BRACE_POSITION_SWITCH_CASE = "switchCaseBracePosition";
    public static final String PROPERTY_NEWLINE_EXTENDS = "newlineExtends";
    public static final String PROPERTY_NEWLINE_IMPLEMENTS = "newlineImplements";
    public static final String PROPERTY_NEWLINE_THROWS = "newlineThrows";
    public static final String PROPERTY_NEWLINE_ELSE = "newlineElse";
    public static final String PROPERTY_NEWLINE_WHILE = "newlineWhile";
    public static final String PROPERTY_NEWLINE_CATCH = "newlineCatch";
    public static final String PROPERTY_NEWLINE_FINALLY = "newlineFinally";
    public static final String PROPERTY_SPACE_BEFORE_COMMA = "spaceBeforeComma";
    public static final String PROPERTY_SPACE_AFTER_COMMA = "spaceAfterComma";
    public static final String PROPERTY_SPACE_BEFORE_SEMICOLON = "spaceBeforeSemicolon";
    public static final String PROPERTY_SPACE_AFTER_SEMICOLON = "spaceAfterSemicolon";
    public static final String PROPERTY_SPACE_BEFORE_QUESTION = "spaceBeforeQuestion";
    public static final String PROPERTY_SPACE_AFTER_QUESTION = "spaceAfterQuestion";
    public static final String PROPERTY_SPACE_BEFORE_COLON = "spaceBeforeColon";
    public static final String PROPERTY_SPACE_AFTER_COLON = "spaceAfterColon";
    public static final String PROPERTY_SPACE_AFTER_TYPECAST = "spaceAfterTypecast";
    public static final String PROPERTY_SPACE_BEFORE_ARGUMENTS = "spaceBeforeArguments";
    public static final String PROPERTY_SPACE_BEFORE_PARAMETERS = "spaceBeforeParameters";
    public static final String PROPERTY_SPACE_AFTER_KEYWORD = "spaceAfterKeyword";
    public static final String PROPERTY_SPACE_AROUND_ASSIGNMENT = "spaceAroundAssignment";
    public static final String PROPERTY_SPACE_AROUND_BINARY_OPERATOR = "spaceAroundBinaryOperator";
    public static final String PROPERTY_SPACE_WITHIN_PARENTHESIS = "spaceWithinParenthesis";
    public static final String PROPERTY_SPACE_WITHIN_BRACKETS = "spaceWithinBrackets";
    public static final String PROPERTY_SPACE_BEFORE_OPEN_BRACE = "spaceBeforeOpenBrace";
    public static final String PROPERTY_WRAP_LINE_WIDTH = "wrapLineWidth";
    public static final String PROPERTY_WRAP_ALIGN = "wrapAlign";
    public static final String PROPERTY_WRAP_MODIFIERS = "wrapModifiers";
    public static final String PROPERTY_WRAP_EXTENDS = "wrapExtends";
    public static final String PROPERTY_WRAP_THROWS = "wrapThrows";
    public static final String PROPERTY_WRAP_PARAMETER_LIST = "wrapParameterList";
    public static final String PROPERTY_WRAP_DOT_CHAIN = "wrapDotChain";
    public static final String PROPERTY_WRAP_FOR_STATEMENT = "wrapForStatement";
    public static final String PROPERTY_WRAP_BINARY_OPERATOR = "wrapBinaryOperator";
    public static final String PROPERTY_WRAP_TERNARY_EXPRESSION = "wrapTernaryExpression";
    public static final String PROPERTY_WRAP_ARRAY_CONSTANT = "wrapArrayConstant";
    public static final String PROPERTY_WRAP_INVOKE_ARGUMENTS = "wrapInvokeArguments";
    public static final String PROPERTY_GROUP_IMPORTS = "groupImports";
    public static final String PROPERTY_GROUP_PACKAGE_DEPTH = "groupPackageDepth";
    public static final String PROPERTY_IMPORT_INNER_CLASSES = "importInnerClasses";
    public static final String PROPERTY_USE_WIDE_IMPORTS = "useWideImports";
    public static final String PROPERTY_WIDE_IMPORT_THRESHOLD = "wideImportThreshold";
    public static final String IMPORT_NARROW_THRESHOLD_PREVIOUS = "import.narrow_threshold.previous";
    public static final String PROPERTY_FIELD_PREFIX = "fieldPrefix";
    public static final String PROPERTY_FIELD_SUFFIX = "fieldSuffix";
    public static final String PROPERTY_STATIC_FIELD_PREFIX = "staticFieldPrefix";
    public static final String PROPERTY_STATIC_FIELD_SUFFIX = "staticFieldSuffix";
    public static final String PROPERTY_PARAMETER_PREFIX = "parameterPrefix";
    public static final String PROPERTY_PARAMETER_SUFFIX = "parameterSuffix";
    public static final String PROPERTY_LOCAL_VARIABLE_PREFIX = "localVariablePrefix";
    public static final String PROPERTY_LOCAL_VARIABLE_SUFFIX = "localVariableSuffix";

    void $init$() {
        this.listeners = new CopyOnWriteList();
    }

    public CodingStyleProfile() {
        this(HashStructure.newInstance());
    }

    public CodingStyleProfile(HashStructure hashStructure) {
        super(hashStructure);
        this.$init$();
        this.preferences = new SourcePreferences(hashStructure);
        hashStructure.addStructureChangeListener((StructureChangeListener)new ChangeListener(null));
    }

    public void addCodingStyleOptionsListener(CodingStyleOptionsListener codingStyleOptionsListener) {
        if (codingStyleOptionsListener != null) {
            this.listeners.addIfAbsent((Object)codingStyleOptionsListener);
        }
    }

    public void removeCodingStyleOptionsListener(CodingStyleOptionsListener codingStyleOptionsListener) {
        if (codingStyleOptionsListener != null) {
            this.listeners.remove((Object)codingStyleOptionsListener);
        }
    }

    public void exportTo(URL uRL) throws IOException {
        HashStructureIO hashStructureIO = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
        hashStructureIO.save(uRL, (Object)this._hash);
    }

    public static CodingStyleProfile importFrom(URL uRL) throws IOException {
        HashStructureIO hashStructureIO = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
        return new CodingStyleProfile((HashStructure)hashStructureIO.load(uRL));
    }

    public boolean isModified() throws TransientMarker {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isDirty() throws TransientMarker {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public SourcePreferences getSourcePreferences() {
        return this.preferences;
    }

    public String getName() {
        return this._hash.getString(NAME);
    }

    public void setName(String string) {
        this._hash.putString(NAME, string, true);
    }

    public int getIndentSize() {
        return this.preferences.getInt(0);
    }

    public void setIndentSize(int n) {
        this.preferences.setInt(0, n);
    }

    public boolean getIndentReplaceWithTabs() {
        return this.preferences.getBoolean(1);
    }

    public void setIndentReplaceWithTabs(boolean bl) {
        this.preferences.setBoolean(1, bl);
    }

    public int getTabSize() {
        return this.preferences.getInt(2);
    }

    public void setTabSize(int n) {
        this.preferences.setInt(2, n);
    }

    public boolean getIndentClassMembers() {
        return this.preferences.getBoolean(3);
    }

    public void setIndentClassMembers(boolean bl) {
        this.preferences.setBoolean(3, bl);
    }

    public boolean getIndentControlBlocks() {
        return this.preferences.getBoolean(5);
    }

    public void setIndentControlBlocks(boolean bl) {
        this.preferences.setBoolean(5, bl);
    }

    public boolean getIndentBlockChildren() {
        return this.preferences.getBoolean(4);
    }

    public void setIndentBlockChildren(boolean bl) {
        this.preferences.setBoolean(4, bl);
    }

    public boolean getIndentSwitchCases() {
        return this.preferences.getBoolean(6);
    }

    public void setIndentSwitchCases(boolean bl) {
        this.preferences.setBoolean(6, bl);
    }

    public int getBlanklinesPreserved() {
        return this.preferences.getInt(7);
    }

    public void setBlanklinesPreserved(int n) {
        this.preferences.setInt(7, n);
    }

    public int getBlanklinesAfterPackage() {
        return this.preferences.getInt(8);
    }

    public void setBlanklinesAfterPackage(int n) {
        this.preferences.setInt(8, n);
    }

    public int getBlanklinesAfterImports() {
        return this.preferences.getInt(9);
    }

    public void setBlanklinesAfterImports(int n) {
        this.preferences.setInt(9, n);
    }

    public int getBlanklinesBeforeFirstClass() {
        return this.preferences.getInt(10);
    }

    public void setBlanklinesBeforeFirstClass(int n) {
        this.preferences.setInt(10, n);
    }

    public int getBlanklinesBeforeFirstMember() {
        return this.preferences.getInt(11);
    }

    public void setBlanklinesBeforeFirstMember(int n) {
        this.preferences.setInt(11, n);
    }

    public int getBlanklinesAfterLastMember() {
        return this.preferences.getInt(12);
    }

    public void setBlanklinesAfterLastMember(int n) {
        this.preferences.setInt(12, n);
    }

    public int getBlanklinesBeforeField() {
        return this.preferences.getInt(14);
    }

    public void setBlanklinesBeforeField(int n) {
        this.preferences.setInt(14, n);
    }

    public int getBlanklinesBeforeMethod() {
        return this.preferences.getInt(15);
    }

    public void setBlanklinesBeforeMethod(int n) {
        this.preferences.setInt(15, n);
    }

    public int getBlanklinesBeforeMemberClass() {
        return this.preferences.getInt(16);
    }

    public void setBlanklinesBeforeMemberClass(int n) {
        this.preferences.setInt(16, n);
    }

    public int getBlanklinesEmptyClass() {
        return this.preferences.getInt(17);
    }

    public void setBlanklinesEmptyClass(int n) {
        this.preferences.setInt(17, n);
    }

    public int getBlanklinesEmptyAnonymous() {
        return this.preferences.getInt(18);
    }

    public void setBlanklinesEmptyAnonymous(int n) {
        this.preferences.setInt(18, n);
    }

    public int getBlanklinesEmptyMethod() {
        return this.preferences.getInt(19);
    }

    public void setBlanklinesEmptyMethod(int n) {
        this.preferences.setInt(19, n);
    }

    public int getBlanklinesEmptyBlock() {
        return this.preferences.getInt(20);
    }

    public void setBlanklinesEmptyBlock(int n) {
        this.preferences.setInt(20, n);
    }

    public int getClassBracePosition() {
        return this.preferences.getBoolean(21) ? 1 : 0;
    }

    public void setClassBracePosition(int n) {
        boolean bl = n == 0;
        this.preferences.setBoolean(21, bl ^ true);
    }

    public int getMethodBracePosition() {
        return this.preferences.getBoolean(22) ? 1 : 0;
    }

    public void setMethodBracePosition(int n) {
        boolean bl = n == 0;
        this.preferences.setBoolean(22, bl ^ true);
    }

    public int getBlockBracePosition() {
        return this.preferences.getBoolean(23) ? 1 : 0;
    }

    public void setBlockBracePosition(int n) {
        boolean bl = n == 0;
        this.preferences.setBoolean(23, bl ^ true);
    }

    public int getArrayBracePosition() {
        return this.preferences.getBoolean(24) ? 1 : 0;
    }

    public void setArrayBracePosition(int n) {
        boolean bl = n == 0;
        this.preferences.setBoolean(24, bl ^ true);
    }

    public int getSwitchCaseBracePosition() {
        return this.preferences.getBoolean(25) ? 1 : 0;
    }

    public void setSwitchCaseBracePosition(int n) {
        boolean bl = n == 0;
        this.preferences.setBoolean(25, bl ^ true);
    }

    public boolean getNewlineExtends() {
        return this.preferences.getBoolean(26);
    }

    public void setNewlineExtends(boolean bl) {
        this.preferences.setBoolean(26, bl);
    }

    public boolean getNewlineImplements() {
        return this.preferences.getBoolean(27);
    }

    public void setNewlineImplements(boolean bl) {
        this.preferences.setBoolean(27, bl);
    }

    public boolean getNewlineThrows() {
        return this.preferences.getBoolean(28);
    }

    public void setNewlineThrows(boolean bl) {
        this.preferences.setBoolean(28, bl);
    }

    public boolean getNewlineElse() {
        return this.preferences.getBoolean(29);
    }

    public void setNewlineElse(boolean bl) {
        this.preferences.setBoolean(29, bl);
    }

    public boolean getNewlineWhile() {
        return this.preferences.getBoolean(30);
    }

    public void setNewlineWhile(boolean bl) {
        this.preferences.setBoolean(30, bl);
    }

    public boolean getNewlineCatch() {
        return this.preferences.getBoolean(31);
    }

    public void setNewlineCatch(boolean bl) {
        this.preferences.setBoolean(31, bl);
    }

    public boolean getNewlineFinally() {
        return this.preferences.getBoolean(32);
    }

    public void setNewlineFinally(boolean bl) {
        this.preferences.setBoolean(32, bl);
    }

    public boolean getSpaceBeforeComma() {
        return this.preferences.getBoolean(33);
    }

    public void setSpaceBeforeComma(boolean bl) {
        this.preferences.setBoolean(33, bl);
    }

    public boolean getSpaceAfterComma() {
        return this.preferences.getBoolean(34);
    }

    public void setSpaceAfterComma(boolean bl) {
        this.preferences.setBoolean(34, bl);
    }

    public boolean getSpaceBeforeSemicolon() {
        return this.preferences.getBoolean(35);
    }

    public void setSpaceBeforeSemicolon(boolean bl) {
        this.preferences.setBoolean(35, bl);
    }

    public boolean getSpaceAfterSemicolon() {
        return this.preferences.getBoolean(36);
    }

    public void setSpaceAfterSemicolon(boolean bl) {
        this.preferences.setBoolean(36, bl);
    }

    public boolean getSpaceBeforeQuestion() {
        return this.preferences.getBoolean(37);
    }

    public void setSpaceBeforeQuestion(boolean bl) {
        this.preferences.setBoolean(37, bl);
    }

    public boolean getSpaceAfterQuestion() {
        return this.preferences.getBoolean(38);
    }

    public void setSpaceAfterQuestion(boolean bl) {
        this.preferences.setBoolean(38, bl);
    }

    public boolean getSpaceBeforeColon() {
        return this.preferences.getBoolean(39);
    }

    public void setSpaceBeforeColon(boolean bl) {
        this.preferences.setBoolean(39, bl);
    }

    public boolean getSpaceAfterColon() {
        return this.preferences.getBoolean(40);
    }

    public void setSpaceAfterColon(boolean bl) {
        this.preferences.setBoolean(40, bl);
    }

    public boolean getSpaceAfterTypecast() {
        return this.preferences.getBoolean(41);
    }

    public void setSpaceAfterTypecast(boolean bl) {
        this.preferences.setBoolean(41, bl);
    }

    public boolean getSpaceBeforeArguments() {
        return this.preferences.getBoolean(42);
    }

    public void setSpaceBeforeArguments(boolean bl) {
        this.preferences.setBoolean(42, bl);
    }

    public boolean getSpaceBeforeParameters() {
        return this.preferences.getBoolean(43);
    }

    public void setSpaceBeforeParameters(boolean bl) {
        this.preferences.setBoolean(43, bl);
    }

    public boolean getSpaceAfterKeyword() {
        return this.preferences.getBoolean(44);
    }

    public void setSpaceAfterKeyword(boolean bl) {
        this.preferences.setBoolean(44, bl);
    }

    public boolean getSpaceAroundAssignment() {
        return this.preferences.getBoolean(45);
    }

    public void setSpaceAroundAssignment(boolean bl) {
        this.preferences.setBoolean(45, bl);
    }

    public boolean getSpaceAroundBinaryOperator() {
        return this.preferences.getBoolean(46);
    }

    public void setSpaceAroundBinaryOperator(boolean bl) {
        this.preferences.setBoolean(46, bl);
    }

    public boolean getSpaceWithinParenthesis() {
        return this.preferences.getBoolean(47);
    }

    public void setSpaceWithinParenthesis(boolean bl) {
        this.preferences.setBoolean(47, bl);
    }

    public boolean getSpaceWithinBrackets() {
        return this.preferences.getBoolean(48);
    }

    public void setSpaceWithinBrackets(boolean bl) {
        this.preferences.setBoolean(48, bl);
    }

    public boolean getSpaceBeforeOpenBrace() {
        return this.preferences.getBoolean(49);
    }

    public void setSpaceBeforeOpenBrace(boolean bl) {
        this.preferences.setBoolean(49, bl);
    }

    public int getWrapLineWidth() {
        return this.preferences.getInt(50);
    }

    public void setWrapLineWidth(int n) {
        this.preferences.setInt(50, n);
    }

    public boolean getWrapAlign() {
        return this.preferences.getBoolean(51);
    }

    public void setWrapAlign(boolean bl) {
        this.preferences.setBoolean(51, bl);
    }

    public int getWrapModifiers() {
        return this.preferences.getInt(52);
    }

    public void setWrapModifiers(int n) {
        this.preferences.setInt(52, n);
    }

    public int getWrapExtends() {
        return this.preferences.getInt(53);
    }

    public void setWrapExtends(int n) {
        this.preferences.setInt(53, n);
    }

    public int getWrapThrows() {
        return this.preferences.getInt(54);
    }

    public void setWrapThrows(int n) {
        this.preferences.setInt(54, n);
    }

    public int getWrapParameterList() {
        return this.preferences.getInt(55);
    }

    public void setWrapParameterList(int n) {
        this.preferences.setInt(55, n);
    }

    public int getWrapDotChain() {
        return this.preferences.getInt(56);
    }

    public void setWrapDotChain(int n) {
        this.preferences.setInt(56, n);
    }

    public int getWrapForStatement() {
        return this.preferences.getInt(57);
    }

    public void setWrapForStatement(int n) {
        this.preferences.setInt(57, n);
    }

    public int getWrapBinaryOperator() {
        return this.preferences.getInt(58);
    }

    public void setWrapBinaryOperator(int n) {
        this.preferences.setInt(58, n);
    }

    public int getWrapTernaryExpression() {
        return this.preferences.getInt(59);
    }

    public void setWrapTernaryExpression(int n) {
        this.preferences.setInt(59, n);
    }

    public int getWrapArrayConstant() {
        return this.preferences.getInt(60);
    }

    public void setWrapArrayConstant(int n) {
        this.preferences.setInt(60, n);
    }

    public int getWrapInvokeArguments() {
        return this.preferences.getInt(61);
    }

    public void setWrapInvokeArguments(int n) {
        this.preferences.setInt(61, n);
    }

    public boolean getGroupImports() {
        return this.preferences.getBoolean(62);
    }

    public void setGroupImports(boolean bl) {
        this.preferences.setBoolean(62, bl);
    }

    public int getGroupPackageDepth() {
        return this.preferences.getInt(63);
    }

    public void setGroupPackageDepth(int n) {
        this.preferences.setInt(63, n);
    }

    public boolean getImportInnerClasses() {
        return this.preferences.getBoolean(64);
    }

    public void setImportInnerClasses(boolean bl) {
        this.preferences.setBoolean(64, bl);
    }

    public boolean getUseWideImports() {
        return this.preferences.getInt(65) != -1;
    }

    public void setUseWideImports(boolean bl) {
        int n = this._hash.getInt(IMPORT_NARROW_THRESHOLD_PREVIOUS, 1);
        this.preferences.setInt(65, bl ? n : -1);
    }

    public int getWideImportThreshold() {
        return this.getUseWideImports() ? this.preferences.getInt(65) : this._hash.getInt(IMPORT_NARROW_THRESHOLD_PREVIOUS, 1);
    }

    public void setWideImportThreshold(int n) {
        if (this.getUseWideImports()) {
            this.preferences.setInt(65, n);
        } else {
            n = Math.max(n, 1);
            this._hash.putInt(IMPORT_NARROW_THRESHOLD_PREVIOUS, n);
        }
    }

    public String getFieldPrefix() {
        return this._hash.getString(FIELD_PREFIX);
    }

    public void setFieldPrefix(String string) {
        this._hash.putString(FIELD_PREFIX, string);
    }

    public String getFieldSuffix() {
        return this._hash.getString(FIELD_SUFFIX);
    }

    public void setFieldSuffix(String string) {
        this._hash.putString(FIELD_SUFFIX, string);
    }

    public String getStaticFieldPrefix() {
        return this._hash.getString(STATIC_FIELD_PREFIX);
    }

    public void setStaticFieldPrefix(String string) {
        this._hash.putString(STATIC_FIELD_PREFIX, string);
    }

    public String getStaticFieldSuffix() {
        return this._hash.getString(STATIC_FIELD_SUFFIX);
    }

    public void setStaticFieldSuffix(String string) {
        this._hash.putString(STATIC_FIELD_SUFFIX, string);
    }

    public String getParameterPrefix() {
        return this._hash.getString(PARAMETER_PREFIX);
    }

    public void setParameterPrefix(String string) {
        this._hash.putString(PARAMETER_PREFIX, string);
    }

    public String getParameterSuffix() {
        return this._hash.getString(PARAMETER_SUFFIX);
    }

    public void setParameterSuffix(String string) {
        this._hash.putString(PARAMETER_SUFFIX, string);
    }

    public String getLocalVariablePrefix() {
        return this._hash.getString(LOCAL_VARIABLE_PREFIX);
    }

    public void setLocalVariablePrefix(String string) {
        this._hash.putString(LOCAL_VARIABLE_PREFIX, string);
    }

    public String getLocalVariableSuffix() {
        return this._hash.getString(LOCAL_VARIABLE_SUFFIX);
    }

    public void setLocalVariableSuffix(String string) {
        this._hash.putString(LOCAL_VARIABLE_SUFFIX, string);
    }

    public byte getMemberOrder(int n) {
        return this.preferences.getMemberOrder(n);
    }

    public void setMemberOrder(int n, byte by) {
        this.preferences.setMemberOrder(n, by);
    }

    public HashStructure getMemberOrderHashStructure() {
        return this.preferences.getMemberOrderHashStructure();
    }

    public void setMemberOrderHashStructure(HashStructure hashStructure) {
        String string = JavaPreferences.PREFERENCES_keys[67];
        if (hashStructure != null) {
            hashStructure.copyTo(this._hash.getOrCreateHashStructure(string));
        } else {
            this._hash.remove(string);
        }
    }

    public char[] getIndentChars(int n) {
        if (n == 0 || this.getIndentSize() == 0) {
            return new char[0];
        }
        int n2 = n * this.getIndentSize();
        int n3 = 0;
        if (this.getIndentReplaceWithTabs()) {
            int n4 = this.getTabSize();
            n3 = n2 / n4;
            n2 %= n4;
        }
        char[] cArray = new char[n3 + n2];
        int n5 = 0;
        while (n5 < n3) {
            cArray[n5] = 9;
            ++n5;
        }
        while (n5 < cArray.length) {
            cArray[n5] = 32;
            ++n5;
        }
        return cArray;
    }

    public String format(String string) {
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        textBuffer.insert(0, string.toCharArray());
        SourceFile sourceFile = JavaParser.parse((ReadTextBuffer)textBuffer);
        sourceFile.setPreferences(this.preferences);
        StringWriter stringWriter = new StringWriter();
        sourceFile.print(new PrintWriter((Writer)stringWriter, true));
        return stringWriter.getBuffer().toString();
    }

    public String getFieldName(String string) {
        return this.generateName(string, this.getFieldPrefix(), this.getFieldSuffix());
    }

    public String getStaticFieldName(String string) {
        return this.generateName(string, this.getStaticFieldPrefix(), this.getStaticFieldSuffix());
    }

    public String getParameterName(String string) {
        return this.generateName(string, this.getParameterPrefix(), this.getParameterSuffix());
    }

    public String getLocalVariableName(String string) {
        return this.generateName(string, this.getLocalVariablePrefix(), this.getLocalVariableSuffix());
    }

    private String generateName(String string, String string2, String string3) {
        string = string == null ? "" : string.trim();
        string2 = string2 == null ? "" : string2.trim();
        string3 = string3 == null ? "" : string3.trim();
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length() + string3.length());
        stringBuffer.append(string);
        if (string.length() > 1) {
            char c;
            stringBuffer.insert(0, string2);
            stringBuffer.append(string3);
            int n = string2.length();
            if (n > 0 && Character.isLetter(c = string2.charAt(n - 1))) {
                stringBuffer.setCharAt(n, Character.toUpperCase(stringBuffer.charAt(n)));
            }
        }
        return stringBuffer.toString();
    }

    public Object copyTo(Object object) {
        if (object == null) {
            object = new CodingStyleProfile();
        }
        CodingStyleProfile codingStyleProfile = (CodingStyleProfile)object;
        try {
            codingStyleProfile.disableEvents();
            Object object2 = super.copyTo(object);
            codingStyleProfile.enableEvents();
            codingStyleProfile.fireOptionsChanged();
            return object2;
        }
        catch (Throwable throwable) {
            codingStyleProfile.enableEvents();
            codingStyleProfile.fireOptionsChanged();
            throw throwable;
        }
    }

    private void disableEvents() {
        this.disableEvents = true;
    }

    private void enableEvents() {
        this.disableEvents = false;
    }

    private void fireOptionsChanged() {
        Object[] objectArray = this.listeners.getItems();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            CodingStyleOptionsListener codingStyleOptionsListener = (CodingStyleOptionsListener)objectArray[n2];
            codingStyleOptionsListener.optionsChanged(this);
            ++n2;
        }
    }

    public String applyNamingConventions(String string) {
        String string2 = string;
        string2 = this.replaceTag(string2, "field", this.getFieldPrefix(), this.getFieldSuffix());
        string2 = this.replaceTag(string2, "static", this.getStaticFieldPrefix(), this.getStaticFieldSuffix());
        string2 = this.replaceTag(string2, "parameter", this.getParameterPrefix(), this.getParameterSuffix());
        string2 = this.replaceTag(string2, "local", this.getLocalVariablePrefix(), this.getLocalVariableSuffix());
        return string2;
    }

    private String replaceTag(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        Pattern pattern = Pattern.compile("\\$\\{" + string2 + " (.*?)\\}");
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        while (matcher.find(n)) {
            int n2 = matcher.start();
            int n3 = matcher.end();
            stringBuffer.append(string.substring(n, n2));
            String string5 = matcher.group(1);
            stringBuffer.append(this.generateName(string5, string3, string4));
            n = n3;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    static boolean ra$disableEvents(CodingStyleProfile codingStyleProfile) {
        return codingStyleProfile.disableEvents;
    }

    static void mav$fireOptionsChanged(CodingStyleProfile codingStyleProfile) {
        codingStyleProfile.fireOptionsChanged();
    }

    private class ChangeListener
    extends StructureChangeListener {
        public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
            if (!CodingStyleProfile.ra$disableEvents(CodingStyleProfile.this)) {
                CodingStyleProfile.mav$fireOptionsChanged(CodingStyleProfile.this);
            }
        }

        private ChangeListener() {
        }

        ChangeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

