/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.profile.ProfileRepository;

public class ProfileModel
extends AbstractListModel
implements ComboBoxModel {
    private List profiles;
    private CodingStyleProfile selection;
    private Comparator comparator;
    private Comparator nameComparator;
    final ProfileRepository repository;
    static final /* synthetic */ boolean $assertionsDisabled;

    void $init$() {
        this.comparator = new ProfileComparator(null);
        this.nameComparator = new ProfileNameComparator(null);
        this.repository = ProfileRepository.getProfileRepository();
    }

    public ProfileModel() {
        this.$init$();
        this.profiles = new ArrayList();
        List list = this.repository.getProfiles();
        for (CodingStyleProfile codingStyleProfile : list) {
            CodingStyleProfile codingStyleProfile2 = new CodingStyleProfile();
            codingStyleProfile.copyTo(codingStyleProfile2);
            this.profiles.add(codingStyleProfile2);
        }
        Collections.sort(this.profiles, this.comparator);
    }

    public int getSize() {
        return this.profiles.size();
    }

    public Object getSelectedItem() {
        return this.selection;
    }

    public Object getElementAt(int n) {
        return this.profiles.get(n);
    }

    public boolean contains(String string) {
        return Collections.binarySearch(this.profiles, string, this.nameComparator) >= 0;
    }

    public CodingStyleProfile getProfile(String string) {
        int n = Collections.binarySearch(this.profiles, string, this.nameComparator);
        return n >= 0 ? (CodingStyleProfile)this.profiles.get(n) : null;
    }

    public void add(CodingStyleProfile codingStyleProfile) {
        int n = Collections.binarySearch(this.profiles, codingStyleProfile, this.comparator);
        if (n < 0) {
            n = -n - 1;
            this.profiles.add(n, codingStyleProfile);
            this.fireIntervalAdded(this, n, n);
        } else {
            this.profiles.set(n, codingStyleProfile);
            codingStyleProfile.setDirty(true);
            this.fireContentsChanged(this, n, n);
        }
    }

    public void remove(CodingStyleProfile codingStyleProfile) {
        int n = Collections.binarySearch(this.profiles, codingStyleProfile, this.comparator);
        if (n >= 0) {
            if (this.selection.equals(codingStyleProfile)) {
                this.setSelectedItem(n > 0 ? this.profiles.get(n - 1) : this.profiles.get(1));
            }
            this.profiles.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }
    }

    public boolean isDefaultProfile(CodingStyleProfile codingStyleProfile) {
        return this.repository.getDefaultProfile(codingStyleProfile.getName()) != null;
    }

    public boolean canRestore(CodingStyleProfile codingStyleProfile) {
        CodingStyleProfile codingStyleProfile2 = this.repository.getDefaultProfile(codingStyleProfile.getName());
        if (codingStyleProfile2 != null) {
            return ModelUtil.areDifferent((Object)codingStyleProfile2, (Object)codingStyleProfile);
        }
        return false;
    }

    static {
        $assertionsDisabled = ProfileModel.class.desiredAssertionStatus() ^ true;
    }

    public void restore(CodingStyleProfile codingStyleProfile) {
        if (!$assertionsDisabled && !this.isDefaultProfile(codingStyleProfile)) {
            throw new AssertionError();
        }
        String string = codingStyleProfile.getName();
        CodingStyleProfile codingStyleProfile2 = this.repository.getDefaultProfile(string);
        codingStyleProfile2.copyTo(codingStyleProfile);
        codingStyleProfile.setModified(false);
        codingStyleProfile.setDirty(true);
        int n = Collections.binarySearch(this.profiles, string, this.nameComparator);
        this.fireContentsChanged(this, n, n);
    }

    public CodingStyleProfile copy(CodingStyleProfile codingStyleProfile, String string) {
        CodingStyleProfile codingStyleProfile2 = new CodingStyleProfile();
        codingStyleProfile.copyTo(codingStyleProfile2);
        codingStyleProfile2.setName(string);
        int n = Collections.binarySearch(this.profiles, string, this.nameComparator);
        if (n < 0) {
            n = -n - 1;
            this.profiles.add(n, codingStyleProfile2);
            this.fireIntervalAdded(this, n, n);
        } else {
            CodingStyleProfile codingStyleProfile3 = (CodingStyleProfile)this.profiles.get(n);
            this.profiles.set(n, codingStyleProfile2);
            if (!string.equals(codingStyleProfile3.getName())) {
                this.repository.removeProfile(codingStyleProfile3);
            }
            this.fireContentsChanged(this, n, n);
        }
        this.save(codingStyleProfile2);
        return codingStyleProfile2;
    }

    public void save() {
        HashSet<String> hashSet = new HashSet<String>();
        for (CodingStyleProfile codingStyleProfile : this.profiles) {
            hashSet.add(codingStyleProfile.getName());
            if (this.repository.contains(codingStyleProfile.getName()) && !codingStyleProfile.isDirty()) continue;
            this.save(codingStyleProfile);
        }
        for (CodingStyleProfile codingStyleProfile : this.repository.getProfiles()) {
            if (hashSet.contains(codingStyleProfile.getName())) continue;
            this.repository.removeProfile(codingStyleProfile);
        }
    }

    public void revert() {
        HashSet hashSet = new HashSet();
        ArrayList<CodingStyleProfile> arrayList = new ArrayList<CodingStyleProfile>();
        for (CodingStyleProfile codingStyleProfile : this.profiles) {
            if (!this.repository.contains(codingStyleProfile.getName())) {
                arrayList.add(codingStyleProfile);
                continue;
            }
            if (!codingStyleProfile.isDirty()) continue;
            this.revert(codingStyleProfile);
        }
        for (CodingStyleProfile codingStyleProfile : arrayList) {
            this.remove(codingStyleProfile);
        }
        for (CodingStyleProfile codingStyleProfile : this.repository.getProfiles()) {
            if (hashSet.contains(codingStyleProfile.getName())) continue;
            this.add(codingStyleProfile);
        }
    }

    public void setModified(CodingStyleProfile codingStyleProfile) {
        int n = this.profiles.indexOf(codingStyleProfile);
        if (n >= 0) {
            codingStyleProfile.setModified(true);
            codingStyleProfile.setDirty(true);
            this.fireContentsChanged(this, n, n);
        }
    }

    public void save(CodingStyleProfile codingStyleProfile) {
        CodingStyleProfile codingStyleProfile2 = new CodingStyleProfile();
        codingStyleProfile.copyTo(codingStyleProfile2);
        this.repository.addProfile(codingStyleProfile2);
    }

    public void revert(CodingStyleProfile codingStyleProfile) {
        String string = codingStyleProfile.getName();
        CodingStyleProfile codingStyleProfile2 = this.repository.getProfile(string);
        if (codingStyleProfile2 != null) {
            codingStyleProfile2.copyTo(codingStyleProfile);
            codingStyleProfile.setModified(false);
            codingStyleProfile.setDirty(false);
            int n = Collections.binarySearch(this.profiles, codingStyleProfile.getName(), this.nameComparator);
            this.fireContentsChanged(this, n, n);
        }
    }

    public CodingStyleProfile getDefaultProfile() {
        String string = this.repository.getDefaultProfile().getName();
        return this.getProfile(string);
    }

    public void setSelectedItem(Object object) {
        if (!(object == null && this.getSize() != 0 || this.selection != null && this.selection.equals(object))) {
            CodingStyleProfile codingStyleProfile = (CodingStyleProfile)object;
            if (codingStyleProfile != null && !this.contains(codingStyleProfile.getName())) {
                this.add(codingStyleProfile);
            }
            this.selection = codingStyleProfile;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    private class ProfileComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            String string = ((CodingStyleProfile)object).getName();
            String string2 = ((CodingStyleProfile)object2).getName();
            return string.compareToIgnoreCase(string2);
        }

        private ProfileComparator() {
        }

        ProfileComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ProfileNameComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            String string = object instanceof CodingStyleProfile ? ((CodingStyleProfile)object).getName() : (String)object;
            String string2 = object2 instanceof CodingStyleProfile ? ((CodingStyleProfile)object2).getName() : (String)object2;
            return string.compareToIgnoreCase(string2);
        }

        private ProfileNameComparator() {
        }

        ProfileNameComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

