/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.profile.CodingStyleProfiles;

public class ProfileRepository {
    private static final String DEFAULT_PROFILES_FILE = "default_profiles.xml";
    private static final String DEFAULT_PROFILES_NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"default-coding-style-profiles");
    private static final String DEFAULT_PROFILES_ROOT_TAG = "profiles";
    private static final String DEFAULT_PROFILE_NAME = "Java Code Conventions";
    private static ProfileRepository instance;
    private static Object lock;
    private Map profileMap;
    private Map defaultProfileMap;

    static {
        lock = new Object();
    }

    private ProfileRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfileRepository getProfileRepository() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new ProfileRepository();
                }
            }
        }
        return instance;
    }

    public CodingStyleProfile getProfile(String string) {
        this.loadProfiles();
        return (CodingStyleProfile)this.profileMap.get(string);
    }

    public boolean contains(String string) {
        this.loadProfiles();
        return this.profileMap.containsKey(string);
    }

    public List getProfiles() {
        this.loadProfiles();
        return Collections.unmodifiableList(new ArrayList(this.profileMap.values()));
    }

    public void addProfile(CodingStyleProfile codingStyleProfile) {
        String string = codingStyleProfile.getName();
        if (this.profileMap.containsKey(string)) {
            CodingStyleProfile codingStyleProfile2 = (CodingStyleProfile)this.profileMap.get(string);
            codingStyleProfile.copyTo(codingStyleProfile2);
        } else {
            this.profileMap.put(string, codingStyleProfile);
        }
    }

    public void removeProfile(CodingStyleProfile codingStyleProfile) {
        this.profileMap.remove(codingStyleProfile.getName());
    }

    public CodingStyleProfile getDefaultProfile(String string) {
        this.loadProfiles();
        return (CodingStyleProfile)this.defaultProfileMap.get(string);
    }

    public CodingStyleProfile getDefaultProfile() {
        return this.getDefaultProfile(DEFAULT_PROFILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProfiles() {
        if (this.profileMap == null) {
            Object object = lock;
            synchronized (object) {
                if (this.profileMap == null) {
                    CodingStyleProfiles codingStyleProfiles = this.loadDefaultProfiles();
                    this.defaultProfileMap = codingStyleProfiles.getProfileMap();
                    DTCache dTCache = Ide.getDTCache();
                    CodingStyleProfiles codingStyleProfiles2 = (CodingStyleProfiles)dTCache.getData("CodingStyleProfiles");
                    if (codingStyleProfiles2 == null) {
                        codingStyleProfiles2 = new CodingStyleProfiles();
                        codingStyleProfiles.copyTo(codingStyleProfiles2);
                        dTCache.putData("CodingStyleProfiles", (Copyable)codingStyleProfiles2);
                    }
                    this.profileMap = codingStyleProfiles2.getProfileMap();
                }
            }
        }
    }

    private CodingStyleProfiles loadDefaultProfiles() {
        CodingStyleProfiles codingStyleProfiles = new CodingStyleProfiles();
        try {
            InputStream inputStream = ProfileRepository.class.getResourceAsStream(DEFAULT_PROFILES_FILE);
            Object2Dom object2Dom = Object2Dom.newInstance();
            CodingStyleProfiles codingStyleProfiles2 = (CodingStyleProfiles)object2Dom.toObject(inputStream, CodingStyleProfiles.class);
            codingStyleProfiles2.copyTo(codingStyleProfiles);
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return codingStyleProfiles;
    }

    public static void saveDefaultProfiles(CodingStyleProfiles codingStyleProfiles) {
        try {
            File file = new File(DEFAULT_PROFILES_FILE);
            URL uRL = URLFactory.newFileURL((File)file);
            Object2Dom object2Dom = Object2Dom.newInstance();
            object2Dom.setNamespaceURI(DEFAULT_PROFILES_NAMESPACE_URI);
            object2Dom.toDocument((Object)codingStyleProfiles, DEFAULT_PROFILES_ROOT_TAG, uRL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

