/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.treetable;

import java.awt.Component;
import java.awt.Font;
import javax.swing.ButtonModel;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.util.TriStateBoolean;
import oracle.jdevimpl.style.treetable.CodingStyleTreeBoolean;
import oracle.jdevimpl.style.treetable.CodingStyleTreeCategory;
import oracle.jdevimpl.style.treetable.CodingStyleTreeCategoryBoolean;
import oracle.jdevimpl.style.treetable.CodingStyleTreeList;
import oracle.jdevimpl.style.treetable.CodingStyleTreeNumber;

public class CodingStyleTreeTable
extends JFastTreeTable {
    public CodingStyleTreeTable(TreeTableModel treeTableModel) {
        super(treeTableModel);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.setAutoResizeMode(1);
        this.setSelectionMode(0);
        this.setTableHeader(null);
        this.setShowGrid(false);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(190);
        tableColumnModel.getColumn(1).setPreferredWidth(40);
        tableColumnModel.setColumnSelectionAllowed(false);
        this.tree.setCellRenderer((TreeCellRenderer)new 1());
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        Object object = this.tree.getPathForRow(n).getLastPathComponent();
        TableCellEditor tableCellEditor = null;
        if (n2 > 0) {
            if (object instanceof CodingStyleTreeNumber) {
                CodingStyleTreeNumber codingStyleTreeNumber = (CodingStyleTreeNumber)object;
                NumericSpinBox numericSpinBox = new NumericSpinBox(codingStyleTreeNumber.getMin(), codingStyleTreeNumber.getMax());
                SpinBuddy spinBuddy = numericSpinBox.getSpinBuddy();
                JTextField jTextField = spinBuddy instanceof JTextField ? (JTextField)spinBuddy : new NumberTextField();
                tableCellEditor = new DefaultCellEditor(jTextField);
                ((DefaultCellEditor)tableCellEditor).setClickCountToStart(1);
            } else if (object instanceof CodingStyleTreeList) {
                CodingStyleTreeList codingStyleTreeList = (CodingStyleTreeList)object;
                tableCellEditor = new DefaultCellEditor(new JComboBox<String>(codingStyleTreeList.getValues()));
            } else if (object instanceof CodingStyleTreeBoolean) {
                tableCellEditor = new DefaultCellEditor(new JCheckBox());
            } else if (object instanceof CodingStyleTreeCategoryBoolean) {
                tableCellEditor = new TriStateBooleanEditor(new TriStateCheckBox());
            }
        }
        if (tableCellEditor == null) {
            tableCellEditor = super.getCellEditor(n, n2);
        }
        return tableCellEditor;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = null;
        if (n2 > 0) {
            Object object = this.tree.getPathForRow(n).getLastPathComponent();
            if (object instanceof CodingStyleTreeBoolean) {
                tableCellRenderer = new BooleanRenderer();
            } else if (object instanceof CodingStyleTreeCategoryBoolean) {
                tableCellRenderer = new TriStateBooleanRenderer();
            }
        }
        if (tableCellRenderer == null) {
            tableCellRenderer = super.getCellRenderer(n, n2);
        }
        return tableCellRenderer;
    }

    public final class 1
    extends DefaultTreeCellRenderer {
        public Icon getIcon() {
            return null;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof CodingStyleTreeCategory) {
                Font font = this.getFont();
                this.setFont(font.deriveFont(1));
            } else {
                this.setFont(null);
            }
            return this;
        }
    }

    public static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        BooleanRenderer() {
            this.setHorizontalAlignment(2);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            if (object instanceof Boolean) {
                this.setSelected((Boolean)object);
            }
            return this;
        }
    }

    public static class TriStateCheckBox
    extends JCheckBox {
        void setTriState(TriStateBoolean triStateBoolean) {
            if (triStateBoolean == null) {
                triStateBoolean = TriStateBoolean.TRI_STATE;
            }
            if (triStateBoolean.isTrue()) {
                super.setSelected(true);
                ButtonModel buttonModel = this.getModel();
                buttonModel.setArmed(false);
                buttonModel.setPressed(false);
            } else if (triStateBoolean.isFalse()) {
                super.setSelected(false);
                ButtonModel buttonModel = this.getModel();
                buttonModel.setArmed(false);
                buttonModel.setPressed(false);
            } else {
                super.setSelected(true);
                ButtonModel buttonModel = this.getModel();
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
            }
        }

        TriStateCheckBox() {
        }
    }

    public static class TriStateBooleanEditor
    extends DefaultCellEditor {
        TriStateBooleanEditor(TriStateCheckBox triStateCheckBox) {
            super(triStateCheckBox);
            DefaultCellEditor.EditorDelegate editorDelegate = this.delegate;
            this.delegate = new 1(this, this, triStateCheckBox, editorDelegate);
            triStateCheckBox.removeActionListener(editorDelegate);
            triStateCheckBox.addActionListener(this.delegate);
        }

        public final class 1
        extends DefaultCellEditor.EditorDelegate {
            private final /* synthetic */ TriStateCheckBox v$triStateCheckBox;
            private final /* synthetic */ DefaultCellEditor.EditorDelegate v$oldDelegate;
            final /* synthetic */ TriStateBooleanEditor this$0;

            public void setValue(Object object) {
                if (object instanceof TriStateBoolean) {
                    this.v$triStateCheckBox.setTriState((TriStateBoolean)object);
                } else {
                    this.v$oldDelegate.setValue(object);
                }
            }

            public Object getCellEditorValue() {
                return this.v$oldDelegate.getCellEditorValue();
            }

            public 1(TriStateBooleanEditor triStateBooleanEditor, DefaultCellEditor defaultCellEditor, TriStateCheckBox triStateCheckBox, DefaultCellEditor.EditorDelegate editorDelegate) {
                this.v$oldDelegate = editorDelegate;
                this.v$triStateCheckBox = triStateCheckBox;
                this.this$0 = triStateBooleanEditor;
                super(defaultCellEditor);
            }
        }
    }

    public static class TriStateBooleanRenderer
    extends TriStateCheckBox
    implements TableCellRenderer {
        TriStateBooleanRenderer() {
            this.setHorizontalAlignment(2);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            if (object instanceof TriStateBoolean) {
                this.setTriState((TriStateBoolean)object);
            }
            return this;
        }
    }
}

