/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.todo;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.todo.ToDoItem;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.jdevimpl.todo.ToDoFilter;
import oracle.jdevimpl.todo.ToDoManagerImpl;
import oracle.jdevimpl.todo.ToDoTableModel;

public final class FilteredToDoTableModel
extends ToDoTableModel
implements NiceTableModel,
TableModelListener {
    private ToDoTableModel _realModel;
    private Integer[] _indexes;
    private Object _scope;
    private Object _oldScope;
    private List _filterList;
    private List _listenerList;
    private Object _scopeBoundaries;

    void $init$() {
        this._listenerList = new ArrayList();
    }

    FilteredToDoTableModel(ToDoTableModel toDoTableModel) {
        this.$init$();
        this.setRealModel(toDoTableModel);
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this._indexes.length || n2 >= this.getColumnCount()) {
            return null;
        }
        return this._realModel.getValueAt(this._indexes[n], n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this._realModel.setValueAt(object, this._indexes[n], n2);
        ToDoItem toDoItem = this._realModel.getToDoItemForRow(this._indexes[n]);
        boolean bl = ToDoFilter.passesFilterList(toDoItem, this._filterList);
        if (!bl) {
            this._allocate();
        }
    }

    public int getRowCount() {
        if (this._indexes == null) {
            this._allocate();
        }
        return this._indexes.length;
    }

    public int getColumnCount() {
        return this._realModel.getColumnCount();
    }

    public String getColumnName(int n) {
        return this._realModel.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this._realModel.getColumnClass(n);
    }

    public boolean isCellEditable(int n, int n2) {
        return this._realModel.isCellEditable(this._indexes[n], n2);
    }

    public boolean isRowEditable(int n) {
        return this._realModel.isRowEditable(this._indexes[n]);
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this._listenerList.add(tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this._listenerList.remove(tableModelListener);
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        int n = 0;
        while (n < this._listenerList.size()) {
            ((TableModelListener)this._listenerList.get(n)).tableChanged(tableModelEvent);
            if (this._listenerList.get(n) instanceof NiceTable) {
                NiceTable niceTable = (NiceTable)this._listenerList.get(n);
                int n2 = niceTable.getSortColumn();
                boolean bl = niceTable.isSortAscending();
                niceTable.setSortColumn(n2, bl);
            }
            ++n;
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this._allocate();
        this.fireTableChanged(tableModelEvent);
    }

    void setScope(Object object, boolean bl) {
        if (object != this._oldScope || bl) {
            this._scope = object;
            this._scopeBoundaries = ToDoManagerImpl.getScopeBoundaries(object);
            this._oldScope = object;
            this._allocate();
        }
    }

    Object getScope() {
        return this._scope;
    }

    void setFilterList(List list) {
        this._filterList = list;
        this._allocate();
    }

    void setRealModel(ToDoTableModel toDoTableModel) {
        if (this._realModel != null) {
            this._realModel.removeTableModelListener(this);
        }
        this._realModel = toDoTableModel;
        if (toDoTableModel == null) {
            this._indexes = null;
            return;
        }
        this._realModel.addTableModelListener(this);
        this._allocate();
    }

    int getModelRow(int n) {
        return this._indexes[n];
    }

    ToDoTableModel getRealModel() {
        return this._realModel;
    }

    private void _allocate() {
        if (this._scope == null && (this._filterList == null || this._filterList.size() == 0)) {
            this._indexes = new Integer[this._realModel.getRowCount()];
            int n = 0;
            while (n < this._indexes.length) {
                this._indexes[n] = new Integer(n);
                ++n;
            }
        } else {
            int n = this._realModel.getRowCount();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
            ToDoItem toDoItem = null;
            int n2 = 0;
            while (n2 < n) {
                toDoItem = this._realModel.getToDoItemForRow(n2);
                if (toDoItem.getURL() == null && ToDoFilter.passesFilterList(toDoItem, this._filterList)) {
                    arrayList.add(new Integer(n2));
                } else if (this._scope instanceof Folder && this._passesScope(toDoItem.getURL()) && ToDoFilter.passesFilterList(toDoItem, this._filterList)) {
                    arrayList.add(new Integer(n2));
                } else if (this._scope instanceof Node && this._passesScope(toDoItem.getURL()) && ToDoFilter.passesFilterList(toDoItem, this._filterList)) {
                    arrayList.add(new Integer(n2));
                }
                ++n2;
            }
            this._indexes = arrayList.toArray(new Integer[arrayList.size()]);
            this.fireTableChanged(new TableModelEvent(this));
        }
    }

    private boolean _passesScope(URL uRL) {
        if (this._scope == null || uRL == null) {
            return true;
        }
        return ToDoManagerImpl.isURLInScopeBoundary(uRL, this._scopeBoundaries);
    }
}

