/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.todo;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.resource.ToDoArb;
import oracle.jdevimpl.todo.ToDoPriority;
import oracle.jdevimpl.todo.ToDoTag;

class TagPanel
extends JPanel
implements VetoableChangeListener {
    private JLabel _tagLbl;
    private JTextField _tagFld;
    private JLabel _priorityLbl;
    private JComboBox _priorityBox;
    private JEWTDialog _dlg;
    private List _tagList;
    private ToDoTag _editTag;

    void $init$() {
        this._tagLbl = new JLabel();
        this._tagFld = new JTextField();
        this._priorityLbl = new JLabel();
        this._priorityBox = new JComboBox();
    }

    public TagPanel() {
        this.$init$();
        this.setLayout(new GridBagLayout());
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            helpSystem.registerTopic((JComponent)this, "f1_idedaddeditsourcetag_html");
        }
        ResourceUtils.resLabel((JLabel)this._tagLbl, (Component)this._tagFld, (String)ToDoArb.getString(18));
        ResourceUtils.resLabel((JLabel)this._priorityLbl, (Component)this._priorityBox, (String)ToDoArb.getString(19));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0);
        this.add((Component)this._tagLbl, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._tagFld, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._priorityLbl, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._priorityBox, gridBagConstraints);
    }

    public ToDoTag runDialog(ToDoTag toDoTag, List list, List list2) {
        this._editTag = toDoTag;
        this._tagList = list;
        this._loadData(toDoTag, list2);
        String string = null;
        string = toDoTag == null ? ToDoArb.getString(20) : ToDoArb.getString(21);
        this._dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this._tagFld, (String)string);
        this._dlg.setDefaultButton(1);
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        if (WizardLauncher.runDialog((JDialog)this._dlg)) {
            return new ToDoTag(this._tagFld.getText(), ((ToDoPriority)this._priorityBox.getSelectedItem()).getId());
        }
        return null;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent) && !this._validateData()) {
            throw new PropertyVetoException("no", propertyChangeEvent);
        }
    }

    private void _loadData(ToDoTag toDoTag, List list) {
        if (list != null) {
            DefaultListComboBoxModel defaultListComboBoxModel = new DefaultListComboBoxModel(list);
            this._priorityBox.setModel(defaultListComboBoxModel);
        }
        if (toDoTag != null) {
            this._tagFld.setText(toDoTag.getTag());
            this._priorityBox.setSelectedItem(toDoTag.getPriorityObject());
        } else {
            this._tagFld.setText("");
            this._priorityBox.setSelectedIndex(0);
        }
    }

    private boolean _validateData() {
        String string = this._tagFld.getText();
        if (!ModelUtil.hasLength((String)string)) {
            this._showErrorMessage(ToDoArb.getString(22), ToDoArb.getString(83));
            return false;
        }
        if (!ToDoTag.isTagUnique(string, this._tagList, this._editTag)) {
            this._showErrorMessage(ToDoArb.getString(23), ToDoArb.getString(83));
            return false;
        }
        return true;
    }

    private void _showErrorMessage(String string, String string2) {
        JOptionPane.showMessageDialog(this, string, string2, 0);
    }
}

