/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.todo;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Addin;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.ClientSetting;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockableFactory;
import oracle.ide.panels.Navigable;
import oracle.ide.todo.ToDoManager;
import oracle.javatools.jndi.Names;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.resource.ToDoArb;
import oracle.jdevimpl.todo.ToDoDockableFactory;
import oracle.jdevimpl.todo.ToDoFilterPanel;
import oracle.jdevimpl.todo.ToDoManagerImpl;
import oracle.jdevimpl.todo.ToDoOptions;
import oracle.jdevimpl.todo.ToDoOptionsPanel;
import oracle.jdevimpl.todo.ToDoPriority;
import oracle.jdevimpl.todo.ToDoTag;

public final class ToDoAddin
implements ChangeListener,
ShutdownHook,
Addin {
    private static ToDoOptions _options;

    public ToDoAddin() {
        ToDoManager toDoManager = ToDoManagerImpl.createInstance();
        Names.bind((Context)Names.newInitialContext(), (String)"jdevimpl/ToDoManagerImpl", (Object)toDoManager);
    }

    public void initialize() {
        this._initIdePreferencesPanels();
        ((ToDoManagerImpl)ToDoManager.getToDoManager()).startup();
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        ToDoOptions toDoOptions = (ToDoOptions)clientSetting.getData("ToDoOptions");
        toDoOptions.addChangeListener(this);
        _options = (ToDoOptions)((Object)toDoOptions.copyTo(null));
        DockStation.getDockStation().registerDockableFactory("ToDoAddin", (DockableFactory)new ToDoDockableFactory());
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    public void shutdown() {
        ((ToDoManagerImpl)ToDoManager.getToDoManager()).shutdown();
    }

    public boolean canShutdown() {
        return true;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        ToDoOptions toDoOptions = (ToDoOptions)clientSetting.getData("ToDoOptions");
        if (!_options.equals((Object)toDoOptions)) {
            List list = ToDoAddin._createRemovedTagList(_options.getTagList(), toDoOptions.getTagList());
            ToDoManagerImpl toDoManagerImpl = (ToDoManagerImpl)ToDoManager.getToDoManager();
            toDoManagerImpl.optionsChanged(list);
            _options = (ToDoOptions)((Object)toDoOptions.copyTo(null));
        }
    }

    static ToDoTag[] getTags() {
        List list = ToDoAddin._getOptions().getTagList();
        int n = list.size();
        if (n > 0) {
            ToDoTag[] toDoTagArray = new ToDoTag[n];
            int n2 = 0;
            while (n2 < n) {
                toDoTagArray[n2] = (ToDoTag)((Object)list.get(n2));
                ++n2;
            }
            return toDoTagArray;
        }
        return null;
    }

    static List getFilterList() {
        return ToDoAddin._getOptions().getFilterList();
    }

    static ToDoPriority getPriorityObjForId(int n) {
        ToDoPriority[] toDoPriorityArray = ToDoAddin.getPriorities();
        ToDoPriority toDoPriority = null;
        int n2 = 0;
        while (n2 < toDoPriorityArray.length) {
            toDoPriority = toDoPriorityArray[n2];
            if (toDoPriority.getId() == n) {
                return toDoPriority;
            }
            ++n2;
        }
        return null;
    }

    static ToDoPriority[] getPriorities() {
        return ToDoAddin._getOptions().getPriorityDataModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getUniquePriorityId() {
        ToDoOptions toDoOptions;
        ToDoOptions toDoOptions2 = toDoOptions = ToDoAddin._getOptions();
        synchronized (toDoOptions2) {
            int n = toDoOptions.getUniquePriorityId();
            return n;
        }
    }

    static SimpleDateFormat getSimpleDateFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ToDoAddin._getOptions().getDateFormatString());
        return simpleDateFormat;
    }

    private final void _initIdePreferencesPanels() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        if (!clientSetting.hasData("ToDoOptions")) {
            ToDoOptions toDoOptions = new ToDoOptions();
            clientSetting.putData("ToDoOptions", (Copyable)toDoOptions);
            List list = toDoOptions.getPriorityList();
            String string = ToDoArb.getInstance().getStringImpl(56);
            URL uRL = ToDoArb.class.getResource(string);
            ToDoPriority toDoPriority = new ToDoPriority(ToDoArb.getString(55), 3, uRL.toString(), 1);
            list.add(toDoPriority);
            string = ToDoArb.getInstance().getStringImpl(58);
            uRL = ToDoArb.class.getResource(string);
            toDoPriority = new ToDoPriority(ToDoArb.getString(57), 2, uRL.toString(), 2);
            list.add(toDoPriority);
            toDoPriority = new ToDoPriority(ToDoArb.getString(59), 1, null, 3);
            list.add(toDoPriority);
            toDoPriority = new ToDoPriority(ToDoArb.getString(60), 0, null, 0);
            list.add(toDoPriority);
            list = toDoOptions.getTagList();
            list.add(new ToDoTag(ToDoArb.getString(61), 3));
            list.add(new ToDoTag(ToDoArb.getString(62), 3));
            list.add(new ToDoTag(ToDoArb.getString(63), 3));
        }
        Navigable navigable = new Navigable(ToDoArb.getString(0), ToDoOptionsPanel.class);
        navigable.addChildNavigable(new Navigable(ToDoArb.getString(1), ToDoFilterPanel.class));
        ClientSetting.registerUI((Navigable)navigable);
    }

    private static final ToDoOptions _getOptions() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        return (ToDoOptions)clientSetting.getData("ToDoOptions");
    }

    private static final List _createRemovedTagList(List list, List list2) {
        ArrayList<ToDoTag> arrayList = new ArrayList<ToDoTag>();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ToDoTag toDoTag = (ToDoTag)((Object)list.get(n2));
            if (!list2.contains((Object)toDoTag)) {
                arrayList.add(toDoTag);
            }
            ++n2;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }
}

