/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.todo;

import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogWindow;
import oracle.jdevimpl.todo.ToDoWindow;

public class ToDoDockableFactory
implements DockableFactory {
    public static final String VIEW_TYPE = "ToDoAddin";
    public static final String VIEW_ID_STR = "ToDoAddin" + "." + "ToDoWindow";
    private ToDoWindow _toDoWindow;

    public Dockable getDockable(ViewId viewId) {
        String string = viewId.getName();
        if (string.equals("ToDoWindow")) {
            return this.getToDoWindow();
        }
        return null;
    }

    public void install() {
        DockingParam dockingParam = new DockingParam();
        LogWindow logWindow = LogManager.getIdeLogWindow();
        if (logWindow != null) {
            dockingParam.setTabbedWith((Dockable)logWindow);
        } else {
            ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
            Dockable dockable = null;
            if (explorerManager != null) {
                ViewId viewId = explorerManager.getDefaultViewId();
                dockable = DockStation.getDockStation().findDockable(viewId);
            }
            dockingParam.setPosition(dockable, 2, 0);
        }
        DockStation.getDockStation().dock((Dockable)this.getToDoWindow(), dockingParam);
    }

    private ToDoWindow getToDoWindow() {
        if (this._toDoWindow == null) {
            this._toDoWindow = new ToDoWindow(VIEW_ID_STR);
        }
        return this._toDoWindow;
    }
}

