/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.todo;

import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.net.URLFileSystem;
import oracle.ide.todo.ToDoItem;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.resource.ToDoArb;
import oracle.jdevimpl.todo.JDevToDoItem;
import oracle.jdevimpl.todo.ToDoAddin;
import oracle.jdevimpl.todo.ToDoPriority;
import oracle.jdevimpl.todo.TranslateableComboBoxItem;

public final class ToDoFilter
extends ChangeEventSource
implements Copyable {
    private int _column;
    private int _operand;
    private Object _testValue;
    public static final int EQUALS = 0;
    public static final int NOT_EQUALS = 1;
    public static final int CONTAINS = 2;
    public static final int NOT_CONTAINS = 3;
    public static final int BEGINS_WITH = 4;
    public static final int ENDS_WITH = 5;
    public static final int GREATER_THAN = 6;
    public static final int LESS_THAN = 7;
    public static final int IS_NULL = 8;
    public static final int IS_NOT_NULL = 9;
    private static final int NUM_OPERANDS = 10;
    private static final TranslateableComboBoxItem[] _operands;

    static {
        TranslateableComboBoxItem translateableComboBoxItem;
        _operands = new TranslateableComboBoxItem[10];
        ToDoFilter._operands[0] = translateableComboBoxItem = new TranslateableComboBoxItem(ToDoArb.getString(92), 0);
        ToDoFilter._operands[1] = translateableComboBoxItem = new TranslateableComboBoxItem(ToDoArb.getString(93), 1);
        ToDoFilter._operands[2] = translateableComboBoxItem = new TranslateableComboBoxItem(ToDoArb.getString(94), 2);
        ToDoFilter._operands[3] = translateableComboBoxItem = new TranslateableComboBoxItem(ToDoArb.getString(95), 3);
        ToDoFilter._operands[4] = translateableComboBoxItem = new TranslateableComboBoxItem(ToDoArb.getString(96), 4);
        ToDoFilter._operands[5] = translateableComboBoxItem = new TranslateableComboBoxItem(ToDoArb.getString(97), 5);
        ToDoFilter._operands[6] = translateableComboBoxItem = new TranslateableComboBoxItem(ToDoArb.getString(98), 6);
        ToDoFilter._operands[7] = translateableComboBoxItem = new TranslateableComboBoxItem(ToDoArb.getString(99), 7);
        ToDoFilter._operands[8] = translateableComboBoxItem = new TranslateableComboBoxItem(ToDoArb.getString(100), 8);
        ToDoFilter._operands[9] = translateableComboBoxItem = new TranslateableComboBoxItem(ToDoArb.getString(101), 9);
    }

    public ToDoFilter() {
    }

    public ToDoFilter(int n, int n2, Object object) {
        this._column = n;
        this._operand = n2;
        this._testValue = object;
    }

    public int getColumn() {
        return this._column;
    }

    public void setColumn(int n) {
        this._column = n;
    }

    public int getOperand() {
        return this._operand;
    }

    public void setOperand(int n) {
        this._operand = n;
    }

    public Object getTestValue() {
        return this._testValue;
    }

    public void setTestValue(Object object) {
        this._testValue = object;
    }

    public Object copyTo(Object object) {
        ToDoFilter toDoFilter = object != null ? (ToDoFilter)((Object)object) : new ToDoFilter();
        this.copyToImpl(toDoFilter);
        return toDoFilter;
    }

    protected void copyToImpl(ToDoFilter toDoFilter) {
        toDoFilter._column = this._column;
        toDoFilter._operand = this._operand;
        toDoFilter._testValue = this._testValue;
        toDoFilter.fireChangeEvent();
    }

    static boolean passesFilterList(ToDoItem toDoItem, List list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        int n = list.size();
        ToDoFilter toDoFilter = null;
        int n2 = 0;
        while (n2 < n) {
            toDoFilter = (ToDoFilter)((Object)list.get(n2));
            if (!ToDoFilter._passesFilter(toDoItem, toDoFilter)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static TranslateableComboBoxItem[] getOperatorsForColumn(int n) {
        TranslateableComboBoxItem[] translateableComboBoxItemArray = null;
        switch (n) {
            case 0: {
                translateableComboBoxItemArray = new TranslateableComboBoxItem[]{_operands[0], _operands[1]};
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 9: {
                translateableComboBoxItemArray = new TranslateableComboBoxItem[]{_operands[0], _operands[1], _operands[2], _operands[3], _operands[4], _operands[5], _operands[8], _operands[9]};
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                translateableComboBoxItemArray = new TranslateableComboBoxItem[]{_operands[0], _operands[1], _operands[6], _operands[7]};
                break;
            }
            case 8: {
                translateableComboBoxItemArray = new TranslateableComboBoxItem[]{_operands[0], _operands[1], _operands[6], _operands[7], _operands[8], _operands[9]};
                break;
            }
        }
        return translateableComboBoxItemArray;
    }

    static TranslateableComboBoxItem[] getAllOperands() {
        return _operands;
    }

    private static boolean _passesFilter(ToDoItem toDoItem, ToDoFilter toDoFilter) {
        Object object = ToDoFilter._getToDoItemValueToTest(toDoItem, toDoFilter.getColumn());
        if (object == null) {
            return toDoFilter.getOperand() == 8;
        }
        if (toDoFilter.getOperand() == 9) {
            return object != null;
        }
        return ToDoFilter._testValues(object, toDoFilter.getTestValue(), toDoFilter.getOperand());
    }

    private static boolean _testValues(Object object, Object object2, int n) {
        if (object instanceof String) {
            return ToDoFilter._testString((String)object, (String)object2, n);
        }
        if (object instanceof Integer) {
            Integer n2 = null;
            if (object2 instanceof Integer) {
                n2 = (Integer)object2;
            } else if (object2 instanceof ToDoPriority) {
                n2 = new Integer(((ToDoPriority)object2).getRanking());
            }
            return ToDoFilter._testInt((Integer)object, n2, n);
        }
        if (object instanceof Date) {
            return ToDoFilter._testDate((Date)object, (Date)object2, n);
        }
        if (object instanceof Boolean) {
            return ToDoFilter._testBoolean((Boolean)object, (Boolean)object2, n);
        }
        return false;
    }

    private static Object _getToDoItemValueToTest(ToDoItem toDoItem, int n) {
        Object object = null;
        switch (n) {
            case 0: {
                if (toDoItem instanceof JDevToDoItem) {
                    JDevToDoItem jDevToDoItem = (JDevToDoItem)toDoItem;
                    String string = jDevToDoItem.getTag();
                    if (string != null) {
                        object = null;
                        break;
                    }
                    object = toDoItem.isDone();
                    break;
                }
                object = toDoItem.isDone();
                break;
            }
            case 2: {
                object = toDoItem.getText();
                break;
            }
            case 4: {
                if (toDoItem.getURL() == null) break;
                object = URLFileSystem.getFileName((URL)toDoItem.getURL());
                break;
            }
            case 5: {
                if (toDoItem.getURL() == null) break;
                object = URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)toDoItem.getURL()));
                break;
            }
            case 3: {
                ToDoPriority toDoPriority = ToDoAddin.getPriorityObjForId(toDoItem.getPriorityId());
                object = new Integer(toDoPriority.getRanking());
                break;
            }
            case 6: {
                object = new Integer(toDoItem.getLine());
                break;
            }
            case 7: {
                object = new Integer(toDoItem.getColumn());
                break;
            }
            case 8: {
                object = toDoItem.getDate();
                break;
            }
            case 9: {
                if (!(toDoItem instanceof JDevToDoItem)) break;
                object = ((JDevToDoItem)toDoItem).getTag();
                break;
            }
        }
        return object;
    }

    private static boolean _testString(String string, String string2, int n) {
        switch (n) {
            case 0: {
                return string.equals(string2);
            }
            case 1: {
                return string.equals(string2) ^ true;
            }
            case 2: {
                return string.indexOf(string2) != -1;
            }
            case 3: {
                return string.indexOf(string2) == -1;
            }
            case 4: {
                return string.startsWith(string2);
            }
            case 5: {
                return string.endsWith(string2);
            }
        }
        return false;
    }

    private static boolean _testInt(int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                return n == n2;
            }
            case 1: {
                return n != n2;
            }
            case 6: {
                return n > n2;
            }
            case 7: {
                return n < n2;
            }
        }
        return false;
    }

    private static boolean _testDate(Date date, Date date2, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date2);
        switch (n) {
            case 0: {
                return ToDoFilter._dateEquals(gregorianCalendar, gregorianCalendar2);
            }
            case 1: {
                return ToDoFilter._dateEquals(gregorianCalendar, gregorianCalendar2) ^ true;
            }
            case 6: {
                return ToDoFilter._dateGreaterThan(gregorianCalendar, gregorianCalendar2);
            }
            case 7: {
                return ToDoFilter._dateGreaterThan(gregorianCalendar2, gregorianCalendar);
            }
        }
        return false;
    }

    private static boolean _dateEquals(Calendar calendar, Calendar calendar2) {
        return calendar.get(1) == calendar2.get(1) && calendar.get(6) == calendar2.get(6);
    }

    private static boolean _dateGreaterThan(Calendar calendar, Calendar calendar2) {
        int n = calendar.get(1);
        int n2 = calendar2.get(1);
        int n3 = calendar.get(6);
        int n4 = calendar2.get(6);
        return n > n2 || n == n2 && n3 > n4;
    }

    private static boolean _testBoolean(boolean bl, boolean bl2, int n) {
        switch (n) {
            case 0: {
                return bl == bl2;
            }
            case 1: {
                return bl != bl2;
            }
        }
        return false;
    }
}

