/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.todo;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controls.ButtonsLayoutManager;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.resource.ToDoArb;
import oracle.jdevimpl.todo.ToDoAddin;
import oracle.jdevimpl.todo.ToDoFilter;
import oracle.jdevimpl.todo.ToDoFilterTableModel;
import oracle.jdevimpl.todo.ToDoOptions;
import oracle.jdevimpl.todo.ToDoPriority;
import oracle.jdevimpl.todo.ToDoTableModel;
import oracle.jdevimpl.todo.TranslateableComboBoxItem;

final class ToDoFilterPanel
extends DefaultTraversablePanel
implements VetoableChangeListener {
    private ToDoOptions _options;
    private ToDoFilterTableModel _filterTableModel;
    private NiceTable _filterTable;
    private JLabel _filterTableLbl;
    private JButton _addFilterButton;
    private JButton _removeFilterButton;
    private JPanel _filterButtonPanel;
    private TableColumn _attributeColumn;
    private TableColumn _operandColumn;
    private TableColumn _testValueColumn;
    private TranslateableComboBoxItem[] _attributeDataModel;
    private TranslateableComboBoxItem[] _allOperandsDataModel;

    void $init$() {
        this._filterTableModel = new ToDoFilterTableModel();
        this._filterTable = new NiceTable();
        this._filterTableLbl = new JLabel();
        this._addFilterButton = new JButton();
        this._removeFilterButton = new JButton();
    }

    public ToDoFilterPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this._options = (ToDoOptions)((Object)traversableContext.find("ToDoOptions"));
        this._filterTableModel.setList(this._options.getFilterList());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this._options.setFilterList(this._filterTableModel.getList());
        traversableContext.put("ToDoOptions", (Object)this._options);
    }

    public boolean runDialog() {
        IdeSettings ideSettings = Ide.getSettings();
        ToDoOptions toDoOptions = (ToDoOptions)((Object)ideSettings.getData("ToDoOptions"));
        ToDoOptions toDoOptions2 = (ToDoOptions)((Object)toDoOptions.copyTo(null));
        Namespace namespace = new Namespace();
        namespace.put("ToDoOptions", (Object)toDoOptions2);
        this._filterTableModel.setList(toDoOptions2.getFilterList());
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)((Object)this), null, (String)ToDoArb.getString(102));
        jEWTDialog.setDefaultButton(1);
        jEWTDialog.addVetoableChangeListener((VetoableChangeListener)this);
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            ToDoOptions toDoOptions3 = toDoOptions2;
            toDoOptions3.setFilterList(this._filterTableModel.getList());
            ClientSetting.findOrCreate((String)"oracle.jdeveloper").putData("ToDoOptions", (Copyable)toDoOptions3);
            return true;
        }
        return false;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent) && !this._validateData()) {
            JOptionPane.showMessageDialog((Component)((Object)this), ToDoArb.getString(116), ToDoArb.getString(83), 0);
            throw new PropertyVetoException("no", propertyChangeEvent);
        }
    }

    private void jbInit() throws Exception {
        super.setLayout((LayoutManager)new GridBagLayout());
        super.setHelpID("f1_idetaskfilters_html");
        this._filterTable.setModel((TableModel)this._filterTableModel);
        this._createAttributeDataModel();
        this._createAllOperandsDataModel();
        TableColumnModel tableColumnModel = this._filterTable.getColumnModel();
        this._attributeColumn = tableColumnModel.getColumn(0);
        this._operandColumn = tableColumnModel.getColumn(1);
        this._testValueColumn = tableColumnModel.getColumn(2);
        CBoxCellEditor cBoxCellEditor = new CBoxCellEditor(this._attributeDataModel);
        CBoxCellRenderer cBoxCellRenderer = new CBoxCellRenderer(this._attributeDataModel);
        this._attributeColumn.setCellRenderer((TableCellRenderer)((Object)cBoxCellRenderer));
        this._attributeColumn.setCellEditor(cBoxCellEditor);
        this._operandColumn.setCellRenderer((TableCellRenderer)((Object)new CBoxCellRenderer(this._allOperandsDataModel)));
        this._operandColumn.setCellEditor(new CBoxCellEditor(this._allOperandsDataModel));
        this._testValueColumn.setCellRenderer((TableCellRenderer)((Object)new TestValueCellRenderer(ToDoAddin.getPriorities())));
        this._testValueColumn.setCellEditor(new TestValueCellEditor(ToDoAddin.getPriorities()));
        this._createButtonsAndLabels();
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0);
        gridBagConstraints.weighty = 0.0;
        super.add((Component)this._filterTableLbl, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        super.add((Component)this._filterTable.getScrollPaneForTable(), (Object)gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        super.add((Component)this._filterButtonPanel, (Object)gridBagConstraints);
    }

    private void _createButtonsAndLabels() {
        this._removeFilterButton.setEnabled(false);
        ListSelectionModel listSelectionModel = this._filterTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new 3());
        ResourceUtils.resLabel((JLabel)this._filterTableLbl, (Component)this._filterTable, (String)ToDoArb.getString(88));
        ButtonsLayoutManager buttonsLayoutManager = new ButtonsLayoutManager();
        buttonsLayoutManager.setGap(5);
        this._filterButtonPanel = new JPanel((LayoutManager)buttonsLayoutManager);
        ResourceUtils.resButton((AbstractButton)this._addFilterButton, (String)ToDoArb.getString(89));
        this._filterButtonPanel.add((Component)this._addFilterButton, new Integer(2));
        this._addFilterButton.addActionListener(new 2());
        ResourceUtils.resButton((AbstractButton)this._removeFilterButton, (String)ToDoArb.getString(90));
        this._filterButtonPanel.add((Component)this._removeFilterButton, new Integer(0));
        this._removeFilterButton.addActionListener(new 1());
    }

    private void _createAttributeDataModel() {
        TranslateableComboBoxItem[] translateableComboBoxItemArray = new TranslateableComboBoxItem[9];
        int n = 0;
        TranslateableComboBoxItem translateableComboBoxItem = null;
        int n2 = 0;
        while (n2 < 10) {
            if (n2 != 1) {
                translateableComboBoxItemArray[n] = translateableComboBoxItem = new TranslateableComboBoxItem(ToDoTableModel.getTranslatedColumnName(n2), n2);
                ++n;
            }
            ++n2;
        }
        this._attributeDataModel = translateableComboBoxItemArray;
    }

    private void _createAllOperandsDataModel() {
        this._allOperandsDataModel = ToDoFilter.getAllOperands();
    }

    private void _addFilterButton_actionPerformed(ActionEvent actionEvent) {
        ToDoFilter toDoFilter = new ToDoFilter(0, 0, true);
        this._filterTableModel.addRow(toDoFilter);
        this._filterTable.requestFocusInWindow();
        int n = this._filterTableModel.getRowCount();
        this._filterTable.setRowSelectionInterval(n - 1, n - 1);
    }

    private void _removeFilterButton_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this._filterTable.getSelectedRows();
        if (nArray != null) {
            int n = nArray.length - 1;
            while (n > -1) {
                this._filterTableModel.removeRow(nArray[n]);
                --n;
            }
        }
        this._filterTable.requestFocusInWindow();
        int n = nArray[0] - 1;
        if (n > -1) {
            this._filterTable.setRowSelectionInterval(n, n);
        } else if (this._filterTable.getRowCount() > 0) {
            this._filterTable.setRowSelectionInterval(0, 0);
        }
    }

    private static TranslateableComboBoxItem getSelectedItem(TranslateableComboBoxItem[] translateableComboBoxItemArray, int n) {
        if (translateableComboBoxItemArray == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < translateableComboBoxItemArray.length) {
            if (translateableComboBoxItemArray[n2].getId() == n) {
                return translateableComboBoxItemArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private boolean _validateData() {
        int n = this._filterTable.getEditingColumn();
        if (n != -1) {
            this._filterTable.getCellEditor().stopCellEditing();
        }
        int n2 = this._filterTableModel.getRowCount();
        boolean bl = true;
        int n3 = 0;
        while (n3 < n2) {
            boolean bl2;
            Object object = this._filterTableModel.getValueAt(n3, 2);
            int n4 = (Integer)this._filterTableModel.getValueAt(n3, 1);
            boolean bl3 = bl2 = object == null || object instanceof String && ((String)object).length() == 0;
            if (bl2 && (!bl2 || n4 == 8 && n4 == 9)) {
                bl = false;
                break;
            }
            ++n3;
        }
        return bl;
    }

    static NiceTable ra$_filterTable(ToDoFilterPanel toDoFilterPanel) {
        return toDoFilterPanel._filterTable;
    }

    static JButton ra$_removeFilterButton(ToDoFilterPanel toDoFilterPanel) {
        return toDoFilterPanel._removeFilterButton;
    }

    static void mav$_addFilterButton_actionPerformed(ToDoFilterPanel toDoFilterPanel, ActionEvent actionEvent) {
        toDoFilterPanel._addFilterButton_actionPerformed(actionEvent);
    }

    static void mav$_removeFilterButton_actionPerformed(ToDoFilterPanel toDoFilterPanel, ActionEvent actionEvent) {
        toDoFilterPanel._removeFilterButton_actionPerformed(actionEvent);
    }

    static TranslateableComboBoxItem maS$getSelectedItem(TranslateableComboBoxItem[] translateableComboBoxItemArray, int n) {
        return ToDoFilterPanel.getSelectedItem(translateableComboBoxItemArray, n);
    }

    final class 3
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int n = ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).getSelectedRow();
                boolean bl = false;
                if (n > -1 && ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).getModel().getRowCount() > 0) {
                    bl = true;
                }
                ToDoFilterPanel.ra$_removeFilterButton(ToDoFilterPanel.this).setEnabled(bl);
            }
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ToDoFilterPanel.mav$_addFilterButton_actionPerformed(ToDoFilterPanel.this, actionEvent);
        }
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ToDoFilterPanel.mav$_removeFilterButton_actionPerformed(ToDoFilterPanel.this, actionEvent);
        }
    }

    private final class CBoxCellRenderer
    extends NiceTableCellRenderer {
        private JComboBox _comboBox;
        private TranslateableComboBoxItem[] _items;

        public CBoxCellRenderer(TranslateableComboBoxItem[] translateableComboBoxItemArray) {
            this._comboBox = new JComboBox<TranslateableComboBoxItem>(translateableComboBoxItemArray);
            this._items = translateableComboBoxItemArray;
            this._comboBox.setEnabled(true);
            this._comboBox.setEditable(false);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = 0;
            if (object == null) {
                return component;
            }
            n3 = (Integer)object;
            TranslateableComboBoxItem translateableComboBoxItem = ToDoFilterPanel.maS$getSelectedItem(this._items, n3);
            this.setText(translateableComboBoxItem.toString());
            return this;
        }
    }

    private final class CBoxCellEditor
    extends DefaultCellEditor {
        private TranslateableComboBoxItem[] _items;

        public CBoxCellEditor(TranslateableComboBoxItem[] translateableComboBoxItemArray) {
            super(new JComboBox<TranslateableComboBoxItem>(translateableComboBoxItemArray));
            super.setClickCountToStart(2);
            this._items = translateableComboBoxItemArray;
            ((JComboBox)super.getComponent()).setEditable(false);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object == null) {
                return null;
            }
            if (n2 == 1) {
                JComboBox jComboBox = (JComboBox)super.getComponent();
                Integer n3 = (Integer)ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).getValueAt(n, 0);
                this._items = ToDoFilter.getOperatorsForColumn(n3);
                DefaultComboBoxModel<TranslateableComboBoxItem> defaultComboBoxModel = new DefaultComboBoxModel<TranslateableComboBoxItem>(this._items);
                jComboBox.setModel(defaultComboBoxModel);
            }
            JComboBox jComboBox = (JComboBox)super.getComponent();
            TranslateableComboBoxItem translateableComboBoxItem = ToDoFilterPanel.maS$getSelectedItem(this._items, (Integer)object);
            if (translateableComboBoxItem == null) {
                jComboBox.setSelectedIndex(0);
            } else {
                jComboBox.setSelectedItem(translateableComboBoxItem);
            }
            return jComboBox;
        }

        public boolean stopCellEditing() {
            Class clazz;
            Class clazz2;
            int n;
            TranslateableComboBoxItem translateableComboBoxItem;
            int n2;
            int n3 = ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).getEditingColumn();
            int n4 = ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).getEditingRow();
            if (n3 == 0 && (n2 = (translateableComboBoxItem = (TranslateableComboBoxItem)this.getCellEditorValue()).getId()) != (n = ((Integer)ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).getValueAt(n4, n3)).intValue()) && (clazz2 = ToDoTableModel.getClassForColumn(n)) != (clazz = ToDoTableModel.getClassForColumn(n2))) {
                TranslateableComboBoxItem[] translateableComboBoxItemArray = ToDoFilter.getOperatorsForColumn(n2);
                ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).setValueAt((Object)translateableComboBoxItemArray[0], n4, 1);
                ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).setValueAt(null, n4, 2);
            }
            return super.stopCellEditing();
        }
    }

    private final class TestValueCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private ToDoPriority[] _priorities;
        private JComboBox _comboBox;
        private JCheckBox _checkBox;
        private JTextField _textField;
        private WholeNumberField _wholeNumberField;
        private DateEditor _dateEditor;

        void $init$() {
            this._checkBox = new JCheckBox();
            this._textField = new JTextField();
            this._wholeNumberField = new WholeNumberField(4);
            this._dateEditor = new DateEditor();
        }

        public TestValueCellEditor(ToDoPriority[] toDoPriorityArray) {
            this.$init$();
            this._comboBox = new JComboBox<ToDoPriority>(toDoPriorityArray);
            this._comboBox.setEditable(false);
            this._priorities = toDoPriorityArray;
            this._checkBox.setBorderPaintedFlat(true);
            this._dateEditor.setDateFormat((DateFormat)ToDoAddin.getSimpleDateFormat());
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Object object2 = null;
            int n3 = (Integer)ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).getValueAt(n, 0);
            switch (n3) {
                case 3: {
                    if (object == null) {
                        ToDoPriority toDoPriority = this._priorities[0];
                        this._comboBox.setSelectedItem(toDoPriority);
                        ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).setValueAt((Object)toDoPriority, n, 2);
                    } else {
                        ToDoPriority toDoPriority = (ToDoPriority)object;
                        ToDoPriority toDoPriority2 = null;
                        int n4 = 0;
                        while (n4 < this._priorities.length) {
                            toDoPriority2 = this._priorities[n4];
                            if (toDoPriority2.getId() == toDoPriority.getId()) {
                                this._comboBox.setSelectedItem(toDoPriority2);
                                break;
                            }
                            ++n4;
                        }
                    }
                    object2 = this._comboBox;
                    break;
                }
                case 0: {
                    if (object == null) {
                        this._checkBox.setSelected(false);
                        ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).setValueAt((Object)false, n, 2);
                    } else {
                        Boolean bl2 = (Boolean)object;
                        this._checkBox.setSelected(bl2);
                    }
                    object2 = this._checkBox;
                    break;
                }
                case 6: 
                case 7: {
                    if (object == null) {
                        this._wholeNumberField.setValue(0);
                        ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).setValueAt((Object)new Integer(0), n, 2);
                    } else {
                        this._wholeNumberField.setValue(((Integer)object).intValue());
                    }
                    object2 = this._wholeNumberField;
                    break;
                }
                case 8: {
                    if (object == null) {
                        this._dateEditor.setDate(null);
                    } else {
                        this._dateEditor.setDate((Date)object);
                    }
                    object2 = this._dateEditor;
                    break;
                }
                default: {
                    if (object == null) {
                        this._textField.setText(null);
                    } else {
                        String string = object.toString();
                        this._textField.setText(string);
                    }
                    object2 = this._textField;
                }
            }
            return object2;
        }

        public boolean stopCellEditing() {
            Object object = this.getCellEditorValue();
            int n = (Integer)ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).getValueAt(ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).getEditingRow(), 1);
            if (object == null && (n != 8 || n != 9)) {
                JOptionPane.showMessageDialog((Component)ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this), ToDoArb.getString(116), ToDoArb.getString(83), 0);
                return false;
            }
            return super.stopCellEditing();
        }

        public Object getCellEditorValue() {
            int n = (Integer)ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).getValueAt(ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).getEditingRow(), 0);
            switch (n) {
                case 0: {
                    return this._checkBox.isSelected();
                }
                case 3: {
                    return this._comboBox.getSelectedItem();
                }
                case 2: 
                case 4: 
                case 5: 
                case 9: {
                    return this._textField.getText();
                }
                case 6: 
                case 7: {
                    return new Integer(this._wholeNumberField.getValue());
                }
                case 8: {
                    return this._dateEditor.getDate();
                }
            }
            return null;
        }

        public Component getComponent() {
            int n = (Integer)ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).getValueAt(ToDoFilterPanel.ra$_filterTable(ToDoFilterPanel.this).getEditingRow(), 0);
            switch (n) {
                case 0: {
                    return this._checkBox;
                }
                case 3: {
                    return this._comboBox;
                }
                case 2: 
                case 4: 
                case 5: 
                case 9: {
                    return this._textField;
                }
                case 6: 
                case 7: {
                    return this._wholeNumberField;
                }
                case 8: {
                    return this._dateEditor;
                }
            }
            return null;
        }
    }

    private final class TestValueCellRenderer
    extends NiceTableCellRenderer {
        private JComboBox _combobox;
        private JCheckBox _checkbox;
        private WholeNumberField _wholeNumberField;
        private DateEditor _dateEditor;

        void $init$() {
            this._checkbox = new JCheckBox();
            this._wholeNumberField = new WholeNumberField(4);
            this._dateEditor = new DateEditor();
        }

        public TestValueCellRenderer(ToDoPriority[] toDoPriorityArray) {
            this.$init$();
            this._combobox = new JComboBox<ToDoPriority>(toDoPriorityArray);
            this._combobox.setEnabled(true);
            this._combobox.setEditable(false);
            this._checkbox.setEnabled(true);
            this._checkbox.setOpaque(false);
            this._checkbox.setBorderPaintedFlat(true);
            this._dateEditor.setDateFormat((DateFormat)ToDoAddin.getSimpleDateFormat());
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object == null) {
                return component;
            }
            Integer n3 = (Integer)jTable.getModel().getValueAt(n, 0);
            int n4 = n3 == null ? 0 : n3;
            Component component2 = null;
            switch (n4) {
                case 0: {
                    Boolean bl3 = (Boolean)jTable.getModel().getValueAt(n, n2);
                    if (bl3 == null) {
                        bl3 = true;
                        jTable.getModel().setValueAt(bl3, n, n2);
                    }
                    this._checkbox.setSelected(bl3);
                    component2 = this._checkbox;
                    break;
                }
                case 3: {
                    this._combobox.setSelectedItem(object);
                    component2 = this._combobox;
                    break;
                }
                case 6: 
                case 7: {
                    if (object == null) {
                        this._wholeNumberField.setValue(0);
                    } else {
                        this._wholeNumberField.setValue(((Integer)object).intValue());
                    }
                    component2 = this._wholeNumberField;
                    break;
                }
                case 8: {
                    if (object == null) {
                        this._dateEditor.setDate(null);
                    } else {
                        this._dateEditor.setDate((Date)object);
                    }
                    component2 = this._dateEditor;
                    break;
                }
                default: {
                    if (object == null) {
                        this.setValue(null);
                    } else {
                        this.setValue(object.toString());
                    }
                    component2 = component;
                }
            }
            component2.setForeground(component.getForeground());
            component2.setBackground(component.getBackground());
            return component2;
        }
    }
}

