/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.todo;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.jdevimpl.resource.ToDoArb;
import oracle.jdevimpl.todo.ToDoFilter;
import oracle.jdevimpl.todo.TranslateableComboBoxItem;

final class ToDoFilterTableModel
extends AbstractTableModel {
    private List _dataList;
    public static final int ATTRIBUTE_COLUMN = 0;
    public static final int OPERAND_COLUMN = 1;
    public static final int TEST_VALUE_COLUMN = 2;
    private static final int NUM_COLUMNS = 3;

    public ToDoFilterTableModel() {
        this.setList(new ArrayList());
    }

    public ToDoFilterTableModel(List list) {
        this.setList(list);
    }

    public void setList(List list) {
        this._dataList = list;
    }

    public List getList() {
        return this._dataList;
    }

    public int getRowCount() {
        return this._dataList.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return Object.class;
            }
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public Object getValueAt(int n, int n2) {
        ToDoFilter toDoFilter = (ToDoFilter)((Object)this._dataList.get(n));
        if (toDoFilter == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return new Integer(toDoFilter.getColumn());
            }
            case 1: {
                return new Integer(toDoFilter.getOperand());
            }
            case 2: {
                return toDoFilter.getTestValue();
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        ToDoFilter toDoFilter = (ToDoFilter)((Object)this._dataList.get(n));
        switch (n2) {
            case 0: {
                toDoFilter.setColumn(((TranslateableComboBoxItem)object).getId());
                break;
            }
            case 1: {
                toDoFilter.setOperand(((TranslateableComboBoxItem)object).getId());
                break;
            }
            case 2: {
                toDoFilter.setTestValue(object);
                break;
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void addRow(ToDoFilter toDoFilter) {
        this._dataList.add(toDoFilter);
        int n = this._dataList.size();
        this.fireTableRowsInserted(n, n);
    }

    public ToDoFilter getRow(int n) {
        return (ToDoFilter)((Object)this._dataList.get(n));
    }

    public void replaceRow(int n, ToDoFilter toDoFilter) {
        this._dataList.set(n, toDoFilter);
        this.fireTableRowsUpdated(n, n);
    }

    public void removeRow(int n) {
        this._dataList.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return ToDoArb.getString(85);
            }
            case 1: {
                return ToDoArb.getString(86);
            }
            case 2: {
                return ToDoArb.getString(87);
            }
        }
        return null;
    }
}

