/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.todo;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ProgressTrackedTask;
import oracle.ide.controls.ProgressTracker;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Folder;
import oracle.ide.model.LocatableItem;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.ide.todo.ToDoItem;
import oracle.ide.todo.ToDoManager;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Pair;
import oracle.ide.util.SwingWorker;
import oracle.ide.view.View;
import oracle.ide.xml.XMLUtil;
import oracle.ideimpl.IdeMenus;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.jdeveloper.usage.keyword.KeywordBatchQueryTask;
import oracle.jdeveloper.usage.keyword.KeywordIndex;
import oracle.jdeveloper.util.gutter.AbstractLineGutterMarkManager;
import oracle.jdeveloper.util.gutter.LineGutterMarkList;
import oracle.jdeveloper.util.gutter.OpenEditor;
import oracle.jdeveloper.util.gutter.OpenLineGutterMark;
import oracle.jdevimpl.resource.ToDoArb;
import oracle.jdevimpl.todo.FilteredToDoTableModel;
import oracle.jdevimpl.todo.JDevToDoItem;
import oracle.jdevimpl.todo.ToDoAddin;
import oracle.jdevimpl.todo.ToDoPanel;
import oracle.jdevimpl.todo.ToDoPriority;
import oracle.jdevimpl.todo.ToDoTableModel;
import oracle.jdevimpl.todo.ToDoTag;
import oracle.jdevimpl.todo.ToDoTagHighlightPlugin;
import oracle.jdevimpl.todo.ToDoWindow;

final class ToDoManagerImpl
extends ToDoManager
implements ContextMenuListener,
Controller {
    private static ToDoManagerImpl INSTANCE;
    private ToDoItemManager _itemManager;
    private FilteredToDoTableModel _filteredTableModel;
    private static ToDoTableModel _baseTableModel;
    private ToDoObserver _toDoObserver;
    private static List _listeningTo;
    private HashMap _editorToPluginMap;
    private ToDoWindow _toDoWindow;
    private Object _currentScope;
    private ToDoFinder _toDoFinder;
    private IdeAction _addToDoAction;
    private JMenuItem _addToDoPopupItem;
    private IdeAction _editToDoAction;
    private JMenuItem _editToDoPopupItem;
    private List _textBufferListeners;
    private static final String TODO_CMD = "oracle.ide.cmd.ToDoCommand";
    private static final int TODO_CMD_ID;
    private static final String ADD_TODO_CMD = "oracle.jdevimpl.todo.AddToDoFromGutterCommand";
    private static final int ADD_TODO_CMD_ID;
    private static final String EDIT_TODO_CMD = "oracle.jdevimpl.todo.EditToDoFromGutterCommand";
    private static final int EDIT_TODO_CMD_ID;
    public static final String TODO_ITEMS_FILE = "ToDoItems.xml";
    public static final String NAMESPACE_URI;
    public static final String ROOT_TAG = "ToDoItems";

    static {
        _baseTableModel = new ToDoTableModel();
        _listeningTo = new ArrayList();
        TODO_CMD_ID = Ide.findOrCreateCmdID((String)TODO_CMD);
        ADD_TODO_CMD_ID = Ide.findOrCreateCmdID((String)ADD_TODO_CMD);
        EDIT_TODO_CMD_ID = Ide.findOrCreateCmdID((String)EDIT_TODO_CMD);
        NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"todo-items");
    }

    void $init$() {
        this._editorToPluginMap = new HashMap();
        this._toDoFinder = new ToDoFinder();
        this._textBufferListeners = new ArrayList();
    }

    public static final ToDoManager createInstance() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = new ToDoManagerImpl();
        return INSTANCE;
    }

    public static final ToDoManager getToDoManager() {
        return INSTANCE;
    }

    private ToDoManagerImpl() {
        this.$init$();
        this._itemManager = new ToDoItemManager();
        this._toDoObserver = new ToDoObserver(null);
        this._createActionsAndMenus();
        JMenuItem jMenuItem = IdeMenus.createMenuItem((Controller)this, (int)TODO_CMD_ID, (String)TODO_CMD, (String)ToDoArb.getString(35), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)ToDoArb.getInteger(36), (ArrayResourceBundle)ToDoArb.getInstance(), (int)128, null, (boolean)true, (float)MenuConstants.WEIGHT_VIEW_LOG);
        Menubar menubar = Ide.getMenubar();
        JMenu jMenu = MenuManager.getJMenu((String)"View");
        menubar.add((Component)jMenuItem, jMenu, MenuConstants.SECTION_VIEW_ADDINS);
        ContextMenu contextMenu = CodeEditorGutter.getGutterContextMenu();
        if (contextMenu != null) {
            contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
    }

    public ToDoItem createToDoItem(String string, int n, Date date) {
        JDevToDoItem jDevToDoItem = new JDevToDoItem(null, string, n, 0, 0, null, false, date);
        return jDevToDoItem;
    }

    public void setWindowVisible(boolean bl) {
        if (bl) {
            this._showToDoWindow();
        } else {
            this.hideToDoWindow();
        }
    }

    public void add(ToDoItem[] toDoItemArray) {
        int n = 0;
        while (n < toDoItemArray.length) {
            ToDoItem toDoItem = toDoItemArray[n];
            this.addToDoItem(toDoItem);
            if (toDoItem.getURL() != null) {
                this._itemManager.createLineGutterMarkFor(toDoItem);
            }
            ++n;
        }
    }

    public void editToDoItems(ToDoItem[] toDoItemArray) {
        this._itemManager.editToDoItems(toDoItemArray);
    }

    public void removeToDoItems(List list) {
        this._itemManager.removeToDoItems(list);
    }

    public void remove(ToDoItem[] toDoItemArray) {
        int n = 0;
        while (n < toDoItemArray.length) {
            this._itemManager.removeToDoItem(toDoItemArray[n]);
            ++n;
        }
    }

    public void optionsChanged(List list) {
        if (this._toDoWindow != null) {
            int n;
            EditorManager editorManager = EditorManager.getEditorManager();
            List list2 = editorManager.getAllEditors();
            int n2 = list2.size();
            int n3 = 0;
            while (n3 < n2) {
                Editor editor = (Editor)list2.get(n3);
                if (editor instanceof CodeEditor) {
                    this._itemManager.editorClosed(editor);
                    this._itemManager.editorOpened(editor);
                }
                ++n3;
            }
            if (list != null) {
                int n4 = list.size();
                int n5 = 0;
                while (n5 < n4) {
                    ToDoTag toDoTag = (ToDoTag)((Object)list.get(n5));
                    this._itemManager.removeItemsWithTag(toDoTag);
                    ++n5;
                }
            }
            if ((n = this._toDoWindow.getScopeActionId()) != ToDoWindow.CURRENT_FILE_CMD_ID) {
                this._setScope(n, true);
            }
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        View view = context.getView();
        int n = ideAction.getCommandId();
        if (n == ADD_TODO_CMD_ID) {
            int n2;
            if (view instanceof CodeEditorGutter.GutterView && (n2 = CodeEditorGutter.getLineForContext((Context)context)) != -1) {
                CodeEditor codeEditor = (CodeEditor)view.owner();
                this._itemManager.addToDoItem(codeEditor, n2);
            }
            return true;
        }
        if (n == EDIT_TODO_CMD_ID) {
            int n3;
            if (view instanceof CodeEditorGutter.GutterView && (n3 = CodeEditorGutter.getLineForContext((Context)context)) != -1) {
                CodeEditor codeEditor = (CodeEditor)view.owner();
                this._itemManager.editToDoItems(codeEditor, n3);
            }
            return true;
        }
        if (n == TODO_CMD_ID) {
            1 var9_9 = new 1();
            IdeUtil.invokeAfterRepaint((Runnable)var9_9);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n;
        View view = context.getView();
        boolean bl = false;
        if (view != null && (view instanceof CodeEditor || view instanceof CodeEditorGutter.GutterView)) {
            bl = true;
        }
        if ((n = ideAction.getCommandId()) == ADD_TODO_CMD_ID) {
            this._addToDoAction.setEnabled(bl);
            return true;
        }
        if (n == EDIT_TODO_CMD_ID) {
            int n2;
            boolean bl2 = false;
            if (view instanceof CodeEditorGutter.GutterView && (n2 = CodeEditorGutter.getLineForContext((Context)context)) != -1) {
                CodeEditor codeEditor = (CodeEditor)view.owner();
                bl2 = this.hasEditableToDoItems(this._itemManager.getURLForEditor(codeEditor), n2);
            }
            this._editToDoAction.setEnabled(bl2);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        int n;
        Context context = contextMenu.getContext();
        View view = context.getView();
        if (view instanceof CodeEditorGutter.GutterView && !CodeEditorGutter.isMarkDroppingDown((Context)context) && (n = CodeEditorGutter.getLineForContext((Context)context)) != -1) {
            contextMenu.add((Component)this._addToDoPopupItem, 5.0f);
            contextMenu.add((Component)this._editToDoPopupItem, 5.0f);
            this.update(this._addToDoAction, context);
            this.update(this._editToDoAction, context);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void closeToDoWindow() {
        this._toDoWindow = null;
    }

    void addToDoItem(ToDoItem toDoItem) {
        _baseTableModel.addToDoItem(toDoItem);
    }

    void startup() {
        this._itemManager.startup();
    }

    void shutdown() {
        if (this._toDoWindow != null) {
            this._toDoWindow.close();
        }
        this._itemManager.shutdown();
    }

    boolean hasEditableToDoItems(URL uRL, int n) {
        LocatableItem[] locatableItemArray = _baseTableModel.findLineGutterMark(uRL, n);
        if (locatableItemArray == null) {
            return false;
        }
        ToDoItem toDoItem = null;
        int n2 = 0;
        while (n2 < locatableItemArray.length) {
            toDoItem = (ToDoItem)locatableItemArray[n2];
            if (toDoItem.isEditable()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void setToDoWindowInstance(ToDoWindow toDoWindow) {
        this._toDoWindow = toDoWindow;
    }

    void setScope(Context context) {
        if (this._toDoWindow != null) {
            int n = this._toDoWindow.getScopeActionId();
            if (n == ToDoWindow.CURRENT_FILE_CMD_ID) {
                Node node = context.getNode();
                if (node instanceof TextNode) {
                    this._setScope(ToDoWindow.CURRENT_FILE_CMD_ID, node, false);
                }
            } else if (n == ToDoWindow.CURRENT_WORKSPACE_CMD_ID) {
                this._setScope(ToDoWindow.CURRENT_WORKSPACE_CMD_ID, context.getWorkspace(), false);
            } else if (n == ToDoWindow.CURRENT_PROJECT_CMD_ID) {
                this._setScope(ToDoWindow.CURRENT_PROJECT_CMD_ID, context.getProject(), false);
            }
        }
    }

    private void _setScope(int n, Object object, boolean bl) {
        if (this._toDoWindow != null) {
            if (bl | object != this._currentScope) {
                this._toDoFinder.addChangeMessage(new ChangeMessage(2, object));
            }
            this._currentScope = object;
        }
    }

    void setScope(int n) {
        Object object = this._getObjectForScope(n);
        this._setScope(n, object, false);
    }

    private void removeListenerFromObject(Node node) {
        URL uRL;
        if (node.isOpen() && (uRL = node.getURL()) != null) {
            int n = this._textBufferListeners.size();
            int n2 = 0;
            while (n2 < n) {
                BufferChangeListener bufferChangeListener = (BufferChangeListener)this._textBufferListeners.get(n2);
                Node node2 = bufferChangeListener.getNode();
                if (node2.getURL().sameFile(uRL) && node2 instanceof TextNode) {
                    TextNode textNode = (TextNode)node2;
                    TextBuffer textBuffer = textNode.acquireTextBuffer();
                    textBuffer.removeTextBufferListener((TextBufferListener)bufferChangeListener);
                    return;
                }
                ++n2;
            }
        }
    }

    void changeFilterList(List list) {
        this._filteredTableModel.setFilterList(list);
    }

    void gotoToDoItem(ToDoItem toDoItem) {
        this._itemManager.gotoLineGutterMark((LocatableItem)toDoItem);
    }

    static final void getProjectsForWorkspace(Workspace workspace, List list) {
        Iterator iterator = workspace.getChildren();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Project)) continue;
            list.add(e);
        }
    }

    private static List buildProjectList(Folder folder) {
        ArrayList<Folder> arrayList = new ArrayList<Folder>();
        if (folder instanceof Workspace) {
            ToDoManagerImpl.getProjectsForWorkspace((Workspace)folder, arrayList);
        } else if (folder instanceof Project) {
            arrayList.add(folder);
        }
        return arrayList;
    }

    private static List buildContentSetListFromProjectList(List list) {
        ArrayList<ContentSet> arrayList = new ArrayList<ContentSet>(list.size());
        int n = 0;
        while (n < list.size()) {
            Project project = (Project)list.get(n);
            ProjectContent projectContent = ProjectContent.getInstance((PropertyStorage)project);
            ContentSet contentSet = projectContent.getAllContents();
            arrayList.add(contentSet);
            ++n;
        }
        return arrayList;
    }

    static boolean isURLInScopeBoundary(URL uRL, Object object) {
        if (object instanceof List) {
            List list = (List)object;
            int n = 0;
            while (n < list.size()) {
                ContentSet contentSet = (ContentSet)list.get(n);
                if (contentSet.canHaveMember(uRL)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        URL uRL2 = (URL)object;
        return uRL.equals(uRL2);
    }

    static Object getScopeBoundaries(Object object) {
        Object object2 = null;
        if (object instanceof Workspace) {
            Workspace workspace = (Workspace)object;
            ArrayList arrayList = new ArrayList();
            ToDoManagerImpl.getProjectsForWorkspace(workspace, arrayList);
            object2 = ToDoManagerImpl.buildContentSetListFromProjectList(arrayList);
        } else if (object instanceof Project) {
            ArrayList<Project> arrayList = new ArrayList<Project>(1);
            arrayList.add((Project)object);
            object2 = ToDoManagerImpl.buildContentSetListFromProjectList(arrayList);
        } else if (object instanceof Node) {
            object2 = ((Node)object).getURL();
        }
        return object2;
    }

    static final ToDoPriority findPriorityInList(int n, List list) {
        int n2 = list.size();
        ToDoPriority toDoPriority = null;
        int n3 = 0;
        while (n3 < n2) {
            toDoPriority = (ToDoPriority)list.get(n3);
            if (toDoPriority.getId() == n) {
                return toDoPriority;
            }
            ++n3;
        }
        return null;
    }

    static final boolean isPriorityTextUnique(String string, List list, ToDoPriority toDoPriority) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ToDoPriority toDoPriority2 = (ToDoPriority)list.get(n2);
            if (toDoPriority2 != toDoPriority && string.equals(toDoPriority2.getText())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static final boolean isRankingUnique(int n, List list, ToDoPriority toDoPriority) {
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            ToDoPriority toDoPriority2 = (ToDoPriority)list.get(n3);
            if (toDoPriority2 != toDoPriority && n == toDoPriority2.getRanking()) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    static final boolean isIconURLStringUnique(String string, List list, ToDoPriority toDoPriority) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ToDoPriority toDoPriority2 = (ToDoPriority)list.get(n2);
            if (toDoPriority2 != toDoPriority && string.equals(toDoPriority2.getIconURLString())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    FilteredToDoTableModel getTableModel() {
        if (this._filteredTableModel == null) {
            this._filteredTableModel = new FilteredToDoTableModel(_baseTableModel);
            this._filteredTableModel.setFilterList(ToDoAddin.getFilterList());
        }
        return this._filteredTableModel;
    }

    ToDoTableModel getBaseModel() {
        return _baseTableModel;
    }

    private Object _getObjectForScope(int n) {
        EditorManager editorManager;
        Editor editor;
        Workspace workspace = null;
        if (n == ToDoWindow.CURRENT_WORKSPACE_CMD_ID) {
            workspace = Ide.getActiveWorkspace();
        } else if (n == ToDoWindow.CURRENT_PROJECT_CMD_ID) {
            workspace = Ide.getActiveProject();
        } else if (n == ToDoWindow.CURRENT_FILE_CMD_ID && (editor = (editorManager = EditorManager.getEditorManager()).getCurrentEditor()) != null) {
            Context context = editor.getContext();
            workspace = context.getNode();
        }
        return workspace;
    }

    private void _setScope(int n, boolean bl) {
        Object object = this._getObjectForScope(n);
        this._setScope(n, object, bl);
    }

    private static List _getToDoListFromNode(Node node) {
        if (!(node instanceof TextNode)) {
            return null;
        }
        ToDoTag[] toDoTagArray = ToDoAddin.getTags();
        if (toDoTagArray == null || toDoTagArray.length == 0) {
            return null;
        }
        TextNode textNode = null;
        TextBuffer textBuffer = null;
        ArrayList arrayList = new ArrayList();
        try {
            textNode = (TextNode)node;
            textBuffer = textNode.acquireTextBuffer();
            textBuffer.readLock();
            LineMap lineMap = textBuffer.getLineMap();
            int n = lineMap.getLineCount();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                n2 = lineMap.getLineStartOffset(n4);
                n3 = lineMap.getLineEndOffset(n4);
                String string = textBuffer.getString(n2, n3 - n2);
                ToDoManagerImpl._searchLineForTags(textNode, string, n4, toDoTagArray, arrayList);
                ++n4;
            }
        }
        finally {
            textBuffer.readUnlock();
            textNode.releaseTextBuffer();
        }
        if (arrayList.size() > 0) {
            return arrayList;
        }
        return null;
    }

    private static void _searchLineForTags(TextNode textNode, String string, int n, ToDoTag[] toDoTagArray, List list) {
        int n2 = -1;
        String string2 = null;
        int n3 = -1;
        int n4 = 0;
        while (n4 < toDoTagArray.length) {
            string2 = toDoTagArray[n4].getTag();
            n3 = toDoTagArray[n4].getPriorityId();
            n2 = string.indexOf(string2);
            if (n2 != -1) {
                char c = string.charAt(n2 + string2.length());
                int n5 = Character.getType(c);
                boolean bl = false;
                if (n5 == 24) {
                    bl = true;
                }
                boolean bl2 = true;
                if (n2 > 0) {
                    char c2 = string.charAt(n2 - 1);
                    bl2 = Character.isWhitespace(c2) || c2 == '/';
                }
                if ((Character.isWhitespace(c) || bl) && bl2) {
                    int n6;
                    String string3 = string.substring(n2 + string2.length() + 1);
                    int n7 = n6 = string3.length();
                    int n8 = n6 - 1;
                    while (n8 > -1) {
                        if (Character.isLetterOrDigit(string3.charAt(n8))) break;
                        n7 = n8 - 1;
                        --n8;
                    }
                    string3 = string3.substring(0, Math.min(string3.length(), n7 + 1));
                    JDevToDoItem jDevToDoItem = new JDevToDoItem(string2, string3, n3, n + 1, n2, textNode.getURL(), false, null);
                    list.add(jDevToDoItem);
                    break;
                }
            }
            ++n4;
        }
    }

    private final void _listenToScope(Object object) {
        if (object instanceof Workspace) {
            Workspace workspace = (Workspace)object;
            if (_listeningTo.contains(workspace)) {
                return;
            }
            this._detachListeners();
            workspace.attach((Observer)this._toDoObserver);
            _listeningTo.add(workspace);
            ArrayList arrayList = new ArrayList();
            ToDoManagerImpl.getProjectsForWorkspace(workspace, arrayList);
            int n = arrayList.size();
            Project project = null;
            int n2 = 0;
            while (n2 < n) {
                project = (Project)arrayList.get(n2);
                project.attach((Observer)this._toDoObserver);
                _listeningTo.add(project);
                ++n2;
            }
        } else if (object instanceof Project) {
            Project project = (Project)object;
            if (_listeningTo.size() != 1 || !_listeningTo.contains(project)) {
                this._detachListeners();
                project.attach((Observer)this._toDoObserver);
                _listeningTo.add(project);
            }
        } else {
            this._detachListeners();
            if (object instanceof TextNode) {
                ((Node)object).addNodeListener((NodeListener)this._toDoObserver);
                _listeningTo.add(object);
            }
        }
    }

    private final void _detachListeners() {
        int n = _listeningTo.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = _listeningTo.get(n2);
            if (e instanceof TextNode) {
                TextNode textNode = (TextNode)e;
                textNode.removeNodeListener((NodeListener)this._toDoObserver);
            } else if (e instanceof Subject) {
                ((Subject)_listeningTo.get(n2)).detach((Observer)this._toDoObserver);
            }
            ++n2;
        }
        _listeningTo.clear();
    }

    private void _addBusyIndicator() {
        if (this._toDoWindow != null) {
            this._toDoWindow.addBusyIndicator();
        }
    }

    private void _removeBusyIndicator() {
        if (this._toDoWindow != null) {
            this._toDoWindow.removeBusyIndicator();
        }
    }

    private void _createActionsAndMenus() {
        this._addToDoAction = IdeAction.get((int)ADD_TODO_CMD_ID, (String)ADD_TODO_CMD, (String)ToDoArb.getString(46), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)ToDoArb.getInteger(47), (ArrayResourceBundle)ToDoArb.getInstance(), (int)48, null, (boolean)false);
        this._addToDoAction.addController((Controller)this);
        this._editToDoAction = IdeAction.get((int)EDIT_TODO_CMD_ID, (String)EDIT_TODO_CMD, (String)ToDoArb.getString(49), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)ToDoArb.getInteger(50), (ArrayResourceBundle)ToDoArb.getInstance(), (int)51, null, (boolean)false);
        this._editToDoAction.addController((Controller)this);
        Menubar menubar = Ide.getMenubar();
        this._addToDoPopupItem = menubar.createMenuItem((ToggleAction)this._addToDoAction, 6.0f);
        this._editToDoPopupItem = menubar.createMenuItem((ToggleAction)this._editToDoAction, 7.0f);
    }

    private void _showToDoWindow() {
        ToDoWindow toDoWindow = this.getToDoWindow();
        toDoWindow.show();
        DockStation.getDockStation().activateDockable((Dockable)toDoWindow);
        this.setScope(toDoWindow.getScopeActionId());
    }

    private void hideToDoWindow() {
        ToDoWindow toDoWindow = this.getToDoWindow();
        DockStation dockStation = DockStation.getDockStation();
        dockStation.setDockableVisible((Dockable)toDoWindow, false);
    }

    private ToDoWindow getToDoWindow() {
        if (this._toDoWindow == null) {
            this._itemManager.loadData();
            this._toDoWindow = (ToDoWindow)DockStation.getDockStation().findDockable(ToDoWindow.getToDoWindowViewId());
        }
        return this._toDoWindow;
    }

    static void mav$_showToDoWindow(ToDoManagerImpl toDoManagerImpl) {
        toDoManagerImpl._showToDoWindow();
    }

    static ToDoTableModel ra$_baseTableModel() {
        return _baseTableModel;
    }

    static ToDoItemManager ra$_itemManager(ToDoManagerImpl toDoManagerImpl) {
        return toDoManagerImpl._itemManager;
    }

    static List ra$_listeningTo() {
        return _listeningTo;
    }

    static ToDoFinder ra$_toDoFinder(ToDoManagerImpl toDoManagerImpl) {
        return toDoManagerImpl._toDoFinder;
    }

    static ToDoWindow ra$_toDoWindow(ToDoManagerImpl toDoManagerImpl) {
        return toDoManagerImpl._toDoWindow;
    }

    static FilteredToDoTableModel ra$_filteredTableModel(ToDoManagerImpl toDoManagerImpl) {
        return toDoManagerImpl._filteredTableModel;
    }

    static void wa$_currentScope(ToDoManagerImpl toDoManagerImpl, Object object) {
        toDoManagerImpl._currentScope = object;
    }

    static HashMap ra$_editorToPluginMap(ToDoManagerImpl toDoManagerImpl) {
        return toDoManagerImpl._editorToPluginMap;
    }

    static void mav$removeListenerFromObject(ToDoManagerImpl toDoManagerImpl, Node node) {
        toDoManagerImpl.removeListenerFromObject(node);
    }

    static List ra$_textBufferListeners(ToDoManagerImpl toDoManagerImpl) {
        return toDoManagerImpl._textBufferListeners;
    }

    static void mav$_detachListeners(ToDoManagerImpl toDoManagerImpl) {
        toDoManagerImpl._detachListeners();
    }

    static List maS$_getToDoListFromNode(Node node) {
        return ToDoManagerImpl._getToDoListFromNode(node);
    }

    static void mav$_addBusyIndicator(ToDoManagerImpl toDoManagerImpl) {
        toDoManagerImpl._addBusyIndicator();
    }

    static Object ra$_currentScope(ToDoManagerImpl toDoManagerImpl) {
        return toDoManagerImpl._currentScope;
    }

    static void mav$_listenToScope(ToDoManagerImpl toDoManagerImpl, Object object) {
        toDoManagerImpl._listenToScope(object);
    }

    static void mav$_removeBusyIndicator(ToDoManagerImpl toDoManagerImpl) {
        toDoManagerImpl._removeBusyIndicator();
    }

    static List maS$buildProjectList(Folder folder) {
        return ToDoManagerImpl.buildProjectList(folder);
    }

    static List maS$buildContentSetListFromProjectList(List list) {
        return ToDoManagerImpl.buildContentSetListFromProjectList(list);
    }

    final class 1
    implements Runnable {
        public void run() {
            ToDoManagerImpl.mav$_showToDoWindow(ToDoManagerImpl.this);
        }
    }

    private final class ToDoObserver
    extends NodeListener
    implements Observer {
        public void update(Object object, UpdateMessage updateMessage) {
            int n = updateMessage.getMessageID();
            if (object instanceof Workspace) {
                if (n == UpdateMessage.CHILD_ADDED) {
                    this._processProjectAdd(updateMessage.getAddObjects());
                } else if (n == UpdateMessage.CHILD_REMOVED) {
                    this._processProjectRemove((Workspace)object, updateMessage.getRemoveObjects());
                }
            } else if (object instanceof Project) {
                if (n == UpdateMessage.CHILD_ADDED) {
                    this._processNodeAdd(updateMessage.getAddObjects());
                } else if (n == UpdateMessage.CHILD_RENAMED) {
                    this._processNodeRemove(updateMessage.getModifyObjects());
                    this._processNodeAdd(updateMessage.getAddObjects());
                } else if (n == UpdateMessage.CHILD_REMOVED) {
                    this._processNodeRemove(updateMessage.getRemoveObjects());
                }
            } else if (n == UpdateMessage.OBJECT_RENAMED) {
                Node node;
                this._processNodeRemove(updateMessage.getModifyObjects());
                this._processNodeAdd(updateMessage.getAddObjects());
                List list = updateMessage.getAddObjects();
                int n2 = ToDoManagerImpl.ra$_toDoWindow(ToDoManagerImpl.this).getScopeActionId();
                if (n2 == ToDoWindow.CURRENT_FILE_CMD_ID && (node = (Node)list.get(0)) instanceof TextNode) {
                    ToDoManagerImpl.ra$_filteredTableModel(ToDoManagerImpl.this).setScope(node, true);
                    ToDoManagerImpl.wa$_currentScope(ToDoManagerImpl.this, node);
                }
            }
        }

        public void nodeClosed(NodeEvent nodeEvent) {
        }

        public void nodeDeleted(NodeEvent nodeEvent) {
            ArrayList<Node> arrayList = new ArrayList<Node>(1);
            arrayList.add(nodeEvent.getNode());
            this._processNodeRemove(arrayList);
        }

        public void nodeDirtyStateChanged(NodeEvent nodeEvent, boolean bl) {
        }

        public void nodeOpened(NodeEvent nodeEvent) {
        }

        public void nodeRenamed(NodeEvent nodeEvent, URL uRL, URL uRL2) {
            ToDoManagerImpl.ra$_itemManager(ToDoManagerImpl.this).renameURL(uRL, uRL2);
        }

        public void nodeReverted(NodeEvent nodeEvent) {
        }

        public void nodeSaved(NodeEvent nodeEvent) {
        }

        public void nodeWillBeSaved(NodeEvent nodeEvent) {
        }

        public void nodeWillClose(NodeEvent nodeEvent) {
        }

        public void nodeWillOpen(NodeEvent nodeEvent) {
        }

        private final void _processProjectAdd(List list) {
            Project project = null;
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                project = (Project)list.get(n2);
                project.attach((Observer)this);
                ToDoManagerImpl.ra$_listeningTo().add(project);
                ++n2;
            }
            ToDoManagerImpl.ra$_toDoFinder(ToDoManagerImpl.this).addChangeMessage(new ChangeMessage(0, list));
        }

        private final void _processProjectRemove(Workspace workspace, List list) {
            Project project = null;
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                project = (Project)list.get(n2);
                project.detach((Observer)this);
                ToDoManagerImpl.ra$_listeningTo().remove(project);
                ++n2;
            }
            ToDoManagerImpl.ra$_toDoFinder(ToDoManagerImpl.this).addChangeMessage(new ChangeMessage(1, list, workspace));
        }

        private final void _processNodeAdd(List list) {
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                ToDoItemManager.mav$_addToDoItemsForNode(ToDoManagerImpl.ra$_itemManager(ToDoManagerImpl.this), (Node)list.get(n2), null);
                ++n2;
            }
        }

        private final void _processNodeRemove(List list) {
            int n = list.size();
            URL uRL = null;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    block4: {
                        Object e;
                        block3: {
                            e = list.get(n2);
                            if (!(e instanceof Node)) break block3;
                            uRL = ((Node)e).getURL();
                            break block4;
                        }
                        if (!(e instanceof URL)) break block5;
                        uRL = (URL)e;
                    }
                    ToDoManagerImpl.ra$_baseTableModel().removeToDoItemsForURL(uRL);
                }
                ++n2;
            }
        }

        private ToDoObserver() {
        }

        ToDoObserver(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class BufferChangeListener
    implements ActionListener,
    TextBufferListener {
        private Node _node;
        private Timer _timer;

        public BufferChangeListener(Node node) {
            this._node = node;
            this._timer = new Timer(500, this);
        }

        public Node getNode() {
            return this._node;
        }

        public void attributeUpdate(TextBuffer textBuffer, int n) {
        }

        public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
            this._timer.restart();
        }

        public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
            this._timer.restart();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ToDoItemManager.mav$_addToDoItemsForNode(ToDoManagerImpl.ra$_itemManager(ToDoManagerImpl.this), this._node, null);
            this._timer.stop();
        }
    }

    private class ToDoItemManager
    extends AbstractLineGutterMarkManager {
        private Icon _toDoIcon;
        private HighlightStyle _toDoTagHighlightStyle = CodeEditor.createHighlightStyle((String)"todo-style", (String)ToDoArb.getString(45), (int)20, (Color)Color.magenta, (Color)new Color(153, 153, 153, 0));
        private static final String TODO_STYLE = "todo-style";
        private static final String TODO_COLUMN = "todo-column";
        private boolean _dataLoaded;

        public ToDoItemManager() {
            FileOverviewMargin.setMarkColor((String)TODO_COLUMN, (HighlightStyle)this._toDoTagHighlightStyle);
        }

        protected void startup() {
            super.startup();
        }

        protected void shutdown() {
            super.shutdown();
            ToDoManagerImpl.mav$_detachListeners(ToDoManagerImpl.this);
            this.saveData();
        }

        public void editorOpened(Editor editor) {
            if (editor instanceof CodeEditor) {
                this.loadData();
                CodeEditor codeEditor = (CodeEditor)editor;
                ToDoTagHighlightPlugin toDoTagHighlightPlugin = new ToDoTagHighlightPlugin(this._toDoTagHighlightStyle);
                BasicEditorPane basicEditorPane = ((CodeEditor)editor).getFocusedEditorPane();
                basicEditorPane.installPlugin((EditorPlugin)toDoTagHighlightPlugin);
                ToDoManagerImpl.ra$_editorToPluginMap(ToDoManagerImpl.this).put(editor, toDoTagHighlightPlugin);
                Node node = codeEditor.getContext().getNode();
                this._addToDoItemsForNode(node, codeEditor);
                if (node instanceof TextNode) {
                    TextNode textNode = (TextNode)node;
                    TextBuffer textBuffer = textNode.acquireTextBuffer();
                    BufferChangeListener bufferChangeListener = new BufferChangeListener(node);
                    ToDoManagerImpl.ra$_textBufferListeners(ToDoManagerImpl.this).add(bufferChangeListener);
                    textBuffer.addTextBufferListener((TextBufferListener)bufferChangeListener);
                }
            }
        }

        public void editorClosed(Editor editor) {
            if (editor instanceof CodeEditor) {
                ToDoTagHighlightPlugin toDoTagHighlightPlugin = (ToDoTagHighlightPlugin)ToDoManagerImpl.ra$_editorToPluginMap(ToDoManagerImpl.this).get(editor);
                BasicEditorPane basicEditorPane = ((CodeEditor)editor).getFocusedEditorPane();
                Node node = editor.getContext().getNode();
                ToDoManagerImpl.mav$removeListenerFromObject(ToDoManagerImpl.this, node);
                basicEditorPane.deinstallPlugin((EditorPlugin)toDoTagHighlightPlugin);
                ToDoManagerImpl.ra$_editorToPluginMap(ToDoManagerImpl.this).remove(editor);
            }
            super.editorClosed(editor);
        }

        public void editorActivated(Editor editor) {
            ToDoManagerImpl.this.setScope(editor.getContext());
        }

        protected OpenLineGutterMark createOpenLineGutterMarkFor(CodeEditorGutter codeEditorGutter, LocatableItem locatableItem) {
            OpenLineGutterMark openLineGutterMark = super.createOpenLineGutterMarkFor(codeEditorGutter, locatableItem);
            CodeEditor codeEditor = codeEditorGutter.getCodeEditor();
            this._handleHighlightFor(locatableItem, codeEditor, true);
            if (locatableItem instanceof ToDoItem && !((ToDoItem)locatableItem).shouldPersist()) {
                openLineGutterMark.getGutterMark().setVisible(false);
            }
            return openLineGutterMark;
        }

        private void _handleHighlightFor(LocatableItem locatableItem, CodeEditor codeEditor, boolean bl) {
            JDevToDoItem jDevToDoItem;
            if (locatableItem instanceof JDevToDoItem && ModelUtil.hasLength((String)(jDevToDoItem = (JDevToDoItem)locatableItem).getTag())) {
                int n = codeEditor.getLineStartOffset(locatableItem.getLine());
                int n2 = locatableItem.getColumn();
                int n3 = n + n2;
                ToDoTagHighlightPlugin toDoTagHighlightPlugin = (ToDoTagHighlightPlugin)ToDoManagerImpl.ra$_editorToPluginMap(ToDoManagerImpl.this).get(codeEditor);
                if (bl) {
                    toDoTagHighlightPlugin.createHighlightForTag(n3, jDevToDoItem.getTag().length(), (ToDoItem)jDevToDoItem);
                } else {
                    toDoTagHighlightPlugin.removeHighlightForTag(n3, (ToDoItem)jDevToDoItem);
                }
            }
        }

        public void createLineGutterMarkFor(ToDoItem toDoItem) {
            super.createLineGutterMarkFor((LocatableItem)toDoItem);
        }

        public void removeLineGutterMark(LocatableItem locatableItem) {
            if (locatableItem instanceof ToDoItem) {
                ToDoManagerImpl.ra$_baseTableModel().removeToDoItem((ToDoItem)locatableItem);
            }
            OpenLineGutterMark[] openLineGutterMarkArray = this.getOpenLineGutterMarksFor(locatableItem);
            int n = openLineGutterMarkArray.length;
            int n2 = 0;
            while (n2 < n) {
                OpenLineGutterMark openLineGutterMark = openLineGutterMarkArray[n2];
                OpenEditor openEditor = this.getOpenEditorFor(openLineGutterMark);
                if (openEditor != null) {
                    openEditor.getOpenLineGutterMarkList().remove(openLineGutterMark);
                    openLineGutterMark.getGutterMark().getGutterColumn().removeGutterMark(openLineGutterMark.getGutterMark());
                    this._handleHighlightFor(locatableItem, openEditor.getEditor(), false);
                    if (openEditor.getOpenLineGutterMarkList().size() == 0) {
                        this.removeGutterColumnFrom(openEditor.getEditor());
                    }
                }
                ++n2;
            }
        }

        protected Icon getIcon() {
            if (this._toDoIcon == null) {
                this._toDoIcon = ToDoArb.getIcon(127);
            }
            return this._toDoIcon;
        }

        protected HighlightStyle getHighlightStyle() {
            return null;
        }

        protected int getMarkOrder() {
            return 5000;
        }

        protected int getMarkOptions() {
            return 4;
        }

        protected String getGutterColumnName() {
            return TODO_COLUMN;
        }

        protected LineGutterMarkList getLineGutterMarkList() {
            return ToDoManagerImpl.ra$_baseTableModel();
        }

        protected int getMissingLineBehavior() {
            return 1;
        }

        protected void loadData() {
            if (!this._dataLoaded) {
                List list = null;
                try {
                    URL uRL = this._getSaveURL();
                    Object2Dom object2Dom = Object2Dom.newInstance();
                    list = (List)object2Dom.toObject(uRL);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                ToDoManagerImpl.ra$_baseTableModel().addToDoItems(list);
                this._dataLoaded = true;
            }
        }

        private URL _getSaveURL() {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
            URL uRL = extensionRegistry.getSystemDirectory("oracle.jdeveloper");
            return URLFactory.newURL((URL)uRL, (String)ToDoManagerImpl.TODO_ITEMS_FILE);
        }

        protected void saveData() {
            ArrayList<ToDoItem> arrayList = new ArrayList<ToDoItem>();
            List list = ToDoManagerImpl.ra$_baseTableModel().getDataList();
            if (list != null && list.size() > 0) {
                int n = list.size();
                ToDoItem toDoItem = null;
                int n2 = 0;
                while (n2 < n) {
                    toDoItem = (ToDoItem)list.get(n2);
                    if (toDoItem.shouldPersist()) {
                        arrayList.add(toDoItem);
                    }
                    ++n2;
                }
            }
            try {
                URL uRL = this._getSaveURL();
                Object2Dom object2Dom = Object2Dom.newInstance();
                object2Dom.setNamespaceURI(NAMESPACE_URI);
                object2Dom.toDocument(arrayList, ToDoManagerImpl.ROOT_TAG, uRL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        void addToDoItem(CodeEditor codeEditor, int n) {
            URL uRL = this.getURLFor(codeEditor);
            if (uRL == null) {
                return;
            }
            JDevToDoItem jDevToDoItem = (JDevToDoItem)ToDoManagerImpl.ra$_baseTableModel().createToDoItem(uRL, n);
            if (jDevToDoItem != null) {
                ToDoManagerImpl.ra$_baseTableModel().addToDoItem((ToDoItem)jDevToDoItem);
                super.createLineGutterMarkFor((LocatableItem)jDevToDoItem);
            }
        }

        void editToDoItems(CodeEditor codeEditor, int n) {
            URL uRL = this.getURLFor(codeEditor);
            if (uRL == null) {
                return;
            }
            LineGutterMarkList lineGutterMarkList = this.getLineGutterMarkList();
            LocatableItem[] locatableItemArray = lineGutterMarkList.findLineGutterMark(uRL, n);
            ToDoItem[] toDoItemArray = new ToDoItem[locatableItemArray.length];
            int n2 = 0;
            while (n2 < locatableItemArray.length) {
                toDoItemArray[n2] = (ToDoItem)locatableItemArray[n2];
                ++n2;
            }
            this.editToDoItems(toDoItemArray);
        }

        void removeToDoItem(ToDoItem toDoItem) {
            ToDoManagerImpl.ra$_baseTableModel().removeToDoItem(toDoItem);
            this.removeLineGutterMark((LocatableItem)toDoItem);
        }

        void removeItemsWithTag(ToDoTag toDoTag) {
            ArrayList<JDevToDoItem> arrayList = new ArrayList<JDevToDoItem>();
            int n = ToDoManagerImpl.ra$_baseTableModel().getRowCount();
            int n2 = 0;
            while (n2 < n) {
                JDevToDoItem jDevToDoItem;
                String string;
                ToDoItem toDoItem = ToDoManagerImpl.ra$_baseTableModel().getToDoItemForRow(n2);
                if (toDoItem instanceof JDevToDoItem && (string = (jDevToDoItem = (JDevToDoItem)toDoItem).getTag()) != null && string.equals(toDoTag.getTag())) {
                    arrayList.add(jDevToDoItem);
                }
                ++n2;
            }
            if (arrayList.size() > 0) {
                this.removeToDoItems(arrayList);
            }
        }

        void removeToDoItems(List list) {
            ToDoManagerImpl.ra$_baseTableModel().removeToDoItems(list);
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                this.removeLineGutterMark((LocatableItem)((ToDoItem)list.get(n2)));
                ++n2;
            }
        }

        URL getURLForEditor(CodeEditor codeEditor) {
            return super.getURLFor(codeEditor);
        }

        public void renameURL(URL uRL, URL uRL2) {
            ToDoManagerImpl.ra$_baseTableModel().renameURL(uRL, uRL2);
        }

        public void updateDataModel(Node node, List list, CodeEditor codeEditor) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ToDoManagerImpl.ra$_baseTableModel().addToDoItems(list, node.getURL(), arrayList, arrayList2);
            if (codeEditor != null) {
                this._superEditorOpened((Editor)codeEditor);
                ToDoManagerImpl.this.setScope(codeEditor.getContext());
            } else {
                ToDoItem toDoItem = null;
                int n = arrayList2.size();
                int n2 = 0;
                while (n2 < n) {
                    toDoItem = (ToDoItem)arrayList2.get(n2);
                    this.removeLineGutterMark((LocatableItem)toDoItem);
                    ++n2;
                }
                n = arrayList.size();
                int n3 = 0;
                while (n3 < n) {
                    toDoItem = (ToDoItem)arrayList.get(n3);
                    this.createLineGutterMarkFor(toDoItem);
                    ++n3;
                }
            }
        }

        private final void _addToDoItemsForNode(Node node, CodeEditor codeEditor) {
            1 var3_3 = new 1(this, node, codeEditor);
            var3_3.start();
        }

        private void _superEditorOpened(Editor editor) {
            super.editorOpened(editor);
        }

        void editToDoItems(ToDoItem[] toDoItemArray) {
            ArrayList<ToDoItem> arrayList = new ArrayList<ToDoItem>();
            int n = 0;
            while (n < toDoItemArray.length) {
                if (toDoItemArray[n].isEditable()) {
                    arrayList.add(toDoItemArray[n]);
                }
                ++n;
            }
            int n2 = arrayList.size();
            ToDoItem[] toDoItemArray2 = new ToDoItem[n2];
            int n3 = 0;
            while (n3 < n2) {
                toDoItemArray2[n3] = (ToDoItem)((ToDoItem)arrayList.get(n3)).copyTo(null);
                ++n3;
            }
            if (n2 == 0) {
                return;
            }
            if (n2 == 1) {
                ToDoPanel toDoPanel = new ToDoPanel();
                toDoItemArray2[0] = toDoPanel.runDialog(toDoItemArray2[0], false);
                if (toDoItemArray2[0] != null) {
                    ToDoManagerImpl.ra$_baseTableModel().updateToDoItem((ToDoItem)arrayList.get(0), toDoItemArray2[0]);
                }
            } else {
                ToDoPanel toDoPanel = new ToDoPanel(true);
                if ((toDoItemArray2 = toDoPanel.runMultiEditDialog(toDoItemArray2)) != null) {
                    int n4 = 0;
                    while (n4 < n2) {
                        ToDoManagerImpl.ra$_baseTableModel().updateToDoItem((ToDoItem)arrayList.get(n4), toDoItemArray2[n4]);
                        ++n4;
                    }
                }
            }
        }

        static void mav$_addToDoItemsForNode(ToDoItemManager toDoItemManager, Node node, CodeEditor codeEditor) {
            toDoItemManager._addToDoItemsForNode(node, codeEditor);
        }

        final class 1
        extends SwingWorker {
            List toDoItemsInFile;
            private final /* synthetic */ Node v$node;
            private final /* synthetic */ CodeEditor v$editorOpened;
            final /* synthetic */ ToDoItemManager this$0;

            void $init$() {
                this.toDoItemsInFile = null;
            }

            public Object construct() {
                this.toDoItemsInFile = ToDoManagerImpl.maS$_getToDoListFromNode(this.v$node);
                return this.toDoItemsInFile;
            }

            public void finished() {
                this.this$0.updateDataModel(this.v$node, this.toDoItemsInFile, this.v$editorOpened);
            }

            public 1(ToDoItemManager toDoItemManager, Node node, CodeEditor codeEditor) {
                this.v$editorOpened = codeEditor;
                this.v$node = node;
                this.this$0 = toDoItemManager;
                this.$init$();
            }
        }
    }

    private static class SearchForTagsTask
    implements Runnable,
    ProgressTrackedTask {
        private ProgressTracker _progressTracker;
        private KeywordBatchQueryTask _queryTask;
        private String _name;

        void $init$() {
            this._progressTracker = Ide.getStatusBar().getProgressTracker();
        }

        public SearchForTagsTask(KeywordBatchQueryTask keywordBatchQueryTask, String string) {
            this.$init$();
            this._queryTask = keywordBatchQueryTask;
            this._name = string;
            this._progressTracker.addTask((ProgressTrackedTask)this, "ToDoQueryTask");
        }

        public boolean isIndeterminate() {
            return true;
        }

        public boolean isWorking() {
            Thread thread = this._progressTracker.getThread((ProgressTrackedTask)this);
            return thread != null && thread.isAlive() && !this._queryTask.isFinished();
        }

        public void run() {
            this._queryTask.waitUntilFinished();
        }

        public int getCurrentValue() {
            return 0;
        }

        public int getMinimum() {
            return 0;
        }

        public int getMaximum() {
            return 0;
        }

        public String getCurrentText() {
            return null;
        }

        public String getTaskDescription() {
            return ToDoArb.format(107, this._name);
        }
    }

    private class ToDoFinder
    implements ActionListener {
        private List _changeMessageList;
        private SwingWorker _swingWorker;
        private UpdateManager _updateManager;

        void $init$() {
            this._changeMessageList = new ArrayList();
        }

        public ToDoFinder() {
            this.$init$();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeMessage(ChangeMessage changeMessage) {
            List list = this._changeMessageList;
            synchronized (list) {
                if (changeMessage.getChangeType() == 2) {
                    if (this._swingWorker != null) {
                        this._swingWorker.interrupt();
                    }
                    this._changeMessageList.clear();
                }
                this._changeMessageList.add(changeMessage);
            }
            this._processChangeMessage();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this._processChangeMessage();
        }

        private void _processChangeMessage() {
            if (this._swingWorker != null) {
                Timer timer = new Timer(25, this);
                timer.setRepeats(false);
                timer.start();
            } else {
                ChangeMessage changeMessage = this._getChangeMessage();
                if (changeMessage == null) {
                    return;
                }
                ToDoManagerImpl.mav$_addBusyIndicator(ToDoManagerImpl.this);
                if (changeMessage.getChangeType() == 2) {
                    ToDoManagerImpl.ra$_filteredTableModel(ToDoManagerImpl.this).setScope(changeMessage.getChangeObject(), false);
                }
                this._swingWorker = new 1(this, changeMessage);
                this._swingWorker.start();
            }
        }

        private final void _sendUpdateMessage(ChangeMessage changeMessage, Node node, List list) {
            ChangeMessage changeMessage2 = null;
            changeMessage2 = changeMessage.getChangeType() == 1 ? new ChangeMessage(changeMessage.getChangeType(), new Pair((Object)node, (Object)list), changeMessage.getWorkspace()) : new ChangeMessage(changeMessage.getChangeType(), new Pair((Object)node, (Object)list));
            this._updateManager.addUpdateMessage(changeMessage2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void _addResultToHashSet(KeywordBatchQueryTask keywordBatchQueryTask, HashSet hashSet, List list) {
            HashSet hashSet2 = hashSet;
            synchronized (hashSet2) {
                URL[][] uRLArray = keywordBatchQueryTask.getBatchQueryResult();
                if (uRLArray != null) {
                    int n = 0;
                    while (n < uRLArray.length) {
                        URL[] uRLArray2 = uRLArray[n];
                        int n2 = 0;
                        while (n2 < uRLArray2.length) {
                            URL uRL = uRLArray2[n2];
                            int n3 = 0;
                            while (n3 < list.size()) {
                                ContentSet contentSet = (ContentSet)list.get(n);
                                if (contentSet.canHaveMember(uRL)) {
                                    hashSet.add(uRL);
                                    break;
                                }
                                ++n3;
                            }
                            ++n2;
                        }
                        ++n;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ChangeMessage _getChangeMessage() {
            ChangeMessage changeMessage = null;
            List list = this._changeMessageList;
            synchronized (list) {
                if (this._changeMessageList.size() == 0) {
                    ChangeMessage changeMessage2 = null;
                    return changeMessage2;
                }
                changeMessage = (ChangeMessage)this._changeMessageList.remove(0);
            }
            return changeMessage;
        }

        private String[] _getTagsToFind() {
            ToDoTag[] toDoTagArray = ToDoAddin.getTags();
            String[] stringArray = new String[toDoTagArray.length];
            int n = 0;
            while (n < toDoTagArray.length) {
                stringArray[n] = toDoTagArray[n].getTag();
                ++n;
            }
            return stringArray;
        }

        private URLPath _buildPathsFromProjectList(List list) {
            URLPath uRLPath = new URLPath();
            int n = list.size();
            Project project = null;
            URLPath uRLPath2 = null;
            int n2 = 0;
            while (n2 < n) {
                project = (Project)list.get(n2);
                uRLPath2 = ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs();
                uRLPath.add(uRLPath2);
                ++n2;
            }
            return uRLPath;
        }

        static void wa$_swingWorker(ToDoFinder toDoFinder, SwingWorker swingWorker) {
            toDoFinder._swingWorker = swingWorker;
        }

        static String[] mav$_getTagsToFind(ToDoFinder toDoFinder) {
            return toDoFinder._getTagsToFind();
        }

        static URLPath mav$_buildPathsFromProjectList(ToDoFinder toDoFinder, List list) {
            return toDoFinder._buildPathsFromProjectList(list);
        }

        static void mav$_addResultToHashSet(ToDoFinder toDoFinder, KeywordBatchQueryTask keywordBatchQueryTask, HashSet hashSet, List list) {
            toDoFinder._addResultToHashSet(keywordBatchQueryTask, hashSet, list);
        }

        static UpdateManager ra$_updateManager(ToDoFinder toDoFinder) {
            return toDoFinder._updateManager;
        }

        static void wa$_updateManager(ToDoFinder toDoFinder, UpdateManager updateManager) {
            toDoFinder._updateManager = updateManager;
        }

        static void mav$_sendUpdateMessage(ToDoFinder toDoFinder, ChangeMessage changeMessage, Node node, List list) {
            toDoFinder._sendUpdateMessage(changeMessage, node, list);
        }

        final class 1
        extends SwingWorker {
            KeywordBatchQueryTask queryTask;
            private final /* synthetic */ ChangeMessage v$changeMessage;
            final /* synthetic */ ToDoFinder this$0;

            void $init$() {
                this.queryTask = null;
            }

            public Object construct() {
                HashSet<URL> hashSet = new HashSet<URL>();
                String[] stringArray = ToDoFinder.mav$_getTagsToFind(this.this$0);
                List list = null;
                if (this.v$changeMessage.getChangeType() == 2) {
                    Object object = this.v$changeMessage.getChangeObject();
                    if (object instanceof Folder) {
                        list = ToDoManagerImpl.maS$buildProjectList((Folder)object);
                    } else if (object instanceof TextNode) {
                        hashSet.add(((Node)object).getURL());
                    }
                } else {
                    list = (List)this.v$changeMessage.getChangeObject();
                }
                if (list != null) {
                    try {
                        URLPath uRLPath = ToDoFinder.mav$_buildPathsFromProjectList(this.this$0, list);
                        List list2 = ToDoManagerImpl.maS$buildContentSetListFromProjectList(list);
                        URL[] uRLArray = uRLPath.getEntries();
                        KeywordIndex keywordIndex = null;
                        int n = 0;
                        while (n < uRLArray.length) {
                            if (Thread.interrupted()) {
                                throw new InterruptedException();
                            }
                            keywordIndex = KeywordIndex.getKeywordIndex(uRLArray[n]);
                            this.queryTask = keywordIndex.getBatchQueryTask(stringArray);
                            SearchForTagsTask searchForTagsTask = new SearchForTagsTask(this.queryTask, uRLArray[n].toString());
                            while (searchForTagsTask.isWorking()) {
                                if (Thread.interrupted()) {
                                    throw new InterruptedException();
                                }
                                try {
                                    Thread.sleep(25);
                                }
                                catch (Exception exception) {
                                    throw new InterruptedException();
                                }
                            }
                            ToDoFinder.mav$_addResultToHashSet(this.this$0, this.queryTask, hashSet, list2);
                            ++n;
                        }
                    }
                    catch (Exception exception) {
                        if (this.queryTask != null) {
                            this.queryTask.cancel();
                            this.queryTask = null;
                        }
                        hashSet = null;
                        if (ToDoFinder.ra$_updateManager(this.this$0) != null) {
                            ToDoFinder.ra$_updateManager(this.this$0).cancel();
                            ToDoFinder.wa$_updateManager(this.this$0, null);
                        }
                        Object var18_13 = null;
                        return var18_13;
                    }
                }
                ToDoFinder.wa$_updateManager(this.this$0, new UpdateManager(ToDoManagerImpl.ra$_itemManager(this.this$0.ToDoManagerImpl.this)));
                if (hashSet != null && hashSet.size() > 0) {
                    Iterator iterator = hashSet.iterator();
                    URL uRL = null;
                    while (iterator.hasNext()) {
                        if (!Thread.interrupted()) {
                            uRL = (URL)iterator.next();
                            try {
                                Node node = NodeFactory.findOrCreate((URL)uRL);
                                List list3 = ToDoManagerImpl.maS$_getToDoListFromNode(node);
                                if (list3 == null) continue;
                                ToDoFinder.mav$_sendUpdateMessage(this.this$0, this.v$changeMessage, node, list3);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        ToDoFinder.ra$_updateManager(this.this$0).cancel();
                        break;
                    }
                }
                ToDoFinder.ra$_updateManager(this.this$0).setState(1);
                ToDoFinder.wa$_updateManager(this.this$0, null);
                return null;
            }

            public void finished() {
                ToDoManagerImpl.mav$_listenToScope(this.this$0.ToDoManagerImpl.this, ToDoManagerImpl.ra$_currentScope(this.this$0.ToDoManagerImpl.this));
                ToDoManagerImpl.mav$_removeBusyIndicator(this.this$0.ToDoManagerImpl.this);
                ToDoFinder.wa$_swingWorker(this.this$0, null);
            }

            public 1(ToDoFinder toDoFinder, ChangeMessage changeMessage) {
                this.v$changeMessage = changeMessage;
                this.this$0 = toDoFinder;
                this.$init$();
            }
        }
    }

    private static class UpdateManager
    implements Runnable,
    ProgressTrackedTask {
        public static final int LOADING_URLS_STATE = 0;
        public static final int DONE_LOADING_URLS_STATE = 1;
        private ProgressTracker _progressTracker;
        private List _list;
        private ToDoItemManager _itemManager;
        private volatile boolean _cancel;
        private int _managerState;

        void $init$() {
            this._progressTracker = Ide.getStatusBar().getProgressTracker();
            this._list = new ArrayList();
            this._managerState = 0;
        }

        public UpdateManager(ToDoItemManager toDoItemManager) {
            this.$init$();
            this._itemManager = toDoItemManager;
            this._progressTracker.addTask((ProgressTrackedTask)this, "TaskUpdateManager");
        }

        public void setState(int n) {
            this._managerState = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addUpdateMessage(ChangeMessage changeMessage) {
            List list = this._list;
            synchronized (list) {
                this._list.add(changeMessage);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ChangeMessage getUpdateMessage() {
            List list = this._list;
            synchronized (list) {
                if (this._list.size() > 0) {
                    ChangeMessage changeMessage = (ChangeMessage)this._list.remove(0);
                    return changeMessage;
                }
                ChangeMessage changeMessage = null;
                return changeMessage;
            }
        }

        public boolean isIndeterminate() {
            return true;
        }

        public boolean isWorking() {
            Thread thread = this._progressTracker.getThread((ProgressTrackedTask)this);
            return thread != null && thread.isAlive() && !this._cancel;
        }

        public void cancel() {
            this._cancel = true;
            Thread thread = this._progressTracker.getThread((ProgressTrackedTask)this);
            thread.interrupt();
        }

        public void run() {
            while (!this._cancel) {
                ChangeMessage changeMessage = this.getUpdateMessage();
                if (changeMessage == null) {
                    if (this._managerState == 0) {
                        try {
                            Thread.sleep(100);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            this._cancel = true;
                            break;
                        }
                    }
                    this._cancel = true;
                    break;
                }
                int n = changeMessage.getChangeType();
                Pair pair = (Pair)changeMessage.getChangeObject();
                Node node = (Node)pair.getFirst();
                List list = (List)pair.getSecond();
                if (n == 0 || n == 2) {
                    2 var7_6 = new 2(this, node, list);
                    if (SwingUtilities.isEventDispatchThread()) {
                        var7_6.run();
                        continue;
                    }
                    SwingUtilities.invokeLater(var7_6);
                    continue;
                }
                Workspace workspace = changeMessage.getWorkspace();
                ArrayList arrayList = new ArrayList();
                ToDoManagerImpl.getProjectsForWorkspace(workspace, arrayList);
                List list2 = ToDoManagerImpl.maS$buildContentSetListFromProjectList(arrayList);
                1 var11_10 = new 1(this, node, list2);
                if (SwingUtilities.isEventDispatchThread()) {
                    var11_10.run();
                    continue;
                }
                SwingUtilities.invokeLater(var11_10);
            }
        }

        public int getCurrentValue() {
            return 0;
        }

        public int getMinimum() {
            return 0;
        }

        public int getMaximum() {
            return 0;
        }

        public String getCurrentText() {
            return null;
        }

        public String getTaskDescription() {
            return ToDoArb.getString(117);
        }

        private void _handleProjectRemove(Node node, List list) {
            URL uRL = node.getURL();
            if (!ToDoManagerImpl.isURLInScopeBoundary(uRL, list)) {
                ToDoManagerImpl.ra$_baseTableModel().removeToDoItemsForURL(uRL);
            }
        }

        static ToDoItemManager ra$_itemManager(UpdateManager updateManager) {
            return updateManager._itemManager;
        }

        static void mav$_handleProjectRemove(UpdateManager updateManager, Node node, List list) {
            updateManager._handleProjectRemove(node, list);
        }

        final class 2
        implements Runnable {
            private final /* synthetic */ Node v$node;
            private final /* synthetic */ List v$taskList;
            final /* synthetic */ UpdateManager this$0;

            public void run() {
                UpdateManager.ra$_itemManager(this.this$0).updateDataModel(this.v$node, this.v$taskList, null);
            }

            public 2(UpdateManager updateManager, Node node, List list) {
                this.v$taskList = list;
                this.v$node = node;
                this.this$0 = updateManager;
            }
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ Node v$node;
            private final /* synthetic */ List v$contentSetList;
            final /* synthetic */ UpdateManager this$0;

            public void run() {
                UpdateManager.mav$_handleProjectRemove(this.this$0, this.v$node, this.v$contentSetList);
            }

            public 1(UpdateManager updateManager, Node node, List list) {
                this.v$contentSetList = list;
                this.v$node = node;
                this.this$0 = updateManager;
            }
        }
    }

    private static class ChangeMessage {
        public static final int PROJECT_ADD = 0;
        public static final int PROJECT_REMOVE = 1;
        public static final int SCOPE_CHANGE = 2;
        private int _changeType;
        private Object _changeObject;
        private Workspace _workspace;

        public ChangeMessage(int n, Object object) {
            this._changeType = n;
            this._changeObject = object;
        }

        public ChangeMessage(int n, Object object, Workspace workspace) {
            this(n, object);
            this._workspace = workspace;
        }

        public int getChangeType() {
            return this._changeType;
        }

        public Object getChangeObject() {
            return this._changeObject;
        }

        public Workspace getWorkspace() {
            return this._workspace;
        }
    }
}

