/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.todo;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.resource.ToDoArb;
import oracle.jdevimpl.todo.ToDoPriority;

public final class ToDoOptions
extends ChangeEventSource
implements Copyable {
    public static final String KEY_SETTINGS = "ToDoOptions";
    private List _tagList;
    private List _priorityList;
    private int _priorityIdGenerator;
    private String _dateFormatString;
    private List _filterList;

    void $init$() {
        this._tagList = new ArrayList();
        this._priorityList = new ArrayList();
        this._priorityIdGenerator = 100;
        this._filterList = new ArrayList();
    }

    public ToDoOptions() {
        this.$init$();
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        if (dateFormat instanceof SimpleDateFormat) {
            this._dateFormatString = ((SimpleDateFormat)dateFormat).toPattern();
        }
        if (this._dateFormatString == null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ToDoArb.getString(64));
            this._dateFormatString = simpleDateFormat.toPattern();
        }
    }

    public List getTagList() {
        return this._tagList;
    }

    public void setTagList(List list) {
        this._tagList = list;
    }

    public List getPriorityList() {
        return this._priorityList;
    }

    public void setPriorityList(List list) {
        this._priorityList = list;
    }

    public List getFilterList() {
        return this._filterList;
    }

    public void setFilterList(List list) {
        this._filterList = list;
    }

    public int getPriorityIdGenerator() {
        return this._priorityIdGenerator;
    }

    public void setPriorityIdGenerator(int n) {
        this._priorityIdGenerator = n;
    }

    public int getUniquePriorityId() {
        ++this._priorityIdGenerator;
        return this._priorityIdGenerator;
    }

    public String getDateFormatString() {
        return this._dateFormatString;
    }

    public void setDateFormatString(String string) {
        this._dateFormatString = string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ToDoOptions)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ToDoOptions toDoOptions = (ToDoOptions)((Object)object);
        if (ToDoOptions.hasStringChanged(this.getDateFormatString(), toDoOptions.getDateFormatString())) {
            return false;
        }
        if (!ModelUtil.areEqual((Object)this.getFilterList(), (Object)toDoOptions.getFilterList())) {
            return false;
        }
        if (!ModelUtil.areEqual((Object)this.getPriorityList(), (Object)toDoOptions.getPriorityList())) {
            return false;
        }
        return ModelUtil.areEqual((Object)this.getTagList(), (Object)toDoOptions.getTagList());
    }

    public Object copyTo(Object object) {
        ToDoOptions toDoOptions = object != null ? (ToDoOptions)((Object)object) : new ToDoOptions();
        this.copyToImpl(toDoOptions);
        return toDoOptions;
    }

    protected final void copyToImpl(ToDoOptions toDoOptions) {
        toDoOptions._tagList.clear();
        ModelUtil.deepCopy((List)this._tagList, (List)toDoOptions._tagList);
        toDoOptions._priorityList.clear();
        ModelUtil.deepCopy((List)this._priorityList, (List)toDoOptions._priorityList);
        toDoOptions._filterList.clear();
        ModelUtil.deepCopy((List)this._filterList, (List)toDoOptions._filterList);
        toDoOptions._dateFormatString = this._dateFormatString;
        toDoOptions.fireChangeEvent();
    }

    ToDoPriority[] getPriorityDataModel() {
        List list = this.getPriorityList();
        int n = list.size();
        ToDoPriority[] toDoPriorityArray = list.toArray(new ToDoPriority[n]);
        return toDoPriorityArray;
    }

    private static boolean hasStringChanged(String string, String string2) {
        if (string == null && string2 == null) {
            return false;
        }
        if (string == null && string2 != null || string != null && string2 == null) {
            return true;
        }
        return string.equals(string2) ^ true;
    }
}

