/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.todo;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.ide.controls.ButtonsLayoutManager;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.todo.ToDoItem;
import oracle.ide.todo.ToDoManager;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.jdevimpl.resource.ToDoArb;
import oracle.jdevimpl.todo.PriorityCellRenderer;
import oracle.jdevimpl.todo.TagPanel;
import oracle.jdevimpl.todo.ToDoAddin;
import oracle.jdevimpl.todo.ToDoManagerImpl;
import oracle.jdevimpl.todo.ToDoOptions;
import oracle.jdevimpl.todo.ToDoPriority;
import oracle.jdevimpl.todo.ToDoPriorityPanel;
import oracle.jdevimpl.todo.ToDoTableModel;
import oracle.jdevimpl.todo.ToDoTag;

final class ToDoOptionsPanel
extends DefaultTraversablePanel
implements TableModelListener {
    private ToDoOptions _options;
    private ToDoPriority.ToDoPriorityTableModel _priorityTableModel;
    private JLabel _priorityTableLbl;
    private NiceTable _priorityTable;
    private JButton _addPriorityButton;
    private JButton _editPriorityButton;
    private JButton _removePriorityButton;
    private ToDoPriorityPanel _priorityPanel;
    private JPanel _priorityButtonPanel;
    private ToDoTagTableModel _tagTableModel;
    private JLabel _tagTableLbl;
    private NiceTable _tagTable;
    private JButton _addTagButton;
    private JButton _editTagButton;
    private JButton _removeTagButton;
    private TagPanel _tagPanel;
    private JPanel _tagsButtonPanel;
    private TableColumn _priorityColumn;
    private JLabel _dateFormatLbl;
    private JComboBox _dateFormatCombo;
    private List _dateFormatList;
    private DefaultListComboBoxModel _formatModel;
    private UniqueTextEditor _uniqueTextEditor;

    void $init$() {
        this._priorityTableModel = new ToDoPriority.ToDoPriorityTableModel();
        this._priorityTableLbl = new JLabel();
        this._priorityTable = new NiceTable();
        this._addPriorityButton = new JButton();
        this._editPriorityButton = new JButton();
        this._removePriorityButton = new JButton();
        this._tagTableModel = new ToDoTagTableModel();
        this._tagTableLbl = new JLabel();
        this._tagTable = new NiceTable();
        this._addTagButton = new JButton();
        this._editTagButton = new JButton();
        this._removeTagButton = new JButton();
        this._dateFormatLbl = new JLabel();
    }

    public ToDoOptionsPanel() {
        this.$init$();
        this._priorityTableModel.addTableModelListener(this);
        this._dateFormatList = new ArrayList(8);
        this._dateFormatList.add(ToDoArb.getString(64));
        this._dateFormatList.add(ToDoArb.getString(65));
        this._dateFormatList.add(ToDoArb.getString(66));
        this._dateFormatList.add(ToDoArb.getString(67));
        this._dateFormatList.add(ToDoArb.getString(68));
        this._dateFormatList.add(ToDoArb.getString(69));
        this._dateFormatList.add(ToDoArb.getString(70));
        this._dateFormatList.add(ToDoArb.getString(71));
        this._ensureDateFormatListContains(3);
        this._ensureDateFormatListContains(2);
        this._formatModel = new DefaultListComboBoxModel(this._dateFormatList);
        this._uniqueTextEditor = new UniqueTextEditor();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this._options = (ToDoOptions)((Object)traversableContext.find("ToDoOptions"));
        this._loadData();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this._saveData();
        traversableContext.put("ToDoOptions", (Object)this._options);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this._updatePriorityModelForComboBox();
    }

    private void jbInit() throws Exception {
        super.setLayout((LayoutManager)new GridBagLayout());
        this._tagTable.setModel((TableModel)this._tagTableModel);
        this._priorityTable.setModel((TableModel)this._priorityTableModel);
        this._createPrioritySection();
        this._createTagsSection();
        this._dateFormatCombo = new JComboBox(this._formatModel);
        this._dateFormatCombo.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0);
        gridBagConstraints.weighty = 0.0;
        super.add((Component)this._priorityTableLbl, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        super.add((Component)this._priorityTable.getScrollPaneForTable(), (Object)gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        super.add((Component)this._priorityButtonPanel, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        super.add((Component)this._tagTableLbl, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        super.add((Component)this._tagTable.getScrollPaneForTable(), (Object)gridBagConstraints);
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        super.add((Component)this._tagsButtonPanel, (Object)gridBagConstraints);
        ResourceUtils.resLabel((JLabel)this._dateFormatLbl, (Component)this._dateFormatCombo, (String)ToDoArb.getString(9));
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        super.add((Component)this._dateFormatLbl, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        super.add((Component)this._dateFormatCombo, (Object)gridBagConstraints);
        this.setHelpID("f1_idedsettasks_html");
    }

    private void _loadData() {
        int n;
        this._tagTableModel.setList(this._options.getTagList());
        this._priorityTableModel.setList(this._options.getPriorityList());
        String string = this._options.getDateFormatString();
        if (string == null) {
            string = ToDoArb.getString(64);
        }
        if ((n = this._formatModel.getIndexOf((Object)string)) == -1) {
            this._formatModel.addElement((Object)string);
        }
        this._dateFormatCombo.setSelectedItem(string);
    }

    private void _saveData() throws TraversalException {
        try {
            this._options.setDateFormatString((String)this._dateFormatCombo.getSelectedItem());
        }
        catch (Exception exception) {
            throw new TraversalException(ToDoArb.getString(72));
        }
    }

    private void _ensureDateFormatListContains(int n) {
        String string;
        DateFormat dateFormat = DateFormat.getDateInstance(n);
        if (dateFormat instanceof SimpleDateFormat && !this._dateFormatList.contains(string = ((SimpleDateFormat)dateFormat).toPattern())) {
            this._dateFormatList.add(string);
        }
    }

    private void _updatePriorityModelForComboBox() {
        Object[] objectArray = this._options.getPriorityDataModel();
        this._priorityColumn.setCellRenderer((TableCellRenderer)((Object)new PriorityCellRenderer((ToDoPriority[])objectArray)));
        DefaultListComboBoxModel defaultListComboBoxModel = new DefaultListComboBoxModel(objectArray);
        JComboBox jComboBox = new JComboBox(defaultListComboBoxModel);
        this._priorityColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        int n = this._tagTableModel.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            ToDoTag toDoTag = this._tagTableModel.getRow(n2);
            ToDoPriority toDoPriority = ToDoOptionsPanel.getPriorityForId((ToDoPriority[])objectArray, toDoTag.getPriorityId());
            if (toDoPriority == null) {
                toDoPriority = ToDoOptionsPanel.getPriorityForId((ToDoPriority[])objectArray, 0);
            }
            toDoTag.setPriorityObject(toDoPriority);
            ++n2;
        }
        this._tagTable.repaint();
    }

    private static ToDoPriority getPriorityForId(ToDoPriority[] toDoPriorityArray, int n) {
        int n2 = toDoPriorityArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (toDoPriorityArray[n3].getId() == n) {
                return toDoPriorityArray[n3];
            }
            ++n3;
        }
        return null;
    }

    private void _createPrioritySection() {
        this._priorityTable.setColumnSelectorAvailable(false);
        this._priorityTable.setSelectionMode(0);
        this._editPriorityButton.setEnabled(false);
        this._removePriorityButton.setEnabled(false);
        ListSelectionModel listSelectionModel = this._priorityTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new 8());
        ResourceUtils.resLabel((JLabel)this._priorityTableLbl, (Component)this._priorityTable, (String)ToDoArb.getString(5));
        ButtonsLayoutManager buttonsLayoutManager = new ButtonsLayoutManager();
        buttonsLayoutManager.setGap(5);
        this._priorityButtonPanel = new JPanel((LayoutManager)buttonsLayoutManager);
        ResourceUtils.resButton((AbstractButton)this._addPriorityButton, (String)ToDoArb.getString(11));
        this._priorityButtonPanel.add((Component)this._addPriorityButton, new Integer(2));
        this._addPriorityButton.addActionListener(new 7());
        ResourceUtils.resButton((AbstractButton)this._editPriorityButton, (String)ToDoArb.getString(12));
        this._priorityButtonPanel.add((Component)this._editPriorityButton, new Integer(1));
        this._editPriorityButton.addActionListener(new 6());
        ResourceUtils.resButton((AbstractButton)this._removePriorityButton, (String)ToDoArb.getString(10));
        this._priorityButtonPanel.add((Component)this._removePriorityButton, new Integer(0));
        this._removePriorityButton.addActionListener(new 5());
        TableColumn tableColumn = this._priorityTable.getColumnModel().getColumn(0);
        tableColumn.setCellEditor(this._uniqueTextEditor);
        TableColumn tableColumn2 = this._priorityTable.getColumnModel().getColumn(1);
        tableColumn2.setCellEditor(new IntegerEditor());
    }

    private void _createTagsSection() {
        this._tagTable.setColumnSelectorAvailable(false);
        this._tagTable.setSelectionMode(0);
        this._priorityColumn = this._tagTable.getColumnModel().getColumn(1);
        Object[] objectArray = ToDoAddin.getPriorities();
        DefaultListComboBoxModel defaultListComboBoxModel = new DefaultListComboBoxModel(objectArray);
        JComboBox jComboBox = new JComboBox(defaultListComboBoxModel);
        this._priorityColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        this._priorityColumn.setCellRenderer((TableCellRenderer)((Object)new PriorityCellRenderer((ToDoPriority[])objectArray)));
        TableColumn tableColumn = this._tagTable.getColumnModel().getColumn(0);
        tableColumn.setCellEditor(this._uniqueTextEditor);
        this._editTagButton.setEnabled(false);
        this._removeTagButton.setEnabled(false);
        ListSelectionModel listSelectionModel = this._tagTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new 4());
        ButtonsLayoutManager buttonsLayoutManager = new ButtonsLayoutManager();
        buttonsLayoutManager.setGap(5);
        this._tagsButtonPanel = new JPanel((LayoutManager)buttonsLayoutManager);
        ResourceUtils.resLabel((JLabel)this._tagTableLbl, (Component)this._tagTable, (String)ToDoArb.getString(2));
        ResourceUtils.resButton((AbstractButton)this._addTagButton, (String)ToDoArb.getString(14));
        this._tagsButtonPanel.add((Component)this._addTagButton, new Integer(2));
        this._addTagButton.addActionListener(new 3());
        ResourceUtils.resButton((AbstractButton)this._editTagButton, (String)ToDoArb.getString(15));
        this._tagsButtonPanel.add((Component)this._editTagButton, new Integer(1));
        this._editTagButton.addActionListener(new 2());
        ResourceUtils.resButton((AbstractButton)this._removeTagButton, (String)ToDoArb.getString(13));
        this._tagsButtonPanel.add((Component)this._removeTagButton, new Integer(0));
        this._removeTagButton.addActionListener(new 1());
    }

    private void _addTagButton_actionPerformed(ActionEvent actionEvent) {
        ToDoTag toDoTag;
        if (this._tagPanel == null) {
            this._tagPanel = new TagPanel();
        }
        if ((toDoTag = this._tagPanel.runDialog(null, this._options.getTagList(), this._options.getPriorityList())) != null) {
            ToDoPriority[] toDoPriorityArray = this._options.getPriorityDataModel();
            toDoTag.setPriorityObject(ToDoOptionsPanel.getPriorityForId(toDoPriorityArray, toDoTag.getPriorityId()));
            this._tagTableModel.addRow(toDoTag);
        }
    }

    private void _editTagButton_actionPerformed(ActionEvent actionEvent) {
        ToDoTag toDoTag;
        ToDoTag toDoTag2;
        int n;
        if (this._tagPanel == null) {
            this._tagPanel = new TagPanel();
        }
        if ((n = this._tagTable.getSelectedRow()) != -1 && (toDoTag2 = this._tagPanel.runDialog(toDoTag = this._tagTableModel.getRow(n), this._options.getTagList(), this._options.getPriorityList())) != null) {
            ToDoPriority[] toDoPriorityArray = this._options.getPriorityDataModel();
            toDoTag2.setPriorityObject(ToDoOptionsPanel.getPriorityForId(toDoPriorityArray, toDoTag2.getPriorityId()));
            this._tagTableModel.replaceRow(n, toDoTag2);
        }
    }

    private void _removeTagButton_actionPerformed(ActionEvent actionEvent) {
        int n = this._tagTable.getSelectedRow();
        if (n != -1) {
            this._tagTableModel.removeRow(n);
        }
    }

    private void _addPriorityButton_actionPerformed(ActionEvent actionEvent) {
        ToDoPriority toDoPriority;
        if (this._priorityPanel == null) {
            this._priorityPanel = new ToDoPriorityPanel();
        }
        if ((toDoPriority = this._priorityPanel.runDialog(null, this._options.getPriorityList())) != null && toDoPriority != null) {
            this._priorityTableModel.addRow(toDoPriority);
        }
    }

    private void _editPriorityButton_actionPerformed(ActionEvent actionEvent) {
        ToDoPriority toDoPriority;
        ToDoPriority toDoPriority2;
        int n;
        if (this._priorityPanel == null) {
            this._priorityPanel = new ToDoPriorityPanel();
        }
        if ((n = this._priorityTable.getSelectedRow()) != -1 && (toDoPriority2 = this._priorityPanel.runDialog(toDoPriority = this._priorityTableModel.getRow(n), this._options.getPriorityList())) != null) {
            this._priorityTableModel.replaceRow(n, toDoPriority2);
        }
    }

    private void _removePriorityButton_actionPerformed(ActionEvent actionEvent) {
        int n = this._priorityTable.getSelectedRow();
        if (n != -1 && this._priorityTableModel.isRowRemovable(n)) {
            ToDoManagerImpl toDoManagerImpl = (ToDoManagerImpl)ToDoManager.getToDoManager();
            ToDoTableModel toDoTableModel = toDoManagerImpl.getBaseModel();
            int n2 = toDoTableModel.getRowCount();
            ToDoPriority toDoPriority = this._priorityTableModel.getRow(n);
            int n3 = toDoPriority.getId();
            ToDoItem toDoItem = null;
            int n4 = 0;
            while (n4 < n2) {
                toDoItem = toDoTableModel.getToDoItemForRow(n4);
                if (toDoItem.getPriorityId() == n3) {
                    toDoItem.setPriorityId(0);
                }
                ++n4;
            }
            n2 = this._tagTableModel.getRowCount();
            ToDoTag toDoTag = null;
            int n5 = 0;
            while (n5 < n2) {
                toDoTag = this._tagTableModel.getRow(n5);
                if (toDoTag.getPriorityId() == n3) {
                    toDoTag.setPriorityId(0);
                }
                ++n5;
            }
            this._priorityTableModel.removeRow(n);
        }
    }

    static JButton ra$_editPriorityButton(ToDoOptionsPanel toDoOptionsPanel) {
        return toDoOptionsPanel._editPriorityButton;
    }

    static NiceTable ra$_priorityTable(ToDoOptionsPanel toDoOptionsPanel) {
        return toDoOptionsPanel._priorityTable;
    }

    static JButton ra$_removePriorityButton(ToDoOptionsPanel toDoOptionsPanel) {
        return toDoOptionsPanel._removePriorityButton;
    }

    static void mav$_addPriorityButton_actionPerformed(ToDoOptionsPanel toDoOptionsPanel, ActionEvent actionEvent) {
        toDoOptionsPanel._addPriorityButton_actionPerformed(actionEvent);
    }

    static void mav$_editPriorityButton_actionPerformed(ToDoOptionsPanel toDoOptionsPanel, ActionEvent actionEvent) {
        toDoOptionsPanel._editPriorityButton_actionPerformed(actionEvent);
    }

    static void mav$_removePriorityButton_actionPerformed(ToDoOptionsPanel toDoOptionsPanel, ActionEvent actionEvent) {
        toDoOptionsPanel._removePriorityButton_actionPerformed(actionEvent);
    }

    static JButton ra$_editTagButton(ToDoOptionsPanel toDoOptionsPanel) {
        return toDoOptionsPanel._editTagButton;
    }

    static JButton ra$_removeTagButton(ToDoOptionsPanel toDoOptionsPanel) {
        return toDoOptionsPanel._removeTagButton;
    }

    static void mav$_addTagButton_actionPerformed(ToDoOptionsPanel toDoOptionsPanel, ActionEvent actionEvent) {
        toDoOptionsPanel._addTagButton_actionPerformed(actionEvent);
    }

    static void mav$_editTagButton_actionPerformed(ToDoOptionsPanel toDoOptionsPanel, ActionEvent actionEvent) {
        toDoOptionsPanel._editTagButton_actionPerformed(actionEvent);
    }

    static void mav$_removeTagButton_actionPerformed(ToDoOptionsPanel toDoOptionsPanel, ActionEvent actionEvent) {
        toDoOptionsPanel._removeTagButton_actionPerformed(actionEvent);
    }

    static ToDoPriority.ToDoPriorityTableModel ra$_priorityTableModel(ToDoOptionsPanel toDoOptionsPanel) {
        return toDoOptionsPanel._priorityTableModel;
    }

    static ToDoOptions ra$_options(ToDoOptionsPanel toDoOptionsPanel) {
        return toDoOptionsPanel._options;
    }

    static NiceTable ra$_tagTable(ToDoOptionsPanel toDoOptionsPanel) {
        return toDoOptionsPanel._tagTable;
    }

    final class 8
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                boolean bl = defaultListSelectionModel.isSelectionEmpty() ^ true;
                ToDoOptionsPanel.ra$_editPriorityButton(ToDoOptionsPanel.this).setEnabled(bl);
                boolean bl2 = false;
                if (!defaultListSelectionModel.isSelectionEmpty()) {
                    ToDoPriority.ToDoPriorityTableModel toDoPriorityTableModel = (ToDoPriority.ToDoPriorityTableModel)ToDoOptionsPanel.ra$_priorityTable(ToDoOptionsPanel.this).getBaseModel();
                    int n = defaultListSelectionModel.getMinSelectionIndex();
                    while (n < defaultListSelectionModel.getMaxSelectionIndex() + 1) {
                        if (toDoPriorityTableModel.isRowRemovable(ToDoOptionsPanel.ra$_priorityTable(ToDoOptionsPanel.this).convertRowToModelIndex(n))) {
                            bl2 = true;
                            break;
                        }
                        ++n;
                    }
                }
                ToDoOptionsPanel.ra$_removePriorityButton(ToDoOptionsPanel.this).setEnabled(bl2);
            }
        }
    }

    final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ToDoOptionsPanel.mav$_addPriorityButton_actionPerformed(ToDoOptionsPanel.this, actionEvent);
        }
    }

    final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ToDoOptionsPanel.mav$_editPriorityButton_actionPerformed(ToDoOptionsPanel.this, actionEvent);
        }
    }

    final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ToDoOptionsPanel.mav$_removePriorityButton_actionPerformed(ToDoOptionsPanel.this, actionEvent);
        }
    }

    final class 4
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                boolean bl = defaultListSelectionModel.isSelectionEmpty() ^ true;
                ToDoOptionsPanel.ra$_editTagButton(ToDoOptionsPanel.this).setEnabled(bl);
                ToDoOptionsPanel.ra$_removeTagButton(ToDoOptionsPanel.this).setEnabled(bl);
            }
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ToDoOptionsPanel.mav$_addTagButton_actionPerformed(ToDoOptionsPanel.this, actionEvent);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ToDoOptionsPanel.mav$_editTagButton_actionPerformed(ToDoOptionsPanel.this, actionEvent);
        }
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ToDoOptionsPanel.mav$_removeTagButton_actionPerformed(ToDoOptionsPanel.this, actionEvent);
        }
    }

    private static class ToDoTagTableModel
    extends AbstractTableModel {
        private List _dataList;

        void $init$() {
            this._dataList = new ArrayList();
        }

        public ToDoTagTableModel() {
            this.$init$();
        }

        public void setList(List list) {
            this._dataList = list;
        }

        public int getRowCount() {
            return this._dataList.size();
        }

        public int getColumnCount() {
            return ToDoTag.NUM_COLUMNS;
        }

        public Object getValueAt(int n, int n2) {
            ToDoTag toDoTag = (ToDoTag)((Object)this._dataList.get(n));
            switch (n2) {
                case 0: {
                    return toDoTag.getTag();
                }
                case 1: {
                    return toDoTag.getPriorityObject();
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            ToDoTag toDoTag = (ToDoTag)((Object)this._dataList.get(n));
            switch (n2) {
                case 0: {
                    toDoTag.setTag((String)object);
                    break;
                }
                case 1: {
                    toDoTag.setPriorityId(((ToDoPriority)object).getId());
                    toDoTag.setPriorityObject((ToDoPriority)object);
                    break;
                }
                default: {
                    return;
                }
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public void addRow(ToDoTag toDoTag) {
            this._dataList.add(toDoTag);
            int n = this._dataList.size();
            this.fireTableRowsInserted(n, n);
        }

        public ToDoTag getRow(int n) {
            return (ToDoTag)((Object)this._dataList.get(n));
        }

        public void replaceRow(int n, ToDoTag toDoTag) {
            this._dataList.set(n, toDoTag);
            this.fireTableRowsUpdated(n, n);
        }

        public void removeRow(int n) {
            this._dataList.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return ToDoArb.getString(79);
                }
                case 1: {
                    return ToDoArb.getString(74);
                }
            }
            return null;
        }
    }

    public class IntegerEditor
    extends DefaultCellEditor {
        private WholeNumberField _numberField;
        private int _currentValue;

        public IntegerEditor() {
            super((JTextField)new WholeNumberField(10));
            this._numberField = (WholeNumberField)super.getComponent();
            this._numberField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
            this._numberField.getActionMap().put("check", new 1());
        }

        public boolean isEditValid() {
            int n = ToDoOptionsPanel.ra$_priorityTable(ToDoOptionsPanel.this).getEditingRow();
            ToDoPriority toDoPriority = ToDoOptionsPanel.ra$_priorityTableModel(ToDoOptionsPanel.this).getRow(n);
            int n2 = (Integer)this.getCellEditorValue();
            return ToDoManagerImpl.isRankingUnique(n2, ToDoOptionsPanel.ra$_options(ToDoOptionsPanel.this).getPriorityList(), toDoPriority);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            WholeNumberField wholeNumberField = (WholeNumberField)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            wholeNumberField.setValue(((Integer)object).intValue());
            this._currentValue = wholeNumberField.getValue();
            return wholeNumberField;
        }

        public Object getCellEditorValue() {
            int n = this._numberField.getValue();
            return new Integer(n);
        }

        public boolean stopCellEditing() {
            if (!this.isEditValid() && !this.userSaysRevert()) {
                return false;
            }
            return super.stopCellEditing();
        }

        protected boolean userSaysRevert() {
            this._numberField.selectAll();
            Object[] objectArray = new Object[]{ToDoArb.getString(118), ToDoArb.getString(119)};
            int n = JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor((Component)this._numberField), ToDoArb.getString(33), ToDoArb.getString(83), 0, 0, null, objectArray, objectArray[1]);
            if (n == 1) {
                this._numberField.setValue(this._currentValue);
                return true;
            }
            return false;
        }

        static WholeNumberField ra$_numberField(IntegerEditor integerEditor) {
            return integerEditor._numberField;
        }

        final class 1
        extends AbstractAction {
            public void actionPerformed(ActionEvent actionEvent) {
                if (!IntegerEditor.this.isEditValid() && IntegerEditor.this.userSaysRevert()) {
                    IntegerEditor.ra$_numberField(IntegerEditor.this).postActionEvent();
                }
            }
        }
    }

    private class UniqueTextEditor
    extends DefaultCellEditor {
        private JFormattedTextField _textField;
        private JTable _table;
        private String _currentValue;
        private String _errorString;

        public UniqueTextEditor() {
            super(new JFormattedTextField());
            this._textField = (JFormattedTextField)super.getComponent();
            this._textField.setFocusLostBehavior(3);
            this._textField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
            this._textField.getActionMap().put("check", new 1());
        }

        public boolean isEditValid() {
            boolean bl = false;
            if (!ModelUtil.hasLength((String)((String)this.getCellEditorValue()))) {
                this._errorString = ToDoArb.getString(30);
            } else {
                int n = this._table.getEditingRow();
                TableModel tableModel = this._table.getModel();
                if (tableModel instanceof ToDoTagTableModel) {
                    ToDoTagTableModel toDoTagTableModel = (ToDoTagTableModel)tableModel;
                    ToDoTag toDoTag = toDoTagTableModel.getRow(n);
                    bl = ToDoTag.isTagUnique((String)this.getCellEditorValue(), ToDoOptionsPanel.ra$_options(ToDoOptionsPanel.this).getTagList(), toDoTag);
                    if (!bl) {
                        this._errorString = ToDoArb.getString(23);
                    }
                } else if (tableModel instanceof ToDoPriority.ToDoPriorityTableModel) {
                    ToDoPriority.ToDoPriorityTableModel toDoPriorityTableModel = (ToDoPriority.ToDoPriorityTableModel)tableModel;
                    ToDoPriority toDoPriority = toDoPriorityTableModel.getRow(n);
                    bl = ToDoManagerImpl.isPriorityTextUnique((String)this.getCellEditorValue(), ToDoOptionsPanel.ra$_options(ToDoOptionsPanel.this).getPriorityList(), toDoPriority);
                    if (!bl) {
                        this._errorString = ToDoArb.getString(32);
                    }
                }
            }
            return bl;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            TableCellEditor tableCellEditor = null;
            tableCellEditor = jTable == ToDoOptionsPanel.ra$_tagTable(ToDoOptionsPanel.this) ? ToDoOptionsPanel.ra$_priorityTable(ToDoOptionsPanel.this).getCellEditor() : ToDoOptionsPanel.ra$_tagTable(ToDoOptionsPanel.this).getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            this._table = jTable;
            JFormattedTextField jFormattedTextField = (JFormattedTextField)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            jFormattedTextField.setValue((String)object);
            this._currentValue = (String)object;
            return jFormattedTextField;
        }

        public boolean stopCellEditing() {
            JFormattedTextField jFormattedTextField = (JFormattedTextField)this.getComponent();
            if (this.isEditValid()) {
                try {
                    jFormattedTextField.commitEdit();
                }
                catch (ParseException parseException) {}
            } else if (!this.userSaysRevert()) {
                return false;
            }
            return super.stopCellEditing();
        }

        protected boolean userSaysRevert() {
            this._textField.selectAll();
            Object[] objectArray = new Object[]{ToDoArb.getString(118), ToDoArb.getString(119)};
            int n = JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor(this._textField), this._errorString, ToDoArb.getString(83), 0, 0, null, objectArray, objectArray[1]);
            if (n == 1) {
                this._textField.setValue(this._currentValue);
                return true;
            }
            return false;
        }

        static JFormattedTextField ra$_textField(UniqueTextEditor uniqueTextEditor) {
            return uniqueTextEditor._textField;
        }

        final class 1
        extends AbstractAction {
            public void actionPerformed(ActionEvent actionEvent) {
                if (!UniqueTextEditor.this.isEditValid()) {
                    if (UniqueTextEditor.this.userSaysRevert()) {
                        UniqueTextEditor.ra$_textField(UniqueTextEditor.this).postActionEvent();
                    }
                } else {
                    try {
                        UniqueTextEditor.ra$_textField(UniqueTextEditor.this).commitEdit();
                        UniqueTextEditor.ra$_textField(UniqueTextEditor.this).postActionEvent();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

