/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.todo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.todo.ToDoItem;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.resource.ToDoArb;
import oracle.jdevimpl.todo.JDevToDoItem;
import oracle.jdevimpl.todo.ToDoAddin;
import oracle.jdevimpl.todo.ToDoPriority;

class ToDoPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
ItemListener,
VetoableChangeListener {
    private JTextField _toDoFld;
    private JComboBox _priorityBox;
    private JCheckBox _doneBox;
    private DateEditor _dateEditor;
    private JButton _dateClearBtn;
    private URL _url;
    private int _line;
    private int _column;
    private JEWTDialog _dlg;
    private ToDoItem[] _multiEditToDoItems;
    private JComboBox _toDoComboBox;
    private boolean _toDoDescriptionChanged;
    private boolean _toDoPriorityChanged;
    private boolean _toDoDoneChanged;
    private boolean _toDoDateChanged;

    void $init$() {
        this._toDoFld = new JTextField();
        this._priorityBox = new JComboBox();
        this._doneBox = new JCheckBox();
        this._dateEditor = new DateEditor();
        this._dateClearBtn = new JButton();
        this._toDoComboBox = new JComboBox();
    }

    public ToDoPanel() {
        this(false);
    }

    public ToDoPanel(boolean bl) {
        this.$init$();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._toDoFld, (String)ToDoArb.getString(38));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._priorityBox, (String)ToDoArb.getString(19));
        ResourceUtils.resButton((AbstractButton)this._doneBox, (String)ToDoArb.getString(39));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._dateEditor, (String)ToDoArb.getString(40));
        ResourceUtils.resButton((AbstractButton)this._dateClearBtn, (String)ToDoArb.getString(44));
        this._dateEditor.setDateFormat((DateFormat)ToDoAddin.getSimpleDateFormat());
        this._dateEditor.setDate(null);
        this._dateClearBtn.addActionListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        if (bl) {
            this._toDoComboBox = new JComboBox();
            this.add((Component)this._toDoComboBox, gridBagConstraints);
            this.setHelpID("f1_idetaskmultiedit_html");
        } else {
            this.add((Component)this._toDoFld, gridBagConstraints);
            this.setHelpID("f1_idededittask_html");
        }
        ++gridBagConstraints.gridy;
        this.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._priorityBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._doneBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)jLabel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this._dateEditor, "Center");
        jPanel.add((Component)this._dateClearBtn, "East");
        this.add((Component)jPanel, gridBagConstraints);
    }

    public ToDoItem[] runMultiEditDialog(ToDoItem[] toDoItemArray) {
        this._multiEditToDoItems = toDoItemArray;
        this._loadData(toDoItemArray);
        String string = ToDoArb.getString(43);
        this._dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this._toDoFld, (String)string);
        this._dlg.setDefaultButton(1);
        if (WizardLauncher.runDialog((JDialog)this._dlg)) {
            this._updateMultiEditData();
            return toDoItemArray;
        }
        return null;
    }

    public ToDoItem runDialog(ToDoItem toDoItem, boolean bl) {
        this._loadData(toDoItem);
        String string = null;
        if (bl) {
            string = ToDoArb.getString(41);
            this.setHelpID("f1_idedaddtask_html");
        } else {
            string = ToDoArb.getString(42);
            this.setHelpID("f1_idededittask_html");
        }
        this._dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this._toDoFld, (String)string);
        this._dlg.setDefaultButton(1);
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        if (WizardLauncher.runDialog((JDialog)this._dlg)) {
            ToDoPriority toDoPriority = (ToDoPriority)this._priorityBox.getSelectedItem();
            return new JDevToDoItem(null, this._toDoFld.getText(), toDoPriority.getId(), this._line, this._column, this._url, this._doneBox.isSelected(), this._dateEditor.getDate());
        }
        return null;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent) && !this._validateToDoItem()) {
            throw new PropertyVetoException("no", propertyChangeEvent);
        }
    }

    private void _loadData(ToDoItem toDoItem) {
        this._loadPriorities();
        if (toDoItem != null) {
            this._toDoFld.setText(toDoItem.getText());
            this._priorityBox.setSelectedItem(ToDoAddin.getPriorityObjForId(toDoItem.getPriorityId()));
            this._doneBox.setSelected(toDoItem.isDone());
            this._dateEditor.setDate(toDoItem.getDate());
            this._url = toDoItem.getURL();
            this._line = toDoItem.getLine();
            this._column = toDoItem.getColumn();
        } else {
            this._toDoFld.setText("");
            this._priorityBox.setSelectedIndex(0);
            this._doneBox.setSelected(false);
            this._dateEditor.setDate(null);
            this._url = null;
            this._line = 0;
            this._column = 0;
        }
    }

    private void _loadPriorities() {
        ToDoPriority[] toDoPriorityArray = ToDoAddin.getPriorities();
        DefaultComboBoxModel<ToDoPriority> defaultComboBoxModel = new DefaultComboBoxModel<ToDoPriority>(toDoPriorityArray);
        this._priorityBox.setModel(defaultComboBoxModel);
    }

    private boolean _validateToDoItem() {
        if (!ModelUtil.hasLength((String)this._toDoFld.getText())) {
            this._showErrorMessage(ToDoArb.getString(82), ToDoArb.getString(83));
            return false;
        }
        return true;
    }

    private void setHelpID(String string) {
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            helpSystem.registerTopic((JComponent)this, string);
        }
    }

    private void _loadData(ToDoItem[] toDoItemArray) {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        ArrayList<ToDoPriority> arrayList = new ArrayList<ToDoPriority>();
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        ArrayList<Date> arrayList3 = new ArrayList<Date>();
        ToDoPriority toDoPriority = null;
        int n = 0;
        while (n < toDoItemArray.length) {
            if (defaultComboBoxModel.getIndexOf(toDoItemArray[n].getText()) == -1) {
                defaultComboBoxModel.addElement(toDoItemArray[n].getText());
            }
            if (arrayList.size() < 2 && !arrayList.contains(toDoPriority = ToDoAddin.getPriorityObjForId(toDoItemArray[n].getPriorityId()))) {
                arrayList.add(toDoPriority);
            }
            if (arrayList2.size() < 2 && !arrayList2.contains(new Boolean(toDoItemArray[n].isDone()))) {
                arrayList2.add(new Boolean(toDoItemArray[n].isDone()));
            }
            if (arrayList3.size() < 2 && !arrayList3.contains(toDoItemArray[n].getDate())) {
                arrayList3.add(toDoItemArray[n].getDate());
            }
            ++n;
        }
        this._toDoComboBox.setModel(defaultComboBoxModel);
        this._toDoComboBox.setSelectedIndex(0);
        this._toDoComboBox.setEditable(true);
        if (defaultComboBoxModel.getSize() > 1) {
            this._toDoComboBox.setFont(this._toDoComboBox.getFont().deriveFont(2));
        }
        this._toDoComboBox.addItemListener(this);
        this._loadPriorities();
        this._priorityBox.setSelectedItem(ToDoAddin.getPriorityObjForId(toDoItemArray[0].getPriorityId()));
        if (arrayList.size() > 1) {
            this._priorityBox.setFont(this._priorityBox.getFont().deriveFont(2));
        }
        this._priorityBox.addItemListener(this);
        this._doneBox.setSelected(toDoItemArray[0].isDone());
        if (arrayList2.size() > 1) {
            this._doneBox.setFont(this._doneBox.getFont().deriveFont(2));
        }
        this._doneBox.addItemListener(this);
        this._dateEditor.setDate(toDoItemArray[0].getDate());
        if (arrayList3.size() > 1) {
            this._dateEditor.setFont(this._dateEditor.getFont().deriveFont(2));
        }
        this._dateEditor.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1 || itemEvent.getStateChange() == 2) {
            if (itemEvent.getSource() == this._toDoComboBox) {
                this._toDoDescriptionChanged = true;
            } else if (itemEvent.getSource() == this._priorityBox) {
                this._toDoPriorityChanged = true;
            } else if (itemEvent.getSource() == this._doneBox) {
                this._toDoDoneChanged = true;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this._dateEditor && propertyChangeEvent.getPropertyName().equals("date")) {
            this._toDoDateChanged = true;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this._dateEditor.setDate(null);
    }

    private void _updateMultiEditData() {
        if (this._toDoDescriptionChanged || this._toDoPriorityChanged || this._toDoDoneChanged || this._toDoDateChanged) {
            int n = 0;
            while (n < this._multiEditToDoItems.length) {
                if (this._toDoDescriptionChanged) {
                    this._multiEditToDoItems[n].setText((String)this._toDoComboBox.getSelectedItem());
                }
                if (this._toDoPriorityChanged) {
                    this._multiEditToDoItems[n].setPriorityId(((ToDoPriority)this._priorityBox.getSelectedItem()).getId());
                }
                if (this._toDoDoneChanged) {
                    this._multiEditToDoItems[n].setDone(this._doneBox.isSelected());
                }
                if (this._toDoDateChanged) {
                    this._multiEditToDoItems[n].setDate(this._dateEditor.getDate());
                }
                ++n;
            }
        }
    }

    private void _showErrorMessage(String string, String string2) {
        JOptionPane.showMessageDialog(this, string, string2, 0);
    }
}

