/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.todo;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.resource.ToDoArb;
import oracle.jdevimpl.todo.ToDoAddin;
import oracle.jdevimpl.todo.ToDoManagerImpl;
import oracle.jdevimpl.todo.ToDoPriority;

class ToDoPriorityPanel
extends JPanel
implements VetoableChangeListener {
    private JLabel _textLbl;
    private JTextField _textFld;
    private JLabel _rankingLbl;
    private WholeNumberField _rankingFld;
    private JLabel _iconURLLbl;
    private MyURLTextField _iconURLFld;
    private JButton _browseBtn;
    private JLabel _iconDisplay;
    private JEWTDialog _dlg;
    private List _priorityList;
    private ToDoPriority _toDoPriority;
    private int _id;

    void $init$() {
        this._textLbl = new JLabel();
        this._textFld = new JTextField();
        this._rankingLbl = new JLabel();
        this._rankingFld = new WholeNumberField(10);
        this._iconURLLbl = new JLabel();
        this._iconURLFld = new MyURLTextField(null, false);
        this._browseBtn = new JButton();
        this._iconDisplay = new JLabel();
    }

    public ToDoPriorityPanel() {
        this.$init$();
        this.setLayout(new GridBagLayout());
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            helpSystem.registerTopic((JComponent)this, "f1_idedaddedittaskpriority_html");
        }
        ResourceUtils.resLabel((JLabel)this._textLbl, (Component)this._textFld, (String)ToDoArb.getString(24));
        ResourceUtils.resLabel((JLabel)this._rankingLbl, (Component)this._rankingFld, (String)ToDoArb.getString(25));
        ResourceUtils.resLabel((JLabel)this._iconURLLbl, (Component)((Object)this._iconURLFld), (String)ToDoArb.getString(26));
        ResourceUtils.resButton((AbstractButton)this._browseBtn, (String)ToDoArb.getString(27));
        this._browseBtn.addActionListener((ActionListener)((Object)this._iconURLFld));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0);
        gridBagConstraints.gridwidth = 4;
        this.add((Component)this._textLbl, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._textFld, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._rankingLbl, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._rankingFld, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._iconURLLbl, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)((Object)this._iconURLFld), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this._browseBtn, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this._iconDisplay, gridBagConstraints);
    }

    public ToDoPriority runDialog(ToDoPriority toDoPriority, List list) {
        this._priorityList = list;
        this._loadData(toDoPriority);
        String string = null;
        string = toDoPriority == null ? ToDoArb.getString(29) : ToDoArb.getString(28);
        this._dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this._textFld, (String)string);
        this._dlg.setDefaultButton(1);
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        if (WizardLauncher.runDialog((JDialog)this._dlg)) {
            ToDoPriority toDoPriority2 = new ToDoPriority(this._textFld.getText(), Integer.parseInt(this._rankingFld.getText()), this._iconURLFld.getText(), this._id == -1 ? ToDoAddin.getUniquePriorityId() : this._id);
            if (this._iconDisplay.getIcon() != null) {
                toDoPriority2.setIcon(this._iconDisplay.getIcon());
            }
            return toDoPriority2;
        }
        return null;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent) && !this._validateData()) {
            throw new PropertyVetoException("no", propertyChangeEvent);
        }
    }

    private void _loadData(ToDoPriority toDoPriority) {
        if (toDoPriority != null) {
            this._toDoPriority = toDoPriority;
            this._textFld.setText(toDoPriority.getText());
            this._rankingFld.setText(Integer.toString(toDoPriority.getRanking()));
            this._id = toDoPriority.getId();
            this._iconURLFld.setURL(toDoPriority.getIconURL());
            Icon icon = toDoPriority.getIcon();
            if (icon != null) {
                this._iconDisplay.setIcon(icon);
                this._iconDisplay.setToolTipText(this._iconURLFld.getText());
            } else {
                this._iconDisplay.setIcon(null);
                this._iconDisplay.setToolTipText(null);
            }
        } else {
            this._toDoPriority = null;
            this._textFld.setText("");
            this._rankingFld.setText("");
            this._iconURLFld.setURL(null);
            this._iconDisplay.setIcon(null);
            this._iconDisplay.setToolTipText(null);
            this._id = -1;
        }
    }

    private boolean _validateData() {
        String string = this._textFld.getText();
        if (!ModelUtil.hasLength((String)string)) {
            this._showErrorMessage(ToDoArb.getString(30), ToDoArb.getString(83));
            return false;
        }
        string = this._rankingFld.getText();
        if (!ModelUtil.hasLength((String)string)) {
            this._showErrorMessage(ToDoArb.getString(31), ToDoArb.getString(83));
            return false;
        }
        if (!ToDoManagerImpl.isPriorityTextUnique(this._textFld.getText(), this._priorityList, this._toDoPriority)) {
            this._showErrorMessage(ToDoArb.getString(32), ToDoArb.getString(83));
            return false;
        }
        int n = this._rankingFld.getValue();
        if (!ToDoManagerImpl.isRankingUnique(n, this._priorityList, this._toDoPriority)) {
            this._showErrorMessage(ToDoArb.getString(33), ToDoArb.getString(83));
            return false;
        }
        string = this._iconURLFld.getText();
        if (ModelUtil.hasLength((String)string) && !ToDoManagerImpl.isIconURLStringUnique(string, this._priorityList, this._toDoPriority)) {
            this._showWarningMessage(ToDoArb.getString(34), ToDoArb.getString(84));
        }
        return this._validateIcon();
    }

    private void _showErrorMessage(String string, String string2) {
        JOptionPane.showMessageDialog(this, string, string2, 0);
    }

    private void _showWarningMessage(String string, String string2) {
        JOptionPane.showMessageDialog(this, string, string2, 2);
    }

    private boolean _validateIcon() {
        if (ModelUtil.hasLength((String)this._iconURLFld.getText())) {
            URL uRL = this._iconURLFld.getURL();
            if (uRL == null) {
                this._showWarningMessage(ToDoArb.getString(126), ToDoArb.getString(122));
                return false;
            }
            ImageIcon imageIcon = new ImageIcon(this._iconURLFld.getURL(), this._textFld.getText());
            int n = imageIcon.getImageLoadStatus();
            if (n == 2 || n == 4) {
                this._showWarningMessage(ToDoArb.getString(123), ToDoArb.getString(122));
                imageIcon = null;
                return false;
            }
            if (imageIcon != null) {
                if (imageIcon.getIconWidth() > 16 || imageIcon.getIconHeight() > 16) {
                    this._showWarningMessage(ToDoArb.getString(121), ToDoArb.getString(120));
                    return false;
                }
                this._iconDisplay.setIcon(imageIcon);
                this._iconDisplay.setToolTipText(this._iconURLFld.getText());
            }
        } else {
            this.clearIcon();
        }
        return true;
    }

    private void clearIcon() {
        this._iconDisplay.setIcon(null);
        this._iconDisplay.setToolTipText(null);
    }

    static void mav$clearIcon(ToDoPriorityPanel toDoPriorityPanel) {
        toDoPriorityPanel.clearIcon();
    }

    static boolean mav$_validateIcon(ToDoPriorityPanel toDoPriorityPanel) {
        return toDoPriorityPanel._validateIcon();
    }

    private class MyURLTextField
    extends URLTextField
    implements DocumentListener {
        public MyURLTextField(URL uRL, boolean bl) {
            super(uRL, bl);
            DefaultURLFilter defaultURLFilter = new DefaultURLFilter(ToDoArb.getString(124), new String[]{".gif", ".jpeg", ".jpg", ".png"});
            super.clearChooseableURLFilters();
            super.setFilter((URLFilter)defaultURLFilter);
            super.setDialogTitle(ToDoArb.getString(125));
            super.getDocument().addDocumentListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ToDoPriorityPanel.mav$_validateIcon(ToDoPriorityPanel.this);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateIcon();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateIcon();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateIcon();
        }

        private void updateIcon() {
            if (!ModelUtil.hasLength((String)super.getText())) {
                ToDoPriorityPanel.mav$clearIcon(ToDoPriorityPanel.this);
            }
        }
    }
}

