/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.todo;

import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import oracle.ide.model.LocatableItem;
import oracle.ide.net.URLFileSystem;
import oracle.ide.todo.ToDoItem;
import oracle.ide.util.ModelUtil;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.jdeveloper.util.gutter.AbstractLineGutterMarkList;
import oracle.jdeveloper.util.gutter.LineGutterMarkList;
import oracle.jdevimpl.resource.ToDoArb;
import oracle.jdevimpl.todo.JDevToDoItem;
import oracle.jdevimpl.todo.ToDoAddin;
import oracle.jdevimpl.todo.ToDoPanel;
import oracle.jdevimpl.todo.ToDoPriority;

class ToDoTableModel
extends AbstractTableModel
implements LineGutterMarkList,
NiceTableModel {
    public static final int DONE_COLUMN = 0;
    public static final int PRIORITY_ICON_COLUMN = 1;
    public static final int TODO_TEXT_COLUMN = 2;
    public static final int PRIORITY_COLUMN = 3;
    public static final int FILE_NAME_COLUMN = 4;
    public static final int FILE_PATH_COLUMN = 5;
    public static final int LINE_COLUMN = 6;
    public static final int COLUMN_COLUMN = 7;
    public static final int DATE_COLUMN = 8;
    public static final int TAG_COLUMN = 9;
    public static final int NUM_COLUMNS = 10;
    private ToDoList _toDoList;
    private List _listenerList;

    void $init$() {
        this._toDoList = new ToDoList();
        this._listenerList = new ArrayList();
    }

    public ToDoTableModel() {
        this.$init$();
    }

    public int getColumnAlignment(int n) {
        if (n == 0) {
            return 0;
        }
        return 2;
    }

    public Comparator getColumnSortComparator(int n) {
        return null;
    }

    public int getColumnCount() {
        return 10;
    }

    public int getRowCount() {
        return this._toDoList.getLineGutterMarkCount();
    }

    public String getColumnName(int n) {
        return ToDoTableModel.getTranslatedColumnName(n);
    }

    public Class getColumnClass(int n) {
        return ToDoTableModel.getClassForColumn(n);
    }

    public Object getValueAt(int n, int n2) {
        ToDoItem toDoItem = this._getToDoItemForRow(n);
        ToDoPriority toDoPriority = ToDoAddin.getPriorityObjForId(toDoItem.getPriorityId());
        switch (n2) {
            case 0: {
                if (toDoItem instanceof JDevToDoItem && ModelUtil.hasLength((String)((JDevToDoItem)toDoItem).getTag())) {
                    return null;
                }
                return toDoItem.isDone();
            }
            case 1: {
                return toDoPriority == null ? null : toDoPriority.getIcon();
            }
            case 2: {
                return toDoItem.getText();
            }
            case 3: {
                return toDoPriority;
            }
            case 4: {
                if (toDoItem.getURL() == null) {
                    return null;
                }
                return URLFileSystem.getFileName((URL)toDoItem.getURL());
            }
            case 5: {
                if (toDoItem.getURL() == null) {
                    return null;
                }
                return URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)toDoItem.getURL()));
            }
            case 6: {
                if (toDoItem.getURL() == null) {
                    return null;
                }
                return new Integer(toDoItem.getLine());
            }
            case 7: {
                if (toDoItem.getURL() == null) {
                    return null;
                }
                return new Integer(toDoItem.getColumn());
            }
            case 8: {
                return toDoItem.getDate();
            }
            case 9: {
                if (toDoItem instanceof JDevToDoItem) {
                    return ((JDevToDoItem)toDoItem).getTag();
                }
                return null;
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        ToDoItem toDoItem = this._getToDoItemForRow(n);
        switch (n2) {
            case 2: {
                toDoItem.setText((String)object);
                break;
            }
            case 0: {
                toDoItem.setDone(((Boolean)object).booleanValue());
                break;
            }
            case 3: {
                toDoItem.setPriorityId(((ToDoPriority)object).getId());
                break;
            }
            case 8: {
                toDoItem.setDate((Date)object);
                break;
            }
            default: {
                return;
            }
        }
        toDoItem.stateChanged();
    }

    ToDoItem getToDoItemForRow(int n) {
        return this._getToDoItemForRow(n);
    }

    public boolean isRowEditable(int n) {
        ToDoItem toDoItem = this._getToDoItemForRow(n);
        return toDoItem.isEditable();
    }

    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                return false;
            }
        }
        ToDoItem toDoItem = this._getToDoItemForRow(n);
        if (toDoItem == null) {
            return false;
        }
        return toDoItem.isEditable();
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this._listenerList.add(tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this._listenerList.remove(tableModelListener);
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        int n = 0;
        while (n < this._listenerList.size()) {
            ((TableModelListener)this._listenerList.get(n)).tableChanged(tableModelEvent);
            ++n;
        }
    }

    public LocatableItem[] getAllLineGutterMarks() {
        return this._toDoList.getAllLineGutterMarks();
    }

    public int getLineGutterMarkCount() {
        return this._toDoList.getLineGutterMarkCount();
    }

    public LocatableItem[] findLineGutterMarks(URL uRL) {
        return this._toDoList.findLineGutterMarks(uRL);
    }

    public LocatableItem[] findLineGutterMark(URL uRL, int n) {
        return this._toDoList.findLineGutterMark(uRL, n);
    }

    public LocatableItem addLineGutterMark(URL uRL, int n) {
        return this._toDoList.addLineGutterMark(uRL, n);
    }

    public LocatableItem addLineGutterMark(LocatableItem locatableItem) {
        return this._toDoList.addLineGutterMark(locatableItem);
    }

    public boolean modifyLineGutterMark(LocatableItem locatableItem, int n) {
        return this._toDoList.modifyLineGutterMark(locatableItem, n);
    }

    public void removeLineGutterMark(LocatableItem locatableItem) {
        this._toDoList.removeLineGutterMark(locatableItem);
    }

    public void removeAllLineGutterMarks() {
        this._toDoList.removeAllLineGutterMarks();
    }

    public boolean allowMultipleMarksPerLine() {
        return this._toDoList.allowMultipleMarksPerLine();
    }

    public LocatableItem createToDoItem(URL uRL, int n) {
        return this._toDoList.createLineGutterMark(uRL, n);
    }

    private ToDoItem _getToDoItemForRow(int n) {
        if (n > this.getRowCount() - 1 || n < 0) {
            return null;
        }
        return (ToDoItem)this._toDoList.getLineGutterMarkList().get(n);
    }

    List getDataList() {
        return this._toDoList.getLineGutterMarkList();
    }

    void addToDoItem(ToDoItem toDoItem) {
        boolean bl = this._toDoList.insertLineGutterMark((LocatableItem)toDoItem);
        if (bl) {
            int n = this._toDoList.getLineGutterMarkList().size();
            super.fireTableRowsInserted(n, n);
        }
    }

    void removeToDoItem(ToDoItem toDoItem) {
        int n = this._toDoList.findToDoItemPosition(toDoItem);
        if (n != -1) {
            this._toDoList.removeToDoItemByPosition(n);
            toDoItem.dispose();
            super.fireTableRowsDeleted(n, n);
        }
    }

    void removeToDoItems(List list) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            this.removeToDoItem((ToDoItem)list.get(n2));
            ++n2;
        }
    }

    void removeToDoItemsForURL(URL uRL) {
        LocatableItem[] locatableItemArray = this.findLineGutterMarks(uRL);
        int n = 0;
        while (n < locatableItemArray.length) {
            this.removeToDoItem((ToDoItem)locatableItemArray[n]);
            ++n;
        }
    }

    void updateToDoItem(ToDoItem toDoItem, ToDoItem toDoItem2) {
        int n = this._toDoList.findToDoItemPosition(toDoItem);
        if (n != -1) {
            toDoItem.setText(toDoItem2.getText());
            toDoItem.setPriorityId(toDoItem2.getPriorityId());
            toDoItem.setDone(toDoItem2.isDone());
            toDoItem.setLine(toDoItem2.getLine());
            toDoItem.setDate(toDoItem2.getDate());
            toDoItem.stateChanged();
            super.fireTableRowsUpdated(n, n);
        }
    }

    void renameURL(URL uRL, URL uRL2) {
        LocatableItem[] locatableItemArray = this._toDoList.findLineGutterMarksForTags(uRL);
        if (locatableItemArray != null) {
            int n = 0;
            while (n < locatableItemArray.length) {
                locatableItemArray[n].setURL(uRL2);
                ++n;
            }
        }
    }

    void addToDoItems(List list, URL uRL, List list2, List list3) {
        int n = list == null ? 0 : list.size();
        LocatableItem[] locatableItemArray = this._toDoList.findLineGutterMarksForTags(uRL);
        if (locatableItemArray == null && list == null) {
            return;
        }
        if (locatableItemArray == null && list != null) {
            this.addToDoItems(list);
            list2.addAll(list);
        } else {
            ArrayList<LocatableItem> arrayList = new ArrayList<LocatableItem>(locatableItemArray.length);
            int n2 = 0;
            while (n2 < locatableItemArray.length) {
                arrayList.add(locatableItemArray[n2]);
                ++n2;
            }
            ArrayList<ToDoItem> arrayList2 = new ArrayList<ToDoItem>();
            ToDoItem toDoItem = null;
            int n3 = 0;
            while (n3 < n) {
                toDoItem = (ToDoItem)list.get(n3);
                if (arrayList.contains(toDoItem)) {
                    arrayList.remove(toDoItem);
                } else {
                    arrayList2.add(toDoItem);
                }
                ++n3;
            }
            if (arrayList.size() > 0) {
                list3.addAll(arrayList);
                this.removeToDoItems(arrayList);
            }
            if (arrayList2.size() > 0) {
                list2.addAll(arrayList2);
                this.addToDoItems(arrayList2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToDoItems(List list) {
        int n = list.size();
        ToDoItem toDoItem = null;
        int n2 = this._toDoList.getLineGutterMarkList().size();
        int n3 = 0;
        ToDoList toDoList = this._toDoList;
        synchronized (toDoList) {
            int n4 = 0;
            while (n4 < n) {
                toDoItem = (ToDoItem)list.get(n4);
                if (this._toDoList.insertLineGutterMark((LocatableItem)toDoItem)) {
                    ++n3;
                }
                ++n4;
            }
            if (n3 > 0) {
                super.fireTableRowsInserted(n2 + 1, n2 + n3);
            }
        }
    }

    static String getTranslatedColumnName(int n) {
        switch (n) {
            case 0: {
                return ToDoArb.getString(91);
            }
            case 1: {
                return ToDoArb.getString(8);
            }
            case 2: {
                return ToDoArb.getString(73);
            }
            case 3: {
                return ToDoArb.getString(74);
            }
            case 4: {
                return ToDoArb.getString(75);
            }
            case 5: {
                return ToDoArb.getString(76);
            }
            case 6: {
                return ToDoArb.getString(77);
            }
            case 7: {
                return ToDoArb.getString(78);
            }
            case 8: {
                return ToDoArb.getString(80);
            }
            case 9: {
                return ToDoArb.getString(79);
            }
        }
        return null;
    }

    static Class getClassForColumn(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Icon.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return ToDoPriority.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return Integer.class;
            }
            case 7: {
                return Integer.class;
            }
            case 8: {
                return Date.class;
            }
            case 9: {
                return String.class;
            }
        }
        return null;
    }

    private static class ToDoList
    extends AbstractLineGutterMarkList {
        public LocatableItem createLineGutterMark(URL uRL, int n) {
            ToDoPanel toDoPanel = new ToDoPanel();
            JDevToDoItem jDevToDoItem = new JDevToDoItem(null, null, 3, n, 0, uRL, false, null);
            ToDoItem toDoItem = toDoPanel.runDialog((ToDoItem)jDevToDoItem, true);
            return toDoItem;
        }

        public boolean allowMultipleMarksPerLine() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean insertLineGutterMark(LocatableItem locatableItem) {
            List list;
            boolean bl = true;
            List list2 = list = this.getLineGutterMarkList();
            synchronized (list2) {
                boolean bl2 = false;
                if (list.contains(locatableItem)) {
                    bl2 = true;
                    bl = false;
                }
                if (!bl2) {
                    list.add(locatableItem);
                }
            }
            return bl;
        }

        public LocatableItem addLineGutterMark(LocatableItem locatableItem) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeToDoItem(ToDoItem toDoItem) {
            List list;
            List list2 = list = this.getLineGutterMarkList();
            synchronized (list2) {
                super.removeLineGutterMark((LocatableItem)toDoItem);
            }
        }

        boolean doesLineHaveToDoItem(URL uRL, int n) {
            return super.findLineGutterMark(uRL, n) != null;
        }

        int findToDoItemPosition(ToDoItem toDoItem) {
            List list = super.getLineGutterMarkList();
            int n = super.getLineGutterMarkCount();
            ToDoItem toDoItem2 = null;
            int n2 = 0;
            while (n2 < n) {
                toDoItem2 = (ToDoItem)list.get(n2);
                if (toDoItem2.equals(toDoItem)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeToDoItemByPosition(int n) {
            List list;
            List list2 = list = super.getLineGutterMarkList();
            synchronized (list2) {
                list.remove(n);
            }
        }

        LocatableItem[] findLineGutterMarksForTags(URL uRL) {
            ArrayList<ToDoItem> arrayList = new ArrayList<ToDoItem>();
            List list = this.getLineGutterMarkList();
            int n = list.size();
            ToDoItem toDoItem = null;
            int n2 = 0;
            while (n2 < n) {
                toDoItem = (ToDoItem)list.get(n2);
                if (toDoItem instanceof JDevToDoItem && ((JDevToDoItem)toDoItem).getTag() != null && toDoItem.getURL() != null && URLFileSystem.equals((URL)uRL, (URL)toDoItem.getURL())) {
                    arrayList.add(toDoItem);
                }
                ++n2;
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return arrayList.toArray(new LocatableItem[arrayList.size()]);
        }
    }
}

