/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.todo;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.swing.text.Document;
import oracle.ide.todo.ToDoItem;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.plugins.EditorPlugin;

final class ToDoTagHighlightPlugin
implements EditorPlugin {
    private BasicEditorPane _editor;
    private HighlightLayer _highlightLayer;
    private ArrayList _highlightList;
    private HighlightStyle _style;

    void $init$() {
        this._highlightList = new ArrayList();
    }

    public ToDoTagHighlightPlugin(HighlightStyle highlightStyle) {
        this.$init$();
        this._style = highlightStyle;
    }

    public void createHighlightForTag(int n, int n2, ToDoItem toDoItem) {
        ToDoHighlightedText toDoHighlightedText = new ToDoHighlightedText(this._getHighlightLayer().addHighlight(this._style, n, n + n2));
        toDoHighlightedText.setToDoItem(toDoItem);
        this._highlightList.add(toDoHighlightedText);
    }

    public void removeHighlightForTag(int n, ToDoItem toDoItem) {
        ToDoHighlightedText toDoHighlightedText = this._findEntryFor(toDoItem);
        if (toDoHighlightedText != null) {
            this._highlightList.remove(toDoHighlightedText);
            this._getHighlightLayer().removeHighlight(toDoHighlightedText.getHighlightedText());
        }
    }

    private ToDoHighlightedText _findEntryFor(ToDoItem toDoItem) {
        int n = this._highlightList.size();
        ToDoHighlightedText toDoHighlightedText = null;
        int n2 = 0;
        while (n2 < n) {
            toDoHighlightedText = (ToDoHighlightedText)this._highlightList.get(n2);
            if (toDoHighlightedText.getToDoItem().equals(toDoItem)) {
                return toDoHighlightedText;
            }
            ++n2;
        }
        return null;
    }

    public void install(BasicEditorPane basicEditorPane) {
        this._editor = basicEditorPane;
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        if (this._highlightLayer != null) {
            basicEditorPane.destroyHighlightLayer(this._highlightLayer);
            this._highlightLayer = null;
        }
        basicEditorPane = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("document") && (object = propertyChangeEvent.getNewValue()) instanceof Document) {
            if (this._highlightLayer != null) {
                this._highlightLayer.removeAllHighlights();
            }
            this._highlightList.clear();
        }
    }

    private HighlightLayer _getHighlightLayer() {
        if (this._highlightLayer == null) {
            this._highlightLayer = this._editor.createHighlightLayer();
        }
        return this._highlightLayer;
    }

    private static final class ToDoHighlightedText {
        private HighlightedText _hText;
        private ToDoItem _toDoItem;

        public ToDoHighlightedText(HighlightedText highlightedText) {
            this._hText = highlightedText;
        }

        public HighlightedText getHighlightedText() {
            return this._hText;
        }

        public void setToDoItem(ToDoItem toDoItem) {
            this._toDoItem = toDoItem;
        }

        public ToDoItem getToDoItem() {
            return this._toDoItem;
        }
    }
}

