/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.todo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileNotFoundException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.ewt.util.MenuUtils;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.JLabeledCheckBox;
import oracle.ide.controls.MenuItem;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFactory;
import oracle.ide.resource.LogArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.todo.ToDoItem;
import oracle.ide.todo.ToDoManager;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.ModelUtil;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.controls.nicetable.NiceTablePersistentSettings;
import oracle.jdeveloper.resource.EJBArb;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdevimpl.resource.ToDoArb;
import oracle.jdevimpl.todo.FilteredToDoTableModel;
import oracle.jdevimpl.todo.JDevToDoItem;
import oracle.jdevimpl.todo.PriorityCellEditor;
import oracle.jdevimpl.todo.ToDoAddin;
import oracle.jdevimpl.todo.ToDoDockableFactory;
import oracle.jdevimpl.todo.ToDoFilterPanel;
import oracle.jdevimpl.todo.ToDoLogPagePersistentSettings;
import oracle.jdevimpl.todo.ToDoManagerImpl;
import oracle.jdevimpl.todo.ToDoPanel;
import oracle.jdevimpl.todo.ToDoTableModel;

class ToDoWindow
extends DockableWindow
implements ContextMenuListener,
ActiveViewListener,
ViewSelectionListener {
    private JPanel _panel;
    private ToolButton _addButton;
    private IdeAction _addAction;
    private ToolButton _removeButton;
    private IdeAction _removeAction;
    private ToolButton _editButton;
    private IdeAction _editAction;
    private ToolButton _filterButton;
    private IdeAction _filterAction;
    private MenuToolButton _scopeToolButton;
    private Toolbar _toolbar;
    private boolean _initialized;
    private IdeAction _currentWorkspaceAction;
    private IdeAction _currentProjectAction;
    private IdeAction _currentFileAction;
    private ContextMenu _contextMenu;
    private JMenuItem _addToDoMenuItem;
    private JMenuItem _editToDoMenuItem;
    private JMenuItem _removeToDoMenuItem;
    private JMenuItem _filterMenuItem;
    private JMenuItem _gotoSourceMenuItem;
    private IdeAction _gotoSourceAction;
    private IdeAction _removeCompletedToDosAction;
    private JMenuItem _removeCompletedToDosMenuItem;
    private View _lastViewSelectionListenerAdded;
    private JButton _busyButton;
    private IdeAction _columnAction;
    private JMenuItem _columnMenuItem;
    private ToDoWindowMouseListener _mouseListener;
    private NiceTable _niceTable;
    private Controller _controller;
    public static final String VIEW_TYPE = "ToDoAddin";
    public static final String NAME = "ToDoWindow";
    public static final ViewId VIEWID = new ViewId(ToDoDockableFactory.VIEW_ID_STR);
    private static final String TODO_WINDOW_ATTRIBUTE_FILE = "ToDoWindowAttr.xml";
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"todo-window-attributes");
    private static final String ROOT_TAG = "ToDoWindowAttributes";
    private static final String ADD_TODO_CMD = "oracle.jdevimpl.todo.AddToDoCommand";
    private static final int ADD_TODO_CMD_ID = Ide.createCmdID((String)"oracle.jdevimpl.todo.AddToDoCommand");
    private static final String EDIT_TODO_CMD = "oracle.jdevimpl.todo.EditToDoCommand";
    private static final int EDIT_TODO_CMD_ID = Ide.createCmdID((String)"oracle.jdevimpl.todo.EditToDoCommand");
    private static final String REMOVE_TODO_CMD = "oracle.jdevimpl.todo.RemoveToDoCommand";
    private static final int REMOVE_TODO_CMD_ID = Ide.createCmdID((String)"oracle.jdevimpl.todo.RemoveToDoCommand");
    private static final String FILTER_TODOS_CMD = "oracle.jdevimpl.todo.FilterToDosCommand";
    private static final int FILTER_TODOS_CMD_ID = Ide.createCmdID((String)"oracle.jdevimpl.todo.FilterToDosCommand");
    private static final String CURRENT_WORKSPACE_CMD = "oracle.jdevimpl.todo.CurrentWorkspaceCmd";
    public static final int CURRENT_WORKSPACE_CMD_ID = Ide.createCmdID((String)"oracle.jdevimpl.todo.CurrentWorkspaceCmd");
    private static final String CURRENT_PROJECT_CMD = "oracle.jdevimpl.todo.CurrentProjectCommand";
    public static final int CURRENT_PROJECT_CMD_ID = Ide.createCmdID((String)"oracle.jdevimpl.todo.CurrentProjectCommand");
    private static final String CURRENT_FILE_CMD = "oracle.jdevimpl.todo.CurrentFileCommand";
    public static final int CURRENT_FILE_CMD_ID = Ide.createCmdID((String)"oracle.jdevimpl.todo.CurrentFileCommand");
    private static final int GOTO_SOURCE_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.todo.GoToSourceCommand");
    private static final String REMOVE_COMPLETED_TODOS_CMD = "oracle.jdevimpl.todo.RemoveCompletedToDosCommand";
    private static final int REMOVE_COMPLETED_TODOS_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.todo.RemoveCompletedToDosCommand");
    private static final String SORT_GROUP_NAME = "ToDoWindowScopeGroup";
    private static final String COLUMN_ACTION_CMD = "ToDoWindowColumnActionCommand";
    private static final int COLUMN_ACTION_CMD_ID = Ide.createCmdID((String)"ToDoWindowColumnActionCommand");

    public ToDoWindow(String string) {
        super(string);
    }

    public ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            this._contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        return this._contextMenu;
    }

    public String getTitleName() {
        return ToDoArb.getString(108);
    }

    public String getTabName() {
        return ToDoArb.getString(109);
    }

    public Component getGUI() {
        if (this._panel == null) {
            this._panel = new JPanel();
            this._initialize();
        }
        return this._panel;
    }

    public int getType() {
        return 32;
    }

    public void close() {
        this._saveWindowAttributes();
        super.close();
        ((ToDoManagerImpl)ToDoManager.getToDoManager()).closeToDoWindow();
        Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
        if (this._lastViewSelectionListenerAdded != null) {
            this._lastViewSelectionListenerAdded.removeViewSelectionListener((ViewSelectionListener)this);
        }
        ContextMenu contextMenu = LogManager.getLogManager().getContextMenu();
        contextMenu.removeContextMenuListener((ContextMenuListener)this);
    }

    public Controller getController() {
        return this._controller;
    }

    public Icon getTabIcon() {
        return ToDoArb.getIcon(128);
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idetaskwindow_html");
    }

    public static ViewId getToDoWindowViewId() {
        return VIEWID;
    }

    public void clearAll() {
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.getGUI().addMouseListener(mouseListener);
        this._niceTable.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.getGUI().removeMouseListener(mouseListener);
        this._niceTable.removeMouseListener(mouseListener);
    }

    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        if (activeViewEvent.getNewView() instanceof NavigatorWindow) {
            activeViewEvent.getNewView().addViewSelectionListener((ViewSelectionListener)this);
            this._lastViewSelectionListenerAdded = activeViewEvent.getNewView();
            if (super.isVisible()) {
                ((ToDoManagerImpl)ToDoManager.getToDoManager()).setScope(activeViewEvent.getNewView().getContext());
            }
        }
        if (activeViewEvent.getOldView() instanceof NavigatorWindow) {
            activeViewEvent.getOldView().removeViewSelectionListener((ViewSelectionListener)this);
        }
    }

    public void viewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        if (super.isVisible()) {
            View view = viewSelectionEvent.getView();
            Context context = view.getContext();
            ((ToDoManagerImpl)ToDoManager.getToDoManager()).setScope(context);
        }
    }

    int getScopeActionId() {
        IdeAction ideAction = (IdeAction)this._scopeToolButton.getAction();
        return ideAction.getCommandId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBusyIndicator() {
        Toolbar toolbar = this._toolbar;
        synchronized (toolbar) {
            if (this._busyButton == null) {
                this._busyButton = new JButton();
                this._busyButton.setIcon(VCSArb.getIcon(32));
                this._busyButton.setToolTipText(ToDoArb.getString(106));
                this._toolbar.add((Component)this._busyButton);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBusyIndicator() {
        Toolbar toolbar = this._toolbar;
        synchronized (toolbar) {
            if (this._busyButton != null) {
                this._toolbar.remove((Component)this._busyButton);
                this._busyButton = null;
                this._toolbar.repaint();
            }
        }
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (context.getView() instanceof ToDoWindow) {
            contextMenu.add((Component)this._addToDoMenuItem, MenuConstants.SECTION_EDIT_CTXT_MENU);
            contextMenu.add((Component)this._editToDoMenuItem, MenuConstants.SECTION_EDIT_CTXT_MENU);
            contextMenu.add((Component)this._removeToDoMenuItem, MenuConstants.SECTION_EDIT_CTXT_MENU);
            contextMenu.add((Component)this._filterMenuItem, MenuConstants.SECTION_EDIT_CTXT_MENU);
            contextMenu.add((Component)this._columnMenuItem, MenuConstants.increment((float)MenuConstants.SECTION_EDIT_CTXT_MENU));
            int n = Ide.findOrCreateCmdID((String)"CLEAR_LOG_CMD_ID");
            MenuItem menuItem = (MenuItem)contextMenu.getChildById(contextMenu.getGUI(false), n);
            contextMenu.remove((Component)menuItem);
            contextMenu.add((Component)this._removeCompletedToDosMenuItem, MenuConstants.SECTION_EDIT_CTXT_MENU);
            this._controller.update(this._removeCompletedToDosAction, context);
            contextMenu.add((Component)this._gotoSourceMenuItem, MenuConstants.SECTION_NAVIGATE_CTXT_MENU);
            this._controller.update(this._gotoSourceAction, context);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void _initialize() {
        if (!this._initialized) {
            this._initialized = true;
            ToDoManager toDoManager = ToDoManager.getToDoManager();
            if (toDoManager instanceof ToDoManagerImpl) {
                ((ToDoManagerImpl)toDoManager).setToDoWindowInstance(this);
            }
            this._controller = new ToDoWindowController(null);
            this._panel.setLayout(new BorderLayout());
            this._mouseListener = new ToDoWindowMouseListener(null);
            this._createActions();
            this._createToolbar();
            this._panel.add((Component)this._toolbar, "North");
            this._createNiceTable();
            JScrollPane jScrollPane = this._niceTable.getScrollPaneForTable();
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this._panel.add((Component)jScrollPane, "Center");
            this._applySavedWindowAttributes();
            this._setupContextMenu();
            Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
        }
    }

    private void _setScope(int n) {
        ((ToDoManagerImpl)ToDoManager.getToDoManager()).setScope(n);
        IdeAction ideAction = null;
        if (n == CURRENT_WORKSPACE_CMD_ID) {
            ideAction = this._currentWorkspaceAction;
        } else if (n == CURRENT_PROJECT_CMD_ID) {
            ideAction = this._currentProjectAction;
        } else if (n == CURRENT_FILE_CMD_ID) {
            ideAction = this._currentFileAction;
        }
        this._scopeToolButton.setAction((Action)ideAction);
    }

    private static ToDoItem _getToDoItemForViewRow(NiceTable niceTable, int n) {
        int n2 = niceTable.convertRowToModelIndex(n);
        FilteredToDoTableModel filteredToDoTableModel = (FilteredToDoTableModel)niceTable.getBaseModel();
        int n3 = filteredToDoTableModel.getModelRow(n2);
        return filteredToDoTableModel.getRealModel().getToDoItemForRow(n3);
    }

    private void _createActions() {
        this._addAction = IdeAction.get((int)ADD_TODO_CMD_ID, (String)ADD_TODO_CMD, (String)ToDoArb.getString(46), null, (Integer)ToDoArb.getInteger(47), (ArrayResourceBundle)EJBArb.getInstance(), (int)165, null, (boolean)true);
        this._addAction.addController(this._controller);
        this._editAction = IdeAction.get((int)EDIT_TODO_CMD_ID, (String)EDIT_TODO_CMD, (String)ToDoArb.getString(49), null, (Integer)ToDoArb.getInteger(50), (ArrayResourceBundle)EJBArb.getInstance(), (int)166, null, (boolean)false);
        this._editAction.addController(this._controller);
        this._removeAction = IdeAction.get((int)REMOVE_TODO_CMD_ID, (String)REMOVE_TODO_CMD, (String)ToDoArb.getString(52), null, (Integer)ToDoArb.getInteger(53), (ArrayResourceBundle)ToDoArb.getInstance(), (int)129, null, (boolean)false);
        this._removeAction.addController(this._controller);
        this._filterAction = IdeAction.get((int)FILTER_TODOS_CMD_ID, (String)FILTER_TODOS_CMD, (String)ToDoArb.getString(16), null, (Integer)ToDoArb.getInteger(17), (ArrayResourceBundle)ToDoArb.getInstance(), (int)130, null, (boolean)true);
        this._filterAction.addController(this._controller);
    }

    private void _createToolbar() {
        this._toolbar = new Toolbar();
        this._createScopeToolButton();
        this._addButton = new ToolButton((Action)this._addAction);
        this._editButton = new ToolButton((Action)this._editAction);
        this._removeButton = new ToolButton((Action)this._removeAction);
        this._filterButton = new ToolButton((Action)this._filterAction);
        this._toolbar.add((Component)this._scopeToolButton);
        this._toolbar.add((Component)this._addButton);
        this._toolbar.add((Component)this._editButton);
        this._toolbar.add((Component)this._removeButton);
        this._toolbar.add((Component)this._filterButton);
    }

    private void _createScopeToolButton() {
        IdeAction[] ideActionArray = new IdeAction[3];
        this._currentWorkspaceAction = IdeAction.get((int)CURRENT_WORKSPACE_CMD_ID, (String)CURRENT_WORKSPACE_CMD, (String)ToDoArb.getString(103), null, null, (ArrayResourceBundle)ModelArb.getInstance(), (int)12, null, (boolean)true);
        this._currentWorkspaceAction.addController(this._controller);
        ideActionArray[0] = this._currentWorkspaceAction;
        this._currentProjectAction = IdeAction.get((int)CURRENT_PROJECT_CMD_ID, (String)CURRENT_PROJECT_CMD, (String)ToDoArb.getString(104), null, null, (ArrayResourceBundle)ModelArb.getInstance(), (int)11, null, (boolean)true);
        this._currentProjectAction.addController(this._controller);
        ideActionArray[1] = this._currentProjectAction;
        this._currentFileAction = IdeAction.get((int)CURRENT_FILE_CMD_ID, (String)CURRENT_FILE_CMD, (String)ToDoArb.getString(105), null, null, (ArrayResourceBundle)ModelArb.getInstance(), (int)15, null, (boolean)true);
        this._currentFileAction.addController(this._controller);
        ideActionArray[2] = this._currentFileAction;
        this._currentWorkspaceAction.putValue("RadioGroupName", (Object)SORT_GROUP_NAME);
        this._currentProjectAction.putValue("RadioGroupName", (Object)SORT_GROUP_NAME);
        this._currentFileAction.putValue("RadioGroupName", (Object)SORT_GROUP_NAME);
        this._currentWorkspaceAction.putValue("Radio", (Object)Boolean.TRUE);
        this._currentProjectAction.putValue("Radio", (Object)Boolean.TRUE);
        this._currentFileAction.putValue("Radio", (Object)Boolean.TRUE);
        this._scopeToolButton = new MenuToolButton((ToggleAction[])ideActionArray);
    }

    private void _setupContextMenu() {
        ContextMenu contextMenu = LogManager.getLogManager().getContextMenu();
        this._gotoSourceAction = IdeAction.get((int)GOTO_SOURCE_CMD_ID, null, (String)LogArb.getString((int)10), (String)null, (Integer)LogArb.getInteger((int)11), (ArrayResourceBundle)LogArb.getInstance(), (int)12, null, (boolean)true);
        this._gotoSourceMenuItem = contextMenu.createMenuItem((ToggleAction)this._gotoSourceAction, MenuConstants.WEIGHT_NAVIGATE_GO_TO_CLASS);
        this._removeCompletedToDosAction = IdeAction.get((int)REMOVE_COMPLETED_TODOS_CMD_ID, (String)REMOVE_COMPLETED_TODOS_CMD, (String)ToDoArb.getString(110), (String)null, (Integer)ToDoArb.getInteger(111), (ArrayResourceBundle)ToDoArb.getInstance(), (int)112, null, (boolean)true);
        this._removeCompletedToDosMenuItem = contextMenu.createMenuItem((ToggleAction)this._removeCompletedToDosAction, MenuConstants.WEIGHT_NAVIGATE_GO_TO_CLASS);
        this._columnAction = IdeAction.get((int)COLUMN_ACTION_CMD_ID, (String)COLUMN_ACTION_CMD, (String)ToDoArb.getString(113), (String)null, (Integer)ToDoArb.getInteger(114), (ArrayResourceBundle)ToDoArb.getInstance(), (int)115, null, (boolean)true);
        this._columnAction.addController(this._controller);
        this._columnMenuItem = contextMenu.createMenuItem((ToggleAction)this._columnAction, MenuConstants.increment((float)MenuConstants.WEIGHT_NAVIGATE_GO_TO_CLASS));
        this._addToDoMenuItem = contextMenu.createMenuItem((ToggleAction)this._addAction, MenuConstants.SECTION_EDIT_CTXT_MENU);
        this._editToDoMenuItem = contextMenu.createMenuItem((ToggleAction)this._editAction, MenuConstants.SECTION_EDIT_CTXT_MENU);
        this._removeToDoMenuItem = contextMenu.createMenuItem((ToggleAction)this._removeAction, MenuConstants.SECTION_EDIT_CTXT_MENU);
        this._filterMenuItem = contextMenu.createMenuItem((ToggleAction)this._filterAction, MenuConstants.SECTION_EDIT_CTXT_MENU);
        contextMenu.addContextMenuListener((ContextMenuListener)this);
    }

    private void _createNiceTable() {
        this._niceTable = new NiceTable((TableModel)((ToDoManagerImpl)ToDoManager.getToDoManager()).getTableModel());
        this._niceTable.setShowToolTips(true);
        this._niceTable.setSorted(true);
        this._niceTable.setAutoResizeMode(1);
        this._niceTable.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this._niceTable.setFocusTraversalKeys(1, Collections.EMPTY_SET);
        TableColumn tableColumn = this._niceTable.getColumnModel().getColumn(2);
        tableColumn.setCellEditor(new NonNullableTextCellEditor());
        TableColumn tableColumn2 = this._niceTable.getColumnModel().getColumn(0);
        tableColumn2.setCellRenderer((TableCellRenderer)((Object)new DoneCellRenderer()));
        tableColumn2.setCellEditor(new DoneCellEditor());
        TableColumn tableColumn3 = this._niceTable.getColumnModel().getColumn(3);
        tableColumn3.setCellEditor(new PriorityCellEditor());
        TableColumn tableColumn4 = this._niceTable.getColumnModel().getColumn(8);
        tableColumn4.setCellRenderer((TableCellRenderer)((Object)new DateCellRenderer()));
        tableColumn4.setCellEditor(new DateCellEditor());
        this._niceTable.addMouseListener((MouseListener)new DoubleClickMouseListener(null));
        this._niceTable.addMouseListener((MouseListener)this._mouseListener);
        ListSelectionModel listSelectionModel = this._niceTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new 1());
    }

    private void _applySavedWindowAttributes() {
        ToDoLogPagePersistentSettings toDoLogPagePersistentSettings = null;
        try {
            URL uRL = this._getSaveURL();
            Object2Dom object2Dom = Object2Dom.newInstance();
            toDoLogPagePersistentSettings = (ToDoLogPagePersistentSettings)object2Dom.toObject(uRL);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (toDoLogPagePersistentSettings != null) {
            if (toDoLogPagePersistentSettings.getScopeAction() != null) {
                String string = toDoLogPagePersistentSettings.getScopeAction();
                if (string.equals(CURRENT_WORKSPACE_CMD)) {
                    this._scopeToolButton.setAction((Action)this._currentWorkspaceAction);
                } else if (string.equals(CURRENT_PROJECT_CMD)) {
                    this._scopeToolButton.setAction((Action)this._currentProjectAction);
                } else if (string.equals(CURRENT_FILE_CMD)) {
                    this._scopeToolButton.setAction((Action)this._currentFileAction);
                }
            } else {
                this._scopeToolButton.setAction((Action)this._currentFileAction);
            }
            if (toDoLogPagePersistentSettings.getNiceTableSettings() != null) {
                NiceTablePersistentSettings niceTablePersistentSettings = toDoLogPagePersistentSettings.getNiceTableSettings();
                this._niceTable.setPersistentSettings(niceTablePersistentSettings);
            }
        } else {
            this._niceTable.setHiddenColumns(new int[]{1, 5, 7, 9});
            this._niceTable.setSortColumn(3, true);
        }
    }

    private URL _getSaveURL() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        URL uRL = extensionRegistry.getSystemDirectory("oracle.jdeveloper");
        return URLFactory.newURL((URL)uRL, (String)TODO_WINDOW_ATTRIBUTE_FILE);
    }

    private void _saveWindowAttributes() {
        ToDoLogPagePersistentSettings toDoLogPagePersistentSettings = new ToDoLogPagePersistentSettings();
        IdeAction ideAction = (IdeAction)this._scopeToolButton.getAction();
        String string = ideAction.getCommand();
        toDoLogPagePersistentSettings.setScopeAction(string);
        NiceTablePersistentSettings niceTablePersistentSettings = this._niceTable.getPersistentSettings();
        toDoLogPagePersistentSettings.setNiceTableSettings(niceTablePersistentSettings);
        try {
            URL uRL = this._getSaveURL();
            Object2Dom object2Dom = Object2Dom.newInstance();
            object2Dom.setNamespaceURI(NAMESPACE_URI);
            object2Dom.toDocument((Object)toDoLogPagePersistentSettings, ROOT_TAG, uRL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static IdeAction ra$_editAction(ToDoWindow toDoWindow) {
        return toDoWindow._editAction;
    }

    static IdeAction ra$_removeAction(ToDoWindow toDoWindow) {
        return toDoWindow._removeAction;
    }

    static NiceTable ra$_niceTable(ToDoWindow toDoWindow) {
        return toDoWindow._niceTable;
    }

    static ToDoItem maS$_getToDoItemForViewRow(NiceTable niceTable, int n) {
        return ToDoWindow._getToDoItemForViewRow(niceTable, n);
    }

    static int ra$ADD_TODO_CMD_ID() {
        return ADD_TODO_CMD_ID;
    }

    static int ra$FILTER_TODOS_CMD_ID() {
        return FILTER_TODOS_CMD_ID;
    }

    static int ra$GOTO_SOURCE_CMD_ID() {
        return GOTO_SOURCE_CMD_ID;
    }

    static IdeAction ra$_gotoSourceAction(ToDoWindow toDoWindow) {
        return toDoWindow._gotoSourceAction;
    }

    static int ra$REMOVE_COMPLETED_TODOS_CMD_ID() {
        return REMOVE_COMPLETED_TODOS_CMD_ID;
    }

    static IdeAction ra$_removeCompletedToDosAction(ToDoWindow toDoWindow) {
        return toDoWindow._removeCompletedToDosAction;
    }

    static int ra$EDIT_TODO_CMD_ID() {
        return EDIT_TODO_CMD_ID;
    }

    static int ra$REMOVE_TODO_CMD_ID() {
        return REMOVE_TODO_CMD_ID;
    }

    static int ra$COLUMN_ACTION_CMD_ID() {
        return COLUMN_ACTION_CMD_ID;
    }

    static void mav$_setScope(ToDoWindow toDoWindow, int n) {
        toDoWindow._setScope(n);
    }

    final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int n;
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    ToDoWindow.ra$_editAction(ToDoWindow.this).setEnabled(false);
                    ToDoWindow.ra$_removeAction(ToDoWindow.this).setEnabled(false);
                    return;
                }
                ToDoTableModel toDoTableModel = (ToDoTableModel)ToDoWindow.ra$_niceTable(ToDoWindow.this).getBaseModel();
                if (toDoTableModel.isRowEditable(n = ToDoWindow.ra$_niceTable(ToDoWindow.this).convertRowToModelIndex(listSelectionModel.getMinSelectionIndex()))) {
                    ToDoWindow.ra$_editAction(ToDoWindow.this).setEnabled(true);
                } else {
                    ToDoWindow.ra$_editAction(ToDoWindow.this).setEnabled(false);
                }
                boolean bl = false;
                int n2 = listSelectionModel.getMinSelectionIndex();
                while (n2 < listSelectionModel.getMaxSelectionIndex() + 1) {
                    if (toDoTableModel.isRowEditable(ToDoWindow.ra$_niceTable(ToDoWindow.this).convertRowToModelIndex(n2))) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                ToDoWindow.ra$_removeAction(ToDoWindow.this).setEnabled(bl);
            }
        }
    }

    private static final class DoneCellRenderer
    extends NiceTableCellRenderer {
        private JLabeledCheckBox _checkbox;

        void $init$() {
            this._checkbox = new JLabeledCheckBox();
        }

        public DoneCellRenderer() {
            this.$init$();
            this._checkbox.checkBox.setBorderPaintedFlat(true);
            this._checkbox.checkBox.setEnabled(true);
            this._checkbox.configureCenteredNoLabel();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = jTable.convertColumnIndexToModel(n2);
            Boolean bl3 = (Boolean)jTable.getModel().getValueAt(n, n3);
            if (bl3 != null) {
                Border border;
                this._checkbox.checkBox.setSelected(bl3);
                this._checkbox.setBackground(component.getBackground());
                this._checkbox.setForeground(component.getForeground());
                if (component instanceof JComponent && (border = ((JComponent)component).getBorder()) != null) {
                    this._checkbox.setBorder(border);
                }
                return this._checkbox;
            }
            return component;
        }
    }

    private static final class NonNullableTextCellEditor
    extends DefaultCellEditor {
        public NonNullableTextCellEditor() {
            super(new JTextField());
        }

        public boolean stopCellEditing() {
            String string = (String)this.getCellEditorValue();
            if (ModelUtil.hasLength((String)string)) {
                return super.stopCellEditing();
            }
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), ToDoArb.getString(82), ToDoArb.getString(83), 0);
            return false;
        }
    }

    private static final class DoneCellEditor
    extends DefaultCellEditor {
        private static JLabeledCheckBox _checkbox = new JLabeledCheckBox();

        public DoneCellEditor() {
            super(DoneCellEditor._checkbox.checkBox);
            _checkbox.configureCenteredNoLabel();
            DoneCellEditor._checkbox.checkBox.setBorderPaintedFlat(true);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            if (object != null) {
                Boolean bl2 = (Boolean)object;
                DoneCellEditor._checkbox.checkBox.setSelected(bl2);
                _checkbox.setBackground(jTable.getSelectionBackground());
                _checkbox.setForeground(jTable.getForeground());
                return _checkbox;
            }
            return null;
        }
    }

    private static final class DateCellRenderer
    extends NiceTableCellRenderer {
        private DateEditor _dateEditor;

        void $init$() {
            this._dateEditor = new DateEditor();
        }

        public DateCellRenderer() {
            this.$init$();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = jTable.convertColumnIndexToModel(n2);
            if (jTable.getModel().isCellEditable(n, n3)) {
                this._dateEditor.setDateFormat((DateFormat)ToDoAddin.getSimpleDateFormat());
                Date date = (Date)jTable.getModel().getValueAt(n, n3);
                if (date != null) {
                    this._dateEditor.setDate(date);
                } else {
                    this._dateEditor.setDate(null);
                }
                if (date != null) {
                    SimpleDateFormat simpleDateFormat = ToDoAddin.getSimpleDateFormat();
                    ((NiceTableCellRenderer)component).setText(simpleDateFormat.format(date));
                    return component;
                }
            }
            return component;
        }
    }

    private static final class DateCellEditor
    extends DefaultCellEditor {
        private DateEditor _dateEditor;

        void $init$() {
            this._dateEditor = new DateEditor();
        }

        public DateCellEditor() {
            super(new JTextField());
            this.$init$();
            this._dateEditor.setDateFormat((DateFormat)ToDoAddin.getSimpleDateFormat());
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            if (object != null) {
                this._dateEditor.setDate((Date)object);
            } else {
                this._dateEditor.setDate(null);
            }
            this._dateEditor.setBackground(component.getBackground());
            this._dateEditor.setForeground(component.getForeground());
            return this._dateEditor;
        }

        public Component getComponent() {
            return this._dateEditor;
        }

        public Object getCellEditorValue() {
            return this._dateEditor.getDate();
        }
    }

    private static class DoubleClickMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                ToDoItem toDoItem;
                Point point = mouseEvent.getPoint();
                NiceTable niceTable = (NiceTable)mouseEvent.getSource();
                int n = niceTable.rowAtPoint(point);
                if (n != -1 && (toDoItem = ToDoWindow.maS$_getToDoItemForViewRow(niceTable, n)).canGoTo()) {
                    toDoItem.goTo();
                }
            }
        }

        private DoubleClickMouseListener() {
        }

        DoubleClickMouseListener(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class ToDoWindowMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            this.triggerPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.triggerPopup(mouseEvent);
        }

        protected void triggerPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ToDoWindow.this.getContextMenu().show(ToDoWindow.this.getContext(mouseEvent));
            }
        }

        private ToDoWindowMouseListener() {
        }

        ToDoWindowMouseListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ToDoWindowController
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == ToDoWindow.ra$ADD_TODO_CMD_ID()) {
                ToDoPanel toDoPanel = new ToDoPanel();
                ToDoItem toDoItem = toDoPanel.runDialog(null, true);
                if (toDoItem != null) {
                    ((ToDoManagerImpl)ToDoManager.getToDoManager()).addToDoItem(toDoItem);
                }
                return true;
            }
            if (n == ToDoWindow.ra$EDIT_TODO_CMD_ID()) {
                int[] nArray = ToDoWindow.ra$_niceTable(ToDoWindow.this).getSelectedRows();
                if (nArray != null) {
                    if (nArray.length == 1) {
                        ToDoItem toDoItem = ToDoWindow.maS$_getToDoItemForViewRow(ToDoWindow.ra$_niceTable(ToDoWindow.this), nArray[0]);
                        ToDoItem[] toDoItemArray = new ToDoItem[]{toDoItem};
                        ((ToDoManagerImpl)ToDoManager.getToDoManager()).editToDoItems(toDoItemArray);
                    } else {
                        ArrayList<ToDoItem> arrayList = new ArrayList<ToDoItem>();
                        int n2 = 0;
                        while (n2 < nArray.length) {
                            arrayList.add(ToDoWindow.maS$_getToDoItemForViewRow(ToDoWindow.ra$_niceTable(ToDoWindow.this), nArray[n2]));
                            ++n2;
                        }
                        ToDoItem[] toDoItemArray = arrayList.toArray(new ToDoItem[arrayList.size()]);
                        ((ToDoManagerImpl)ToDoManager.getToDoManager()).editToDoItems(toDoItemArray);
                    }
                }
                return true;
            }
            if (n == ToDoWindow.ra$REMOVE_TODO_CMD_ID()) {
                TableCellEditor tableCellEditor = ToDoWindow.ra$_niceTable(ToDoWindow.this).getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.stopCellEditing();
                }
                int[] nArray = ToDoWindow.ra$_niceTable(ToDoWindow.this).getSelectedRows();
                int n3 = -1;
                int n4 = -1;
                if (nArray != null && nArray.length > 0) {
                    ArrayList<ToDoItem> arrayList = new ArrayList<ToDoItem>();
                    int n5 = 0;
                    while (n5 < nArray.length) {
                        ToDoItem toDoItem = ToDoWindow.maS$_getToDoItemForViewRow(ToDoWindow.ra$_niceTable(ToDoWindow.this), nArray[n5]);
                        if (!(toDoItem instanceof JDevToDoItem) || ((JDevToDoItem)toDoItem).getTag() == null) {
                            arrayList.add(toDoItem);
                            n3 = nArray[n5];
                            ++n4;
                        }
                        ++n5;
                    }
                    ((ToDoManagerImpl)ToDoManager.getToDoManager()).removeToDoItems(arrayList);
                }
                return true;
            }
            if (n == ToDoWindow.ra$FILTER_TODOS_CMD_ID()) {
                ToDoFilterPanel toDoFilterPanel = new ToDoFilterPanel();
                if (toDoFilterPanel.runDialog()) {
                    ((ToDoManagerImpl)ToDoManager.getToDoManager()).changeFilterList(ToDoAddin.getFilterList());
                    ListSelectionModel listSelectionModel = ToDoWindow.ra$_niceTable(ToDoWindow.this).getSelectionModel();
                    listSelectionModel.clearSelection();
                    listSelectionModel.setLeadSelectionIndex(0);
                }
                return true;
            }
            if (n == ToDoWindow.ra$COLUMN_ACTION_CMD_ID()) {
                MenuUtils.showPopupMenu((JPopupMenu)ToDoWindow.ra$_niceTable(ToDoWindow.this).createSelectorMenu(), (Component)ToDoWindow.ra$_niceTable(ToDoWindow.this), (int)ToDoWindow.ra$_niceTable(ToDoWindow.this).getX(), (int)ToDoWindow.ra$_niceTable(ToDoWindow.this).getY());
                return true;
            }
            if (n == CURRENT_WORKSPACE_CMD_ID) {
                ToDoWindow.mav$_setScope(ToDoWindow.this, n);
                return true;
            }
            if (n == CURRENT_PROJECT_CMD_ID) {
                ToDoWindow.mav$_setScope(ToDoWindow.this, n);
                return true;
            }
            if (n == CURRENT_FILE_CMD_ID) {
                ToDoWindow.mav$_setScope(ToDoWindow.this, n);
                return true;
            }
            if (n == ToDoWindow.ra$GOTO_SOURCE_CMD_ID()) {
                ToDoItem toDoItem;
                int n6 = ToDoWindow.ra$_niceTable(ToDoWindow.this).getSelectedRow();
                if (n6 != -1 && (toDoItem = ToDoWindow.maS$_getToDoItemForViewRow(ToDoWindow.ra$_niceTable(ToDoWindow.this), n6)).getURL() != null) {
                    ((ToDoManagerImpl)ToDoManager.getToDoManager()).gotoToDoItem(toDoItem);
                }
                return true;
            }
            if (n == ToDoWindow.ra$REMOVE_COMPLETED_TODOS_CMD_ID()) {
                int n7 = ToDoWindow.ra$_niceTable(ToDoWindow.this).getRowCount();
                ToDoItem toDoItem = null;
                ArrayList<ToDoItem> arrayList = new ArrayList<ToDoItem>();
                int n8 = 0;
                while (n8 < n7) {
                    toDoItem = ToDoWindow.maS$_getToDoItemForViewRow(ToDoWindow.ra$_niceTable(ToDoWindow.this), n8);
                    if (toDoItem.isDone()) {
                        arrayList.add(toDoItem);
                    }
                    ++n8;
                }
                ((ToDoManagerImpl)ToDoManager.getToDoManager()).removeToDoItems(arrayList);
                return true;
            }
            if (n == 30 || n == 31) {
                int n9 = ToDoWindow.ra$_niceTable(ToDoWindow.this).getSelectedRow();
                int n10 = -1;
                n10 = n == 30 ? this._getNextNavigableRow(n9) : this._getPreviousNavigableRow(n9);
                if (n10 == -1) {
                    return true;
                }
                ToDoItem toDoItem = ToDoWindow.maS$_getToDoItemForViewRow(ToDoWindow.ra$_niceTable(ToDoWindow.this), n10);
                ((ToDoManagerImpl)ToDoManager.getToDoManager()).gotoToDoItem(toDoItem);
                ListSelectionModel listSelectionModel = ToDoWindow.ra$_niceTable(ToDoWindow.this).getSelectionModel();
                listSelectionModel.setSelectionInterval(n10, n10);
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == ToDoWindow.ra$ADD_TODO_CMD_ID()) {
                return true;
            }
            if (n == ToDoWindow.ra$FILTER_TODOS_CMD_ID()) {
                return true;
            }
            if (n == ToDoWindow.ra$GOTO_SOURCE_CMD_ID()) {
                int n2 = ToDoWindow.ra$_niceTable(ToDoWindow.this).getSelectedRow();
                if (n2 == -1) {
                    ToDoWindow.ra$_gotoSourceAction(ToDoWindow.this).setEnabled(false);
                } else {
                    ToDoItem toDoItem = ToDoWindow.maS$_getToDoItemForViewRow(ToDoWindow.ra$_niceTable(ToDoWindow.this), n2);
                    ToDoWindow.ra$_gotoSourceAction(ToDoWindow.this).setEnabled(toDoItem.canGoTo());
                }
                return true;
            }
            if (n == ToDoWindow.ra$REMOVE_COMPLETED_TODOS_CMD_ID()) {
                int n3 = ToDoWindow.ra$_niceTable(ToDoWindow.this).getRowCount();
                ToDoItem toDoItem = null;
                ToDoWindow.ra$_removeCompletedToDosAction(ToDoWindow.this).setEnabled(false);
                int n4 = 0;
                while (n4 < n3) {
                    toDoItem = ToDoWindow.maS$_getToDoItemForViewRow(ToDoWindow.ra$_niceTable(ToDoWindow.this), n4);
                    if (toDoItem.isDone()) {
                        ToDoWindow.ra$_removeCompletedToDosAction(ToDoWindow.this).setEnabled(true);
                        break;
                    }
                    ++n4;
                }
                return true;
            }
            if (n == 30 || n == 31) {
                int n5 = ToDoWindow.ra$_niceTable(ToDoWindow.this).getSelectedRow();
                int n6 = -1;
                n6 = n == 30 ? this._getNextNavigableRow(n5) : this._getPreviousNavigableRow(n5);
                if (n6 == -1) {
                    ideAction.setEnabled(false);
                } else {
                    ideAction.setEnabled(true);
                }
                return true;
            }
            return false;
        }

        private int _getNextNavigableRow(int n) {
            int n2 = ToDoWindow.ra$_niceTable(ToDoWindow.this).getRowCount();
            ToDoItem toDoItem = null;
            int n3 = n + 1;
            while (n3 < n2) {
                toDoItem = ToDoWindow.maS$_getToDoItemForViewRow(ToDoWindow.ra$_niceTable(ToDoWindow.this), n3);
                if (toDoItem.getURL() != null) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }

        private int _getPreviousNavigableRow(int n) {
            ToDoItem toDoItem = null;
            int n2 = n - 1;
            while (n2 > -1) {
                toDoItem = ToDoWindow.maS$_getToDoItemForViewRow(ToDoWindow.ra$_niceTable(ToDoWindow.this), n2);
                if (toDoItem.getURL() != null) {
                    return n2;
                }
                --n2;
            }
            return -1;
        }

        private ToDoWindowController() {
        }

        ToDoWindowController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

