/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.extension;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.model.Project;
import oracle.ide.wizard.Wizard;
import oracle.jdevimpl.wizard.extension.ExtensionArb;
import oracle.jdevimpl.wizard.extension.ExtensionIconUtil;
import oracle.jdevimpl.wizard.extension.ExtensionUtil;
import oracle.jdevimpl.wizard.extension.ExtensionValidation;
import oracle.jdevimpl.wizard.extension.generate.code.ExtensionJavaGenerator;
import oracle.jdevimpl.wizard.extension.generate.manifest.ExtensionElement;
import oracle.jdevimpl.wizard.extension.generate.manifest.ExtensionManifestGenerator;
import oracle.jdevimpl.wizard.extension.generate.manifest.ExtensionManifestTranslator;
import oracle.jdevimpl.wizard.extension.model.Model;
import oracle.jdevimpl.wizard.extension.model.ModelInfo;
import oracle.jdevimpl.wizard.extension.ui.minimal.MinimalExtensionPanel;

public final class MinimalExtension
extends Wizard
implements VetoableChangeListener {
    private static final String ICON_NAME = "Addin.gif";
    private Icon _icon;
    private Context _context;

    public boolean isAvailable(Context context) {
        return context != null && context.getProject() != null;
    }

    public boolean invoke(Context context) {
        Model model = new Model();
        model.setContext(context);
        this._context = context;
        MinimalExtensionPanel minimalExtensionPanel = new MinimalExtensionPanel(model);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)minimalExtensionPanel, (Component)minimalExtensionPanel.getInitialFocusComponent(), (String)ExtensionArb.getString(183), (int)7);
        jEWTDialog.addVetoableChangeListener((VetoableChangeListener)this);
        boolean bl = jEWTDialog.runDialog();
        jEWTDialog.dispose();
        if (bl) {
            this.populate(model, minimalExtensionPanel);
            this.generate(model);
        }
        return true;
    }

    public String getShortLabel() {
        return ExtensionArb.getString(181);
    }

    public String getLongLabel() {
        return ExtensionArb.getString(182);
    }

    public Icon getIcon() {
        if (this._icon == null) {
            this._icon = new ImageIcon(ExtensionIconUtil.getIconUrl(ICON_NAME));
        }
        return this._icon;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
            MinimalExtensionPanel minimalExtensionPanel = (MinimalExtensionPanel)((JEWTDialog)propertyChangeEvent.getSource()).getContent();
            String string = minimalExtensionPanel.getClassName().trim();
            String string2 = minimalExtensionPanel.getPackage().trim();
            if (!ExtensionValidation.isValidClassName(minimalExtensionPanel, string)) {
                throw new PropertyVetoException(null, propertyChangeEvent);
            }
            if (!ExtensionValidation.isValidPackageName(minimalExtensionPanel, string2)) {
                throw new PropertyVetoException(null, propertyChangeEvent);
            }
            Project project = this._context.getProject();
            URL uRL = ExtensionUtil.getFileURL(minimalExtensionPanel.getPackage(), minimalExtensionPanel.getClassName(), ".java", project);
            if (ExtensionValidation.urlExist(minimalExtensionPanel, uRL)) {
                throw new PropertyVetoException(null, propertyChangeEvent);
            }
        }
    }

    private void populate(ModelInfo modelInfo, MinimalExtensionPanel minimalExtensionPanel) {
        ((Model)modelInfo).setPackageName(minimalExtensionPanel.getPackage());
        ((Model)modelInfo).setClassName(minimalExtensionPanel.getClassName());
    }

    private void generate(ModelInfo modelInfo) {
        ExtensionJavaGenerator extensionJavaGenerator = new ExtensionJavaGenerator();
        extensionJavaGenerator.setModel(modelInfo);
        extensionJavaGenerator.generate();
        ExtensionManifestTranslator extensionManifestTranslator = new ExtensionManifestTranslator();
        extensionManifestTranslator.setProject(modelInfo.getContext().getProject());
        ExtensionElement extensionElement = extensionManifestTranslator.getExtensionManifest();
        extensionElement.populateManifest(modelInfo);
        ExtensionManifestGenerator extensionManifestGenerator = new ExtensionManifestGenerator();
        extensionManifestGenerator.setModel(extensionElement);
        extensionManifestGenerator.generate();
    }
}

