/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.extension.generate.code;

import java.util.Iterator;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controller.ContextMenuListener;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.wizard.extension.ExtensionArb;
import oracle.jdevimpl.wizard.extension.ExtensionUtil;
import oracle.jdevimpl.wizard.extension.generate.code.Generator;
import oracle.jdevimpl.wizard.extension.generate.code.GeneratorUtils;
import oracle.jdevimpl.wizard.extension.model.Model;

public final class ContextMenuListenerGenerator
extends GeneratorUtils
implements Generator {
    private final String CLASS_NAME;

    void $init$() {
        this.CLASS_NAME = ContextMenuListener.class.getName();
    }

    public boolean generateClassHeader(JavaManager javaManager, SourceFile sourceFile, SourceClass sourceClass, Model model) {
        Iterator iterator = model.getContextMenuIndexes().iterator();
        if (iterator != null) {
            ContextMenuListenerGenerator.addImport(sourceFile, "oracle.ide.ContextMenu");
            this._createBuildMenuItemMethod(sourceFile, sourceClass, model.getMainMenuTitle(), ExtensionUtil.getFileName(model.getMainMenuIcon()), model.getCommandId());
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this._addContextMenuRegistration(sourceFile, sourceClass, model, string);
            }
        }
        return true;
    }

    public boolean generateMethod(JavaManager javaManager, SourceFile sourceFile, SourceClass sourceClass, SourceMethod sourceMethod, SourceTypeReference sourceTypeReference, String string, Model model) {
        SourceBlock sourceBlock = sourceMethod.getBlock();
        if (string.equals("poppingUp")) {
            SourceVariable sourceVariable = ContextMenuListenerGenerator.getMethodParameter(sourceMethod, 0);
            sourceVariable.setName("popup");
            String string2 = ExtensionArb.getString(7);
            ContextMenuListenerGenerator.addLineComment(sourceFile, sourceBlock, string2);
            String[] stringArray = new String[]{"getContextMenuItem()"};
            ContextMenuListenerGenerator.addMethodCallStatement(sourceFile, sourceBlock, "popup", "add", stringArray);
        } else if (string.equals("poppingDown")) {
            SourceVariable sourceVariable = ContextMenuListenerGenerator.getMethodParameter(sourceMethod, 0);
            sourceVariable.setName("popup");
        } else if (string.equals("handleDefaultAction")) {
            SourceVariable sourceVariable = ContextMenuListenerGenerator.getMethodParameter(sourceMethod, 0);
            sourceVariable.setName("context");
            String string3 = ExtensionArb.getString(8);
            ContextMenuListenerGenerator.addLineComment(sourceFile, sourceBlock, string3);
            ContextMenuListenerGenerator.addReturn(sourceFile, sourceBlock, "false");
        } else {
            return false;
        }
        return true;
    }

    private boolean _createBuildMenuItemMethod(SourceFile sourceFile, SourceClass sourceClass, String string, String string2, String string3) {
        ContextMenuListenerGenerator.addField(sourceFile, sourceClass, "javax.swing.JMenuItem", "contextMenuItem", 10, "null");
        SourceFactory sourceFactory = sourceFile.getFactory();
        SourceBlock sourceBlock = sourceFactory.createBlock();
        SourceTypeReference sourceTypeReference = sourceFactory.createType("javax.swing.JMenuItem");
        SourceMethod sourceMethod = sourceFactory.createMethod(sourceTypeReference, "getContextMenuItem", null, null, sourceBlock);
        sourceMethod.setModifiers(2);
        sourceClass.getSourceMethods().add(sourceMethod);
        SourceBlock sourceBlock2 = sourceFactory.createBlock();
        ContextMenuListenerGenerator.addIfStatement(sourceFile, sourceBlock, "contextMenuItem == null", sourceBlock2);
        String string4 = "createMenu_" + string3;
        String[] stringArray = new String[]{"\"" + string2 + "\"", "\"" + StringUtils.stripMnemonic((String)string) + "\"", Integer.toString(StringUtils.getMnemonicKeyCode((String)string))};
        SourceExpression sourceExpression = ContextMenuListenerGenerator.createMethodCall(sourceFile, null, string4, stringArray);
        ContextMenuListenerGenerator.addAssignStatement(sourceFile, sourceBlock2, "contextMenuItem", sourceExpression);
        ContextMenuListenerGenerator.addReturn(sourceFile, sourceBlock, "contextMenuItem");
        return true;
    }

    private boolean _addContextMenuRegistration(SourceFile sourceFile, SourceClass sourceClass, Model model, String string) {
        SourceMethod sourceMethod = sourceClass.getSourceMethod("initialize", null);
        SourceBlock sourceBlock = sourceMethod.getBlock();
        ContextMenuListenerGenerator.addImport(sourceFile, model.getSelectedContextMenuImport(string));
        String string2 = model.getSelectedContextMenuListenerName(string);
        String[] stringArray = "NavigatorManager.getWorkspaceNavigatorManager()".equals(string2) || "NavigatorManager.getApplicationNavigatorManager()".equals(string2) ? new String[]{"this", "null"} : new String[]{"this"};
        ContextMenuListenerGenerator.addMethodCallStatement(sourceFile, sourceBlock, string2, "addContextMenuListener", stringArray);
        return true;
    }

    public ContextMenuListenerGenerator() {
        this.$init$();
    }
}

