/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.extension.generate.code;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.imports.ImportUtilities2;
import oracle.jdevimpl.wizard.extension.ExtensionArb;
import oracle.jdevimpl.wizard.extension.ExtensionUtil;
import oracle.jdevimpl.wizard.extension.generate.code.Generator;
import oracle.jdevimpl.wizard.extension.generate.code.GeneratorUtils;
import oracle.jdevimpl.wizard.extension.model.Model;
import oracle.jdevimpl.wizard.extension.model.ModelInfo;

public abstract class ExtensionGenerator
extends GeneratorUtils {
    protected static final int ERROR_CREATE_NODE = 0;
    protected static final int ERROR_READ_ONLY = 1;
    protected static final int ERROR_UNKNOWN_NODE = 2;
    protected static final int ERROR_COPY_SOURCE = 3;
    private ModelInfo _model;
    private Project _proj;

    public void setModel(ModelInfo modelInfo) {
        this._model = modelInfo;
    }

    protected URL _getURL() {
        return ExtensionUtil.getFileURL(this._model.getPackageName(), this._model.getClassName(), this.getFileExtension(), this.getProject());
    }

    protected void addNodeToProject(Node node) {
        this._proj.add((Element)node, true);
    }

    protected Node _createNode() {
        URL uRL = this._getURL();
        Node node = null;
        try {
            node = NodeFactory.findOrCreate((URL)uRL);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return node;
    }

    protected void _clearFile(Node node) {
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            TextBuffer textBuffer = null;
            try {
                textBuffer = textNode.acquireTextBuffer();
                int n = textBuffer.getLength();
                if (n > 0) {
                    textBuffer.remove(0, n);
                    UpdateMessage.fireStructureChanged((Subject)textNode);
                }
            }
            finally {
                if (textBuffer != null) {
                    textNode.releaseTextBuffer();
                }
            }
        }
    }

    protected void _openFileInEditor(Node node) {
        SwingUtilities.invokeLater(new 1(this, node));
    }

    protected abstract boolean createSource(Node var1);

    protected abstract String getFileExtension();

    protected void createImageNode(URL uRL, URL uRL2) {
        URL uRL3 = URLFactory.newURL((URL)uRL, (String)URLFileSystem.getFileName((URL)uRL2));
        try {
            URLFileSystem.copy((URL)uRL2, (URL)uRL3);
            Node node = NodeFactory.findOrCreate((URL)uRL3);
            if (!this._proj.containsChild((Element)node)) {
                this._proj.add((Element)node, true);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
    }

    protected void _showError(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = ExtensionArb.getString(125);
                break;
            }
            case 1: {
                string = ExtensionArb.getString(126);
                break;
            }
            case 2: {
                string = ExtensionArb.getString(127);
                break;
            }
            case 3: {
                string = ExtensionArb.getString(128);
                break;
            }
            default: {
                string = ExtensionArb.getString(129);
            }
        }
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)ExtensionArb.getString(130), null);
    }

    protected Project getProject() {
        if (this._proj == null) {
            Context context = this._model.getContext();
            this._proj = context.getProject();
        }
        return this._proj;
    }

    protected ModelInfo getModel() {
        return this._model;
    }

    protected abstract Generator getGenerator(String var1);

    protected boolean implementInterface(JavaManager javaManager, SourceFile sourceFile, SourceClass sourceClass, JavaClass javaClass) {
        String string = javaClass.getQualifiedName();
        Generator generator = this.getGenerator(string);
        if (generator != null && !generator.generateClassHeader(javaManager, sourceFile, sourceClass, (Model)this.getModel())) {
            return false;
        }
        for (JavaMethod javaMethod : javaClass.getDeclaredMethods()) {
            SourceMethod sourceMethod = sourceClass.getSourceMethod(javaMethod.getName(), javaMethod.getTypeParameters().toArray(new JavaType[0]));
            if (sourceMethod != null && !Modifier.isAbstract(sourceMethod.getModifiers())) continue;
            this.addMethod(javaManager, sourceFile, sourceClass, javaMethod);
        }
        if (!sourceClass.isSubtypeOf((JavaType)javaClass)) {
            SourceFactory sourceFactory = sourceFile.getFactory();
            SourceTypeReference sourceTypeReference = sourceFactory.createType(javaClass.getQualifiedName());
            sourceClass.getSourceInterfaces().add(sourceTypeReference);
        }
        return true;
    }

    protected void addMethod(JavaManager javaManager, SourceFile sourceFile, SourceClass sourceClass, JavaMethod javaMethod) {
        JavaType javaType = javaMethod.getReturnType();
        String string = javaMethod.getName();
        SourceFactory sourceFactory = sourceFile.getFactory();
        SourceTypeReference sourceTypeReference = sourceFactory.createType(javaType.getQualifiedName());
        SourceFormalParameterList sourceFormalParameterList = sourceFactory.createFormalParameterList();
        SourceBlock sourceBlock = sourceFactory.createBlock();
        SourceMethod sourceMethod = sourceFactory.createMethod(sourceTypeReference, string, sourceFormalParameterList, null, sourceBlock);
        sourceClass.getSourceMethods().add(sourceMethod);
        sourceMethod.setModifiers(1);
        Iterator iterator = javaMethod.getParameters().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            JavaLocalVariable javaLocalVariable = (JavaLocalVariable)iterator.next();
            JavaType javaType2 = javaLocalVariable.getResolvedType();
            String string2 = javaLocalVariable.getName();
            if (string2 == null || string2.length() == 0) {
                string2 = "param" + n++;
            }
            SourceLocalVariable sourceLocalVariable = sourceFactory.createLocalVariable(sourceFactory.createType(javaType2.getQualifiedName()), string2);
            sourceFormalParameterList.getSourceParameters().add(sourceLocalVariable);
        }
        Object var18_18 = null;
        for (JavaType javaType3 : javaMethod.getExceptions()) {
            sourceMethod.getSourceExceptions().add(sourceFactory.createType(javaType3.getQualifiedName()));
        }
        String string3 = javaMethod.getOwningClass().getQualifiedName();
        Generator generator = this.getGenerator(string3);
        if (generator != null && generator.generateMethod(javaManager, sourceFile, sourceClass, sourceMethod, sourceTypeReference, string, (Model)this.getModel())) {
            return;
        }
        this.generateDefaultMethod(javaManager, sourceFile, sourceClass, sourceMethod, sourceTypeReference);
    }

    protected void generateDefaultMethod(JavaManager javaManager, SourceFile sourceFile, SourceClass sourceClass, SourceMethod sourceMethod, SourceTypeReference sourceTypeReference) {
        String string = sourceTypeReference.getName();
        if (!string.equals("void")) {
            String string2 = "null";
            if (sourceTypeReference.isPrimitive()) {
                string2 = string.equals("boolean") ? "false" : "0";
            }
            SourceBlock sourceBlock = sourceMethod.getBlock();
            ExtensionGenerator.addReturn(sourceFile, sourceBlock, string2);
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ Node v$node;
        final /* synthetic */ ExtensionGenerator this$0;

        public void run() {
            Editor editor = EditorUtil.openExplicitDefaultEditorInFrame((Node)this.v$node);
            if (editor instanceof CodeEditor) {
                BasicEditorPane basicEditorPane = ((CodeEditor)editor).getFocusedEditorPane();
                Context context = editor.getContext();
                ImportUtilities2.sortImports(basicEditorPane, context);
                try {
                    this.v$node.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public 1(ExtensionGenerator extensionGenerator, Node node) {
            this.v$node = node;
            this.this$0 = extensionGenerator;
        }
    }
}

